/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.extras;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.physics.bullet.dynamics.btDynamicsWorld;
import com.badlogic.gdx.physics.bullet.extras.ExtrasJNI;
import com.badlogic.gdx.physics.bullet.extras.SWIGTYPE_p_bParse__btBulletFile;
import com.badlogic.gdx.physics.bullet.extras.btWorldImporter;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.ByteBuffer;

public class btBulletWorldImporter
extends btWorldImporter {
    private long swigCPtr;

    protected btBulletWorldImporter(String className, long cPtr, boolean cMemoryOwn) {
        super(className, ExtrasJNI.btBulletWorldImporter_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btBulletWorldImporter(long cPtr, boolean cMemoryOwn) {
        this("btBulletWorldImporter", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(ExtrasJNI.btBulletWorldImporter_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btBulletWorldImporter obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                ExtrasJNI.delete_btBulletWorldImporter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    protected void swigDirectorDisconnect() {
        this.swigCMemOwn = false;
        this.delete();
    }

    public void swigReleaseOwnership() {
        this.swigCMemOwn = false;
        ExtrasJNI.btBulletWorldImporter_change_ownership(this, this.swigCPtr, false);
    }

    public void swigTakeOwnership() {
        this.swigCMemOwn = true;
        ExtrasJNI.btBulletWorldImporter_change_ownership(this, this.swigCPtr, true);
    }

    public boolean loadFile(FileHandle fileHandle) {
        int len = (int)fileHandle.length();
        if (len <= 0) {
            throw new GdxRuntimeException("Incorrect file specified");
        }
        ByteBuffer buff = BufferUtils.newUnsafeByteBuffer(len);
        buff.put(fileHandle.readBytes());
        buff.position(0);
        boolean result = this.loadFileFromMemory(buff, len);
        BufferUtils.disposeUnsafeByteBuffer(buff);
        return result;
    }

    public btBulletWorldImporter(btDynamicsWorld world) {
        this(ExtrasJNI.new_btBulletWorldImporter__SWIG_0(btDynamicsWorld.getCPtr(world), world), true);
        ExtrasJNI.btBulletWorldImporter_director_connect(this, this.swigCPtr, this.swigCMemOwn, true);
    }

    public btBulletWorldImporter() {
        this(ExtrasJNI.new_btBulletWorldImporter__SWIG_1(), true);
        ExtrasJNI.btBulletWorldImporter_director_connect(this, this.swigCPtr, this.swigCMemOwn, true);
    }

    public boolean loadFile(String fileName, String preSwapFilenameOut) {
        return ExtrasJNI.btBulletWorldImporter_loadFile__SWIG_0(this.swigCPtr, this, fileName, preSwapFilenameOut);
    }

    public boolean loadFile(String fileName) {
        return ExtrasJNI.btBulletWorldImporter_loadFile__SWIG_1(this.swigCPtr, this, fileName);
    }

    public boolean loadFileFromMemory(SWIGTYPE_p_bParse__btBulletFile file) {
        return ExtrasJNI.btBulletWorldImporter_loadFileFromMemory__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_bParse__btBulletFile.getCPtr(file));
    }

    public boolean convertAllObjects(SWIGTYPE_p_bParse__btBulletFile file) {
        return this.getClass() == btBulletWorldImporter.class ? ExtrasJNI.btBulletWorldImporter_convertAllObjects(this.swigCPtr, this, SWIGTYPE_p_bParse__btBulletFile.getCPtr(file)) : ExtrasJNI.btBulletWorldImporter_convertAllObjectsSwigExplicitbtBulletWorldImporter(this.swigCPtr, this, SWIGTYPE_p_bParse__btBulletFile.getCPtr(file));
    }

    public boolean loadFileFromMemory(ByteBuffer memoryBuffer, int len) {
        assert (memoryBuffer.isDirect()) : "Buffer must be allocated direct.";
        return ExtrasJNI.btBulletWorldImporter_loadFileFromMemory__SWIG_1(this.swigCPtr, this, memoryBuffer, len);
    }
}

