/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Config {
    public static final Client CLIENT = new Client();
    public static final Server SERVER = new Server();
    private static final String DIR = "configs";

    public static class Server {
        private final String CONFIG = "physics_server_config.json";
        public volatile boolean collapse = true;
        public volatile boolean dropBlocks = true;
        public volatile int maxCollapseObjects = 100;
        public volatile int collapseSpeed = 10;

        public Server() {
            File configFile;
            JsonObject config = new JsonObject();
            config.add("collapse", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.collapse)));
            config.add("maxCollapseObjects", (JsonElement)new JsonPrimitive((Number)this.maxCollapseObjects));
            config.add("collapseSpeed", (JsonElement)new JsonPrimitive((Number)this.collapseSpeed));
            config.add("dropBlocks", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.dropBlocks)));
            File directory = new File(Config.DIR);
            if (!directory.exists()) {
                directory.mkdir();
            }
            if (!(configFile = new File("configs/physics_server_config.json")).exists()) {
                try {
                    configFile.createNewFile();
                    try (FileWriter writer = new FileWriter(configFile);){
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        gson.toJson((JsonElement)config, (Appendable)writer);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Gson gson = new Gson();
                try {
                    config = (JsonObject)gson.fromJson((Reader)new FileReader(configFile), JsonObject.class);
                }
                catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.collapse = config.get("collapse").getAsBoolean();
                this.maxCollapseObjects = config.get("maxCollapseObjects").getAsInt();
                this.collapseSpeed = config.get("collapseSpeed").getAsInt();
                this.dropBlocks = config.get("dropBlocks").getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void save() {
            File configFile;
            File directory = new File(Config.DIR);
            if (!directory.exists()) {
                directory.mkdir();
            }
            if ((configFile = new File("configs/physics_server_config.json")).exists()) {
                configFile.delete();
            }
            JsonObject config = new JsonObject();
            config.add("collapse", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.collapse)));
            config.add("maxCollapseObjects", (JsonElement)new JsonPrimitive((Number)this.maxCollapseObjects));
            config.add("collapseSpeed", (JsonElement)new JsonPrimitive((Number)this.collapseSpeed));
            config.add("dropBlocks", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.dropBlocks)));
            try {
                configFile.createNewFile();
                try (FileWriter writer = new FileWriter(configFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Client {
        private final String CONFIG = "physics_config.json";
        public boolean mobPhysics = true;
        public boolean bloodPhysics = true;
        public boolean mobBlockyPhysics = false;
        public boolean blockPhysics = true;
        public int physicsRange = 60;
        public int maxPhysicsObjects = 500;
        public double blockPhysicsScale = 1.0;
        public double particleLifetime = 4.0;

        public Client() {
            File configFile;
            JsonObject config = new JsonObject();
            config.add("mobPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.mobPhysics)));
            config.add("bloodPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.bloodPhysics)));
            config.add("mobBlockyPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.mobBlockyPhysics)));
            config.add("blockPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.blockPhysics)));
            config.add("physicsRange", (JsonElement)new JsonPrimitive((Number)this.physicsRange));
            config.add("maxPhysicsObjects", (JsonElement)new JsonPrimitive((Number)this.maxPhysicsObjects));
            config.add("blockPhysicsScale", (JsonElement)new JsonPrimitive((Number)this.blockPhysicsScale));
            config.add("particleLifetime", (JsonElement)new JsonPrimitive((Number)this.particleLifetime));
            File directory = new File(Config.DIR);
            if (!directory.exists()) {
                directory.mkdir();
            }
            if (!(configFile = new File("configs/physics_config.json")).exists()) {
                try {
                    configFile.createNewFile();
                    try (FileWriter writer = new FileWriter(configFile);){
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        gson.toJson((JsonElement)config, (Appendable)writer);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Gson gson = new Gson();
                try {
                    config = (JsonObject)gson.fromJson((Reader)new FileReader(configFile), JsonObject.class);
                }
                catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.mobPhysics = config.get("mobPhysics").getAsBoolean();
                this.bloodPhysics = config.get("bloodPhysics").getAsBoolean();
                this.mobBlockyPhysics = config.get("mobBlockyPhysics").getAsBoolean();
                this.blockPhysics = config.get("blockPhysics").getAsBoolean();
                this.physicsRange = config.get("physicsRange").getAsInt();
                this.maxPhysicsObjects = config.get("maxPhysicsObjects").getAsInt();
                this.blockPhysicsScale = config.get("blockPhysicsScale").getAsDouble();
                this.particleLifetime = config.get("particleLifetime").getAsDouble();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void save() {
            File configFile;
            File directory = new File(Config.DIR);
            if (!directory.exists()) {
                directory.mkdir();
            }
            if ((configFile = new File("configs/physics_config.json")).exists()) {
                configFile.delete();
            }
            JsonObject config = new JsonObject();
            config.add("mobPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.mobPhysics)));
            config.add("bloodPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.bloodPhysics)));
            config.add("mobBlockyPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.mobBlockyPhysics)));
            config.add("blockPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.blockPhysics)));
            config.add("physicsRange", (JsonElement)new JsonPrimitive((Number)this.physicsRange));
            config.add("maxPhysicsObjects", (JsonElement)new JsonPrimitive((Number)this.maxPhysicsObjects));
            config.add("blockPhysicsScale", (JsonElement)new JsonPrimitive((Number)this.blockPhysicsScale));
            config.add("particleLifetime", (JsonElement)new JsonPrimitive((Number)this.particleLifetime));
            try {
                configFile.createNewFile();
                try (FileWriter writer = new FileWriter(configFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

