/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.engine.util.math;

public class Math {
    public static final double PI = java.lang.Math.PI;

    public static double lerp(double first, double second, double target) {
        if (first == second) {
            return first;
        }
        return first + (second - first) * target;
    }

    public static double lerpDegree(double first, double second, double target) {
        if (first == second) {
            return first;
        }
        double shortestAngle = ((second - first) % 360.0 + 540.0) % 360.0 - 180.0;
        return first + shortestAngle * target;
    }

    public static double lerpRadians(double first, double second, double target) {
        if (first == second) {
            return first;
        }
        return first + target * Math.wrapRadians(second - first);
    }

    public static double lerpRadians(double first, double second, double maxMovement, double target) {
        if (first == second) {
            return first;
        }
        double movement = target * Math.wrapRadians(second - first);
        if (movement < -maxMovement) {
            movement = -maxMovement;
        } else if (movement > maxMovement) {
            movement = maxMovement;
        }
        return first + movement;
    }

    private static double wrapRadians(double radians) {
        return Math.wrapMinMax(radians, -java.lang.Math.PI, java.lang.Math.PI);
    }

    private static double wrapMax(double x, double max) {
        return (max + x % max) % max;
    }

    private static double wrapMinMax(double x, double min, double max) {
        return min + Math.wrapMax(x - min, max - min);
    }

    public static float lerp(float first, float second, float target) {
        if (first == second) {
            return first;
        }
        return first + (second - first) * target;
    }

    public static double getWeight(double first, double second, double target) {
        if (second == first) {
            return 1.0;
        }
        return (target - first) / (second - first);
    }

    public static float getWeight(float first, float second, float target) {
        if (second == first) {
            return 1.0f;
        }
        return (target - first) / (second - first);
    }

    public static int fastFloor(double value) {
        return value > 0.0 ? (int)value : (int)value - 1;
    }

    public static double clamp(double val, double min, double max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static byte clamp(int val, byte min, byte max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return (byte)val;
    }

    public static int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float clamp(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static double toRadians(double angdeg) {
        return angdeg / 180.0 * java.lang.Math.PI;
    }

    public static double remap(double value, double oldMin, double oldMax, double newMin, double newMax) {
        return newMin + (value - oldMin) / (oldMax - oldMin) * (newMax - newMin);
    }

    public static double remapClamp(double value, double oldMin, double oldMax, double newMin, double newMax) {
        if (newMin < newMax) {
            return Math.clamp(newMin + (value - oldMin) / (oldMax - oldMin) * (newMax - newMin), newMin, newMax);
        }
        return Math.clamp(newMin + (value - oldMin) / (oldMax - oldMin) * (newMax - newMin), newMax, newMin);
    }

    public static float remap(float value, float oldMin, float oldMax, float newMin, float newMax) {
        return newMin + (value - oldMin) / (oldMax - oldMin) * (newMax - newMin);
    }

    public static float remapClamp(float value, float oldMin, float oldMax, float newMin, float newMax) {
        if (newMin < newMax) {
            return Math.clamp(newMin + (value - oldMin) / (oldMax - oldMin) * (newMax - newMin), newMin, newMax);
        }
        return Math.clamp(newMin + (value - oldMin) / (oldMax - oldMin) * (newMax - newMin), newMax, newMin);
    }

    public static int fastfloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }
}

