/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.Random;
import net.diebuddies.engine.util.math.Math;
import net.diebuddies.engine.util.math.MatrixUtil;
import net.diebuddies.physics.BlockParticle;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.class_1159;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public class MixinWorldRenderer {
    private static final int[] indices = new int[]{0, 1, 2, 0, 2, 3, 6, 5, 4, 7, 6, 4, 10, 9, 8, 11, 10, 8, 12, 13, 14, 12, 14, 15, 18, 17, 16, 19, 18, 16, 20, 21, 22, 20, 22, 23};
    private static final int[] indices_quad = new int[]{0, 1, 2, 3, 6, 5, 4, 7, 10, 9, 8, 11, 12, 13, 14, 15, 18, 17, 16, 19, 20, 21, 22, 23};
    private static final float[] positions = new float[]{-0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f};
    private static final float[] uv = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private static final byte[] colors = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final float[] normals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};

    @Inject(at={@At(value="TAIL")}, method={"renderLayer"})
    private void renderLayer(class_1921 blockLayerIn, class_4587 matrixStackIn, double xIn, double yIn, double zIn, CallbackInfo ci) {
        PhysicsMod mod = PhysicsMod.getInstance();
        if (blockLayerIn == class_1921.method_23577()) {
            class_638 world;
            blockLayerIn.method_23518();
            RenderSystem.enableDepthTest();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            class_243 view = class_310.method_1551().field_1773.method_19418().method_19326();
            class_4587 stack = matrixStackIn;
            RenderSystem.pushMatrix();
            RenderSystem.enableLighting();
            RenderSystem.enableColorMaterial();
            RenderSystem.enableFog();
            RenderSystem.enableCull();
            class_310.method_1551().field_1773.method_22974().method_3316();
            class_308.method_27869((class_1159)matrixStackIn.method_23760().method_23761());
            class_4493.method_21945((int)516, (float)0.95f);
            class_746 player = class_310.method_1551().field_1724;
            float[] m = new float[16];
            if (player != null && (world = player.field_17892) != null) {
                PhysicsWorld physics = mod.physicWorlds.get(world);
                if (physics == null) {
                    physics = new PhysicsWorld((class_1937)world);
                    mod.physicWorlds.put((class_1937)world, physics);
                }
                RenderSystem.pushMatrix();
                RenderSystem.multMatrix((class_1159)stack.method_23760().method_23761());
                if (physics != null) {
                    BlockParticle particle;
                    int qsize;
                    double chance = 1.0;
                    if (mod.queue.size() > 10 || (double)physics.getBodies().size() > (double)mod.clientConfig.maxPhysicsObjects * 0.4) {
                        chance = 0.3;
                        if ((double)physics.getBodies().size() > (double)mod.clientConfig.maxPhysicsObjects * 0.7) {
                            chance = 0.05;
                        }
                    }
                    if (physics.getBodies().size() > mod.clientConfig.maxPhysicsObjects) {
                        chance = 0.0;
                    }
                    if ((qsize = mod.queue.size()) == 1) {
                        chance = 1.0;
                    }
                    while (!mod.queue.isEmpty()) {
                        particle = mod.queue.poll();
                        Vector3d vector3d = new Vector3d();
                        if (!(particle.getTransformation().getTranslation(vector3d).distance(player.method_23317(), player.method_23318(), player.method_23321()) < (double)mod.clientConfig.physicsRange) || !(java.lang.Math.random() < chance)) continue;
                        if (chance < 0.5 || (double)physics.getBodies().size() > (double)mod.clientConfig.maxPhysicsObjects * 0.4) {
                            particle.scale = PhysicsMod.getInstance().clientConfig.blockPhysicsScale;
                            physics.addBlockParticle(PhysicsMod.brokenBlocksLittle.get(new Random().nextInt(PhysicsMod.brokenBlocksLittle.size())), particle);
                            continue;
                        }
                        particle.scale = PhysicsMod.getInstance().clientConfig.blockPhysicsScale;
                        physics.addBlockParticle(PhysicsMod.brokenBlocksLots.get(new Random().nextInt(PhysicsMod.brokenBlocksLots.size())), particle);
                    }
                    while (!mod.entityBlocks.isEmpty()) {
                        particle = mod.entityBlocks.poll();
                        Vector3d vector3d = new Vector3d();
                        if (!(particle.getTransformation().getTranslation(vector3d).distance(player.method_23317(), player.method_23318(), player.method_23321()) < (double)mod.clientConfig.physicsRange) || physics.getBodies().size() >= mod.clientConfig.maxPhysicsObjects) continue;
                        physics.addBlockParticle(particle);
                    }
                    while (!mod.blockUpdates.isEmpty()) {
                        class_2338 pos = mod.blockUpdates.poll();
                        class_243 class_2432 = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                        if (!(player.method_19538().method_1022(class_2432) < (double)mod.clientConfig.physicsRange + 5.0)) continue;
                        physics.blockUpdate(pos);
                    }
                    while (!mod.explosions.isEmpty()) {
                        physics.applyExplosion(mod.explosions.poll());
                    }
                    for (IRigidBody body : physics.getBodies()) {
                        BlockParticle particle2 = (BlockParticle)body.getEntity();
                        Matrix4d transformation = MatrixUtil.slerp(particle2.getOldTransformation(), particle2.getTransformation(), physics.getRenderPercent(), new Matrix4d());
                        transformation.scale(Math.clamp(particle2.time * 2.0, 0.0, 1.0));
                        Vector3d pos = transformation.getTranslation(new Vector3d());
                        class_2338 blockPos = new class_2338(pos.x + physics.getOffset().x, pos.y + physics.getOffset().y, pos.z + physics.getOffset().z);
                        transformation._m30(transformation.m30() - view.field_1352 + physics.getOffset().x);
                        transformation._m31(transformation.m31() - view.field_1351 + physics.getOffset().y);
                        transformation._m32(transformation.m32() - view.field_1350 + physics.getOffset().z);
                        transformation.scale(particle2.scalePhysics.x, particle2.scalePhysics.y, particle2.scalePhysics.z);
                        RenderSystem.pushMatrix();
                        try (MemoryStack mstack = MemoryStack.stackPush();){
                            FloatBuffer matrixBuffer = mstack.mallocFloat(16);
                            GL11.glMultMatrixf((FloatBuffer)transformation.get(matrixBuffer));
                        }
                        if (particle2.texture != null) {
                            particle2.texture.method_24119().method_23207();
                        } else if (particle2.textureState != null) {
                            particle2.textureState.method_23516();
                        }
                        bufferbuilder.method_1328(4, class_290.field_1580);
                        Mesh mesh = particle2.mesh;
                        int brightness = 0;
                        class_2680 bState = world.method_8320(blockPos);
                        brightness = bState.method_26204() == class_2246.field_10124 || bState.method_26204() == class_2246.field_10382 || bState.method_26204() == class_2246.field_10164 ? (world.method_8477(blockPos) ? class_761.method_23794((class_1920)world, (class_2338)blockPos) : 0) : (world.method_8477(blockPos.method_10084()) ? class_761.method_23794((class_1920)world, (class_2338)blockPos.method_10084()) : 0);
                        int j = brightness >> 16 & 0xFFFF;
                        int k = brightness & 0xFFFF;
                        int b = particle2.color & 0xFF;
                        int g = particle2.color >> 8 & 0xFF;
                        int r = particle2.color >> 16 & 0xFF;
                        for (Vector3i index : mesh.indices) {
                            Vector3d position = mesh.positions.get(index.x - 1);
                            Vector2d uv = mesh.uvs.get(index.y - 1);
                            Vector3d normal = mesh.normals.get(index.z - 1);
                            if (mesh.colors.size() > 0) {
                                Vector3f color = mesh.colors.get(index.x - 1);
                                r = (int)(color.x * 255.0f);
                                g = (int)(color.y * 255.0f);
                                b = (int)(color.z * 255.0f);
                            }
                            float minU = 0.0f;
                            float maxU = 1.0f;
                            float minV = 0.0f;
                            float maxV = 1.0f;
                            if (particle2.texture != null) {
                                minU = particle2.texture.method_4594();
                                maxU = particle2.texture.method_4577();
                                minV = particle2.texture.method_4593();
                                maxV = particle2.texture.method_4575();
                            }
                            bufferbuilder.method_22912(position.x * particle2.scale, position.y * particle2.scale, position.z * particle2.scale).method_1336(r, g, b, 255).method_22913(Math.remap((float)uv.x, 0.0f, 1.0f, minU, maxU), Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV)).method_22917(0, 0).method_22921(k, j).method_22914((float)normal.x, (float)normal.y, (float)normal.z).method_1344();
                        }
                        tessellator.method_1350();
                        RenderSystem.popMatrix();
                    }
                }
                RenderSystem.popMatrix();
            }
            RenderSystem.popMatrix();
        }
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableLighting();
        blockLayerIn.method_23516();
    }
}

