/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.linearmath.btDefaultMotionState;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.PhysicsEntity;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3d;

public class BoxRigidBody
extends IRigidBody {
    private btDefaultMotionState motionState;
    private btRigidBody.btRigidBodyConstructionInfo rbInfo;
    public float width;
    public float height;
    public float depth;

    private BoxRigidBody() {
    }

    public static BoxRigidBody create(PhysicsEntity entity, float width, float height, float depth, Matrix4d offset, boolean dynamic) {
        BoxRigidBody boxRigidBody = new BoxRigidBody();
        Vector3d scale = entity.getTransformation().getScale(new Vector3d());
        Vector3d translation = entity.getTransformation().getTranslation(new Vector3d());
        boxRigidBody.entity = entity;
        boxRigidBody.shape = new btBoxShape(new Vector3(width / 2.0f * (float)Math.abs(scale.x), height / 2.0f * (float)Math.abs(scale.y), depth / 2.0f * (float)Math.abs(scale.z)));
        boxRigidBody.offset.set(offset).mulLocal(new Matrix4d().scale(scale.x, scale.y, scale.z));
        boxRigidBody.offset.normalize3x3();
        Matrix4 transformation = new Matrix4();
        Quaterniond tmpQuat = new Quaterniond();
        entity.getTransformation().getUnnormalizedRotation(tmpQuat).normalize();
        Matrix4 tmp = new Matrix4(boxRigidBody.offset.get(new float[16]));
        transformation.translate((float)translation.x, (float)translation.y, (float)translation.z).rotate(new Quaternion((float)tmpQuat.x, (float)tmpQuat.y, (float)tmpQuat.z, (float)tmpQuat.w)).mul(tmp);
        boxRigidBody.motionState = new btDefaultMotionState(transformation);
        float mass = dynamic ? 1.0f : 0.0f;
        Vector3 fallInertia = new Vector3(0.0f, 0.0f, 0.0f);
        boxRigidBody.shape.calculateLocalInertia(mass, fallInertia);
        boxRigidBody.rbInfo = new btRigidBody.btRigidBodyConstructionInfo(mass, boxRigidBody.motionState, boxRigidBody.shape, fallInertia);
        boxRigidBody.rbInfo.setFriction(1.0f);
        boxRigidBody.rigidBody = new btRigidBody(boxRigidBody.rbInfo);
        boxRigidBody.rigidBody.userData = boxRigidBody;
        if (dynamic) {
            boxRigidBody.rigidBody.setActivationState(4);
        } else {
            boxRigidBody.rigidBody.setCollisionFlags(1);
            boxRigidBody.rigidBody.setActivationState(5);
            boxRigidBody.rigidBody.setAngularFactor(0.0f);
        }
        boxRigidBody.width = width;
        boxRigidBody.height = height;
        boxRigidBody.depth = depth;
        return boxRigidBody;
    }

    public static BoxRigidBody create(PhysicsEntity entity, float width, float height, float depth, boolean dynamic) {
        return BoxRigidBody.create(entity, width, height, depth, new Matrix4d(), dynamic);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.motionState != null) {
            this.motionState.dispose();
        }
        if (this.rbInfo != null) {
            this.rbInfo.dispose();
        }
    }
}

