/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class Mesh {
    private static final Vector3d[] faceNormals = new Vector3d[]{new Vector3d(0.0, 0.0, 1.0), new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, -1.0, 0.0)};
    public List<Vector3d> positions = new ArrayList<Vector3d>();
    public List<Vector2d> uvs = new ArrayList<Vector2d>();
    public List<Vector3d> normals = new ArrayList<Vector3d>();
    public List<Vector3f> colors;
    public List<Integer> sides;
    public List<Vector3i> indices = new ArrayList<Vector3i>();
    public Vector3d offset;

    public Mesh() {
        this.colors = new ArrayList<Vector3f>();
        this.sides = new ArrayList<Integer>();
    }

    public void calculateOffset() {
        this.calculateOffset(true);
    }

    public void calculateOffset(boolean needsSides) {
        this.offset = new Vector3d();
        for (Vector3d position : this.positions) {
            this.offset.add(position);
        }
        this.offset.div(this.positions.size());
        for (Vector3d position : this.positions) {
            position.sub(this.offset);
        }
        if (needsSides) {
            for (int j = 0; j < this.normals.size(); ++j) {
                boolean hasSide = false;
                for (int i = 0; i < faceNormals.length; ++i) {
                    if (!(Math.abs(org.joml.Math.acos(this.normals.get(j).dot(Mesh.faceNormals[i].x, Mesh.faceNormals[i].y, Mesh.faceNormals[i].z))) < 0.01)) continue;
                    this.sides.add(i);
                    hasSide = true;
                    break;
                }
                if (hasSide) continue;
                this.sides.add(-1);
            }
        }
    }
}

