/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.diebuddies.config.Config;
import net.diebuddies.physics.BlockParticle;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4592;
import net.minecraft.class_4595;
import net.minecraft.class_4668;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;

public class PhysicsMod {
    public static PhysicsMod instance;
    public Map<class_1937, PhysicsWorld> physicWorlds = new HashMap<class_1937, PhysicsWorld>();
    public boolean init = false;
    public ConcurrentLinkedQueue<BlockParticle> queue = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<BlockParticle> entityBlocks = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<class_2338> blockUpdates = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Explosion> explosions = new ConcurrentLinkedQueue();
    public Set<Integer> alreadyBlockified = new HashSet<Integer>();
    public Map<class_1657, Float> players = new HashMap<class_1657, Float>();
    public long time;
    public Config.Client clientConfig;
    public static final List<List<Mesh>> brokenBlocksLittle;
    public static final List<List<Mesh>> brokenBlocksLots;
    public static final List<Mesh> brokenBlock;

    private static List<Mesh> readBlock(String asset) {
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(PhysicsMod.class.getClassLoader().getResourceAsStream(asset)));){
            String line = "";
            Mesh mesh = null;
            int ov = 0;
            int ot = 0;
            int on = 0;
            while ((line = reader.readLine()) != null) {
                String[] data;
                if (line.startsWith("o")) {
                    if (mesh != null) {
                        mesh.calculateOffset();
                        meshes.add(mesh);
                        ov += mesh.positions.size();
                        ot += mesh.uvs.size();
                        on += mesh.normals.size();
                    }
                    mesh = new Mesh();
                    continue;
                }
                if (line.startsWith("vt")) {
                    data = line.split(" ");
                    mesh.uvs.add(new Vector2d(Double.parseDouble(data[1]), Double.parseDouble(data[2])));
                    continue;
                }
                if (line.startsWith("vn")) {
                    data = line.split(" ");
                    mesh.normals.add(new Vector3d(Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3])));
                    continue;
                }
                if (line.startsWith("v")) {
                    data = line.split(" ");
                    mesh.positions.add(new Vector3d(Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3])));
                    continue;
                }
                if (!line.startsWith("f")) continue;
                data = line.split(" ");
                for (int i = 1; i < data.length; ++i) {
                    String[] idata = data[i].split("/");
                    mesh.indices.add(new Vector3i(Integer.parseInt(idata[0]) - ov, Integer.parseInt(idata[1]) - ot, Integer.parseInt(idata[2]) - on));
                }
            }
            if (mesh != null) {
                mesh.calculateOffset();
                meshes.add(mesh);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return meshes;
    }

    public static PhysicsMod getInstance() {
        return instance;
    }

    public PhysicsMod() {
        instance = this;
        this.clientConfig = Config.CLIENT;
    }

    public static void blockifyEntity(class_1937 world, class_1297 entity) {
        if (!PhysicsMod.getInstance().clientConfig.mobPhysics) {
            return;
        }
        if (PhysicsMod.getInstance().alreadyBlockified.contains(entity.method_5628()) && !(entity instanceof class_1657)) {
            return;
        }
        if (entity instanceof class_1309 && ((class_1309)entity).method_5767()) {
            return;
        }
        PhysicsMod.getInstance().alreadyBlockified.add(entity.method_5628());
        class_897 entityRenderer = class_310.method_1551().method_1561().method_3953(entity);
        class_4587 stack = new class_4587();
        if (entityRenderer instanceof class_922) {
            class_922 renderer = (class_922)entityRenderer;
            class_583 model = renderer.method_4038();
            class_243 entPos = entity.method_19538();
            stack.method_22903();
            PhysicsMod.applyTranslationRotation(stack, (class_1309)entity, renderer);
            if (model instanceof class_4595) {
                if (entity instanceof class_1309) {
                    ((class_1309)entity).method_5650();
                }
                class_4595 segmentedModel = (class_4595)model;
                for (Object part : segmentedModel.method_22960()) {
                    if (!(part instanceof class_630)) continue;
                    class_630 modelRenderer = (class_630)part;
                    PhysicsMod.addBox(stack, new class_4587(), world, entPos, modelRenderer, (class_1309)entity, renderer);
                }
            } else if (model instanceof class_4592) {
                class_630 modelRenderer;
                if (entity instanceof class_1309) {
                    ((class_1309)entity).method_5650();
                }
                class_4592 ageableModel = (class_4592)model;
                class_4587 local = new class_4587();
                if (ageableModel.field_3448) {
                    local.method_22903();
                    if (ageableModel.field_20915) {
                        float f = 1.5f / ageableModel.field_20918;
                        local.method_22905(f, f, f);
                    }
                    local.method_22904(0.0, (double)(ageableModel.field_20916 / 16.0f), (double)(ageableModel.field_20917 / 16.0f));
                }
                for (Object part : ageableModel.method_22946()) {
                    if (!(part instanceof class_630)) continue;
                    modelRenderer = (class_630)part;
                    PhysicsMod.addBox(stack, local, world, entPos, modelRenderer, (class_1309)entity, renderer);
                }
                if (ageableModel.field_3448) {
                    local.method_22909();
                    local.method_22903();
                    float bodyScale = 1.0f / ageableModel.field_20919;
                    local.method_22905(bodyScale, bodyScale, bodyScale);
                    local.method_22904(0.0, (double)(ageableModel.field_20920 / 16.0f), 0.0);
                }
                for (Object part : ageableModel.method_22948()) {
                    if (!(part instanceof class_630)) continue;
                    modelRenderer = (class_630)part;
                    PhysicsMod.addBox(stack, local, world, entPos, modelRenderer, (class_1309)entity, renderer);
                }
                if (ageableModel.field_3448) {
                    local.method_22909();
                }
            }
            stack.method_22909();
        }
    }

    private static void addBox(class_4587 stack, class_4587 local, class_1937 world, class_243 pos, class_630 modelRenderer, class_1309 entity, class_922 renderer) {
        local.method_22903();
        stack.method_22903();
        local.method_22904((double)(modelRenderer.field_3657 / 16.0f), (double)(modelRenderer.field_3656 / 16.0f), (double)(modelRenderer.field_3655 / 16.0f));
        if (modelRenderer.field_3674 != 0.0f) {
            local.method_22907(class_1160.field_20707.method_23626(modelRenderer.field_3674));
        }
        if (modelRenderer.field_3675 != 0.0f) {
            local.method_22907(class_1160.field_20705.method_23626(modelRenderer.field_3675));
        }
        if (modelRenderer.field_3654 != 0.0f) {
            local.method_22907(class_1160.field_20703.method_23626(modelRenderer.field_3654));
        }
        for (class_630 model : modelRenderer.field_3661) {
            PhysicsMod.addBox(stack, local, world, pos, model, entity, renderer);
        }
        class_1159 m = stack.method_23760().method_23761();
        class_1159 localM = local.method_23760().method_23761();
        class_4581 localNM = local.method_23760().method_23762();
        Matrix4d transformation = new Matrix4d(m.field_21652, m.field_21653, m.field_21654, m.field_21655, m.field_21656, m.field_21657, m.field_21658, m.field_21659, m.field_21660, m.field_21661, m.field_21662, m.field_21663, m.field_21664, m.field_21665, m.field_21666, m.field_21667);
        transformation.transpose();
        Vector4f[] minMax = new Vector4f[6];
        class_4668.class_4683 textureState = new class_4668.class_4683(renderer.method_3931((class_1297)entity), false, false);
        class_1160 tmpNormal = new class_1160();
        class_1162 tmpPos = new class_1162();
        for (int i = 0; i < minMax.length; ++i) {
            minMax[i] = new Vector4f();
        }
        for (class_630.class_628 box : modelRenderer.field_3663) {
            int[] remap = new int[]{5, 0, 4, 1, 3, 2};
            float volume = Math.abs(box.field_3648 - box.field_3645) / 16.0f * (Math.abs(box.field_3647 - box.field_3644) / 16.0f) * (Math.abs(box.field_3646 - box.field_3643) / 16.0f);
            if ((double)volume <= 1.0E-4) continue;
            List<Mesh> meshes = brokenBlocksLittle.get((int)(Math.random() * (double)brokenBlocksLittle.size()));
            if ((double)volume <= 0.04 || PhysicsMod.getInstance().clientConfig.mobBlockyPhysics) {
                meshes = brokenBlock;
            }
            for (int i = 0; i < box.field_3649.length; ++i) {
                float minU = 1.0f;
                float maxU = 0.0f;
                float minV = 1.0f;
                float maxV = 0.0f;
                for (class_630.class_618 vertex : box.field_3649[i].field_3502) {
                    if (vertex.field_3604 < minU) {
                        minU = vertex.field_3604;
                    }
                    if (vertex.field_3603 < minV) {
                        minV = vertex.field_3603;
                    }
                    if (vertex.field_3604 > maxU) {
                        maxU = vertex.field_3604;
                    }
                    if (!(vertex.field_3603 > maxV)) continue;
                    maxV = vertex.field_3603;
                }
                minMax[i].set(minU, maxU, minV, maxV);
            }
            for (Mesh mesh : meshes) {
                Mesh clone;
                BlockParticle particle = new BlockParticle();
                particle.textureState = textureState;
                particle.mesh = clone = new Mesh();
                particle.setTransformation(new Matrix4d(transformation));
                particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
                int count = 1;
                Vector3d offset = new Vector3d();
                for (Vector3i index : mesh.indices) {
                    int sideIndex = mesh.sides.get(index.z - 1);
                    Vector3d position = mesh.positions.get(index.x - 1);
                    Vector2d uv = mesh.uvs.get(index.y - 1);
                    Vector3d normal = mesh.normals.get(index.z - 1);
                    Vector3f color = new Vector3f(1.0f);
                    if (sideIndex == -1) {
                        if (PhysicsMod.getInstance().clientConfig.bloodPhysics && !PhysicsMod.getInstance().clientConfig.mobBlockyPhysics) {
                            color.set(0.6f, 0.0f, 0.0f);
                        }
                        sideIndex = 0;
                    }
                    tmpNormal.method_4949((float)normal.x, (float)normal.y, (float)normal.z);
                    tmpNormal.method_23215(localNM);
                    Vector4f minMaxUVs = minMax[remap[sideIndex]];
                    tmpPos.method_23851((float)net.diebuddies.engine.util.math.Math.remap(position.x + mesh.offset.x, -0.5, 0.5, (double)box.field_3645, (double)box.field_3648) / 16.0f, (float)net.diebuddies.engine.util.math.Math.remap(position.y + mesh.offset.y, -0.5, 0.5, (double)box.field_3644, (double)box.field_3647) / 16.0f, (float)net.diebuddies.engine.util.math.Math.remap(position.z + mesh.offset.z, -0.5, 0.5, (double)box.field_3643, (double)box.field_3646) / 16.0f, 1.0f);
                    tmpPos.method_22674(localM);
                    clone.indices.add(new Vector3i(count, count, count));
                    offset.add(tmpPos.method_4953(), tmpPos.method_4956(), tmpPos.method_4957());
                    ++count;
                    Vector3d posR = new Vector3d(tmpPos.method_4953(), tmpPos.method_4956(), tmpPos.method_4957());
                    clone.positions.add(posR);
                    clone.uvs.add(new Vector2d(net.diebuddies.engine.util.math.Math.remap((float)uv.x, 1.0f, 0.0f, minMaxUVs.x, minMaxUVs.y), net.diebuddies.engine.util.math.Math.remap((float)uv.y, 0.0f, 1.0f, minMaxUVs.z, minMaxUVs.w)));
                    clone.normals.add(new Vector3d(tmpNormal.method_4943(), tmpNormal.method_4945(), tmpNormal.method_4947()));
                    clone.colors.add(color);
                }
                offset.div(clone.positions.size());
                for (Vector3d position : clone.positions) {
                    position.sub(offset);
                }
                clone.offset = offset;
                PhysicsMod.getInstance().entityBlocks.add(particle);
            }
        }
        local.method_22909();
        stack.method_22909();
    }

    private static void applyTranslationRotation(class_4587 stack, class_1309 entityIn, class_922 renderer) {
        class_2350 direction;
        float partialTicks = class_310.method_1551().method_1488();
        double px = class_3532.method_16436((double)partialTicks, (double)entityIn.field_6014, (double)entityIn.method_23317());
        double py = class_3532.method_16436((double)partialTicks, (double)entityIn.field_6036, (double)entityIn.method_23318());
        double pz = class_3532.method_16436((double)partialTicks, (double)entityIn.field_5969, (double)entityIn.method_23321());
        stack.method_22904(px, py, pz);
        renderer.method_4038().field_3447 = renderer.method_4044(entityIn, partialTicks);
        renderer.method_4038().field_3449 = entityIn.method_5765();
        renderer.method_4038().field_3448 = entityIn.method_6109();
        float h = class_3532.method_17821((float)partialTicks, (float)entityIn.field_6220, (float)entityIn.field_6283);
        float j = class_3532.method_17821((float)partialTicks, (float)entityIn.field_6259, (float)entityIn.field_6241);
        float k = j - h;
        if (entityIn.method_5765() && entityIn.method_5854() instanceof class_1309) {
            class_1309 livingEntity2 = (class_1309)entityIn.method_5854();
            h = class_3532.method_17821((float)partialTicks, (float)livingEntity2.field_6220, (float)livingEntity2.field_6283);
            k = j - h;
            float l = class_3532.method_15393((float)k);
            if (l < -85.0f) {
                l = -85.0f;
            }
            if (l >= 85.0f) {
                l = 85.0f;
            }
            h = j - l;
            if (l * l > 2500.0f) {
                h += l * 0.2f;
            }
            k = j - h;
        }
        float m = class_3532.method_16439((float)partialTicks, (float)entityIn.field_6004, (float)entityIn.field_5965);
        if (entityIn.method_18376() == class_4050.field_18078 && (direction = entityIn.method_18401()) != null) {
            float n = entityIn.method_18381(class_4050.field_18076) - 0.1f;
            stack.method_22904((double)((float)(-direction.method_10148()) * n), 0.0, (double)((float)(-direction.method_10165()) * n));
        }
        float o = renderer.method_4045(entityIn, partialTicks);
        renderer.method_4058(entityIn, stack, o, h, partialTicks);
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        renderer.method_4042(entityIn, stack, partialTicks);
        stack.method_22904(0.0, (double)-1.501f, 0.0);
        float p = 0.0f;
        float q = 0.0f;
        if (!entityIn.method_5765() && entityIn.method_5805()) {
            p = class_3532.method_16439((float)partialTicks, (float)entityIn.field_6211, (float)entityIn.field_6225);
            q = entityIn.field_6249 - entityIn.field_6225 * (1.0f - partialTicks);
            if (entityIn.method_6109()) {
                q *= 3.0f;
            }
            if (p > 1.0f) {
                p = 1.0f;
            }
        }
        renderer.method_4038().method_2816((class_1297)entityIn, q, p, partialTicks);
        renderer.method_4038().method_2819((class_1297)entityIn, q, p, o, k, m);
    }

    static {
        brokenBlocksLittle = new ArrayList<List<Mesh>>();
        brokenBlocksLots = new ArrayList<List<Mesh>>();
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physics_shattered_little_1.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physics_shattered_little_2.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physics_shattered_little_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_2.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_4.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_5.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_6.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_7.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_8.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_9.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_10.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_11.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_12.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_13.obj"));
        brokenBlock = PhysicsMod.readBlock("assets/physics_simple.obj");
    }
}

