/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.diebuddies.engine.util.math.Math;
import net.diebuddies.engine.util.math.Vector3i;
import net.diebuddies.physics.BlockParticle;
import net.diebuddies.physics.BoxRigidBody;
import net.diebuddies.physics.ConvexRigidBody;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import org.joml.Matrix4d;
import org.joml.Vector3d;

public class PhysicsWorld {
    private static final int CHUNK_SIZE = 2;
    private static final double CHUNK_UNLOAD_TIME = 1000.0;
    private DynamicsWorld dynamicsWorld;
    private class_1937 world;
    private List<IRigidBody> bodies;
    private Map<Vector3i, Long> loadedChunks;
    private Map<Vector3i, List<IRigidBody>> chunkBodies;
    private IRigidBody player;
    private double renderPercent;
    private List<Explosion> explosions = new ArrayList<Explosion>();
    private Set<Vector3i> chunkUpdates = new HashSet<Vector3i>();
    private Vector3d offset;

    public PhysicsWorld(class_1937 world) {
        this.dynamicsWorld = new DynamicsWorld(0.025f);
        this.world = world;
        this.bodies = new ArrayList<IRigidBody>();
        this.loadedChunks = new HashMap<Vector3i, Long>();
        this.chunkBodies = new HashMap<Vector3i, List<IRigidBody>>();
        this.offset = new Vector3d();
    }

    public void update(double diff) {
        this.checkChunksToUnload();
        if (this.player == null) {
            this.player = BoxRigidBody.create(new PhysicsEntity(), 0.6f, 2.0f, 0.6f, true);
            this.player.getRigidBody().setGravity(new Vector3(0.0f, 0.0f, 0.0f));
            this.dynamicsWorld.getPhysics().addRigidBody(this.player.getRigidBody(), 1, 1);
        } else {
            btRigidBody rigidBody = this.player.getRigidBody();
            Matrix4 tmpPhysics = new Matrix4();
            if (class_310.method_1551().field_1724 != null) {
                class_243 position = class_310.method_1551().field_1724.method_19538();
                rigidBody.setWorldTransform(tmpPhysics.translate((float)(position.field_1352 - this.offset.x), (float)(position.field_1351 + 1.0 - this.offset.y), (float)(position.field_1350 - this.offset.z)));
            }
        }
        boolean updated = this.dynamicsWorld.update(diff);
        this.renderPercent = this.dynamicsWorld.getTime() / (double)this.dynamicsWorld.getFixedTimeStep();
        if (updated) {
            this.checkLoadedChunks();
            for (IRigidBody body : this.bodies) {
                class_2680 above;
                body.updatePositions(diff);
                if (body.entity instanceof BlockParticle && ((BlockParticle)body.getEntity()).spawned) {
                    ((BlockParticle)body.getEntity()).spawned = false;
                    float strength = 9.0f;
                    body.getRigidBody().setLinearVelocity(new Vector3((float)(java.lang.Math.random() - 0.5) * strength, (float)(java.lang.Math.random() - 0.5) * strength, (float)(java.lang.Math.random() - 0.5) * strength));
                }
                Vector3d pos = body.getEntity().getTransformation().getTranslation(new Vector3d()).add(this.offset.x, this.offset.y, this.offset.z);
                class_2338 blockPos = new class_2338(pos.x, pos.y, pos.z);
                class_2680 state = this.world.method_8320(blockPos);
                body.getRigidBody().setGravity(DynamicsWorld.GRAVITY.cpy());
                if (state.method_26204() != class_2246.field_10382 && state.method_26204() != class_2246.field_10164) continue;
                float height = state.method_26227().method_20785();
                if (this.world.method_8477(blockPos.method_10084()) && ((above = this.world.method_8320(blockPos.method_10084())).method_26204() == class_2246.field_10382 || above.method_26204() == class_2246.field_10164)) {
                    height = 1.0f;
                }
                if (!(pos.y % 1.0 < (double)height)) continue;
                class_243 direction = state.method_26227().method_15758((class_1922)this.world, blockPos);
                body.getRigidBody().setGravity(DynamicsWorld.WATER_GRAVITY.cpy());
                Vector3 v = body.getRigidBody().getLinearVelocity();
                float damping = 0.95f;
                float aDamping = 0.95f;
                float flowStrength = 0.1f;
                body.getRigidBody().setLinearVelocity(new Vector3(v.x * damping + (float)direction.field_1352 * flowStrength, v.y * damping + (float)direction.field_1351 * flowStrength, v.z * damping + (float)direction.field_1350 * flowStrength));
                Vector3 a = body.getRigidBody().getAngularVelocity();
                body.getRigidBody().setAngularVelocity(new Vector3(a.x * aDamping, a.y * aDamping, a.z * aDamping));
            }
            Iterator<Explosion> itE = this.explosions.iterator();
            while (itE.hasNext()) {
                Explosion explosion = itE.next();
                if (explosion.tickDelay == 0) {
                    this.executeExplosion(explosion);
                    itE.remove();
                }
                --explosion.tickDelay;
            }
        }
        this.chunkUpdates.clear();
        Iterator<IRigidBody> it = this.bodies.iterator();
        while (it.hasNext()) {
            IRigidBody body;
            body = it.next();
            if (!(body.entity instanceof BlockParticle)) continue;
            ((BlockParticle)body.entity).time -= diff;
            if (!(((BlockParticle)body.entity).time < 0.0)) continue;
            this.dynamicsWorld.getPhysics().removeRigidBody(body.getRigidBody());
            body.destroy();
            it.remove();
        }
    }

    private void checkLoadedChunks() {
        HashSet<Vector3i> positions = new HashSet<Vector3i>();
        HashSet<Vector3i> shouldLoadChunks = new HashSet<Vector3i>();
        Vector3d pos = new Vector3d();
        long time = System.nanoTime();
        for (IRigidBody body : this.bodies) {
            body.getEntity().getTransformation().getTranslation(pos).add(this.offset);
            int cx = pos.x < 0.0 ? (int)((pos.x + 1.0) / 2.0) - 1 : (int)(pos.x / 2.0);
            int cy = pos.y < 0.0 ? (int)((pos.y + 1.0) / 2.0) - 1 : (int)(pos.y / 2.0);
            int cz = pos.z < 0.0 ? (int)((pos.z + 1.0) / 2.0) - 1 : (int)(pos.z / 2.0);
            positions.add(new Vector3i(cx, cy, cz));
        }
        for (Vector3i position : positions) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        shouldLoadChunks.add(new Vector3i(position.x + x, position.y + y, position.z + z));
                    }
                }
            }
        }
        Iterator it = shouldLoadChunks.iterator();
        while (it.hasNext()) {
            Vector3i loaded = (Vector3i)it.next();
            if (this.loadedChunks.containsKey(loaded)) {
                it.remove();
            } else {
                this.loadChunk(loaded);
            }
            this.loadedChunks.put(loaded, time);
        }
    }

    private void checkChunksToUnload() {
        long time = System.nanoTime();
        Iterator<Map.Entry<Vector3i, Long>> itMap = this.loadedChunks.entrySet().iterator();
        while (itMap.hasNext()) {
            Map.Entry<Vector3i, Long> entry = itMap.next();
            if (!((double)(time - entry.getValue()) / 1000000.0 > 1000.0)) continue;
            this.unloadChunk(entry.getKey());
            itMap.remove();
        }
    }

    private void unloadChunk(Vector3i chunkPos) {
        List<IRigidBody> bodies = this.chunkBodies.remove(chunkPos);
        if (bodies != null) {
            for (IRigidBody body : bodies) {
                this.dynamicsWorld.getPhysics().removeRigidBody(body.getRigidBody());
                body.destroy();
            }
        }
    }

    public void blockUpdate(class_2338 pos) {
        int cx = pos.method_10263() < 0 ? (int)((double)(pos.method_10263() + 1) / 2.0) - 1 : (int)((double)pos.method_10263() / 2.0);
        int cy = pos.method_10264() < 0 ? (int)((double)(pos.method_10264() + 1) / 2.0) - 1 : (int)((double)pos.method_10264() / 2.0);
        int cz = pos.method_10260() < 0 ? (int)((double)(pos.method_10260() + 1) / 2.0) - 1 : (int)((double)pos.method_10260() / 2.0);
        int ax = pos.method_10263() < 0 ? 2 + (pos.method_10263() + 1) % 2 - 1 : pos.method_10263() % 2;
        int ay = pos.method_10264() < 0 ? 2 + (pos.method_10264() + 1) % 2 - 1 : pos.method_10264() % 2;
        int az = pos.method_10260() < 0 ? 2 + (pos.method_10260() + 1) % 2 - 1 : pos.method_10260() % 2;
        this.updateChunk(cx, cy, cz);
        if (ax == 0) {
            this.updateChunk(cx - 1, cy, cz);
        }
        if (ay == 0) {
            this.updateChunk(cx, cy - 1, cz);
        }
        if (az == 0) {
            this.updateChunk(cx, cy, cz - 1);
        }
        if (ax == 1) {
            this.updateChunk(cx + 1, cy, cz);
        }
        if (ay == 1) {
            this.updateChunk(cx, cy + 1, cz);
        }
        if (az == 1) {
            this.updateChunk(cx, cy, cz + 1);
        }
    }

    private void updateChunk(int cx, int cy, int cz) {
        Vector3i chunkPos = new Vector3i(cx, cy, cz);
        if (this.chunkUpdates.contains(chunkPos)) {
            return;
        }
        this.chunkUpdates.add(chunkPos);
        if (this.loadedChunks.containsKey(chunkPos)) {
            this.unloadChunk(chunkPos);
            this.loadChunk(chunkPos);
        }
    }

    private void loadChunk(Vector3i chunkPos) {
        if (chunkPos.y < 0 || chunkPos.y >= 128) {
            return;
        }
        List<IRigidBody> bodies = this.chunkBodies.get(chunkPos);
        if (bodies == null) {
            bodies = new ArrayList<IRigidBody>();
            this.chunkBodies.put(chunkPos, bodies);
        }
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    class_2338 pos = new class_2338(chunkPos.x * 2 + x, chunkPos.y * 2 + y, chunkPos.z * 2 + z);
                    class_2680 state = this.world.method_8320(pos);
                    class_265 voxelShape = state.method_26220((class_1922)this.world, pos);
                    if (voxelShape.method_1110() || !this.areNeighboursEmpty(this.world, pos)) continue;
                    for (class_238 aabb : voxelShape.method_1090()) {
                        PhysicsEntity entity = new PhysicsEntity();
                        double width = aabb.field_1320 - aabb.field_1323;
                        double height = aabb.field_1325 - aabb.field_1322;
                        double depth = aabb.field_1324 - aabb.field_1321;
                        entity.getTransformation().translate((double)pos.method_10263() + aabb.field_1323 + width / 2.0 - this.offset.x, (double)pos.method_10264() + aabb.field_1322 + height / 2.0 - this.offset.y, (double)pos.method_10260() + aabb.field_1321 + depth / 2.0 - this.offset.z);
                        BoxRigidBody body = BoxRigidBody.create(entity, (float)width, (float)height, (float)depth, false);
                        this.dynamicsWorld.getPhysics().addRigidBody(body.getRigidBody(), 1, 1);
                        bodies.add(body);
                    }
                }
            }
        }
    }

    private boolean areNeighboursEmpty(class_1937 world, class_2338 pos) {
        return pos.method_10264() < 255 && (!world.method_8320(pos.method_10084()).method_26225() || world.method_8320(pos.method_10084()).method_26204() == class_2246.field_10477) || pos.method_10264() > 0 && (!world.method_8320(pos.method_10074()).method_26225() || world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10477) || !world.method_8320(pos.method_10095()).method_26225() || world.method_8320(pos.method_10095()).method_26204() == class_2246.field_10477 || !world.method_8320(pos.method_10078()).method_26225() || world.method_8320(pos.method_10078()).method_26204() == class_2246.field_10477 || !world.method_8320(pos.method_10072()).method_26225() || world.method_8320(pos.method_10072()).method_26204() == class_2246.field_10477 || !world.method_8320(pos.method_10067()).method_26225() || world.method_8320(pos.method_10067()).method_26204() == class_2246.field_10477;
    }

    public void destroy() {
        for (IRigidBody iRigidBody : this.bodies) {
            this.dynamicsWorld.getPhysics().removeRigidBody(iRigidBody.getRigidBody());
            iRigidBody.destroy();
        }
        for (Map.Entry entry : this.chunkBodies.entrySet()) {
            for (IRigidBody body : (List)entry.getValue()) {
                this.dynamicsWorld.getPhysics().removeRigidBody(body.getRigidBody());
                body.destroy();
            }
        }
        if (this.player != null) {
            this.dynamicsWorld.getPhysics().removeRigidBody(this.player.getRigidBody());
            this.player.destroy();
        }
        this.dynamicsWorld.destroy();
        this.chunkBodies.clear();
        this.loadedChunks.clear();
        this.bodies.clear();
    }

    public void addBlockParticle(List<Mesh> brokenBlock, BlockParticle particle) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        for (Mesh mesh : brokenBlock) {
            BlockParticle broken = new BlockParticle();
            broken.texture = particle.texture;
            broken.color = particle.color;
            broken.textureState = particle.textureState;
            broken.setTransformation(new Matrix4d(particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate(mesh.offset));
            broken.setOldTransformation(new Matrix4d(broken.getTransformation()));
            broken.mesh = mesh;
            broken.scale = particle.scale;
            broken.time = PhysicsMod.getInstance().clientConfig.particleLifetime + java.lang.Math.random() * 3.0;
            ConvexRigidBody body = ConvexRigidBody.create(broken, 1.0f, 1.0f, 1.0f, true);
            this.bodies.add(body);
            this.dynamicsWorld.getPhysics().addRigidBody(body.getRigidBody(), 1, 1);
        }
    }

    public void addBlockParticle(BlockParticle particle) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        BlockParticle broken = particle;
        broken.setTransformation(new Matrix4d(particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate(particle.mesh.offset));
        broken.setOldTransformation(new Matrix4d(broken.getTransformation()));
        broken.scale = particle.scale;
        broken.time = PhysicsMod.getInstance().clientConfig.particleLifetime + java.lang.Math.random() * 3.0;
        ConvexRigidBody body = ConvexRigidBody.create(broken, 1.0f, 1.0f, 1.0f, true);
        this.bodies.add(body);
        this.dynamicsWorld.getPhysics().addRigidBody(body.getRigidBody(), 1, 1);
    }

    public List<IRigidBody> getBodies() {
        return this.bodies;
    }

    public Map<Vector3i, List<IRigidBody>> getChunkBodies() {
        return this.chunkBodies;
    }

    public double getRenderPercent() {
        return this.renderPercent;
    }

    public void applyExplosion(Explosion explosion) {
        this.explosions.add(explosion);
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public void executeExplosion(Explosion explosion) {
        for (IRigidBody body : this.bodies) {
            double distance = explosion.position.distance(body.getEntity().getTransformation().getTranslation(new Vector3d()).add(this.offset));
            Vector3d direction = body.getEntity().getTransformation().getTranslation(new Vector3d()).add(this.offset).sub(explosion.position).normalize();
            direction.y += 2.0;
            direction.normalize();
            double realStrength = 1.0 - Math.clamp(distance / ((double)explosion.strength * 2.0), 0.0, 1.0);
            body.getRigidBody().activate();
            Vector3 v = body.getRigidBody().getLinearVelocity();
            body.getRigidBody().setLinearVelocity(new Vector3((float)(direction.x * (realStrength *= 15.0)), (float)(direction.y * realStrength), (float)(direction.z * realStrength)).add(v));
        }
    }
}

