/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.11
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION)
#include <iostream>
#endif

#include <exception>

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    const char *message() const {
      return message_.c_str("Could not get exception message in JavaExceptionMessage");
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (throwable) {
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message());
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : classname_(0), msg_(copystr(msg ? msg : "Unspecified DirectorException message")) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_;
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void raiseJavaException(JNIEnv *jenv) const {
      if (jenv) {
	jenv->ExceptionClear();

	jmethodID ctorMethodID = 0;
	jclass throwableclass = 0;
        if (classname_) {
          throwableclass = jenv->FindClass(classname_);
          if (throwableclass)
            ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
	}

	if (ctorMethodID) {
	  jenv->ThrowNew(throwableclass, what());
	} else {
	  SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
	}
      }
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  SWIGINTERN inline bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_ExtrasJNI = NULL;
    jmethodID director_method_ids[43];
  }
}

#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <gdx/common/jniHelpers.h>


#include <stdint.h>


#include <gdx/linearmath/mathtypes.h>
#include <LinearMath/btVector3.h>
#include <LinearMath/btQuaternion.h>
#include <LinearMath/btMatrix3x3.h>
#include <LinearMath/btTransform.h>


#include <BulletWorldImporter/btWorldImporter.h>
#include <BulletWorldImporter/btBulletWorldImporter.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassVector3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectVector3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectVector3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseVector3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseVector3() {
		gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Vector3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnVector3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassVector3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticVector3", "Lcom/badlogic/gdx/math/Vector3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 & target, jobject source) {
		Vector3_to_btVector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 * target, jobject source) {
		gdx_setbtVector3FromVector3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 & source) {
		btVector3_to_Vector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 * source) {
		gdx_setVector3FrombtVector3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btVector3 back to Vector3
	 */
	class gdxAutoCommitVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	public:
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3) { };
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3) { };
	  virtual ~gdxAutoCommitVector3() {
	    gdx_setVector3FrombtVector3(this->jenv, this->jVector3, this->cbtVector3);
	  };
	};

	class gdxAutoCommitbtVector3AndReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3), poolName(poolName) { };
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtVector3AndReleaseVector3() {
	    gdx_setbtVector3FromVector3(this->jenv, this->cbtVector3, this->jVector3);
	    gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->jVector3);
	  };
	};



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix4(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix4(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix4() {
		gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix4.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix4(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix4(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix4", "Lcom/badlogic/gdx/math/Matrix4;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform & target, jobject source) {
		Matrix4_to_btTransform(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform * target, jobject source) {
		gdx_setbtTransformFromMatrix4(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform & source) {
		btTransform_to_Matrix4(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform * source) {
		gdx_setMatrix4FrombtTransform(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btTransform back to Matrix4
	 */
	class gdxAutoCommitMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	public:
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform) { };
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform) { };
	  virtual ~gdxAutoCommitMatrix4() {
	    gdx_setMatrix4FrombtTransform(this->jenv, this->jMatrix4, this->cbtTransform);
	  };
	};

	class gdxAutoCommitbtTransformAndReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	  const char * poolName;
	public:
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform), poolName(poolName) { };
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtTransformAndReleaseMatrix4() {
	    gdx_setbtTransformFromMatrix4(this->jenv, this->cbtTransform, this->jMatrix4);
	    gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->jMatrix4);
	  };
	};

SWIGINTERN bool btBulletWorldImporter_loadFileFromMemory__SWIG_1(btBulletWorldImporter *self,unsigned char *memoryBuffer,int len){
		return self->loadFileFromMemory((char *)memoryBuffer, len);
	}

#include <InverseDynamics/MultiBodyTreeCreator.hpp>


#include <InverseDynamics/CoilCreator.hpp>


#include <InverseDynamics/CloneTreeCreator.hpp>


#include <InverseDynamics/DillCreator.hpp>


#include <InverseDynamics/btMultiBodyTreeCreator.hpp>


#include <InverseDynamics/IDRandomUtil.hpp>


#include <InverseDynamics/MultiBodyNameMap.hpp>


#include <InverseDynamics/MultiBodyTreeDebugGraph.hpp>


#include <InverseDynamics/RandomTreeCreator.hpp>


#include <InverseDynamics/SimpleTreeCreator.hpp>


#include <InverseDynamics/User2InternalIndex.hpp>


#include <InverseDynamics/BulletInverseDynamicsUtilsCommon.h>


#include <InverseDynamics/invdyn_bullet_comparison.hpp>


using namespace btInverseDynamicsBullet3;
using namespace btInverseDynamics;



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "extras_wrap.h"

SwigDirector_btBulletWorldImporter::SwigDirector_btBulletWorldImporter(JNIEnv *jenv, btDynamicsWorld *world) : btBulletWorldImporter(world), Swig::Director(jenv) {
}

SwigDirector_btBulletWorldImporter::~SwigDirector_btBulletWorldImporter() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btBulletWorldImporter::deleteAllData() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    btWorldImporter::deleteAllData();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[0], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::deleteAllData ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btBulletWorldImporter::setDynamicsWorldInfo(btVector3 const &gravity, btContactSolverInfo const &solverInfo) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jgravity = 0 ;
  jlong jsolverInfo = 0 ;
  
  if (!swig_override[1]) {
    btWorldImporter::setDynamicsWorldInfo(gravity,solverInfo);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jgravity = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jgravity, gravity);
    gdxPoolAutoReleaseVector3 autoRelease_jgravity(jenv, "poolVector3", jgravity);
    *(btContactSolverInfo **)&jsolverInfo = (btContactSolverInfo *) &solverInfo; 
    jenv->CallStaticVoidMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[1], swigjobj, jgravity, jsolverInfo);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::setDynamicsWorldInfo ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

btRigidBody *SwigDirector_btBulletWorldImporter::createRigidBody(bool isDynamic, btScalar mass, btTransform const &startTransform, btCollisionShape *shape, char const *bodyName) {
  btRigidBody *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jboolean jisDynamic  ;
  jfloat jmass  ;
  jobject jstartTransform = 0 ;
  jlong jshape = 0 ;
  jstring jbodyName = 0 ;
  
  if (!swig_override[2]) {
    return btWorldImporter::createRigidBody(isDynamic,mass,startTransform,shape,bodyName);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jisDynamic = (jboolean) isDynamic;
    jmass = (jfloat) mass;
    jstartTransform = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jstartTransform, startTransform);
    gdxPoolAutoReleaseMatrix4 autoRelease_jstartTransform(jenv, "poolMatrix4", jstartTransform);
    *((btCollisionShape **)&jshape) = (btCollisionShape *) shape; 
    jbodyName = 0;
    if (bodyName) {
      jbodyName = jenv->NewStringUTF((const char *)bodyName);
      if (!jbodyName) return c_result;
    }
    Swig::LocalRefGuard bodyName_refguard(jenv, jbodyName);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[2], swigjobj, jisDynamic, jmass, jstartTransform, jshape, jbodyName);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btRigidBody **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createRigidBody ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionObject *SwigDirector_btBulletWorldImporter::createCollisionObject(btTransform const &startTransform, btCollisionShape *shape, char const *bodyName) {
  btCollisionObject *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jstartTransform = 0 ;
  jlong jshape = 0 ;
  jstring jbodyName = 0 ;
  
  if (!swig_override[3]) {
    return btWorldImporter::createCollisionObject(startTransform,shape,bodyName);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jstartTransform = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jstartTransform, startTransform);
    gdxPoolAutoReleaseMatrix4 autoRelease_jstartTransform(jenv, "poolMatrix4", jstartTransform);
    *((btCollisionShape **)&jshape) = (btCollisionShape *) shape; 
    jbodyName = 0;
    if (bodyName) {
      jbodyName = jenv->NewStringUTF((const char *)bodyName);
      if (!jbodyName) return c_result;
    }
    Swig::LocalRefGuard bodyName_refguard(jenv, jbodyName);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[3], swigjobj, jstartTransform, jshape, jbodyName);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionObject **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createCollisionObject ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createPlaneShape(btVector3 const &planeNormal, btScalar planeConstant) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jplaneNormal = 0 ;
  jfloat jplaneConstant  ;
  
  if (!swig_override[4]) {
    return btWorldImporter::createPlaneShape(planeNormal,planeConstant);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jplaneNormal = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jplaneNormal, planeNormal);
    gdxPoolAutoReleaseVector3 autoRelease_jplaneNormal(jenv, "poolVector3", jplaneNormal);
    jplaneConstant = (jfloat) planeConstant;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[4], swigjobj, jplaneNormal, jplaneConstant);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createPlaneShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createBoxShape(btVector3 const &halfExtents) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jhalfExtents = 0 ;
  
  if (!swig_override[5]) {
    return btWorldImporter::createBoxShape(halfExtents);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jhalfExtents = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jhalfExtents, halfExtents);
    gdxPoolAutoReleaseVector3 autoRelease_jhalfExtents(jenv, "poolVector3", jhalfExtents);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[5], swigjobj, jhalfExtents);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createBoxShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createSphereShape(btScalar radius) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  
  if (!swig_override[6]) {
    return btWorldImporter::createSphereShape(radius);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[6], swigjobj, jradius);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createSphereShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCapsuleShapeX(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[7]) {
    return btWorldImporter::createCapsuleShapeX(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[7], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createCapsuleShapeX ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCapsuleShapeY(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[8]) {
    return btWorldImporter::createCapsuleShapeY(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[8], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createCapsuleShapeY ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCapsuleShapeZ(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[9]) {
    return btWorldImporter::createCapsuleShapeZ(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[9], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createCapsuleShapeZ ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCylinderShapeX(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[10]) {
    return btWorldImporter::createCylinderShapeX(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[10], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createCylinderShapeX ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCylinderShapeY(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[11]) {
    return btWorldImporter::createCylinderShapeY(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[11], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createCylinderShapeY ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createCylinderShapeZ(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[12]) {
    return btWorldImporter::createCylinderShapeZ(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[12], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createCylinderShapeZ ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createConeShapeX(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[13]) {
    return btWorldImporter::createConeShapeX(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[13], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createConeShapeX ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createConeShapeY(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[14]) {
    return btWorldImporter::createConeShapeY(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[14], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createConeShapeY ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createConeShapeZ(btScalar radius, btScalar height) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  
  if (!swig_override[15]) {
    return btWorldImporter::createConeShapeZ(radius,height);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[15], swigjobj, jradius, jheight);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createConeShapeZ ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btTriangleIndexVertexArray *SwigDirector_btBulletWorldImporter::createTriangleMeshContainer() {
  btTriangleIndexVertexArray *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[16]) {
    return btWorldImporter::createTriangleMeshContainer();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[16], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btTriangleIndexVertexArray **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createTriangleMeshContainer ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btBvhTriangleMeshShape *SwigDirector_btBulletWorldImporter::createBvhTriangleMeshShape(btStridingMeshInterface *trimesh, btOptimizedBvh *bvh) {
  btBvhTriangleMeshShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtrimesh = 0 ;
  jlong jbvh = 0 ;
  
  if (!swig_override[17]) {
    return btWorldImporter::createBvhTriangleMeshShape(trimesh,bvh);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btStridingMeshInterface **)&jtrimesh) = (btStridingMeshInterface *) trimesh; 
    *((btOptimizedBvh **)&jbvh) = (btOptimizedBvh *) bvh; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[17], swigjobj, jtrimesh, jbvh);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btBvhTriangleMeshShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createBvhTriangleMeshShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCollisionShape *SwigDirector_btBulletWorldImporter::createConvexTriangleMeshShape(btStridingMeshInterface *trimesh) {
  btCollisionShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtrimesh = 0 ;
  
  if (!swig_override[18]) {
    return btWorldImporter::createConvexTriangleMeshShape(trimesh);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btStridingMeshInterface **)&jtrimesh) = (btStridingMeshInterface *) trimesh; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[18], swigjobj, jtrimesh);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCollisionShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createConvexTriangleMeshShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGImpactMeshShape *SwigDirector_btBulletWorldImporter::createGimpactShape(btStridingMeshInterface *trimesh) {
  btGImpactMeshShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtrimesh = 0 ;
  
  if (!swig_override[19]) {
    return btWorldImporter::createGimpactShape(trimesh);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btStridingMeshInterface **)&jtrimesh) = (btStridingMeshInterface *) trimesh; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[19], swigjobj, jtrimesh);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btGImpactMeshShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createGimpactShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btStridingMeshInterfaceData *SwigDirector_btBulletWorldImporter::createStridingMeshInterfaceData(btStridingMeshInterfaceData *interfaceData) {
  btStridingMeshInterfaceData *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jinterfaceData = 0 ;
  
  if (!swig_override[20]) {
    return btWorldImporter::createStridingMeshInterfaceData(interfaceData);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btStridingMeshInterfaceData **)&jinterfaceData) = (btStridingMeshInterfaceData *) interfaceData; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[20], swigjobj, jinterfaceData);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btStridingMeshInterfaceData **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createStridingMeshInterfaceData ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btConvexHullShape *SwigDirector_btBulletWorldImporter::createConvexHullShape() {
  btConvexHullShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[21]) {
    return btWorldImporter::createConvexHullShape();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[21], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btConvexHullShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createConvexHullShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btCompoundShape *SwigDirector_btBulletWorldImporter::createCompoundShape() {
  btCompoundShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[22]) {
    return btWorldImporter::createCompoundShape();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[22], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btCompoundShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createCompoundShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btScaledBvhTriangleMeshShape *SwigDirector_btBulletWorldImporter::createScaledTrangleMeshShape(btBvhTriangleMeshShape *meshShape, btVector3 const &localScalingbtBvhTriangleMeshShape) {
  btScaledBvhTriangleMeshShape *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmeshShape = 0 ;
  jobject jlocalScalingbtBvhTriangleMeshShape = 0 ;
  
  if (!swig_override[23]) {
    return btWorldImporter::createScaledTrangleMeshShape(meshShape,localScalingbtBvhTriangleMeshShape);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btBvhTriangleMeshShape **)&jmeshShape) = (btBvhTriangleMeshShape *) meshShape; 
    jlocalScalingbtBvhTriangleMeshShape = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jlocalScalingbtBvhTriangleMeshShape, localScalingbtBvhTriangleMeshShape);
    gdxPoolAutoReleaseVector3 autoRelease_jlocalScalingbtBvhTriangleMeshShape(jenv, "poolVector3", jlocalScalingbtBvhTriangleMeshShape);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[23], swigjobj, jmeshShape, jlocalScalingbtBvhTriangleMeshShape);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btScaledBvhTriangleMeshShape **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createScaledTrangleMeshShape ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btTriangleIndexVertexArray *SwigDirector_btBulletWorldImporter::createMeshInterface(btStridingMeshInterfaceData &meshData) {
  btTriangleIndexVertexArray *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmeshData = 0 ;
  
  if (!swig_override[24]) {
    return btWorldImporter::createMeshInterface(meshData);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btStridingMeshInterfaceData **)&jmeshData = (btStridingMeshInterfaceData *) &meshData; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[24], swigjobj, jmeshData);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btTriangleIndexVertexArray **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createMeshInterface ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btOptimizedBvh *SwigDirector_btBulletWorldImporter::createOptimizedBvh() {
  btOptimizedBvh *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[25]) {
    return btWorldImporter::createOptimizedBvh();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[25], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btOptimizedBvh **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createOptimizedBvh ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btTriangleInfoMap *SwigDirector_btBulletWorldImporter::createTriangleInfoMap() {
  btTriangleInfoMap *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[26]) {
    return btWorldImporter::createTriangleInfoMap();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[26], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btTriangleInfoMap **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createTriangleInfoMap ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btPoint2PointConstraint *SwigDirector_btBulletWorldImporter::createPoint2PointConstraint(btRigidBody &rbA, btRigidBody &rbB, btVector3 const &pivotInA, btVector3 const &pivotInB) {
  btPoint2PointConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jpivotInA = 0 ;
  jobject jpivotInB = 0 ;
  
  if (!swig_override[27]) {
    return btWorldImporter::createPoint2PointConstraint(rbA,rbB,pivotInA,pivotInB);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jpivotInA = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jpivotInA, pivotInA);
    gdxPoolAutoReleaseVector3 autoRelease_jpivotInA(jenv, "poolVector3", jpivotInA);
    jpivotInB = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jpivotInB, pivotInB);
    gdxPoolAutoReleaseVector3 autoRelease_jpivotInB(jenv, "poolVector3", jpivotInB);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[27], swigjobj, jrbA, jrbB, jpivotInA, jpivotInB);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btPoint2PointConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createPoint2PointConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btPoint2PointConstraint *SwigDirector_btBulletWorldImporter::createPoint2PointConstraint(btRigidBody &rbA, btVector3 const &pivotInA) {
  btPoint2PointConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jobject jpivotInA = 0 ;
  
  if (!swig_override[28]) {
    return btWorldImporter::createPoint2PointConstraint(rbA,pivotInA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    jpivotInA = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jpivotInA, pivotInA);
    gdxPoolAutoReleaseVector3 autoRelease_jpivotInA(jenv, "poolVector3", jpivotInA);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[28], swigjobj, jrbA, jpivotInA);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btPoint2PointConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createPoint2PointConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btHingeConstraint *SwigDirector_btBulletWorldImporter::createHingeConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &rbAFrame, btTransform const &rbBFrame, bool useReferenceFrameA) {
  btHingeConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jrbAFrame = 0 ;
  jobject jrbBFrame = 0 ;
  jboolean juseReferenceFrameA  ;
  
  if (!swig_override[29]) {
    return btWorldImporter::createHingeConstraint(rbA,rbB,rbAFrame,rbBFrame,useReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jrbAFrame = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbAFrame, rbAFrame);
    gdxPoolAutoReleaseMatrix4 autoRelease_jrbAFrame(jenv, "poolMatrix4", jrbAFrame);
    jrbBFrame = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbBFrame, rbBFrame);
    gdxPoolAutoReleaseMatrix4 autoRelease_jrbBFrame(jenv, "poolMatrix4", jrbBFrame);
    juseReferenceFrameA = (jboolean) useReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[29], swigjobj, jrbA, jrbB, jrbAFrame, jrbBFrame, juseReferenceFrameA);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btHingeConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createHingeConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btHingeConstraint *SwigDirector_btBulletWorldImporter::createHingeConstraint(btRigidBody &rbA, btTransform const &rbAFrame, bool useReferenceFrameA) {
  btHingeConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jobject jrbAFrame = 0 ;
  jboolean juseReferenceFrameA  ;
  
  if (!swig_override[31]) {
    return btWorldImporter::createHingeConstraint(rbA,rbAFrame,useReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    jrbAFrame = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbAFrame, rbAFrame);
    gdxPoolAutoReleaseMatrix4 autoRelease_jrbAFrame(jenv, "poolMatrix4", jrbAFrame);
    juseReferenceFrameA = (jboolean) useReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[31], swigjobj, jrbA, jrbAFrame, juseReferenceFrameA);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btHingeConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createHingeConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btConeTwistConstraint *SwigDirector_btBulletWorldImporter::createConeTwistConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &rbAFrame, btTransform const &rbBFrame) {
  btConeTwistConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jrbAFrame = 0 ;
  jobject jrbBFrame = 0 ;
  
  if (!swig_override[33]) {
    return btWorldImporter::createConeTwistConstraint(rbA,rbB,rbAFrame,rbBFrame);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jrbAFrame = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbAFrame, rbAFrame);
    gdxPoolAutoReleaseMatrix4 autoRelease_jrbAFrame(jenv, "poolMatrix4", jrbAFrame);
    jrbBFrame = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbBFrame, rbBFrame);
    gdxPoolAutoReleaseMatrix4 autoRelease_jrbBFrame(jenv, "poolMatrix4", jrbBFrame);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[33], swigjobj, jrbA, jrbB, jrbAFrame, jrbBFrame);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btConeTwistConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createConeTwistConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btConeTwistConstraint *SwigDirector_btBulletWorldImporter::createConeTwistConstraint(btRigidBody &rbA, btTransform const &rbAFrame) {
  btConeTwistConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jobject jrbAFrame = 0 ;
  
  if (!swig_override[34]) {
    return btWorldImporter::createConeTwistConstraint(rbA,rbAFrame);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    jrbAFrame = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jrbAFrame, rbAFrame);
    gdxPoolAutoReleaseMatrix4 autoRelease_jrbAFrame(jenv, "poolMatrix4", jrbAFrame);
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[34], swigjobj, jrbA, jrbAFrame);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btConeTwistConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createConeTwistConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGeneric6DofConstraint *SwigDirector_btBulletWorldImporter::createGeneric6DofConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &frameInA, btTransform const &frameInB, bool useLinearReferenceFrameA) {
  btGeneric6DofConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jframeInA = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameA  ;
  
  if (!swig_override[35]) {
    return btWorldImporter::createGeneric6DofConstraint(rbA,rbB,frameInA,frameInB,useLinearReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInA = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInA, frameInA);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInA(jenv, "poolMatrix4", jframeInA);
    jframeInB = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameA = (jboolean) useLinearReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[35], swigjobj, jrbA, jrbB, jframeInA, jframeInB, juseLinearReferenceFrameA);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btGeneric6DofConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createGeneric6DofConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGeneric6DofConstraint *SwigDirector_btBulletWorldImporter::createGeneric6DofConstraint(btRigidBody &rbB, btTransform const &frameInB, bool useLinearReferenceFrameB) {
  btGeneric6DofConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbB = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameB  ;
  
  if (!swig_override[36]) {
    return btWorldImporter::createGeneric6DofConstraint(rbB,frameInB,useLinearReferenceFrameB);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInB = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameB = (jboolean) useLinearReferenceFrameB;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[36], swigjobj, jrbB, jframeInB, juseLinearReferenceFrameB);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btGeneric6DofConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createGeneric6DofConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGeneric6DofSpringConstraint *SwigDirector_btBulletWorldImporter::createGeneric6DofSpringConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &frameInA, btTransform const &frameInB, bool useLinearReferenceFrameA) {
  btGeneric6DofSpringConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jframeInA = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameA  ;
  
  if (!swig_override[37]) {
    return btWorldImporter::createGeneric6DofSpringConstraint(rbA,rbB,frameInA,frameInB,useLinearReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInA = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInA, frameInA);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInA(jenv, "poolMatrix4", jframeInA);
    jframeInB = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameA = (jboolean) useLinearReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[37], swigjobj, jrbA, jrbB, jframeInA, jframeInB, juseLinearReferenceFrameA);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btGeneric6DofSpringConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createGeneric6DofSpringConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGeneric6DofSpring2Constraint *SwigDirector_btBulletWorldImporter::createGeneric6DofSpring2Constraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &frameInA, btTransform const &frameInB, int rotateOrder) {
  btGeneric6DofSpring2Constraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jframeInA = 0 ;
  jobject jframeInB = 0 ;
  jint jrotateOrder  ;
  
  if (!swig_override[38]) {
    return btWorldImporter::createGeneric6DofSpring2Constraint(rbA,rbB,frameInA,frameInB,rotateOrder);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInA = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInA, frameInA);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInA(jenv, "poolMatrix4", jframeInA);
    jframeInB = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    jrotateOrder = (jint) rotateOrder;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[38], swigjobj, jrbA, jrbB, jframeInA, jframeInB, jrotateOrder);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btGeneric6DofSpring2Constraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createGeneric6DofSpring2Constraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btSliderConstraint *SwigDirector_btBulletWorldImporter::createSliderConstraint(btRigidBody &rbA, btRigidBody &rbB, btTransform const &frameInA, btTransform const &frameInB, bool useLinearReferenceFrameA) {
  btSliderConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jframeInA = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameA  ;
  
  if (!swig_override[39]) {
    return btWorldImporter::createSliderConstraint(rbA,rbB,frameInA,frameInB,useLinearReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInA = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInA, frameInA);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInA(jenv, "poolMatrix4", jframeInA);
    jframeInB = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameA = (jboolean) useLinearReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[39], swigjobj, jrbA, jrbB, jframeInA, jframeInB, juseLinearReferenceFrameA);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btSliderConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createSliderConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btSliderConstraint *SwigDirector_btBulletWorldImporter::createSliderConstraint(btRigidBody &rbB, btTransform const &frameInB, bool useLinearReferenceFrameA) {
  btSliderConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbB = 0 ;
  jobject jframeInB = 0 ;
  jboolean juseLinearReferenceFrameA  ;
  
  if (!swig_override[40]) {
    return btWorldImporter::createSliderConstraint(rbB,frameInB,useLinearReferenceFrameA);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jframeInB = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jframeInB, frameInB);
    gdxPoolAutoReleaseMatrix4 autoRelease_jframeInB(jenv, "poolMatrix4", jframeInB);
    juseLinearReferenceFrameA = (jboolean) useLinearReferenceFrameA;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[40], swigjobj, jrbB, jframeInB, juseLinearReferenceFrameA);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btSliderConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createSliderConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

btGearConstraint *SwigDirector_btBulletWorldImporter::createGearConstraint(btRigidBody &rbA, btRigidBody &rbB, btVector3 const &axisInA, btVector3 const &axisInB, btScalar ratio) {
  btGearConstraint *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrbA = 0 ;
  jlong jrbB = 0 ;
  jobject jaxisInA = 0 ;
  jobject jaxisInB = 0 ;
  jfloat jratio  ;
  
  if (!swig_override[41]) {
    return btWorldImporter::createGearConstraint(rbA,rbB,axisInA,axisInB,ratio);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btRigidBody **)&jrbA = (btRigidBody *) &rbA; 
    *(btRigidBody **)&jrbB = (btRigidBody *) &rbB; 
    jaxisInA = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jaxisInA, axisInA);
    gdxPoolAutoReleaseVector3 autoRelease_jaxisInA(jenv, "poolVector3", jaxisInA);
    jaxisInB = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jaxisInB, axisInB);
    gdxPoolAutoReleaseVector3 autoRelease_jaxisInB(jenv, "poolVector3", jaxisInB);
    jratio = (jfloat) ratio;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[41], swigjobj, jrbA, jrbB, jaxisInA, jaxisInB, jratio);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = *(btGearConstraint **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::createGearConstraint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_btBulletWorldImporter::convertAllObjects(bParse::btBulletFile *file) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jfile = 0 ;
  
  if (!swig_override[42]) {
    return btBulletWorldImporter::convertAllObjects(file);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((bParse::btBulletFile **)&jfile) = (bParse::btBulletFile *) file; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_ExtrasJNI, Swig::director_method_ids[42], swigjobj, jfile);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btBulletWorldImporter::convertAllObjects ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btBulletWorldImporter::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "deleteAllData", "()V", NULL 
    },
    {
      "setDynamicsWorldInfo", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/physics/bullet/dynamics/btContactSolverInfo;)V", NULL 
    },
    {
      "createRigidBody", "(ZFLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;Ljava/lang/String;)Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;", NULL 
    },
    {
      "createCollisionObject", "(Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;Ljava/lang/String;)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionObject;", NULL 
    },
    {
      "createPlaneShape", "(Lcom/badlogic/gdx/math/Vector3;F)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createBoxShape", "(Lcom/badlogic/gdx/math/Vector3;)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createSphereShape", "(F)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createCapsuleShapeX", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createCapsuleShapeY", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createCapsuleShapeZ", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createCylinderShapeX", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createCylinderShapeY", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createCylinderShapeZ", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createConeShapeX", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createConeShapeY", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createConeShapeZ", "(FF)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createTriangleMeshContainer", "()Lcom/badlogic/gdx/physics/bullet/collision/btTriangleIndexVertexArray;", NULL 
    },
    {
      "createBvhTriangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/collision/btStridingMeshInterface;Lcom/badlogic/gdx/physics/bullet/collision/btOptimizedBvh;)Lcom/badlogic/gdx/physics/bullet/collision/btBvhTriangleMeshShape;", NULL 
    },
    {
      "createConvexTriangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/collision/btStridingMeshInterface;)Lcom/badlogic/gdx/physics/bullet/collision/btCollisionShape;", NULL 
    },
    {
      "createGimpactShape", "(Lcom/badlogic/gdx/physics/bullet/collision/btStridingMeshInterface;)Lcom/badlogic/gdx/physics/bullet/collision/btGImpactMeshShape;", NULL 
    },
    {
      "createStridingMeshInterfaceData", "(Lcom/badlogic/gdx/physics/bullet/collision/btStridingMeshInterfaceData;)Lcom/badlogic/gdx/physics/bullet/collision/btStridingMeshInterfaceData;", NULL 
    },
    {
      "createConvexHullShape", "()Lcom/badlogic/gdx/physics/bullet/collision/btConvexHullShape;", NULL 
    },
    {
      "createCompoundShape", "()Lcom/badlogic/gdx/physics/bullet/collision/btCompoundShape;", NULL 
    },
    {
      "createScaledTrangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/collision/btBvhTriangleMeshShape;Lcom/badlogic/gdx/math/Vector3;)Lcom/badlogic/gdx/physics/bullet/collision/btScaledBvhTriangleMeshShape;", NULL 
    },
    {
      "createMeshInterface", "(Lcom/badlogic/gdx/physics/bullet/collision/btStridingMeshInterfaceData;)Lcom/badlogic/gdx/physics/bullet/collision/btTriangleIndexVertexArray;", NULL 
    },
    {
      "createOptimizedBvh", "()Lcom/badlogic/gdx/physics/bullet/collision/btOptimizedBvh;", NULL 
    },
    {
      "createTriangleInfoMap", "()Lcom/badlogic/gdx/physics/bullet/collision/btTriangleInfoMap;", NULL 
    },
    {
      "createPoint2PointConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)Lcom/badlogic/gdx/physics/bullet/dynamics/btPoint2PointConstraint;", NULL 
    },
    {
      "createPoint2PointConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Vector3;)Lcom/badlogic/gdx/physics/bullet/dynamics/btPoint2PointConstraint;", NULL 
    },
    {
      "createHingeConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/dynamics/btHingeConstraint;", NULL 
    },
    {
      "createHingeConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;)Lcom/badlogic/gdx/physics/bullet/dynamics/btHingeConstraint;", NULL 
    },
    {
      "createHingeConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/dynamics/btHingeConstraint;", NULL 
    },
    {
      "createHingeConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;)Lcom/badlogic/gdx/physics/bullet/dynamics/btHingeConstraint;", NULL 
    },
    {
      "createConeTwistConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;)Lcom/badlogic/gdx/physics/bullet/dynamics/btConeTwistConstraint;", NULL 
    },
    {
      "createConeTwistConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;)Lcom/badlogic/gdx/physics/bullet/dynamics/btConeTwistConstraint;", NULL 
    },
    {
      "createGeneric6DofConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/dynamics/btGeneric6DofConstraint;", NULL 
    },
    {
      "createGeneric6DofConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/dynamics/btGeneric6DofConstraint;", NULL 
    },
    {
      "createGeneric6DofSpringConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/dynamics/btGeneric6DofSpringConstraint;", NULL 
    },
    {
      "createGeneric6DofSpring2Constraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;I)Lcom/badlogic/gdx/physics/bullet/dynamics/btGeneric6DofSpring2Constraint;", NULL 
    },
    {
      "createSliderConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/dynamics/btSliderConstraint;", NULL 
    },
    {
      "createSliderConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Matrix4;Z)Lcom/badlogic/gdx/physics/bullet/dynamics/btSliderConstraint;", NULL 
    },
    {
      "createGearConstraint", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/physics/bullet/dynamics/btRigidBody;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;F)Lcom/badlogic/gdx/physics/bullet/dynamics/btGearConstraint;", NULL 
    },
    {
      "convertAllObjects", "(Lcom/badlogic/gdx/physics/bullet/extras/SWIGTYPE_p_bParse__btBulletFile;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 43; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1operatorAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  btAlignedObjectArray< char * > *arg2 = 0 ;
  btAlignedObjectArray< char * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = *(btAlignedObjectArray< char * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< char * > const & reference is null");
    return 0;
  } 
  result = (btAlignedObjectArray< char * > *) &(arg1)->operator =((btAlignedObjectArray< char * > const &)*arg2);
  *(btAlignedObjectArray< char * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1btStringArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAlignedObjectArray< char * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAlignedObjectArray< char * > *)new btAlignedObjectArray< char * >();
  *(btAlignedObjectArray< char * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1btStringArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1btStringArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = 0 ;
  btAlignedObjectArray< char * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< char * > const & reference is null");
    return 0;
  } 
  result = (btAlignedObjectArray< char * > *)new btAlignedObjectArray< char * >((btAlignedObjectArray< char * > const &)*arg1);
  *(btAlignedObjectArray< char * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  result = (int)((btAlignedObjectArray< char * > const *)arg1)->size();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1at_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int arg2 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char **) &((btAlignedObjectArray< char * > const *)arg1)->at(arg2);
  if (*result) jresult = jenv->NewStringUTF((const char *)*result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1operatorSubscript_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int arg2 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char **) &((btAlignedObjectArray< char * > const *)arg1)->operator [](arg2);
  if (*result) jresult = jenv->NewStringUTF((const char *)*result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1pop_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  (arg1)->pop_back();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1resizeNoInitialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->resizeNoInitialize(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1resize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int arg2 ;
  char **arg3 = 0 ;
  char *temp3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    temp3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!temp3) return ;
  }
  arg3 = &temp3;
  (arg1)->resize(arg2,(char *const &)*arg3);
  if (arg3 && *arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1resize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->resize(arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1expandNonInitializing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  result = (char **) &(arg1)->expandNonInitializing();
  if (*result) jresult = jenv->NewStringUTF((const char *)*result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1expand_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  char **arg2 = 0 ;
  char *temp2 = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    temp2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!temp2) return 0;
  }
  arg2 = &temp2;
  result = (char **) &(arg1)->expand((char *const &)*arg2);
  if (*result) jresult = jenv->NewStringUTF((const char *)*result);
  if (arg2 && *arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)*arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1expand_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  result = (char **) &(arg1)->expand();
  if (*result) jresult = jenv->NewStringUTF((const char *)*result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1push_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  char **arg2 = 0 ;
  char *temp2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    temp2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!temp2) return ;
  }
  arg2 = &temp2;
  (arg1)->push_back((char *const &)*arg2);
  if (arg2 && *arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  result = (int)((btAlignedObjectArray< char * > const *)arg1)->capacity();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->reserve(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1less_1operatorFunctionCall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  btAlignedObjectArray< char * >::less *arg1 = (btAlignedObjectArray< char * >::less *) 0 ;
  char **arg2 = 0 ;
  char **arg3 = 0 ;
  char *temp2 = 0 ;
  char *temp3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * >::less **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    temp2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!temp2) return 0;
  }
  arg2 = &temp2;
  arg3 = 0;
  if (jarg3) {
    temp3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!temp3) return 0;
  }
  arg3 = &temp3;
  result = (bool)((btAlignedObjectArray< char * >::less const *)arg1)->operator ()((char *const &)*arg2,(char *const &)*arg3);
  jresult = (jboolean)result; 
  if (arg2 && *arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)*arg2);
  if (arg3 && *arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)*arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1btStringArray_1less(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAlignedObjectArray< char * >::less *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAlignedObjectArray< char * >::less *)new btAlignedObjectArray< char * >::less();
  *(btAlignedObjectArray< char * >::less **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1btStringArray_1less(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAlignedObjectArray< char * >::less *arg1 = (btAlignedObjectArray< char * >::less *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< char * >::less **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1swap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->swap(arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1findBinarySearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  char **arg2 = 0 ;
  char *temp2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    temp2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!temp2) return 0;
  }
  arg2 = &temp2;
  result = (int)((btAlignedObjectArray< char * > const *)arg1)->findBinarySearch((char *const &)*arg2);
  jresult = (jint)result; 
  if (arg2 && *arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)*arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1findLinearSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  char **arg2 = 0 ;
  char *temp2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    temp2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!temp2) return 0;
  }
  arg2 = &temp2;
  result = (int)((btAlignedObjectArray< char * > const *)arg1)->findLinearSearch((char *const &)*arg2);
  jresult = (jint)result; 
  if (arg2 && *arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)*arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1findLinearSearch2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  char **arg2 = 0 ;
  char *temp2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    temp2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!temp2) return 0;
  }
  arg2 = &temp2;
  result = (int)((btAlignedObjectArray< char * > const *)arg1)->findLinearSearch2((char *const &)*arg2);
  jresult = (jint)result; 
  if (arg2 && *arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)*arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1removeAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->removeAtIndex(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  char **arg2 = 0 ;
  char *temp2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    temp2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!temp2) return ;
  }
  arg2 = &temp2;
  (arg1)->remove((char *const &)*arg2);
  if (arg2 && *arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1initializeFromBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->initializeFromBuffer(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btStringArray_1copyFromArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAlignedObjectArray< char * > *arg1 = (btAlignedObjectArray< char * > *) 0 ;
  btAlignedObjectArray< char * > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAlignedObjectArray< char * > **)&jarg1; 
  arg2 = *(btAlignedObjectArray< char * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< char * > const & reference is null");
    return ;
  } 
  (arg1)->copyFromArray((btAlignedObjectArray< char * > const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1btWorldImporter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btWorldImporter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (btWorldImporter *)new btWorldImporter(arg1);
  *(btWorldImporter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1btWorldImporter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btWorldImporter **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1deleteAllData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  (arg1)->deleteAllData();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1setVerboseMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setVerboseMode(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getVerboseMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (int)((btWorldImporter const *)arg1)->getVerboseMode();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getNumCollisionShapes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (int)((btWorldImporter const *)arg1)->getNumCollisionShapes();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getCollisionShapeByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int arg2 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btCollisionShape *)(arg1)->getCollisionShapeByIndex(arg2);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getNumRigidBodies(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (int)((btWorldImporter const *)arg1)->getNumRigidBodies();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getRigidBodyByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int arg2 ;
  btCollisionObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btCollisionObject *)((btWorldImporter const *)arg1)->getRigidBodyByIndex(arg2);
  *(btCollisionObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getNumConstraints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (int)((btWorldImporter const *)arg1)->getNumConstraints();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getConstraintByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int arg2 ;
  btTypedConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btTypedConstraint *)((btWorldImporter const *)arg1)->getConstraintByIndex(arg2);
  *(btTypedConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getNumBvhs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (int)((btWorldImporter const *)arg1)->getNumBvhs();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getBvhByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int arg2 ;
  btOptimizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btOptimizedBvh *)((btWorldImporter const *)arg1)->getBvhByIndex(arg2);
  *(btOptimizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getNumTriangleInfoMaps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (int)((btWorldImporter const *)arg1)->getNumTriangleInfoMaps();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getTriangleInfoMapByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  int arg2 ;
  btTriangleInfoMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btTriangleInfoMap *)((btWorldImporter const *)arg1)->getTriangleInfoMapByIndex(arg2);
  *(btTriangleInfoMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getCollisionShapeByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  char *arg2 = (char *) 0 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (btCollisionShape *)(arg1)->getCollisionShapeByName((char const *)arg2);
  *(btCollisionShape **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getRigidBodyByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  char *arg2 = (char *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (btRigidBody *)(arg1)->getRigidBodyByName((char const *)arg2);
  *(btRigidBody **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getConstraintByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  char *arg2 = (char *) 0 ;
  btTypedConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (btTypedConstraint *)(arg1)->getConstraintByName((char const *)arg2);
  *(btTypedConstraint **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1getNameForPointer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  void *arg2 = (void *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (void *)jarg2; 
  result = (char *)((btWorldImporter const *)arg1)->getNameForPointer((void const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1setDynamicsWorldInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btVector3 *arg2 = 0 ;
  btContactSolverInfo *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btContactSolverInfo **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btContactSolverInfo const & reference is null");
    return ;
  } 
  (arg1)->setDynamicsWorldInfo((btVector3 const &)*arg2,(btContactSolverInfo const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createRigidBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jfloat jarg3, jobject jarg4, jlong jarg5, jobject jarg5_, jstring jarg6) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  bool arg2 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btCollisionShape *arg5 = (btCollisionShape *) 0 ;
  char *arg6 = (char *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = (btScalar)jarg3; 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btCollisionShape **)&jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  result = (btRigidBody *)(arg1)->createRigidBody(arg2,arg3,(btTransform const &)*arg4,arg5,(char const *)arg6);
  *(btRigidBody **)&jresult = result; 
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createCollisionObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_, jstring jarg4) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btTransform *arg2 = 0 ;
  btCollisionShape *arg3 = (btCollisionShape *) 0 ;
  char *arg4 = (char *) 0 ;
  btCollisionObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btCollisionShape **)&jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (btCollisionObject *)(arg1)->createCollisionObject((btTransform const &)*arg2,arg3,(char const *)arg4);
  *(btCollisionObject **)&jresult = result; 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createPlaneShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createPlaneShape((btVector3 const &)*arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createBoxShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btVector3 *arg2 = 0 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btCollisionShape *)(arg1)->createBoxShape((btVector3 const &)*arg2);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createSphereShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btCollisionShape *)(arg1)->createSphereShape(arg2);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createCapsuleShapeX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createCapsuleShapeX(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createCapsuleShapeY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createCapsuleShapeY(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createCapsuleShapeZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createCapsuleShapeZ(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createCylinderShapeX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createCylinderShapeX(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createCylinderShapeY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createCylinderShapeY(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createCylinderShapeZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createCylinderShapeZ(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createConeShapeX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createConeShapeX(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createConeShapeY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createConeShapeY(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createConeShapeZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btCollisionShape *)(arg1)->createConeShapeZ(arg2,arg3);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createTriangleMeshContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btTriangleIndexVertexArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (btTriangleIndexVertexArray *)(arg1)->createTriangleMeshContainer();
  *(btTriangleIndexVertexArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createBvhTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  btOptimizedBvh *arg3 = (btOptimizedBvh *) 0 ;
  btBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  arg3 = *(btOptimizedBvh **)&jarg3; 
  result = (btBvhTriangleMeshShape *)(arg1)->createBvhTriangleMeshShape(arg2,arg3);
  *(btBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createConvexTriangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  result = (btCollisionShape *)(arg1)->createConvexTriangleMeshShape(arg2);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createGimpactShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btStridingMeshInterface *arg2 = (btStridingMeshInterface *) 0 ;
  btGImpactMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btStridingMeshInterface **)&jarg2; 
  result = (btGImpactMeshShape *)(arg1)->createGimpactShape(arg2);
  *(btGImpactMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createStridingMeshInterfaceData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btStridingMeshInterfaceData *arg2 = (btStridingMeshInterfaceData *) 0 ;
  btStridingMeshInterfaceData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btStridingMeshInterfaceData **)&jarg2; 
  result = (btStridingMeshInterfaceData *)(arg1)->createStridingMeshInterfaceData(arg2);
  *(btStridingMeshInterfaceData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createConvexHullShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btConvexHullShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (btConvexHullShape *)(arg1)->createConvexHullShape();
  *(btConvexHullShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createCompoundShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btCompoundShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (btCompoundShape *)(arg1)->createCompoundShape();
  *(btCompoundShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createScaledTrangleMeshShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btBvhTriangleMeshShape *arg2 = (btBvhTriangleMeshShape *) 0 ;
  btVector3 *arg3 = 0 ;
  btScaledBvhTriangleMeshShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btBvhTriangleMeshShape **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btScaledBvhTriangleMeshShape *)(arg1)->createScaledTrangleMeshShape(arg2,(btVector3 const &)*arg3);
  *(btScaledBvhTriangleMeshShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createMultiSphereShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btScalar *arg3 = (btScalar *) 0 ;
  int arg4 ;
  btMultiSphereShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    arg3 = (btScalar*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = (int)jarg4; 
  result = (btMultiSphereShape *)(arg1)->createMultiSphereShape((btVector3 const *)arg2,(btScalar const *)arg3,arg4);
  *(btMultiSphereShape **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createMeshInterface(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btStridingMeshInterfaceData *arg2 = 0 ;
  btTriangleIndexVertexArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btStridingMeshInterfaceData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btStridingMeshInterfaceData & reference is null");
    return 0;
  } 
  result = (btTriangleIndexVertexArray *)(arg1)->createMeshInterface(*arg2);
  *(btTriangleIndexVertexArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createOptimizedBvh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btOptimizedBvh *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (btOptimizedBvh *)(arg1)->createOptimizedBvh();
  *(btOptimizedBvh **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createTriangleInfoMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btTriangleInfoMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btWorldImporter **)&jarg1; 
  result = (btTriangleInfoMap *)(arg1)->createTriangleInfoMap();
  *(btTriangleInfoMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createPoint2PointConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btPoint2PointConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btPoint2PointConstraint *)(arg1)->createPoint2PointConstraint(*arg2,*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
  *(btPoint2PointConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createPoint2PointConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btPoint2PointConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btPoint2PointConstraint *)(arg1)->createPoint2PointConstraint(*arg2,(btVector3 const &)*arg3);
  *(btPoint2PointConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createHingeConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  bool arg6 ;
  btHingeConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = jarg6 ? true : false; 
  result = (btHingeConstraint *)(arg1)->createHingeConstraint(*arg2,*arg3,(btTransform const &)*arg4,(btTransform const &)*arg5,arg6);
  *(btHingeConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createHingeConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  btHingeConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btHingeConstraint *)(arg1)->createHingeConstraint(*arg2,*arg3,(btTransform const &)*arg4,(btTransform const &)*arg5);
  *(btHingeConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createHingeConstraint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  bool arg4 ;
  btHingeConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = jarg4 ? true : false; 
  result = (btHingeConstraint *)(arg1)->createHingeConstraint(*arg2,(btTransform const &)*arg3,arg4);
  *(btHingeConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createHingeConstraint_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btHingeConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btHingeConstraint *)(arg1)->createHingeConstraint(*arg2,(btTransform const &)*arg3);
  *(btHingeConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createConeTwistConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  btConeTwistConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btConeTwistConstraint *)(arg1)->createConeTwistConstraint(*arg2,*arg3,(btTransform const &)*arg4,(btTransform const &)*arg5);
  *(btConeTwistConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createConeTwistConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btConeTwistConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btConeTwistConstraint *)(arg1)->createConeTwistConstraint(*arg2,(btTransform const &)*arg3);
  *(btConeTwistConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createGeneric6DofConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  bool arg6 ;
  btGeneric6DofConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = jarg6 ? true : false; 
  result = (btGeneric6DofConstraint *)(arg1)->createGeneric6DofConstraint(*arg2,*arg3,(btTransform const &)*arg4,(btTransform const &)*arg5,arg6);
  *(btGeneric6DofConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createGeneric6DofConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  bool arg4 ;
  btGeneric6DofConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = jarg4 ? true : false; 
  result = (btGeneric6DofConstraint *)(arg1)->createGeneric6DofConstraint(*arg2,(btTransform const &)*arg3,arg4);
  *(btGeneric6DofConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createGeneric6DofSpringConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  bool arg6 ;
  btGeneric6DofSpringConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = jarg6 ? true : false; 
  result = (btGeneric6DofSpringConstraint *)(arg1)->createGeneric6DofSpringConstraint(*arg2,*arg3,(btTransform const &)*arg4,(btTransform const &)*arg5,arg6);
  *(btGeneric6DofSpringConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createGeneric6DofSpring2Constraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5, jint jarg6) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  int arg6 ;
  btGeneric6DofSpring2Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = (int)jarg6; 
  result = (btGeneric6DofSpring2Constraint *)(arg1)->createGeneric6DofSpring2Constraint(*arg2,*arg3,(btTransform const &)*arg4,(btTransform const &)*arg5,arg6);
  *(btGeneric6DofSpring2Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createSliderConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  bool arg6 ;
  btSliderConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = jarg6 ? true : false; 
  result = (btSliderConstraint *)(arg1)->createSliderConstraint(*arg2,*arg3,(btTransform const &)*arg4,(btTransform const &)*arg5,arg6);
  *(btSliderConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createSliderConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  bool arg4 ;
  btSliderConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = jarg4 ? true : false; 
  result = (btSliderConstraint *)(arg1)->createSliderConstraint(*arg2,(btTransform const &)*arg3,arg4);
  *(btSliderConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btWorldImporter_1createGearConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5, jfloat jarg6) {
  jlong jresult = 0 ;
  btWorldImporter *arg1 = (btWorldImporter *) 0 ;
  btRigidBody *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btScalar arg6 ;
  btGearConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btWorldImporter **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = (btScalar)jarg6; 
  result = (btGearConstraint *)(arg1)->createGearConstraint(*arg2,*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6);
  *(btGearConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1btBulletWorldImporter_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btBulletWorldImporter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (btBulletWorldImporter *)new SwigDirector_btBulletWorldImporter(jenv,arg1);
  *(btBulletWorldImporter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1btBulletWorldImporter_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBulletWorldImporter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBulletWorldImporter *)new SwigDirector_btBulletWorldImporter(jenv);
  *(btBulletWorldImporter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1btBulletWorldImporter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBulletWorldImporter *arg1 = (btBulletWorldImporter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBulletWorldImporter **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1loadFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  btBulletWorldImporter *arg1 = (btBulletWorldImporter *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletWorldImporter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->loadFile((char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1loadFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  btBulletWorldImporter *arg1 = (btBulletWorldImporter *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletWorldImporter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->loadFile((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1loadFileFromMemory_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  btBulletWorldImporter *arg1 = (btBulletWorldImporter *) 0 ;
  bParse::btBulletFile *arg2 = (bParse::btBulletFile *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletWorldImporter **)&jarg1; 
  arg2 = *(bParse::btBulletFile **)&jarg2; 
  result = (bool)(arg1)->loadFileFromMemory(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1convertAllObjects(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  btBulletWorldImporter *arg1 = (btBulletWorldImporter *) 0 ;
  bParse::btBulletFile *arg2 = (bParse::btBulletFile *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletWorldImporter **)&jarg1; 
  arg2 = *(bParse::btBulletFile **)&jarg2; 
  result = (bool)(arg1)->convertAllObjects(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1convertAllObjectsSwigExplicitbtBulletWorldImporter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  btBulletWorldImporter *arg1 = (btBulletWorldImporter *) 0 ;
  bParse::btBulletFile *arg2 = (bParse::btBulletFile *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletWorldImporter **)&jarg1; 
  arg2 = *(bParse::btBulletFile **)&jarg2; 
  result = (bool)(arg1)->btBulletWorldImporter::convertAllObjects(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1loadFileFromMemory_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  btBulletWorldImporter *arg1 = (btBulletWorldImporter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletWorldImporter **)&jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  result = (bool)btBulletWorldImporter_loadFileFromMemory__SWIG_1(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btBulletWorldImporter *obj = *((btBulletWorldImporter **)&objarg);
  (void)jcls;
  SwigDirector_btBulletWorldImporter *director = (SwigDirector_btBulletWorldImporter *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btBulletWorldImporter *obj = *((btBulletWorldImporter **)&objarg);
  SwigDirector_btBulletWorldImporter *director = (SwigDirector_btBulletWorldImporter *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1MultiBodyTreeCreator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::MultiBodyTreeCreator *arg1 = (btInverseDynamicsBullet3::MultiBodyTreeCreator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyTreeCreator_1getNumBodies(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTreeCreator *arg1 = (btInverseDynamicsBullet3::MultiBodyTreeCreator *) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::MultiBodyTreeCreator const *)arg1)->getNumBodies(arg2);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyTreeCreator_1getBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jobject jarg8, jlong jarg9, jlong jarg10, jobject jarg11, jlong jarg12) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTreeCreator *arg1 = (btInverseDynamicsBullet3::MultiBodyTreeCreator *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  btInverseDynamicsBullet3::JointType *arg4 = (btInverseDynamicsBullet3::JointType *) 0 ;
  vec3 *arg5 = (vec3 *) 0 ;
  mat33 *arg6 = (mat33 *) 0 ;
  vec3 *arg7 = (vec3 *) 0 ;
  idScalar *arg8 = (idScalar *) 0 ;
  vec3 *arg9 = (vec3 *) 0 ;
  mat33 *arg10 = (mat33 *) 0 ;
  int *arg11 = (int *) 0 ;
  void **arg12 = (void **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = *(btInverseDynamicsBullet3::JointType **)&jarg4; 
  arg5 = *(vec3 **)&jarg5; 
  arg6 = *(mat33 **)&jarg6; 
  arg7 = *(vec3 **)&jarg7; 
  {
    arg8 = (btScalar*)jenv->GetDirectBufferAddress(jarg8);
    if (arg8 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg9 = *(vec3 **)&jarg9; 
  arg10 = *(mat33 **)&jarg10; 
  {
    arg11 = (int*)jenv->GetDirectBufferAddress(jarg11);
    if (arg11 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg12 = *(void ***)&jarg12; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTreeCreator const *)arg1)->getBody(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
  jresult = (jint)result; 
  
  
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyTreeCreator_1getNameMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTreeCreator *arg1 = (btInverseDynamicsBullet3::MultiBodyTreeCreator *) 0 ;
  MultiBodyNameMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&jarg1; 
  result = (MultiBodyNameMap *)((btInverseDynamicsBullet3::MultiBodyTreeCreator const *)arg1)->getNameMap();
  *(MultiBodyNameMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_CreateMultiBodyTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTreeCreator *arg1 = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btInverseDynamicsBullet3::MultiBodyTreeCreator const & reference is null");
    return 0;
  } 
  result = (btInverseDynamicsBullet3::MultiBodyTree *)btInverseDynamicsBullet3::CreateMultiBodyTree((btInverseDynamicsBullet3::MultiBodyTreeCreator const &)*arg1);
  *(btInverseDynamicsBullet3::MultiBodyTree **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1CoilCreator(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btInverseDynamicsBullet3::CoilCreator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btInverseDynamicsBullet3::CoilCreator *)new btInverseDynamicsBullet3::CoilCreator(arg1);
  *(btInverseDynamicsBullet3::CoilCreator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1CoilCreator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::CoilCreator *arg1 = (btInverseDynamicsBullet3::CoilCreator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::CoilCreator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1CloneTreeCreator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  btInverseDynamicsBullet3::CloneTreeCreator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  result = (btInverseDynamicsBullet3::CloneTreeCreator *)new btInverseDynamicsBullet3::CloneTreeCreator((btInverseDynamicsBullet3::MultiBodyTree const *)arg1);
  *(btInverseDynamicsBullet3::CloneTreeCreator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1CloneTreeCreator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::CloneTreeCreator *arg1 = (btInverseDynamicsBullet3::CloneTreeCreator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::CloneTreeCreator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1DillCreator(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btInverseDynamicsBullet3::DillCreator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btInverseDynamicsBullet3::DillCreator *)new btInverseDynamicsBullet3::DillCreator(arg1);
  *(btInverseDynamicsBullet3::DillCreator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1DillCreator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::DillCreator *arg1 = (btInverseDynamicsBullet3::DillCreator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::DillCreator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1btMultiBodyTreeCreator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::btMultiBodyTreeCreator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btInverseDynamicsBullet3::btMultiBodyTreeCreator *)new btInverseDynamicsBullet3::btMultiBodyTreeCreator();
  *(btInverseDynamicsBullet3::btMultiBodyTreeCreator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1btMultiBodyTreeCreator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::btMultiBodyTreeCreator *arg1 = (btInverseDynamicsBullet3::btMultiBodyTreeCreator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::btMultiBodyTreeCreator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btMultiBodyTreeCreator_1createFromBtMultiBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::btMultiBodyTreeCreator *arg1 = (btInverseDynamicsBullet3::btMultiBodyTreeCreator *) 0 ;
  btMultiBody *arg2 = (btMultiBody *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btInverseDynamicsBullet3::btMultiBodyTreeCreator **)&jarg1; 
  arg2 = *(btMultiBody **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)(arg1)->createFromBtMultiBody((btMultiBody const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btMultiBodyTreeCreator_1createFromBtMultiBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::btMultiBodyTreeCreator *arg1 = (btInverseDynamicsBullet3::btMultiBodyTreeCreator *) 0 ;
  btMultiBody *arg2 = (btMultiBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btInverseDynamicsBullet3::btMultiBodyTreeCreator **)&jarg1; 
  arg2 = *(btMultiBody **)&jarg2; 
  result = (int)(arg1)->createFromBtMultiBody((btMultiBody const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_randomInit_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  btInverseDynamicsBullet3::randomInit();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_randomInit_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  unsigned int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  btInverseDynamicsBullet3::randomInit(arg1);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_randomInt(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (int)btInverseDynamicsBullet3::randomInt(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_randomFloat(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  float arg1 ;
  float arg2 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (float)jarg1; 
  arg2 = (float)jarg2; 
  result = (float)btInverseDynamicsBullet3::randomFloat(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_randomMass(JNIEnv *jenv, jclass jcls) {
  jfloat jresult = 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  result = (float)btInverseDynamicsBullet3::randomMass();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_randomInertiaPrincipal(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  vec3 result;
  
  (void)jenv;
  (void)jcls;
  result = btInverseDynamicsBullet3::randomInertiaPrincipal();
  *(vec3 **)&jresult = new vec3((const vec3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_randomInertiaMatrix(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  mat33 result;
  
  (void)jenv;
  (void)jcls;
  result = btInverseDynamicsBullet3::randomInertiaMatrix();
  *(mat33 **)&jresult = new mat33((const mat33 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_randomAxis(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  vec3 result;
  
  (void)jenv;
  (void)jcls;
  result = btInverseDynamicsBullet3::randomAxis();
  *(vec3 **)&jresult = new vec3((const vec3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1MultiBodyNameMap(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyNameMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btInverseDynamicsBullet3::MultiBodyNameMap *)new btInverseDynamicsBullet3::MultiBodyNameMap();
  *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyNameMap_1addBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyNameMap *arg1 = (btInverseDynamicsBullet3::MultiBodyNameMap *) 0 ;
  int arg2 ;
  std::string *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->addBody(arg2,(std::string const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyNameMap_1addJoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyNameMap *arg1 = (btInverseDynamicsBullet3::MultiBodyNameMap *) 0 ;
  int arg2 ;
  std::string *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->addJoint(arg2,(std::string const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyNameMap_1getBodyName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyNameMap *arg1 = (btInverseDynamicsBullet3::MultiBodyNameMap *) 0 ;
  int arg2 ;
  std::string *arg3 = (std::string *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::string **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyNameMap const *)arg1)->getBodyName(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyNameMap_1getJointName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyNameMap *arg1 = (btInverseDynamicsBullet3::MultiBodyNameMap *) 0 ;
  int arg2 ;
  std::string *arg3 = (std::string *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::string **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyNameMap const *)arg1)->getJointName(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyNameMap_1getBodyIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyNameMap *arg1 = (btInverseDynamicsBullet3::MultiBodyNameMap *) 0 ;
  std::string *arg2 = 0 ;
  int *arg3 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string const & reference is null");
    return 0;
  } 
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::MultiBodyNameMap const *)arg1)->getBodyIndex((std::string const &)*arg2,arg3);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_MultiBodyNameMap_1getJointIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyNameMap *arg1 = (btInverseDynamicsBullet3::MultiBodyNameMap *) 0 ;
  std::string *arg2 = 0 ;
  int *arg3 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string const & reference is null");
    return 0;
  } 
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::MultiBodyNameMap const *)arg1)->getJointIndex((std::string const &)*arg2,arg3);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1MultiBodyNameMap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::MultiBodyNameMap *arg1 = (btInverseDynamicsBullet3::MultiBodyNameMap *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_writeGraphvizDotFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  btInverseDynamicsBullet3::MultiBodyNameMap *arg2 = (btInverseDynamicsBullet3::MultiBodyNameMap *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = *(btInverseDynamicsBullet3::MultiBodyNameMap **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)btInverseDynamicsBullet3::writeGraphvizDotFile((btInverseDynamicsBullet3::MultiBodyTree const *)arg1,(btInverseDynamicsBullet3::MultiBodyNameMap const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1RandomTreeCreator_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  bool arg2 ;
  btInverseDynamicsBullet3::RandomTreeCreator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (btInverseDynamicsBullet3::RandomTreeCreator *)new btInverseDynamicsBullet3::RandomTreeCreator(arg1,arg2);
  *(btInverseDynamicsBullet3::RandomTreeCreator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1RandomTreeCreator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btInverseDynamicsBullet3::RandomTreeCreator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btInverseDynamicsBullet3::RandomTreeCreator *)new btInverseDynamicsBullet3::RandomTreeCreator(arg1);
  *(btInverseDynamicsBullet3::RandomTreeCreator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1RandomTreeCreator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::RandomTreeCreator *arg1 = (btInverseDynamicsBullet3::RandomTreeCreator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::RandomTreeCreator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1SimpleTreeCreator(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btInverseDynamicsBullet3::SimpleTreeCreator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btInverseDynamicsBullet3::SimpleTreeCreator *)new btInverseDynamicsBullet3::SimpleTreeCreator(arg1);
  *(btInverseDynamicsBullet3::SimpleTreeCreator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1SimpleTreeCreator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::SimpleTreeCreator *arg1 = (btInverseDynamicsBullet3::SimpleTreeCreator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::SimpleTreeCreator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_new_1User2InternalIndex(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::User2InternalIndex *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btInverseDynamicsBullet3::User2InternalIndex *)new btInverseDynamicsBullet3::User2InternalIndex();
  *(btInverseDynamicsBullet3::User2InternalIndex **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_User2InternalIndex_1addBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btInverseDynamicsBullet3::User2InternalIndex *arg1 = (btInverseDynamicsBullet3::User2InternalIndex *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::User2InternalIndex **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->addBody(arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_User2InternalIndex_1buildMapping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::User2InternalIndex *arg1 = (btInverseDynamicsBullet3::User2InternalIndex *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::User2InternalIndex **)&jarg1; 
  result = (int)(arg1)->buildMapping();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_User2InternalIndex_1user2internal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::User2InternalIndex *arg1 = (btInverseDynamicsBullet3::User2InternalIndex *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::User2InternalIndex **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::User2InternalIndex const *)arg1)->user2internal(arg2,arg3);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_User2InternalIndex_1internal2user(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::User2InternalIndex *arg1 = (btInverseDynamicsBullet3::User2InternalIndex *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::User2InternalIndex **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::User2InternalIndex const *)arg1)->internal2user(arg2,arg3);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_delete_1User2InternalIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::User2InternalIndex *arg1 = (btInverseDynamicsBullet3::User2InternalIndex *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::User2InternalIndex **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_compareInverseAndForwardDynamics(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg4, jboolean jarg5, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_, jobject jarg8, jobject jarg9) {
  jint jresult = 0 ;
  vecx *arg1 = 0 ;
  vecx *arg2 = 0 ;
  vecx *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  bool arg5 ;
  btMultiBody *arg6 = (btMultiBody *) 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg7 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  double *arg8 = (double *) 0 ;
  double *arg9 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = *(vecx **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx & reference is null");
    return 0;
  } 
  arg2 = *(vecx **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx & reference is null");
    return 0;
  } 
  arg3 = *(vecx **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx & reference is null");
    return 0;
  } 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = jarg5 ? true : false; 
  arg6 = *(btMultiBody **)&jarg6; 
  arg7 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg7; 
  {
    arg8 = (double*)jenv->GetDirectBufferAddress(jarg8);
    if (arg8 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg9 = (double*)jenv->GetDirectBufferAddress(jarg9);
    if (arg9 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)btInverseDynamicsBullet3::compareInverseAndForwardDynamics(*arg1,*arg2,*arg3,*arg4,arg5,arg6,arg7,arg8,arg9);
  jresult = (jint)result; 
  
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btBulletWorldImporter_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btWorldImporter **)&baseptr = *(btBulletWorldImporter **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_CoilCreator_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&baseptr = *(btInverseDynamicsBullet3::CoilCreator **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_CloneTreeCreator_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&baseptr = *(btInverseDynamicsBullet3::CloneTreeCreator **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_DillCreator_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&baseptr = *(btInverseDynamicsBullet3::DillCreator **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_btMultiBodyTreeCreator_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&baseptr = *(btInverseDynamicsBullet3::btMultiBodyTreeCreator **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_RandomTreeCreator_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&baseptr = *(btInverseDynamicsBullet3::RandomTreeCreator **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_SimpleTreeCreator_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btInverseDynamicsBullet3::MultiBodyTreeCreator **)&baseptr = *(btInverseDynamicsBullet3::SimpleTreeCreator **)&jarg1;
    return baseptr;
}

SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_extras_ExtrasJNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[43] = {
    {
      "SwigDirector_btBulletWorldImporter_deleteAllData", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;)V" 
    },
    {
      "SwigDirector_btBulletWorldImporter_setDynamicsWorldInfo", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;Lcom/badlogic/gdx/math/Vector3;J)V" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createRigidBody", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;ZFLcom/badlogic/gdx/math/Matrix4;JLjava/lang/String;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createCollisionObject", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;Lcom/badlogic/gdx/math/Matrix4;JLjava/lang/String;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createPlaneShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;Lcom/badlogic/gdx/math/Vector3;F)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createBoxShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;Lcom/badlogic/gdx/math/Vector3;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createSphereShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;F)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createCapsuleShapeX", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createCapsuleShapeY", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createCapsuleShapeZ", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createCylinderShapeX", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createCylinderShapeY", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createCylinderShapeZ", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createConeShapeX", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createConeShapeY", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createConeShapeZ", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;FF)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createTriangleMeshContainer", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createBvhTriangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJ)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createConvexTriangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;J)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createGimpactShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;J)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createStridingMeshInterfaceData", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;J)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createConvexHullShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createCompoundShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createScaledTrangleMeshShape", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JLcom/badlogic/gdx/math/Vector3;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createMeshInterface", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;J)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createOptimizedBvh", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createTriangleInfoMap", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createPoint2PointConstraint__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createPoint2PointConstraint__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JLcom/badlogic/gdx/math/Vector3;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createHingeConstraint__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createHingeConstraint__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createHingeConstraint__SWIG_2", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JLcom/badlogic/gdx/math/Matrix4;Z)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createHingeConstraint__SWIG_3", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JLcom/badlogic/gdx/math/Matrix4;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createConeTwistConstraint__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createConeTwistConstraint__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JLcom/badlogic/gdx/math/Matrix4;)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createGeneric6DofConstraint__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createGeneric6DofConstraint__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JLcom/badlogic/gdx/math/Matrix4;Z)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createGeneric6DofSpringConstraint", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createGeneric6DofSpring2Constraint", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;I)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createSliderConstraint__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Matrix4;Z)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createSliderConstraint__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JLcom/badlogic/gdx/math/Matrix4;Z)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_createGearConstraint", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;JJLcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;F)J" 
    },
    {
      "SwigDirector_btBulletWorldImporter_convertAllObjects", "(Lcom/badlogic/gdx/physics/bullet/extras/btBulletWorldImporter;J)Z" 
    }
  };
  Swig::jclass_ExtrasJNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_ExtrasJNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_method_ids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_method_ids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

