/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.11
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION)
#include <iostream>
#endif

#include <exception>

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    const char *message() const {
      return message_.c_str("Could not get exception message in JavaExceptionMessage");
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (throwable) {
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message());
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : classname_(0), msg_(copystr(msg ? msg : "Unspecified DirectorException message")) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_;
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void raiseJavaException(JNIEnv *jenv) const {
      if (jenv) {
	jenv->ExceptionClear();

	jmethodID ctorMethodID = 0;
	jclass throwableclass = 0;
        if (classname_) {
          throwableclass = jenv->FindClass(classname_);
          if (throwableclass)
            ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
	}

	if (ctorMethodID) {
	  jenv->ThrowNew(throwableclass, what());
	} else {
	  SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
	}
      }
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  SWIGINTERN inline bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <gdx/common/jniHelpers.h>


#include <stdint.h>


#include <gdx/linearmath/mathtypes.h>
#include <LinearMath/btVector3.h>
#include <LinearMath/btQuaternion.h>
#include <LinearMath/btMatrix3x3.h>
#include <LinearMath/btTransform.h>


#include <BulletInverseDynamics/IDConfig.hpp>


#include <BulletInverseDynamics/IDErrorMessages.hpp>


#include <BulletInverseDynamics/IDMath.hpp>


#include <BulletInverseDynamics/MultiBodyTree.hpp>


using namespace btInverseDynamicsBullet3;



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "inversedynamics_wrap.h"


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_setZero_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  vec3 *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(vec3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 & reference is null");
    return ;
  } 
  btInverseDynamicsBullet3::setZero(*arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_setZero_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  vecx *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(vecx **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx & reference is null");
    return ;
  } 
  btInverseDynamicsBullet3::setZero(*arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_setZero_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  mat33 *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(mat33 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 & reference is null");
    return ;
  } 
  btInverseDynamicsBullet3::setZero(*arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_skew(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  vec3 *arg1 = 0 ;
  mat33 *arg2 = (mat33 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(vec3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 & reference is null");
    return ;
  } 
  arg2 = *(mat33 **)&jarg2; 
  btInverseDynamicsBullet3::skew(*arg1,arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_maxAbs_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jfloat jresult = 0 ;
  vecx *arg1 = 0 ;
  idScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(vecx **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  result = (idScalar)btInverseDynamicsBullet3::maxAbs((vecx const &)*arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_maxAbs_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jfloat jresult = 0 ;
  vec3 *arg1 = 0 ;
  idScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(vec3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  result = (idScalar)btInverseDynamicsBullet3::maxAbs((vec3 const &)*arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_getVecMatFromDH(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jfloat jarg4, jlong jarg5, jlong jarg6) {
  idScalar arg1 ;
  idScalar arg2 ;
  idScalar arg3 ;
  idScalar arg4 ;
  vec3 *arg5 = (vec3 *) 0 ;
  mat33 *arg6 = (mat33 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (idScalar)jarg1; 
  arg2 = (idScalar)jarg2; 
  arg3 = (idScalar)jarg3; 
  arg4 = (idScalar)jarg4; 
  arg5 = *(vec3 **)&jarg5; 
  arg6 = *(mat33 **)&jarg6; 
  btInverseDynamicsBullet3::getVecMatFromDH(arg1,arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_isPositiveDefinite(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  mat33 *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(mat33 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  result = (bool)btInverseDynamicsBullet3::isPositiveDefinite((mat33 const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_isPositiveSemiDefinite(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  mat33 *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(mat33 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  result = (bool)btInverseDynamicsBullet3::isPositiveSemiDefinite((mat33 const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_isPositiveSemiDefiniteFuzzy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  mat33 *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(mat33 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  result = (bool)btInverseDynamicsBullet3::isPositiveSemiDefiniteFuzzy((mat33 const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_determinant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jfloat jresult = 0 ;
  mat33 *arg1 = 0 ;
  idScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(mat33 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  result = (idScalar)btInverseDynamicsBullet3::determinant((mat33 const &)*arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_isValidInertiaMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  mat33 *arg1 = 0 ;
  int arg2 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(mat33 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (bool)btInverseDynamicsBullet3::isValidInertiaMatrix((mat33 const &)*arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_isValidTransformMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  mat33 *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(mat33 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  result = (bool)btInverseDynamicsBullet3::isValidTransformMatrix((mat33 const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_bodyTParentFromAxisAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2, jlong jarg3) {
  vec3 *arg1 = 0 ;
  idScalar *arg2 = 0 ;
  mat33 *arg3 = (mat33 *) 0 ;
  idScalar temp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(vec3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return ;
  } 
  temp2 = (idScalar)jarg2; 
  arg2 = &temp2; 
  arg3 = *(mat33 **)&jarg3; 
  btInverseDynamicsBullet3::bodyTParentFromAxisAngle((vec3 const &)*arg1,(float const &)*arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_isUnitVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  vec3 *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(vec3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  result = (bool)btInverseDynamicsBullet3::isUnitVector((vec3 const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_tildeOperator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  vec3 *arg1 = 0 ;
  mat33 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(vec3 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  result = btInverseDynamicsBullet3::tildeOperator((vec3 const &)*arg1);
  *(mat33 **)&jresult = new mat33((const mat33 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_transformX(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  idScalar *arg1 = 0 ;
  idScalar temp1 ;
  mat33 result;
  
  (void)jenv;
  (void)jcls;
  temp1 = (idScalar)jarg1; 
  arg1 = &temp1; 
  result = btInverseDynamicsBullet3::transformX((float const &)*arg1);
  *(mat33 **)&jresult = new mat33((const mat33 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_transformY(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  idScalar *arg1 = 0 ;
  idScalar temp1 ;
  mat33 result;
  
  (void)jenv;
  (void)jcls;
  temp1 = (idScalar)jarg1; 
  arg1 = &temp1; 
  result = btInverseDynamicsBullet3::transformY((float const &)*arg1);
  *(mat33 **)&jresult = new mat33((const mat33 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_transformZ(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  idScalar *arg1 = 0 ;
  idScalar temp1 ;
  mat33 result;
  
  (void)jenv;
  (void)jcls;
  temp1 = (idScalar)jarg1; 
  arg1 = &temp1; 
  result = btInverseDynamicsBullet3::transformZ((float const &)*arg1);
  *(mat33 **)&jresult = new mat33((const mat33 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_rpyFromMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  mat33 *arg1 = 0 ;
  vec3 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(mat33 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  result = btInverseDynamicsBullet3::rpyFromMatrix((mat33 const &)*arg1);
  *(vec3 **)&jresult = new vec3((const vec3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_new_1MultiBodyTree(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btInverseDynamicsBullet3::MultiBodyTree *)new btInverseDynamicsBullet3::MultiBodyTree();
  *(btInverseDynamicsBullet3::MultiBodyTree **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_delete_1MultiBodyTree(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1addBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jfloat jarg8, jlong jarg9, jlong jarg10, jint jarg11, jlong jarg12) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  int arg3 ;
  btInverseDynamicsBullet3::JointType arg4 ;
  vec3 *arg5 = 0 ;
  mat33 *arg6 = 0 ;
  vec3 *arg7 = 0 ;
  idScalar arg8 ;
  vec3 *arg9 = 0 ;
  mat33 *arg10 = 0 ;
  int arg11 ;
  void *arg12 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (btInverseDynamicsBullet3::JointType)jarg4; 
  arg5 = *(vec3 **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  arg6 = *(mat33 **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  arg7 = *(vec3 **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  arg8 = (idScalar)jarg8; 
  arg9 = *(vec3 **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  arg10 = *(mat33 **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  arg11 = (int)jarg11; 
  arg12 = (void *)jarg12; 
  result = (int)(arg1)->addBody(arg2,arg3,arg4,(vec3 const &)*arg5,(mat33 const &)*arg6,(vec3 const &)*arg7,arg8,(vec3 const &)*arg9,(mat33 const &)*arg10,arg11,arg12);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1setAcceptInvalidMassParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setAcceptInvalidMassParameters(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getAcceptInvalidMassProperties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  result = (bool)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getAcceptInvalidMassProperties();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1finalizeInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  result = (int)(arg1)->finalize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1printTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  (arg1)->printTree();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1printTreeData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  (arg1)->printTreeData();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1calculateInverseDynamics(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  vecx *arg2 = 0 ;
  vecx *arg3 = 0 ;
  vecx *arg4 = 0 ;
  vecx *arg5 = (vecx *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = *(vecx **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  arg3 = *(vecx **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  arg4 = *(vecx **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  arg5 = *(vecx **)&jarg5; 
  result = (int)(arg1)->calculateInverseDynamics((vecx const &)*arg2,(vecx const &)*arg3,(vecx const &)*arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1calculateMassMatrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3, jboolean jarg4, jboolean jarg5, jlong jarg6) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  vecx *arg2 = 0 ;
  bool arg3 ;
  bool arg4 ;
  bool arg5 ;
  matxx *arg6 = (matxx *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = *(vecx **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  arg6 = *(matxx **)&jarg6; 
  result = (int)(arg1)->calculateMassMatrix((vecx const &)*arg2,arg3,arg4,arg5,arg6);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1calculateMassMatrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  vecx *arg2 = 0 ;
  matxx *arg3 = (matxx *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = *(vecx **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  arg3 = *(matxx **)&jarg3; 
  result = (int)(arg1)->calculateMassMatrix((vecx const &)*arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1calculateKinematics(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  vecx *arg2 = 0 ;
  vecx *arg3 = 0 ;
  vecx *arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = *(vecx **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  arg3 = *(vecx **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  arg4 = *(vecx **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->calculateKinematics((vecx const &)*arg2,(vecx const &)*arg3,(vecx const &)*arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1calculatePositionKinematics(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  vecx *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = *(vecx **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->calculatePositionKinematics((vecx const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1calculatePositionAndVelocityKinematics(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  vecx *arg2 = 0 ;
  vecx *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = *(vecx **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  arg3 = *(vecx **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vecx const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->calculatePositionAndVelocityKinematics((vecx const &)*arg2,(vecx const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1setGravityInWorldFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  vec3 *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = *(vec3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->setGravityInWorldFrame((vec3 const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1numBodies(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->numBodies();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1numDoFs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->numDoFs();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyOrigin(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyCoM(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyCoM(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  mat33 *arg3 = (mat33 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(mat33 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyTransform(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyAngularVelocity(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyLinearVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyLinearVelocity(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyLinearVelocityCoM(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyLinearVelocityCoM(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyAngularAcceleration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyAngularAcceleration(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyLinearAcceleration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyLinearAcceleration(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getParentIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getParentIndex(arg2,arg3);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getJointType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  btInverseDynamicsBullet3::JointType *arg3 = (btInverseDynamicsBullet3::JointType *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btInverseDynamicsBullet3::JointType **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getJointType(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getJointTypeStr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  char **arg3 = (char **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(char ***)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getJointTypeStr(arg2,(char const **)arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getParentRParentBodyRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getParentRParentBodyRef(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyTParentRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  mat33 *arg3 = (mat33 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(mat33 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyTParentRef(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyAxisOfMotion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyAxisOfMotion(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getDoFOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getDoFOffset(arg2,arg3);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getUserInt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getUserInt(arg2,arg3);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getUserPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  void **arg3 = (void **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(void ***)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getUserPtr(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1setUserInt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->setUserInt(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1setUserPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  void *arg3 = (void *) (void *)0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (void *)jarg3; 
  result = (int)(arg1)->setUserPtr(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1setBodyMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  idScalar arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (idScalar)jarg3; 
  result = (int)(arg1)->setBodyMass(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1setBodyFirstMassMoment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->setBodyFirstMassMoment(arg2,(vec3 const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1setBodySecondMassMoment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  mat33 *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(mat33 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "mat33 const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->setBodySecondMassMoment(arg2,(mat33 const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  idScalar *arg3 = (idScalar *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (btScalar*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyMass(arg2,arg3);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodyFirstMassMoment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = (vec3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodyFirstMassMoment(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1getBodySecondMassMoment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  mat33 *arg3 = (mat33 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(mat33 **)&jarg3; 
  result = (int)((btInverseDynamicsBullet3::MultiBodyTree const *)arg1)->getBodySecondMassMoment(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1clearAllUserForcesAndMoments(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  (arg1)->clearAllUserForcesAndMoments();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1addUserForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->addUserForce(arg2,(vec3 const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_inversedynamics_InverseDynamicsJNI_MultiBodyTree_1addUserMoment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  btInverseDynamicsBullet3::MultiBodyTree *arg1 = (btInverseDynamicsBullet3::MultiBodyTree *) 0 ;
  int arg2 ;
  vec3 *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btInverseDynamicsBullet3::MultiBodyTree **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(vec3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "vec3 const & reference is null");
    return 0;
  } 
  result = (int)(arg1)->addUserMoment(arg2,(vec3 const &)*arg3);
  jresult = (jint)result; 
  return jresult;
}


#ifdef __cplusplus
}
#endif

