/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.class_1297;
import net.minecraft.class_1299;

public final class ConfigMobs {
    private static final String DIR = "config/physicsmod";
    public static final int MOB_PHYSICS_TYPE_OFF = 0;
    public static final int MOB_PHYSICS_TYPE_FRACTURED = 1;
    public static final int MOB_PHYSICS_TYPE_FRACTURED_BLOOD = 2;
    public static final int MOB_PHYSICS_TYPE_BLOCKY = 3;
    public static final int MOB_PHYSICS_TYPE_RAGDOLL = 4;
    public static final int MOB_PHYSICS_TYPE_PARENT = 5;
    private static final String CONFIG = "physics_mobs_client_config.json";
    public static Map<String, Integer> customizedMobs;

    public static void init() {
    }

    public static int getMobSetting(class_1297 entity) {
        Integer val = customizedMobs.get(class_1299.method_5890((class_1299)entity.method_5864()).toString());
        if (val == null) {
            val = 5;
        }
        if (val == 5) {
            return ConfigClient.mobPhysicsType;
        }
        return val;
    }

    private static JsonObject createConfig() {
        JsonObject config = new JsonObject();
        JsonArray array = new JsonArray();
        for (class_1299<?> type : PhysicsMod.renderers.keySet()) {
            String id = class_1299.method_5890(type).toString();
            Integer val = customizedMobs.get(id);
            if (val == null) {
                val = 5;
                customizedMobs.put(id, val);
            }
            array.add(id);
            array.add((Number)val);
        }
        config.add("customizedMobs", (JsonElement)array);
        return config;
    }

    public static void resetMobs() {
        for (Map.Entry<String, Integer> entry : customizedMobs.entrySet()) {
            customizedMobs.put(entry.getKey(), 5);
        }
        ConfigMobs.save();
    }

    public static void save() {
        File configFile;
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if ((configFile = new File("config/physicsmod/physics_mobs_client_config.json")).exists()) {
            configFile.delete();
        }
        JsonObject config = ConfigMobs.createConfig();
        try {
            configFile.createNewFile();
            try (FileWriter writer = new FileWriter(configFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((JsonElement)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        File configFile;
        customizedMobs = new HashMap<String, Integer>();
        JsonObject config = ConfigMobs.createConfig();
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!(configFile = new File("config/physicsmod/physics_mobs_client_config.json")).exists()) {
            try {
                configFile.createNewFile();
                try (FileWriter writer = new FileWriter(configFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Gson gson = new Gson();
            try {
                config = (JsonObject)gson.fromJson((Reader)new FileReader(configFile), JsonObject.class);
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            JsonArray array = config.get("customizedMobs").getAsJsonArray();
            for (int i = 0; i < array.size() / 2; ++i) {
                String id = array.get(i * 2).getAsString();
                Integer val = array.get(i * 2 + 1).getAsInt();
                customizedMobs.put(id, val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

