/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.math.MatrixUtil;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.Usage;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.CameraMatrices;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.JsonUnbakedModelHolder;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.ModExecutor;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1095;
import net.minecraft.class_1159;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4584;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_785;
import net.minecraft.class_793;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.FrustumIntersection;
import org.joml.Matrix3d;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.lwjgl.opengl.GL32C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public class MixinLevelRenderer
implements CameraMatrices {
    @Unique
    private static final Matrix3d IDENTITY_3_BY_3 = new Matrix3d();
    @Unique
    private FrustumIntersection frustumInt;
    @Unique
    private Matrix4f viewProjectionMatrix = new Matrix4f();
    @Unique
    private Matrix4f projectionMatrix = new Matrix4f();
    @Unique
    private Matrix4f viewMatrix = new Matrix4f();
    @Unique
    private class_1159 projectionMatrixMojang = new class_1159();
    @Unique
    private class_1159 viewMatrixMojang = new class_1159();
    private static final int DEFAULT_SIZE = 200;
    @Unique
    private int size = 200;
    @Unique
    private float[] mpos = new float[this.size * 3];
    @Unique
    private byte[] mcol = new byte[this.size * 4];
    @Unique
    private float[] muv = new float[this.size * 2];
    @Unique
    private short[] moverlay = new short[this.size * 2];
    @Unique
    private short[] mlight = new short[this.size * 2];
    @Unique
    private byte[] mnormals = new byte[this.size * 3];
    @Unique
    private int[] mindices = new int[this.size];
    @Unique
    private Matrix4d transformation = new Matrix4d();
    @Unique
    private Matrix3d normalMatrix = new Matrix3d();
    @Unique
    private Vector3d pos = new Vector3d();
    @Unique
    private class_1159 localT = new class_1159();
    @Unique
    private class_1159 mojangNormalMatrix = new class_1159();
    @Unique
    private class_2338.class_2339 blockPos = new class_2338.class_2339();
    @Unique
    private ObjectSet<class_1058> uniqueSprites = new ObjectOpenHashSet();

    @Override
    public Matrix4f getViewMatrix() {
        return this.viewMatrix;
    }

    @Override
    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    @Override
    public Matrix4f getViewProjectionMatrix() {
        return this.viewProjectionMatrix;
    }

    @Override
    public class_1159 getViewMatrixMojang() {
        return this.viewMatrixMojang;
    }

    @Override
    public class_1159 getProjectionMatrixMojang() {
        return this.projectionMatrixMojang;
    }

    @Override
    public FrustumIntersection getFrustum() {
        return this.frustumInt;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLevel"})
    public void renderLevel(class_4587 viewMatrixStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, class_1159 projectionMatrix, CallbackInfo info) {
        if (this.frustumInt == null) {
            this.frustumInt = new FrustumIntersection();
        }
        ModExecutor.setMatrix(this.projectionMatrix, projectionMatrix);
        ModExecutor.setMatrix(this.viewMatrix, viewMatrixStack.method_23760().method_23761());
        this.projectionMatrixMojang = new class_1159(projectionMatrix);
        this.viewMatrixMojang = new class_1159(viewMatrixStack.method_23760().method_23761());
        this.projectionMatrix.mul(this.viewMatrix, this.viewProjectionMatrix);
        this.frustumInt.set(this.viewProjectionMatrix, true);
    }

    @Inject(at={@At(value="TAIL")}, method={"renderChunkLayer"})
    private void renderChunkLayer(class_1921 blockLayerIn, class_4587 viewMatrixStack, double xIn, double yIn, double zInm, class_1159 projectionMatrix, CallbackInfo ci) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (ModExecutor.updateMessage != null && !ModExecutor.updateMessage.isBlank() && class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.class_2562.method_10877((String)ModExecutor.updateMessage), false);
            ModExecutor.updateMessage = "";
        }
        if (ModExecutor.customMessage != null && !ModExecutor.customMessage.isBlank() && class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.class_2562.method_10877((String)ModExecutor.customMessage), false);
            ModExecutor.customMessage = "";
        }
        blockLayerIn.method_23516();
        if (blockLayerIn == class_1921.method_23581()) {
            class_1937 level;
            if (this.frustumInt == null) {
                this.frustumInt = new FrustumIntersection();
            }
            ModExecutor.setMatrix(this.projectionMatrix, projectionMatrix);
            ModExecutor.setMatrix(this.viewMatrix, viewMatrixStack.method_23760().method_23761());
            this.projectionMatrixMojang = new class_1159(projectionMatrix);
            this.viewMatrixMojang = new class_1159(viewMatrixStack.method_23760().method_23761());
            this.projectionMatrix.mul(this.viewMatrix, this.viewProjectionMatrix);
            this.frustumInt.set(this.viewProjectionMatrix, true);
            RenderSystem.setShader(class_757::method_34501);
            RenderSystem.setProjectionMatrix((class_1159)projectionMatrix);
            class_4587 matrixStackIn = RenderSystem.getModelViewStack();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_243 view = class_310.method_1551().field_1773.method_19418().method_19326();
            matrixStackIn.method_22903();
            matrixStackIn.method_34425(viewMatrixStack.method_23760().method_23761());
            class_310.method_1551().field_1773.method_22974().method_3316();
            RenderSystem.activeTexture((int)33984);
            RenderSystem.enableTexture();
            class_746 player = class_310.method_1551().field_1724;
            this.uniqueSprites.clear();
            if (player != null && (level = player.method_5770()) != null) {
                matrixStackIn.method_22903();
                PhysicsMod mod = PhysicsMod.getInstance(level);
                PhysicsWorld physics = mod.getPhysicsWorld();
                physics.updateLastSeen();
                this.updatePhysics(mod, level, player, physics);
                int oldVao = 0;
                if (physics.getBodies().size() > 0 || physics.getRagdolls().size() > 0) {
                    if (!ModExecutor.RENDER_LEGACY) {
                        this.setupShader(RenderSystem.getShader());
                        oldVao = GL32C.glGetInteger((int)34229);
                    }
                    int count = 0;
                    for (IRigidBody body : physics.getBodies()) {
                        if (body.isRagdoll) continue;
                        this.setTransformation(physics, body, body.getEntity());
                        this.render(physics, level, matrixStackIn, view, body.getEntity());
                        ++count;
                    }
                    for (Ragdoll ragdoll : physics.getRagdolls()) {
                        for (IRigidBody body : ragdoll.btBodies) {
                            this.setTransformation(physics, body, body.getEntity());
                            this.render(physics, level, matrixStackIn, view, body.getEntity());
                            ++count;
                        }
                    }
                    if (!ModExecutor.RENDER_LEGACY) {
                        GL32C.glBindVertexArray((int)oldVao);
                        RenderSystem.getShader().method_34585();
                    }
                }
                matrixStackIn.method_22909();
            }
            if (ModExecutor.sodium) {
                for (class_1058 sprite : this.uniqueSprites) {
                    Sodium.markSpriteActive(sprite);
                }
            }
            matrixStackIn.method_22909();
        }
        RenderSystem.activeTexture((int)33984);
        RenderSystem.enableCull();
        blockLayerIn.method_23518();
        RenderSystem.applyModelViewMatrix();
    }

    @Unique
    private void setTransformation(PhysicsWorld physics, IRigidBody body, PhysicsEntity entity) {
        if (body.hasTransformationChanged()) {
            MatrixUtil.slerp(entity.getOldTransformation(), entity.getTransformation(), physics.getRenderPercent(), this.transformation);
        } else {
            this.transformation.set(entity.getTransformation());
        }
    }

    @Unique
    private void render(PhysicsWorld physics, class_1937 level, class_4587 matrixStackIn, class_243 view, PhysicsEntity particle) {
        if (particle.models.get((int)0).mesh == null) {
            return;
        }
        if (particle.backfaceCulling) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        double scaleX = Math.clamp(particle.time * 2.0, 0.0, 1.0) * particle.scalePhysics.x * particle.scale;
        double scaleY = Math.clamp(particle.time * 2.0, 0.0, 1.0) * particle.scalePhysics.y * particle.scale;
        double scaleZ = Math.clamp(particle.time * 2.0, 0.0, 1.0) * particle.scalePhysics.z * particle.scale;
        this.transformation.m30(this.transformation.m30() + physics.getOffset().x - view.field_1352);
        this.transformation.m31(this.transformation.m31() + physics.getOffset().y - view.field_1351);
        this.transformation.m32(this.transformation.m32() + physics.getOffset().z - view.field_1350);
        this.transformation.scale((float)scaleX, (float)scaleY, (float)scaleZ);
        this.transformation.getTranslation(this.pos);
        if (!this.frustumInt.testSphere((float)this.pos.x, (float)this.pos.y, (float)this.pos.z, (float)particle.getBoundingSphereRadius())) {
            return;
        }
        this.blockPos.method_10102(this.pos.x + view.field_1352, this.pos.y + view.field_1351, this.pos.z + view.field_1350);
        matrixStackIn.method_22903();
        ModExecutor.setMojangMatrix(this.localT, this.transformation);
        matrixStackIn.method_34425(this.localT);
        this.transformation.normal(this.normalMatrix).invert();
        if (particle.shade) {
            ModExecutor.setMojangMatrix(this.mojangNormalMatrix, this.normalMatrix);
        } else {
            ModExecutor.setMojangMatrix(this.mojangNormalMatrix, IDENTITY_3_BY_3);
        }
        RenderSystem.applyModelViewMatrix();
        if (class_310.method_1551().field_1724 != null && (level instanceof class_638 ? ((class_638)level).method_28103().method_29993() : class_310.method_1551().field_1724.field_17892.method_28103().method_29993())) {
            class_308.method_1452((class_1159)this.mojangNormalMatrix);
        } else {
            class_308.method_27869((class_1159)this.mojangNormalMatrix);
        }
        for (Model model : particle.models) {
            for (int i = 0; i < model.textureIDs.length; ++i) {
                RenderSystem.setShaderTexture((int)i, (int)model.textureIDs[i]);
                RenderSystem.activeTexture((int)(33984 + i));
                RenderSystem.bindTexture((int)model.textureIDs[i]);
            }
            if (model.animationSprite != null) {
                this.uniqueSprites.add((Object)model.animationSprite);
            }
            if (ModExecutor.RENDER_LEGACY) {
                this.renderLegacy(level, particle, model, this.blockPos);
                continue;
            }
            this.renderFast(level, particle, model, this.blockPos);
        }
        matrixStackIn.method_22909();
    }

    @Unique
    private void updatePhysics(PhysicsMod mod, class_1937 level, class_746 player, PhysicsWorld physics) {
        PhysicsEntity particle;
        int qsize;
        mod.removeUpdates.clear();
        for (int i = mod.updateQueue.size() - 1; i >= 0; --i) {
            mod.removeUpdates.add(mod.updateQueue.get(i));
        }
        mod.updateQueue.clear();
        ObjectArrayList newParts = new ObjectArrayList();
        for (BlockUpdate bu : mod.removeUpdates) {
            Object entity;
            if (bu.state.method_26204() == class_2246.field_10375 || bu.state.method_26204() == class_2246.field_10379) continue;
            int blockSetting = ConfigBlocks.getBlockSetting(bu.state.method_26204());
            if (blockSetting == 1) {
                newParts.addAll(this.getBlockData(bu, bu.level));
                continue;
            }
            if (blockSetting != 3 || bu.state.method_26204() == class_2246.field_10124 || (entity = mod.renderBlockIntoEntity(PhysicsEntity.Type.BLOCK, bu.state, bu.pos)) == null) continue;
            physics.addBlockParticle((PhysicsEntity)entity).applyRandomSpawnForces();
        }
        double chance = 1.0;
        if (newParts.size() > 10 || (double)physics.getBodies().size() > (double)ConfigClient.maxPhysicsObjects * 0.4) {
            chance = 0.3;
            if ((double)physics.getBodies().size() > (double)ConfigClient.maxPhysicsObjects * 0.7) {
                chance = 0.05;
            }
        }
        if (physics.getBodies().size() > ConfigClient.maxPhysicsObjects) {
            chance = 0.0;
        }
        if ((qsize = newParts.size()) == 1) {
            chance = 1.0;
        }
        for (PhysicsEntity particle2 : newParts) {
            double volume = (particle2.max.x - particle2.min.x) * (particle2.max.y - particle2.min.y) * (particle2.max.z - particle2.min.z);
            List<Mesh> mesh = PhysicsMod.brokenBlock;
            if (!(java.lang.Math.random() < chance)) continue;
            mesh = chance < 0.5 || (double)physics.getBodies().size() > (double)ConfigClient.maxPhysicsObjects * 0.4 ? PhysicsMod.brokenBlocksLittle.get(new Random().nextInt(PhysicsMod.brokenBlocksLittle.size())) : PhysicsMod.brokenBlocksLots.get(new Random().nextInt(PhysicsMod.brokenBlocksLots.size()));
            if (volume < 0.05) {
                mesh = PhysicsMod.brokenBlock;
            } else if (volume < 0.9) {
                mesh = PhysicsMod.brokenBlocksLittle.get(new Random().nextInt(PhysicsMod.brokenBlocksLittle.size()));
            }
            particle2.scale = ConfigClient.blockPhysicsScale;
            physics.addBlockParticle(mesh, particle2);
        }
        while (!mod.entityBlocks.isEmpty()) {
            particle = mod.entityBlocks.poll();
            if (particle.noVolume) continue;
            physics.addBlockParticle(particle).applyRandomSpawnForces();
        }
        while (!mod.additionalPhysics.isEmpty()) {
            particle = mod.additionalPhysics.poll();
            physics.addBlockParticle(particle).applyRandomSpawnForces();
        }
        while (!mod.ragdolls.isEmpty()) {
            Ragdoll ragdoll = mod.ragdolls.poll();
            physics.addRagdoll(ragdoll);
        }
        while (!mod.blockUpdates.isEmpty()) {
            class_2338 pos = mod.blockUpdates.poll();
            physics.blockUpdate(pos);
        }
        while (!mod.explosions.isEmpty()) {
            physics.applyExplosion(mod.explosions.poll());
        }
    }

    @Unique
    private void renderFast(class_1937 level, PhysicsEntity particle, Model model, class_2338.class_2339 blockPos) {
        Mesh mesh = model.mesh;
        boolean shade = particle.shade;
        if (mesh.indices.size() < 3) {
            return;
        }
        int brightness = mesh.light.size() == 0 ? particle.getLight(level, blockPos) : 0;
        int j = brightness >> 16 & 0xFFFF;
        int k = brightness & 0xFFFF;
        int overlay = model.overlay;
        short overlayX = (short)(overlay >> 16 & 0xFFFF);
        short overlayY = (short)(overlay & 0xFFFF);
        if (model.vao == null) {
            model.brightness = brightness;
            float b = (float)(particle.color & 0xFF) / 255.0f;
            float g = (float)(particle.color >> 8 & 0xFF) / 255.0f;
            float r = (float)(particle.color >> 16 & 0xFF) / 255.0f;
            net.diebuddies.opengl.Mesh openglMesh = new net.diebuddies.opengl.Mesh();
            this.checkArrays(mesh.indices.size());
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 0.0f;
            float maxV = 1.0f;
            if (model.texture != null) {
                minU = model.texture.method_4594();
                maxU = model.texture.method_4577();
                minV = model.texture.method_4593();
                maxV = model.texture.method_4575();
            }
            for (int i = 0; i < mesh.indices.size(); ++i) {
                Vector3i index = mesh.indices.get(i);
                Vector3d p = mesh.positions.get(index.x - 1);
                Vector2d uv = mesh.uvs.get(index.y - 1);
                Vector3d normal = mesh.normals.get(index.z - 1);
                if (mesh.colors.size() > 0) {
                    Vector3f color = mesh.colors.get(index.x - 1);
                    r = color.x;
                    g = color.y;
                    b = color.z;
                }
                if (mesh.light.size() > 0) {
                    Vector2i light = mesh.light.get(index.x - 1);
                    this.mlight[i * 2] = (short)light.x;
                    this.mlight[i * 2 + 1] = (short)light.y;
                } else {
                    this.mlight[i * 2] = (short)k;
                    this.mlight[i * 2 + 1] = (short)j;
                }
                this.mpos[i * 3] = (float)p.x;
                this.mpos[i * 3 + 1] = (float)p.y;
                this.mpos[i * 3 + 2] = (float)p.z;
                this.mcol[i * 4] = (byte)(r * 255.0f);
                this.mcol[i * 4 + 1] = (byte)(g * 255.0f);
                this.mcol[i * 4 + 2] = (byte)(b * 255.0f);
                this.mcol[i * 4 + 3] = -1;
                this.muv[i * 2] = Math.remap((float)uv.x, 0.0f, 1.0f, minU, maxU);
                this.muv[i * 2 + 1] = Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV);
                this.moverlay[i * 2] = overlayX;
                this.moverlay[i * 2 + 1] = overlayY;
                if (shade) {
                    this.mnormals[i * 3] = class_4584.method_24212((float)((float)normal.x));
                    this.mnormals[i * 3 + 1] = class_4584.method_24212((float)((float)normal.y));
                    this.mnormals[i * 3 + 2] = class_4584.method_24212((float)((float)normal.z));
                } else {
                    this.mnormals[i * 3] = class_4584.method_24212((float)0.0f);
                    this.mnormals[i * 3 + 1] = class_4584.method_24212((float)1.0f);
                    this.mnormals[i * 3 + 2] = class_4584.method_24212((float)0.0f);
                }
                this.mindices[i] = i;
            }
            openglMesh.set(this.mpos, Data.POSITION);
            openglMesh.set(this.mcol, Data.COLOR);
            openglMesh.set(this.muv, Data.TEX_COORD);
            openglMesh.set(this.moverlay, Data.OVERLAY);
            openglMesh.set(this.mlight, Data.LIGHT);
            openglMesh.set(this.mnormals, Data.NORMAL);
            openglMesh.set(this.mindices, Data.INDEX);
            openglMesh.setSize(Data.POSITION, mesh.indices.size() * 3);
            openglMesh.setSize(Data.COLOR, mesh.indices.size() * 4);
            openglMesh.setSize(Data.TEX_COORD, mesh.indices.size() * 2);
            openglMesh.setSize(Data.OVERLAY, mesh.indices.size() * 2);
            openglMesh.setSize(Data.LIGHT, mesh.indices.size() * 2);
            openglMesh.setSize(Data.NORMAL, mesh.indices.size() * 3);
            openglMesh.setSize(Data.INDEX, mesh.indices.size());
            model.vao = openglMesh.constructVAO(Usage.DYNAMIC);
        }
        if (brightness != model.brightness && mesh.light.size() == 0) {
            model.brightness = brightness;
            this.checkArrays(mesh.indices.size());
            for (int i = 0; i < mesh.indices.size(); ++i) {
                this.mlight[i * 2] = (short)k;
                this.mlight[i * 2 + 1] = (short)j;
            }
            model.vao.bind();
            model.vao.updateAttribute(Data.LIGHT, this.mlight, mesh.indices.size() * 2);
        }
        class_5944 shader = RenderSystem.getShader();
        shader.field_29470.method_1250(RenderSystem.getModelViewMatrix());
        RenderSystem.setupShaderLights((class_5944)shader);
        if (shader.field_29475 != null) {
            shader.field_29475.method_1300();
        }
        if (shader.field_29476 != null) {
            shader.field_29476.method_1300();
        }
        shader.field_29470.method_1300();
        model.vao.render();
    }

    @Unique
    private void checkArrays(int neededSize) {
        if (neededSize > this.size) {
            this.size *= 2;
            this.mpos = new float[this.size * 3];
            this.mcol = new byte[this.size * 4];
            this.muv = new float[this.size * 2];
            this.moverlay = new short[this.size * 2];
            this.mlight = new short[this.size * 2];
            this.mnormals = new byte[this.size * 3];
            this.mindices = new int[this.size];
        }
    }

    @Unique
    private void renderLegacy(class_1937 level, PhysicsEntity particle, Model model, class_2338.class_2339 blockPos) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1580);
        int brightness = particle.getLight(level, blockPos);
        Mesh mesh = model.mesh;
        boolean shade = particle.shade;
        int j = brightness >> 16 & 0xFFFF;
        int k = brightness & 0xFFFF;
        float b = (float)(particle.color & 0xFF) / 255.0f;
        float g = (float)(particle.color >> 8 & 0xFF) / 255.0f;
        float r = (float)(particle.color >> 16 & 0xFF) / 255.0f;
        for (Vector3i index : mesh.indices) {
            Vector3d position = mesh.positions.get(index.x - 1);
            Vector2d uv = mesh.uvs.get(index.y - 1);
            Vector3d normal = mesh.normals.get(index.z - 1);
            if (mesh.colors.size() > 0) {
                Vector3f color = mesh.colors.get(index.x - 1);
                r = color.x;
                g = color.y;
                b = color.z;
            }
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 0.0f;
            float maxV = 1.0f;
            if (model.texture != null) {
                minU = model.texture.method_4594();
                maxU = model.texture.method_4577();
                minV = model.texture.method_4593();
                maxV = model.texture.method_4575();
            }
            if (shade) {
                bufferbuilder.method_23919((float)position.x, (float)position.y, (float)position.z, r, g, b, 1.0f, Math.remap((float)uv.x, 0.0f, 1.0f, minU, maxU), Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV), model.overlay, k | j << 16, (float)normal.x, (float)normal.y, (float)normal.z);
                continue;
            }
            bufferbuilder.method_23919((float)position.x, (float)position.y, (float)position.z, r, g, b, 1.0f, Math.remap((float)uv.x, 0.0f, 1.0f, minU, maxU), Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV), model.overlay, k | j << 16, 0.0f, 1.0f, 0.0f);
        }
        tessellator.method_1350();
    }

    @Unique
    private void debugRenderBox(float width, float height, float depth, float r, float g, float b, float a) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        float[] positions = new float[]{-0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f};
        int[] indices = new int[]{0, 1, 2, 0, 2, 3, 6, 5, 4, 7, 6, 4, 10, 9, 8, 11, 10, 8, 12, 13, 14, 12, 14, 15, 18, 17, 16, 19, 18, 16, 20, 21, 22, 20, 22, 23};
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i] * 3;
            bufferbuilder.method_22912((double)(positions[index] * width), (double)(positions[index + 1] * height), (double)(positions[index + 2] * depth)).method_22915(r, g, b, a).method_1344();
        }
        tessellator.method_1350();
    }

    @Unique
    private void setupShader(class_5944 shader) {
        for (int n = 0; n < 8; ++n) {
            int o = RenderSystem.getShaderTexture((int)n);
            shader.method_34583("Sampler" + n, (Object)o);
        }
        if (shader.field_29470 != null) {
            shader.field_29470.method_1250(RenderSystem.getModelViewMatrix());
        }
        if (shader.field_29471 != null) {
            shader.field_29471.method_1250(RenderSystem.getProjectionMatrix());
        }
        if (shader.field_29474 != null) {
            shader.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shader.field_29477 != null) {
            shader.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (shader.field_29478 != null) {
            shader.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (shader.field_29479 != null) {
            shader.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (shader.field_29472 != null) {
            shader.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shader.field_29481 != null) {
            shader.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (shader.field_29473 != null) {
            class_1041 window = class_310.method_1551().method_22683();
            shader.field_29473.method_1255((float)window.method_4489(), (float)window.method_4506());
        }
        RenderSystem.setupShaderLights((class_5944)shader);
        shader.method_34586();
    }

    @Unique
    private List<PhysicsEntity> getBlockData(BlockUpdate update, class_1937 level) {
        ObjectArrayList particles = new ObjectArrayList();
        class_2338 pos = update.pos;
        class_2680 state = update.state;
        class_1091 id = class_773.method_3340((class_2680)state);
        class_1087 bakedModel = class_310.method_1551().method_1554().method_4742(id);
        if (state.method_26204() == class_2246.field_10580 || state.method_26204() == class_2246.field_10240 || state.method_26204() == class_2246.field_10556) {
            bakedModel = null;
        }
        if (bakedModel instanceof class_1095) {
            class_1095 multi = (class_1095)bakedModel;
            BitSet bitSet = (BitSet)multi.field_5431.get(state);
            if (bitSet == null) {
                bitSet = new BitSet();
                for (int i = 0; i < multi.field_5427.size(); ++i) {
                    Pair pair = (Pair)multi.field_5427.get(i);
                    if (!((Predicate)pair.getLeft()).test(state)) continue;
                    bitSet.set(i);
                }
                multi.field_5431.put(state, bitSet);
            }
            for (int j = 0; j < bitSet.length(); ++j) {
                class_1087 model;
                JsonUnbakedModelHolder unbakedModel;
                if (!bitSet.get(j) || (unbakedModel = PhysicsMod.loadedModels.get(model = (class_1087)((Pair)multi.field_5427.get(j)).getRight())) == null || !(unbakedModel.model instanceof class_793)) continue;
                this.addParticles((List<PhysicsEntity>)particles, unbakedModel, level, update);
            }
        } else {
            JsonUnbakedModelHolder unbakedModel = PhysicsMod.loadedModels.get(bakedModel);
            if (unbakedModel != null && unbakedModel.model instanceof class_793) {
                this.addParticles((List<PhysicsEntity>)particles, unbakedModel, level, update);
            } else {
                PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.BLOCK);
                class_310 minecraft = class_310.method_1551();
                class_776 ren = minecraft.method_1541();
                class_1087 model = ren.method_3349(state);
                particle.setTransformation(new Matrix4d().translate((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5));
                particle.setOldTransformation(new Matrix4d().translate((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5));
                particle.models.get((int)0).texture = model.method_4711();
                particle.models.get((int)0).textureIDs = new int[]{model.method_4711().method_24119().method_4624()};
                int color = class_310.method_1551().method_1505().method_1697(update.state, (class_1920)level, update.pos, 0);
                if (color == -1) {
                    color = -1;
                }
                particle.color = color;
                if (update.state.method_26204() == class_2246.field_10593 || update.state.method_26204() == class_2246.field_10219) {
                    particle.color = -1;
                }
                particles.add(particle);
            }
        }
        return particles;
    }

    @Unique
    private void addParticles(List<PhysicsEntity> particles, JsonUnbakedModelHolder unbakedModel, class_1937 level, BlockUpdate update) {
        class_2680 state = update.state;
        class_2338 pos = update.pos;
        for (class_785 element : unbakedModel.model.method_3433()) {
            PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.BLOCK);
            particle.min.set(element.field_4228.method_4943() / 16.0f, element.field_4228.method_4945() / 16.0f, element.field_4228.method_4947() / 16.0f);
            particle.max.set(element.field_4231.method_4943() / 16.0f, element.field_4231.method_4945() / 16.0f, element.field_4231.method_4947() / 16.0f);
            particle.shade = element.field_4229;
            class_310 minecraft = class_310.method_1551();
            class_776 ren = minecraft.method_1541();
            class_1087 model = ren.method_3349(state);
            class_1159 m = unbakedModel.transformation;
            Matrix4d transformation = new Matrix4d();
            ModExecutor.setMatrix(transformation, m);
            particle.setTransformation(new Matrix4d().translate((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5).mul(transformation));
            particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
            particle.models.get((int)0).texture = model.method_4711();
            particle.models.get((int)0).textureIDs = new int[]{model.method_4711().method_24119().method_4624()};
            int color = class_310.method_1551().method_1505().method_1697(update.state, (class_1920)level, update.pos, 0);
            if (color == -1) {
                color = -1;
            }
            particle.color = color;
            if (update.state.method_26204() == class_2246.field_10593 || update.state.method_26204() == class_2246.field_10219) {
                particle.color = -1;
            }
            particles.add(particle);
        }
    }
}

