/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.capes;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.physics.CameraMatrices;
import net.diebuddies.physics.ModExecutor;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_757;
import net.minecraft.class_922;
import net.minecraft.class_972;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_972.class})
public class MixinCapeFeatureRenderer {
    @Unique
    private Map<class_742, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private class_1159 localT = new class_1159();
    @Unique
    private class_742 player;
    @Unique
    private float tickDelta;
    @Unique
    private float animationProgress;
    @Unique
    private boolean renderedCape;

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void renderHead(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_742 player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        this.player = player;
        this.tickDelta = tickDelta;
        this.animationProgress = animationProgress;
        this.renderedCape = false;
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    public void renderTail(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_742 player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    public void renderCloak(class_591 playerModel, class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay) {
        ((class_591)((class_972)this).method_17165()).method_2823(poseStack, vertexConsumer, light, class_4608.field_21444);
        this.renderedCape = true;
    }

    private boolean shouldRenderPhysicsCape(class_742 player) {
        return !PhysicsMod.hudRendering && ConfigClient.clothPhysics && player.method_3125() && !player.method_5767() && player.method_7348(class_1664.field_7559) && (player.method_3119() != null || class_310.method_1551().field_1724 == player && ConfigClient.physicsModCape);
    }

    private void renderPhysicsCape(class_742 player, int light) {
    }

    private int getCapeTexture(class_742 player) {
        if (this.isMojangCape(player)) {
            return class_310.method_1551().method_1531().method_4619(player.method_3119()).method_4624();
        }
        return PhysicsMod.capeTexture.getID();
    }

    private ColladaMesh getCapeMesh(class_742 player) {
        if (this.isMojangCape(player)) {
            return PhysicsMod.defaultCapeMesh;
        }
        return PhysicsMod.capeMesh;
    }

    public boolean isMojangCape(class_742 player) {
        return player.method_3119() != null && (!ConfigClient.physicsModCape || class_310.method_1551().field_1724 != player);
    }

    private void renderDefaultCape(class_4587 viewModelMatrix, class_4597 vertexConsumerProvider, int light, class_742 player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_1799 itemStack;
        if (player.method_3125() && !player.method_5767() && player.method_7348(class_1664.field_7559) && player.method_3119() != null && !(itemStack = player.method_6118(class_1304.field_6174)).method_31574(class_1802.field_8833)) {
            viewModelMatrix.method_22903();
            viewModelMatrix.method_22904(0.0, 0.0, 0.125);
            double d = class_3532.method_16436((double)tickDelta, (double)player.field_7524, (double)player.field_7500) - class_3532.method_16436((double)tickDelta, (double)player.field_6014, (double)player.method_23317());
            double e = class_3532.method_16436((double)tickDelta, (double)player.field_7502, (double)player.field_7521) - class_3532.method_16436((double)tickDelta, (double)player.field_6036, (double)player.method_23318());
            double m = class_3532.method_16436((double)tickDelta, (double)player.field_7522, (double)player.field_7499) - class_3532.method_16436((double)tickDelta, (double)player.field_5969, (double)player.method_23321());
            float n = player.field_6220 + (player.field_6283 - player.field_6220);
            double o = class_3532.method_15374((float)(n * ((float)java.lang.Math.PI / 180)));
            double p = -class_3532.method_15362((float)(n * ((float)java.lang.Math.PI / 180)));
            float q = (float)e * 10.0f;
            q = class_3532.method_15363((float)q, (float)-6.0f, (float)32.0f);
            float r = (float)(d * o + m * p) * 100.0f;
            r = class_3532.method_15363((float)r, (float)0.0f, (float)150.0f);
            float s = (float)(d * p - m * o) * 100.0f;
            s = class_3532.method_15363((float)s, (float)-20.0f, (float)20.0f);
            if (r < 0.0f) {
                r = 0.0f;
            }
            float t = class_3532.method_16439((float)tickDelta, (float)player.field_7505, (float)player.field_7483);
            q += class_3532.method_15374((float)(class_3532.method_16439((float)tickDelta, (float)player.field_6039, (float)player.field_5973) * 6.0f)) * 32.0f * t;
            if (player.method_18276()) {
                q += 25.0f;
            }
            viewModelMatrix.method_22907(class_1160.field_20703.method_23214(6.0f + r / 2.0f + q));
            viewModelMatrix.method_22907(class_1160.field_20707.method_23214(s / 2.0f));
            viewModelMatrix.method_22907(class_1160.field_20705.method_23214(180.0f - s / 2.0f));
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23572((class_2960)player.method_3119()));
            ((class_591)((class_972)this).method_17165()).method_2823(viewModelMatrix, vertexConsumer, light, class_4608.field_21444);
            viewModelMatrix.method_22909();
        }
    }

    @Unique
    private void doCapeTransformation(class_4587 modelMatrix, class_742 player, float tickDelta) {
        double d = class_3532.method_16436((double)tickDelta, (double)player.field_7524, (double)player.field_7500) - class_3532.method_16436((double)tickDelta, (double)player.field_6014, (double)player.method_23317());
        double e = class_3532.method_16436((double)tickDelta, (double)player.field_7502, (double)player.field_7521) - class_3532.method_16436((double)tickDelta, (double)player.field_6036, (double)player.method_23318());
        double m = class_3532.method_16436((double)tickDelta, (double)player.field_7522, (double)player.field_7499) - class_3532.method_16436((double)tickDelta, (double)player.field_5969, (double)player.method_23321());
        float n = player.field_6220 + (player.field_6283 - player.field_6220);
        double o = class_3532.method_15374((float)(n * ((float)java.lang.Math.PI / 180)));
        double p = -class_3532.method_15362((float)(n * ((float)java.lang.Math.PI / 180)));
        float q = (float)e * 10.0f;
        q = class_3532.method_15363((float)q, (float)-6.0f, (float)32.0f);
        float r = (float)(d * o + m * p) * 100.0f;
        r = class_3532.method_15363((float)r, (float)0.0f, (float)150.0f);
        float s = (float)(d * p - m * o) * 100.0f;
        s = class_3532.method_15363((float)s, (float)-20.0f, (float)20.0f);
        if (r < 0.0f) {
            r = 0.0f;
        }
        float t = class_3532.method_16439((float)tickDelta, (float)player.field_7505, (float)player.field_7483);
        q += class_3532.method_15374((float)(class_3532.method_16439((float)tickDelta, (float)player.field_6039, (float)player.field_5973) * 6.0f)) * 32.0f * t;
        if (player.method_18276()) {
            q += 25.0f;
        }
        modelMatrix.method_22904(0.0, 0.0, 0.125);
        modelMatrix.method_22907(class_1160.field_20703.method_23214(6.0f + r / 2.0f + q));
        modelMatrix.method_22907(class_1160.field_20707.method_23214(s / 2.0f));
        modelMatrix.method_22907(class_1160.field_20705.method_23214(180.0f - s / 2.0f));
        class_591 entityModel = (class_591)((class_972)this).method_17165();
        entityModel.field_3485.method_22703(modelMatrix);
    }

    @Unique
    private void playerCollisionDetection(class_4587 modelMatrix, VerletSimulation simulation, class_742 player, float tickDelta, float animationProgress) {
        class_2350 direction;
        class_922 renderer = (class_922)class_310.method_1551().method_1561().method_3953((class_1297)player);
        float enlarge = 0.075f;
        double px = class_3532.method_16436((double)tickDelta, (double)player.field_6038, (double)player.method_23317());
        double py = class_3532.method_16436((double)tickDelta, (double)player.field_5971, (double)player.method_23318());
        double pz = class_3532.method_16436((double)tickDelta, (double)player.field_5989, (double)player.method_23321());
        if (simulation != null) {
            px -= simulation.getOffset().x;
            py -= simulation.getOffset().y;
            pz -= simulation.getOffset().z;
        }
        modelMatrix.method_22904(px, py, pz);
        class_243 positionOffset = renderer.method_23169((class_1297)player, tickDelta);
        modelMatrix.method_22904(positionOffset.field_1352, positionOffset.field_1351, positionOffset.field_1350);
        float yaw = class_3532.method_17821((float)tickDelta, (float)player.field_6220, (float)player.field_6283);
        if (player.method_18376() == class_4050.field_18078 && (direction = player.method_18401()) != null) {
            float eyeHeight = player.method_18381(class_4050.field_18076) - 0.1f;
            modelMatrix.method_22904((double)((float)(-direction.method_10148()) * eyeHeight), 0.0, (double)((float)(-direction.method_10165()) * eyeHeight));
        }
        renderer.method_4058((class_1309)player, modelMatrix, animationProgress, yaw, tickDelta);
        modelMatrix.method_22905(-1.0f, -1.0f, 1.0f);
        modelMatrix.method_22905(0.9375f, 0.9375f, 0.9375f);
        modelMatrix.method_22904(0.0, (double)-1.501f, 0.0);
    }

    @Unique
    private void renderVerletSimulation(VerletSimulation verletSimulation, class_1937 level, class_742 player, int brightness) {
        CameraMatrices cameraMatrices = (CameraMatrices)class_310.method_1551().field_1769;
        double renderPercent = PhysicsMod.getInstance(level).getPhysicsWorld().getRenderPercent();
        class_5944 shader = RenderSystem.getShader();
        RenderSystem.setShader(class_757::method_34501);
        RenderSystem.setProjectionMatrix((class_1159)cameraMatrices.getProjectionMatrixMojang());
        class_1159 projectionBefore = RenderSystem.getProjectionMatrix();
        class_4587 matrixStackIn = RenderSystem.getModelViewStack();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_243 view = class_310.method_1551().field_1773.method_19418().method_19326();
        int glID = verletSimulation.textureID;
        RenderSystem.activeTexture((int)33984);
        RenderSystem.setShaderTexture((int)0, (int)glID);
        RenderSystem.bindTexture((int)glID);
        RenderSystem.disableCull();
        this.localT.method_22668();
        Vector3d offset = verletSimulation.getOffset();
        this.localT.method_31544((float)(-view.field_1352 + offset.x), (float)(-view.field_1351 + offset.y), (float)(-view.field_1350 + offset.z));
        matrixStackIn.method_22903();
        matrixStackIn.method_23760().method_23761().method_35434(cameraMatrices.getViewMatrixMojang());
        ModExecutor.setMojangMatrix(matrixStackIn.method_23760().method_23762(), cameraMatrices.getViewMatrixMojang());
        matrixStackIn.method_34425(this.localT);
        RenderSystem.applyModelViewMatrix();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        class_1159 identity = new class_1159();
        identity.method_22668();
        if (class_310.method_1551().field_1724 != null && (level instanceof class_638 ? ((class_638)level).method_28103().method_29993() : class_310.method_1551().field_1724.field_17892.method_28103().method_29993())) {
            class_308.method_1452((class_1159)identity);
        } else {
            class_308.method_27869((class_1159)identity);
        }
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1580);
        List<VerletQuad> quads = verletSimulation.getQuads();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        for (int i = 0; i < quads.size(); ++i) {
            VerletQuad quad = quads.get(i);
            if (ConfigClient.clothSmoothShading) {
                this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point4.position, quad.point4.prevPosition, quad.point4.uv, quad.point4.normal, brightness, r, g, b, a);
                this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point3.position, quad.point3.prevPosition, quad.point3.uv, quad.point3.normal, brightness, r, g, b, a);
                this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point2.position, quad.point2.prevPosition, quad.point2.uv, quad.point2.normal, brightness, r, g, b, a);
                this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point1.position, quad.point1.prevPosition, quad.point1.uv, quad.point1.normal, brightness, r, g, b, a);
                continue;
            }
            this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point4.position, quad.point4.prevPosition, quad.point4.uv, quad.point1.normal, brightness, r, g, b, a);
            this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point3.position, quad.point3.prevPosition, quad.point3.uv, quad.point1.normal, brightness, r, g, b, a);
            this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point2.position, quad.point2.prevPosition, quad.point2.uv, quad.point1.normal, brightness, r, g, b, a);
            this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point1.position, quad.point1.prevPosition, quad.point1.uv, quad.point1.normal, brightness, r, g, b, a);
        }
        tessellator.method_1350();
        matrixStackIn.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setProjectionMatrix((class_1159)projectionBefore);
        RenderSystem.setShader(() -> shader);
    }

    @Unique
    private void bufferVertex(class_4588 bufferbuilder, double renderPercent, Vector3d position, Vector3d prevPosition, Vector2f uv, Vector3d normal, int brightness, float r, float g, float b, float a) {
        bufferbuilder.method_23919((float)Math.lerp(prevPosition.x, position.x, renderPercent), (float)Math.lerp(prevPosition.y, position.y, renderPercent), (float)Math.lerp(prevPosition.z, position.z, renderPercent), r, g, b, 1.0f, uv.x, uv.y, 0, brightness, (float)normal.x, (float)normal.y, (float)normal.z);
    }

    @Unique
    public Vector3d[] createBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        Vector3d[] box = new Vector3d[]{new Vector3d(minX, minY, minZ), new Vector3d(minX, minY, maxZ), new Vector3d(minX, maxY, minZ), new Vector3d(minX, maxY, maxZ), new Vector3d(maxX, minY, minZ), new Vector3d(maxX, minY, maxZ), new Vector3d(maxX, maxY, minZ), new Vector3d(maxX, maxY, maxZ)};
        return box;
    }
}

