/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.opengl;

import org.joml.Vector3d;

public enum Data {
    POSITION(0, 3, new float[0]),
    COLOR(1, 4, false, 5121, 1.0f, 1.0f, 1.0f, 1.0f),
    TEX_COORD(2, 2, new float[0]),
    OVERLAY(3, 2, false, 5122, new float[0]),
    LIGHT(4, 2, false, 5122, new float[0]),
    NORMAL(5, 3, false, 5120, new float[0]),
    INDEX(6, 1, new float[0]),
    MATERIAL(7, 1, new float[0]),
    TREE_MATERIAL(7, 1, new float[0]),
    MATERIAL_INDEX(8, 1, new float[0]),
    METALLIC_ROUGHNESS(4, 2, new float[0]),
    POSITION_NEXT(5, 3, new float[0]),
    POSITION_PREVIOUS(6, 3, new float[0]),
    PARTICLE_POSITION(3, 3, true, new float[0]),
    PARTICLE_COLOR(4, 4, true, new float[0]),
    PARTICLE_SCALE_AGE_ROTATION(5, 3, true, new float[0]),
    INSTANCED_PARTICLE(PARTICLE_POSITION, PARTICLE_COLOR, PARTICLE_SCALE_AGE_ROTATION),
    CHUNK_NORMAL(1, 4, false, 33640, new float[0]),
    CHUNK_COLOR(3, 3, false, 5121, new float[0]),
    CHUNK_MATERIAL_AMBIENT(4, 2, false, 5121, new float[0]),
    ATLAS_ID(4, 1, new float[0]);

    private Data[] children;
    private boolean perInstance;
    private float[] defaultValue;
    private int dataType;
    private int dataTypeSize;
    private int attribute;
    private int size;

    private Data(int attribute, int size, boolean perInstance, int dataType, float ... defaultValue) {
        this.defaultValue = defaultValue;
        this.attribute = attribute;
        this.size = size;
        this.dataType = dataType;
        this.perInstance = perInstance;
        switch (dataType) {
            case 5126: {
                this.dataTypeSize = 4;
                break;
            }
            case 5131: {
                this.dataTypeSize = 4;
                break;
            }
            case 5130: {
                this.dataTypeSize = 8;
                break;
            }
            case 5120: {
                this.dataTypeSize = 1;
                break;
            }
            case 5121: {
                this.dataTypeSize = 1;
                break;
            }
            case 5122: {
                this.dataTypeSize = 2;
                break;
            }
            case 5123: {
                this.dataTypeSize = 2;
                break;
            }
            case 5124: {
                this.dataTypeSize = 4;
                break;
            }
            case 5125: {
                this.dataTypeSize = 4;
                break;
            }
            case 33640: {
                this.dataTypeSize = 1;
                break;
            }
            default: {
                this.dataTypeSize = 4;
            }
        }
    }

    private Data(int attribute, int size, boolean perInstance, float ... defaultValue) {
        this(attribute, size, perInstance, 5126, defaultValue);
    }

    private Data(int attribute, int size, int dataType, float ... defaultValue) {
        this(attribute, size, false, dataType, defaultValue);
    }

    private Data(int attribute, int size, float ... defaultValue) {
        this(attribute, size, 5126, defaultValue);
    }

    private Data(Data ... data) {
        int size = 0;
        for (Data d : data) {
            size += d.size;
        }
        this.attribute = 0;
        this.size = size;
        this.children = data;
        this.dataType = 5126;
        this.perInstance = false;
        this.dataTypeSize = 4;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isPerInstance() {
        return this.perInstance;
    }

    public int getAttribute() {
        return this.attribute;
    }

    public Data[] getChildren() {
        return this.children;
    }

    public float[] getDefaultValue() {
        return this.defaultValue;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length != 0;
    }

    public int getDataTypeSize() {
        return this.dataTypeSize;
    }

    public static int pack_INT_2_10_10_10_REV(float x, float y, float z, float w) {
        x = x * 0.5f + 0.5f;
        y = y * 0.5f + 0.5f;
        z = z * 0.5f + 0.5f;
        int wi = Math.round(w * 3.0f) & 3;
        int xi = Math.round(x * 1023.0f) & 0x3FF;
        int yi = Math.round(y * 1023.0f) & 0x3FF;
        int zi = Math.round(z * 1023.0f) & 0x3FF;
        int result = wi << 30 | zi << 20 | yi << 10 | xi;
        return result;
    }

    public static void unpack_INT_2_10_10_10_REV(int value, Vector3d dst) {
        double x = (double)(value & 0x3FF) / 1023.0 * 2.0 - 1.0;
        double y = (double)(value >> 10 & 0x3FF) / 1023.0 * 2.0 - 1.0;
        double z = (double)(value >> 20 & 0x3FF) / 1023.0 * 2.0 - 1.0;
        dst.set(x, y, z);
    }
}

