/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.opengl;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;

public class OpenGLUtil {
    private static GLDebugMessageCallback debugMessageCallback;
    private static Thread currentThread;
    private static Int2ObjectMap<Boolean> states;
    private static boolean depthMask;
    private static Int2IntMap polygon;
    private static Int2ObjectMap<String> staticStrings;
    private static int x;
    private static int y;
    private static int w;
    private static int h;
    private static Vector4f clearColor;
    private static float[] va1;
    private static float[] va2;
    private static float[] va3;
    private static float[] va4;

    public static void enable(int state) {
        Boolean oldState = (Boolean)states.get(state);
        if (oldState == null || oldState.equals(Boolean.FALSE)) {
            GL32C.glEnable((int)state);
            states.put(state, (Object)Boolean.TRUE);
        }
    }

    public static void disable(int state) {
        Boolean oldState = (Boolean)states.get(state);
        if (oldState == null || oldState.equals(Boolean.TRUE)) {
            GL32C.glDisable((int)state);
            states.put(state, (Object)Boolean.FALSE);
        }
    }

    public static boolean getState(int state) {
        Boolean stateValue = (Boolean)states.get(state);
        if (stateValue != null) {
            return stateValue;
        }
        return false;
    }

    public static void polygonMode(int face, int mode) {
        int oldMode = polygon.get(face);
        if (!polygon.containsKey(face) || oldMode != mode) {
            GL32C.glPolygonMode((int)face, (int)mode);
            polygon.put(face, mode);
        }
    }

    public static void depthMask(boolean enabled) {
        if (enabled != depthMask) {
            GL32C.glDepthMask((boolean)enabled);
            depthMask = enabled;
        }
    }

    public static void clearColor(float r, float g, float b, float a) {
        if (r != OpenGLUtil.clearColor.x || g != OpenGLUtil.clearColor.y || b != OpenGLUtil.clearColor.z || a != OpenGLUtil.clearColor.w) {
            GL32C.glClearColor((float)r, (float)g, (float)b, (float)a);
            clearColor.set(r, g, b, a);
        }
    }

    public static void viewport(int x, int y, int w, int h) {
        if (x != OpenGLUtil.x || y != OpenGLUtil.y || w != OpenGLUtil.w || h != OpenGLUtil.h) {
            GL32C.glViewport((int)x, (int)y, (int)w, (int)h);
            OpenGLUtil.x = x;
            OpenGLUtil.y = y;
            OpenGLUtil.w = w;
            OpenGLUtil.h = h;
        }
    }

    public static String getStaticString(int id) {
        String str = (String)staticStrings.get(id);
        if (str == null) {
            str = GL32C.glGetString((int)id);
            staticStrings.put(id, (Object)str);
        }
        return str;
    }

    public static void checkError() {
        int error;
        block9: while ((error = GL32C.glGetError()) != 0) {
            switch (error) {
                case 1280: {
                    System.out.println("GL_INVALID_ENUM");
                    continue block9;
                }
                case 1281: {
                    System.out.println("GL_INVALID_VALUE");
                    continue block9;
                }
                case 1282: {
                    System.out.println("GL_INVALID_OPERATION");
                    continue block9;
                }
                case 1283: {
                    System.out.println("GL_STACK_OVERFLOW");
                    continue block9;
                }
                case 1284: {
                    System.out.println("GL_STACK_UNDERFLOW");
                    continue block9;
                }
                case 1285: {
                    System.out.println("GL_OUT_OF_MEMORY");
                    continue block9;
                }
                case 1286: {
                    System.out.println("GL_INVALID_FRAMEBUFFER_OPERATION");
                    continue block9;
                }
            }
            System.out.println("UNKNOWN ERROR");
        }
    }

    public static void enableDebugging() {
        boolean isAvailable;
        boolean bl = isAvailable = GL.getCapabilities().OpenGL43 || GL.getCapabilities().GL_KHR_debug;
        if (!isAvailable) {
            return;
        }
        OpenGLUtil.enable(37600);
        if (debugMessageCallback != null) {
            debugMessageCallback.free();
        }
        debugMessageCallback = new GLDebugMessageCallback(){

            public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
                if (severity != 33387) {
                    System.err.println("Debug message");
                    System.err.println("\tID: " + id);
                    String description = switch (source) {
                        case 33350 -> "API";
                        case 33351 -> "WINDOW SYSTEM";
                        case 33352 -> "SHADER COMPILER";
                        case 33353 -> "THIRD PARTY";
                        case 33354 -> "APPLICATION";
                        case 33355 -> "OTHER";
                        default -> this.printUnknownToken(source);
                    };
                    System.err.println("\tSource: " + description);
                    switch (type) {
                        case 33356: {
                            description = "ERROR";
                            Thread.dumpStack();
                            break;
                        }
                        case 33357: {
                            description = "DEPRECATED BEHAVIOR";
                            break;
                        }
                        case 33358: {
                            description = "UNDEFINED BEHAVIOR";
                            break;
                        }
                        case 33359: {
                            description = "PORTABILITY";
                            break;
                        }
                        case 33360: {
                            description = "PERFORMANCE";
                            break;
                        }
                        case 33361: {
                            description = "OTHER";
                            break;
                        }
                        case 33384: {
                            description = "MARKER";
                            break;
                        }
                        default: {
                            description = this.printUnknownToken(type);
                        }
                    }
                    System.err.println("\tType: " + description);
                    switch (severity) {
                        case 37190: {
                            description = "HIGH";
                            break;
                        }
                        case 37191: {
                            description = "MEDIUM";
                            break;
                        }
                        case 37192: {
                            description = "LOW";
                            break;
                        }
                        case 33387: {
                            description = "NOTIFICATION";
                            break;
                        }
                        default: {
                            description = this.printUnknownToken(severity);
                        }
                    }
                    System.err.println("\tSeverity: " + description);
                    String errorMessage = 1.getMessage((int)length, (long)message);
                    System.err.println("\tMessage: " + errorMessage);
                }
            }

            private String printUnknownToken(int token) {
                return "Unknown (0x" + Integer.toHexString(token).toUpperCase() + ")";
            }
        };
        if (GL.getCapabilities().OpenGL43) {
            GL43.glDebugMessageCallback((GLDebugMessageCallbackI)debugMessageCallback, (long)0L);
        } else if (GL.getCapabilities().GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)debugMessageCallback, (long)0L);
        }
    }

    public static void disableDebugging() {
        OpenGLUtil.disable(37600);
    }

    public static void glVertexAttrib1fv(int index, float[] value) {
        if (value[0] == va1[0]) {
            return;
        }
        OpenGLUtil.va1[0] = value[0];
        GL32C.glVertexAttrib1fv((int)index, (float[])value);
    }

    public static void glVertexAttrib2fv(int index, float[] value) {
        if (value[0] == va2[0] && value[1] == va2[1]) {
            return;
        }
        OpenGLUtil.va2[0] = value[0];
        OpenGLUtil.va2[1] = value[1];
        GL32C.glVertexAttrib2fv((int)index, (float[])value);
    }

    public static void glVertexAttrib3fv(int index, float[] value) {
        if (value[0] == va3[0] && value[1] == va3[1] && value[2] == va3[2]) {
            return;
        }
        OpenGLUtil.va3[0] = value[0];
        OpenGLUtil.va3[1] = value[1];
        OpenGLUtil.va3[2] = value[2];
        GL32C.glVertexAttrib3fv((int)index, (float[])value);
    }

    public static void glVertexAttrib4fv(int index, float[] value) {
        if (value[0] == va4[0] && value[1] == va4[1] && value[2] == va4[2] && value[3] == va4[3]) {
            return;
        }
        OpenGLUtil.va4[0] = value[0];
        OpenGLUtil.va4[1] = value[1];
        OpenGLUtil.va4[2] = value[2];
        OpenGLUtil.va4[3] = value[3];
        GL32C.glVertexAttrib4fv((int)index, (float[])value);
    }

    public static void printStates() {
        for (Int2ObjectMap.Entry entry : states.int2ObjectEntrySet()) {
            System.out.println(entry.getIntKey() + ":" + entry.getValue());
        }
    }

    public static void setCurrentThread(Thread currentThread) {
        OpenGLUtil.currentThread = currentThread;
    }

    public static Thread getCurrentThread() {
        return currentThread;
    }

    public static void destroy() {
        if (debugMessageCallback != null) {
            debugMessageCallback.free();
        }
    }

    static {
        states = new Int2ObjectOpenHashMap();
        depthMask = true;
        polygon = new Int2IntOpenHashMap();
        staticStrings = new Int2ObjectOpenHashMap();
        clearColor = new Vector4f();
        va1 = new float[1];
        va2 = new float[2];
        va3 = new float[3];
        va4 = new float[4];
    }
}

