/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.joml.Vector2d;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class Mesh {
    private static final Vector3d[] faceNormals = new Vector3d[]{new Vector3d(0.0, 0.0, 1.0), new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, -1.0, 0.0)};
    public List<Vector3d> positions;
    public List<Vector2d> uvs;
    public List<Vector3d> normals;
    public List<Vector3f> colors;
    public List<Integer> sides;
    public List<Vector2i> light;
    public List<Vector3i> indices;
    public Vector3d offset;
    public double radius = Double.MAX_VALUE;

    public Mesh() {
        this.positions = new ObjectArrayList();
        this.uvs = new ObjectArrayList();
        this.normals = new ObjectArrayList();
        this.indices = new ObjectArrayList();
        this.colors = new ObjectArrayList();
        this.light = new ObjectArrayList();
        this.sides = new ObjectArrayList();
    }

    public void calculateOffset() {
        this.calculateOffset(false);
    }

    public double getRadius(boolean reculalcate) {
        if (this.radius == Double.MAX_VALUE) {
            for (Vector3d position : this.positions) {
                double radiusSquared = position.lengthSquared();
                if (!(radiusSquared < this.radius)) continue;
                this.radius = radiusSquared;
            }
            this.radius = Math.sqrt(this.radius);
        }
        return this.radius;
    }

    public double getRadius() {
        return this.getRadius(false);
    }

    public void calculateOffset(boolean needsSides) {
        this.offset = new Vector3d();
        for (Vector3d position : this.positions) {
            this.offset.add(position);
        }
        this.offset.div(this.positions.size());
        for (Vector3d position : this.positions) {
            position.sub(this.offset);
            double radiusSquared = position.lengthSquared();
            if (!(radiusSquared < this.radius)) continue;
            this.radius = radiusSquared;
        }
        this.radius = Math.sqrt(this.radius);
        if (needsSides) {
            for (int j = 0; j < this.normals.size(); ++j) {
                boolean hasSide = false;
                for (int i = 0; i < faceNormals.length; ++i) {
                    if (!(Math.abs(org.joml.Math.acos(this.normals.get(j).dot(Mesh.faceNormals[i].x, Mesh.faceNormals[i].y, Mesh.faceNormals[i].z))) < 0.01)) continue;
                    this.sides.add(i);
                    hasSide = true;
                    break;
                }
                if (hasSide) continue;
                this.sides.add(-1);
            }
        }
    }

    public List<Integer> calculedAngleSides() {
        ObjectArrayList sides = new ObjectArrayList();
        for (int j = 0; j < this.normals.size(); ++j) {
            int maxComp;
            Vector3d normal = this.normals.get(j);
            double max = normal.get(maxComp = normal.maxComponent());
            if (max >= 0.0) {
                if (maxComp == 0) {
                    sides.add(1);
                    continue;
                }
                if (maxComp == 1) {
                    sides.add(4);
                    continue;
                }
                sides.add(0);
                continue;
            }
            if (maxComp == 0) {
                sides.add(3);
                continue;
            }
            if (maxComp == 1) {
                sides.add(5);
                continue;
            }
            sides.add(2);
        }
        return sides;
    }

    public boolean isEmpty() {
        return this.indices.size() == 0;
    }
}

