/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.opengl.Texture;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ServerPhysicsMod;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1159;
import net.minecraft.class_310;
import net.minecraft.class_3797;
import net.minecraft.class_4581;
import org.joml.Matrix3d;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import physx.PxTopLevelFunctions;
import physx.common.JavaErrorCallback;
import physx.common.PxDefaultErrorCallback;
import physx.common.PxErrorCodeEnum;
import physx.common.PxFoundation;
import physx.common.PxTolerancesScale;
import physx.cooking.PxCooking;
import physx.cooking.PxCookingParams;
import physx.extensions.PxDefaultAllocator;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;

public class ModExecutor
implements ClientModInitializer {
    public static boolean optifabric;
    public static boolean iris;
    public static boolean sodium;
    public static boolean replay;
    public static boolean RENDER_LEGACY;
    public static final boolean DEBUG_RENDER = false;
    public static final boolean PRO_VERSION = false;
    public static PxPhysics physics;
    public static PxTolerancesScale tolerances;
    public static PxCooking cooking;
    public static PxMaterial defaultMaterial;
    public static volatile String updateMessage;
    public static volatile String customMessage;

    public void onInitializeClient() {
        boolean updateNotifications = ConfigClient.showUpdateNotifications;
        Thread checkVersion = new Thread(() -> {
            Version currentPhysicsModVersion = null;
            String url = "https://minecraftphysicsmod.com/versions?format=rss";
            for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
                ModMetadata mod = container.getMetadata();
                if (!mod.getId().equalsIgnoreCase("physicsmod")) continue;
                currentPhysicsModVersion = new Version(mod.getVersion().getFriendlyString());
            }
            Version currentMCVersion = new Version(class_3797.field_25319.getReleaseTarget());
            try {
                String text = ModExecutor.getText(url);
                Document doc = ModExecutor.convertStringToXMLDocument(text);
                NodeList entries = doc.getElementsByTagName("item");
                for (Node node : ModExecutor.asList(entries)) {
                    try {
                        Element element = (Element)node;
                        String title = element.getElementsByTagName("title").item(0).getTextContent();
                        if (title.startsWith("Custom_Message:")) {
                            customMessage = title.replaceFirst("Custom_Message:", "");
                            continue;
                        }
                        String[] split = title.split(":");
                        String type = split[0];
                        Version mcVersion = new Version(split[1]);
                        Version physicsVersion = new Version(split[2]);
                        if (!type.equalsIgnoreCase("Fabric") || !mcVersion.equals(currentMCVersion) || currentPhysicsModVersion.equals(physicsVersion) || !updateNotifications) continue;
                        updateMessage = "{\"text\":\"NEW PHYSICS VERSION AVAILABLE! CLICK HERE!\",\"bold\":true,\"underlined\":true,\"color\":\"red\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"https://minecraftphysicsmod.com/\"}}";
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        checkVersion.setDaemon(true);
        checkVersion.start();
        if (FabricLoader.getInstance().isModLoaded("optifabric")) {
            optifabric = true;
            RENDER_LEGACY = true;
        }
        iris = FabricLoader.getInstance().isModLoaded("iris");
        sodium = FabricLoader.getInstance().isModLoaded("sodium") || iris;
        replay = FabricLoader.getInstance().isModLoaded("replaymod");
        ConfigClient.init();
        ConfigMobs.init();
        ConfigBlocks.init();
        int version = PxTopLevelFunctions.getPHYSICS_VERSION();
        final PxDefaultAllocator allocator = new PxDefaultAllocator();
        final PxDefaultErrorCallback errorCb = new PxDefaultErrorCallback();
        final PxFoundation foundation = PxTopLevelFunctions.CreateFoundation(version, allocator, errorCb);
        tolerances = new PxTolerancesScale();
        physics = PxTopLevelFunctions.CreatePhysics(version, foundation, tolerances);
        final PxCookingParams cookingParams = new PxCookingParams(tolerances);
        cooking = PxTopLevelFunctions.CreateCooking(version, foundation, cookingParams);
        defaultMaterial = physics.createMaterial(1.0f, 1.0f, 0.0f);
        ClientLifecycleEvents.CLIENT_STOPPING.register((Object)new ClientLifecycleEvents.ClientStopping(){

            public void onClientStopping(class_310 client) {
                for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                    mod.physicsWorld.destroy();
                }
                PhysicsMod.getInstances().clear();
                defaultMaterial.release();
                physics.release();
                cooking.release();
                foundation.release();
                cookingParams.destroy();
                errorCb.destroy();
                allocator.destroy();
                Texture.destroyAll();
            }
        });
        ServerPhysicsMod server = new ServerPhysicsMod();
        ServerTickEvents.START_WORLD_TICK.register((Object)server);
        PlayerBlockBreakEvents.AFTER.register((Object)server);
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getText(String urlString) throws Exception {
        URL url = new URL(urlString);
        URLConnection con = url.openConnection();
        con.setReadTimeout(10000);
        con.setConnectTimeout(10000);
        Object text = "";
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                text = (String)text + line + "\n";
            }
        }
        return text;
    }

    public static Matrix4f setMatrix(Matrix4f to, class_1159 from) {
        to.set(from.field_21652, from.field_21656, from.field_21660, from.field_21664, from.field_21653, from.field_21657, from.field_21661, from.field_21665, from.field_21654, from.field_21658, from.field_21662, from.field_21666, from.field_21655, from.field_21659, from.field_21663, from.field_21667);
        return to;
    }

    public static Matrix4d setMatrix(Matrix4d to, class_1159 from) {
        to.set(from.field_21652, from.field_21656, from.field_21660, from.field_21664, from.field_21653, from.field_21657, from.field_21661, from.field_21665, from.field_21654, from.field_21658, from.field_21662, from.field_21666, from.field_21655, from.field_21659, from.field_21663, from.field_21667);
        return to;
    }

    public static class_1159 setMojangMatrix(class_1159 to, Matrix4f from) {
        to.field_21652 = from.m00();
        to.field_21656 = from.m01();
        to.field_21660 = from.m02();
        to.field_21664 = from.m03();
        to.field_21653 = from.m10();
        to.field_21657 = from.m11();
        to.field_21661 = from.m12();
        to.field_21665 = from.m13();
        to.field_21654 = from.m20();
        to.field_21658 = from.m21();
        to.field_21662 = from.m22();
        to.field_21666 = from.m23();
        to.field_21655 = from.m30();
        to.field_21659 = from.m31();
        to.field_21663 = from.m32();
        to.field_21667 = from.m33();
        return to;
    }

    public static class_1159 setMojangMatrix(class_1159 to, class_1159 from) {
        to.field_21652 = from.field_21652;
        to.field_21656 = from.field_21656;
        to.field_21660 = from.field_21660;
        to.field_21664 = from.field_21664;
        to.field_21653 = from.field_21653;
        to.field_21657 = from.field_21657;
        to.field_21661 = from.field_21661;
        to.field_21665 = from.field_21665;
        to.field_21654 = from.field_21654;
        to.field_21658 = from.field_21658;
        to.field_21662 = from.field_21662;
        to.field_21666 = from.field_21666;
        to.field_21655 = from.field_21655;
        to.field_21659 = from.field_21659;
        to.field_21663 = from.field_21663;
        to.field_21667 = from.field_21667;
        return to;
    }

    public static class_4581 setMojangMatrix(class_4581 to, class_1159 from) {
        to.field_21633 = from.field_21652;
        to.field_21636 = from.field_21656;
        to.field_21639 = from.field_21660;
        to.field_21634 = from.field_21653;
        to.field_21637 = from.field_21657;
        to.field_21640 = from.field_21661;
        to.field_21635 = from.field_21654;
        to.field_21638 = from.field_21658;
        to.field_21641 = from.field_21662;
        return to;
    }

    public static class_1159 setMojangMatrix(class_1159 to, Matrix4d from) {
        to.field_21652 = (float)from.m00();
        to.field_21656 = (float)from.m01();
        to.field_21660 = (float)from.m02();
        to.field_21664 = (float)from.m03();
        to.field_21653 = (float)from.m10();
        to.field_21657 = (float)from.m11();
        to.field_21661 = (float)from.m12();
        to.field_21665 = (float)from.m13();
        to.field_21654 = (float)from.m20();
        to.field_21658 = (float)from.m21();
        to.field_21662 = (float)from.m22();
        to.field_21666 = (float)from.m23();
        to.field_21655 = (float)from.m30();
        to.field_21659 = (float)from.m31();
        to.field_21663 = (float)from.m32();
        to.field_21667 = (float)from.m33();
        return to;
    }

    public static class_1159 setMojangMatrix(class_1159 to, Matrix3d from) {
        to.field_21652 = (float)from.m00();
        to.field_21656 = (float)from.m01();
        to.field_21660 = (float)from.m02();
        to.field_21664 = 0.0f;
        to.field_21653 = (float)from.m10();
        to.field_21657 = (float)from.m11();
        to.field_21661 = (float)from.m12();
        to.field_21665 = 0.0f;
        to.field_21654 = (float)from.m20();
        to.field_21658 = (float)from.m21();
        to.field_21662 = (float)from.m22();
        to.field_21666 = 0.0f;
        to.field_21655 = 0.0f;
        to.field_21659 = 0.0f;
        to.field_21663 = 0.0f;
        to.field_21667 = 1.0f;
        return to;
    }

    private static List<Node> asList(NodeList n) {
        return n.getLength() == 0 ? Collections.emptyList() : new NodeListWrapper(n);
    }

    static {
        RENDER_LEGACY = false;
        updateMessage = "";
        customMessage = "";
    }

    static final class NodeListWrapper
    extends AbstractList<Node>
    implements RandomAccess {
        private final NodeList list;

        NodeListWrapper(NodeList l) {
            this.list = l;
        }

        @Override
        public Node get(int index) {
            return this.list.item(index);
        }

        @Override
        public int size() {
            return this.list.getLength();
        }
    }

    static final class Version {
        int[] versions;

        public Version(String version) {
            String[] split = version.split("\\.");
            this.versions = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.versions[i] = Integer.parseInt(split[i]);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.versions);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            return Arrays.equals(this.versions, other.versions);
        }

        public String toString() {
            return "Version [versions=" + Arrays.toString(this.versions) + "]";
        }
    }

    static class CustomErrorCallback
    extends JavaErrorCallback {
        private Map<Integer, String> codeNames = new HashMap<Integer, String>(){
            {
                this.put(PxErrorCodeEnum.eDEBUG_INFO, "DEBUG_INFO");
                this.put(PxErrorCodeEnum.eDEBUG_WARNING, "DEBUG_WARNING");
                this.put(PxErrorCodeEnum.eINVALID_PARAMETER, "INVALID_PARAMETER");
                this.put(PxErrorCodeEnum.eINVALID_OPERATION, "INVALID_OPERATION");
                this.put(PxErrorCodeEnum.eOUT_OF_MEMORY, "OUT_OF_MEMORY");
                this.put(PxErrorCodeEnum.eINTERNAL_ERROR, "INTERNAL_ERROR");
                this.put(PxErrorCodeEnum.eABORT, "ABORT");
                this.put(PxErrorCodeEnum.ePERF_WARNING, "PERF_WARNING");
            }
        };

        CustomErrorCallback() {
        }

        @Override
        public void reportError(int code, String message, String file, int line) {
            String codeName = this.codeNames.getOrDefault(code, "code: " + code);
            System.out.printf("[%s] %s (%s:%d)\n", codeName, message, file, line);
        }
    }
}

