/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.diebuddies.compat.Replay;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.math.Math;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.model.ColladaParser;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.TextureHelper;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.DummyMultiBufferSource;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.ItemVertexConsumerProvider;
import net.diebuddies.physics.JsonUnbakedModelHolder;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.ModExecutor;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.RagdollMapper;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3887;
import net.minecraft.class_4184;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_759;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;

public class PhysicsMod {
    public static final Path CAPES_DIRECTORY = FabricLoader.getInstance().getGameDir().resolve("capes");
    public static final double SCALE_DOWN_SPEED = 2.0;
    public static final double SCALE_DOWN_SPEED_INV = 0.5;
    public static Object2ObjectMap<class_1937, PhysicsMod> instances = new Object2ObjectOpenHashMap();
    private static PhysicsMod currentInstance;
    public static final Map<class_1299<?>, class_897<?>> renderers;
    public static final Map<class_2248, String> registeredBlocks;
    public static final Map<class_630.class_628, Boolean> mirroredCuboids;
    public static boolean hudRendering;
    public static Map<class_1087, JsonUnbakedModelHolder> loadedModels;
    public PhysicsWorld physicsWorld;
    public boolean init = false;
    public ConcurrentLinkedQueue<PhysicsEntity> entityBlocks = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<PhysicsEntity> additionalPhysics = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<class_2338> blockUpdates = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Explosion> explosions = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Ragdoll> ragdolls = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Ragdoll> sodiumRemoveRagdolls = new ConcurrentLinkedQueue();
    public List<BlockUpdate> updateQueue = new ObjectArrayList();
    public List<PhysicsEntity> blockifiedEntity = new ObjectArrayList();
    public List<class_630> cuboidEntity = new ObjectArrayList();
    public PhysicsEntity itemStackEntity;
    public Set<BlockUpdate> removeUpdates = new ObjectOpenHashSet();
    public Set<Integer> alreadyBlockified = new ObjectOpenHashSet();
    public class_4587 localPivotMatrix = new class_4587();
    public class_897 cubifyEntityRenderer;
    public class_1297 cubifyEntity;
    public Map<class_1657, Float> players = new Object2ObjectOpenHashMap();
    public long time;
    public boolean blockify;
    public boolean ragdollBlockify;
    public class_1044 blockifyTexture;
    public class_1297 blockifyEntity;
    public int blockifyFeatureIndex;
    public class_3887 blockifyFeature;
    public Map<Long, Integer> builtChunks = new ConcurrentHashMap<Long, Integer>();
    public static final List<List<Mesh>> brokenBlocksLittle;
    public static final List<List<Mesh>> brokenBlocksLots;
    public static final List<Mesh> brokenBlock;
    public static ColladaMesh capeMesh;
    public static Texture capeTexture;
    public static ColladaMesh defaultCapeMesh;
    private static final class_2350[] DIRECTIONS;

    private static List<Mesh> readBlock(String asset) {
        ObjectArrayList meshes = new ObjectArrayList();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(PhysicsMod.class.getClassLoader().getResourceAsStream(asset)));){
            String line = "";
            Mesh mesh = null;
            int ov = 0;
            int ot = 0;
            int on = 0;
            while ((line = reader.readLine()) != null) {
                String[] data;
                if (line.startsWith("o")) {
                    if (mesh != null) {
                        mesh.calculateOffset(true);
                        meshes.add(mesh);
                        ov += mesh.positions.size();
                        ot += mesh.uvs.size();
                        on += mesh.normals.size();
                    }
                    mesh = new Mesh();
                    continue;
                }
                if (line.startsWith("vt")) {
                    data = line.split(" ");
                    mesh.uvs.add(new Vector2d(Double.parseDouble(data[1]), Double.parseDouble(data[2])));
                    continue;
                }
                if (line.startsWith("vn")) {
                    data = line.split(" ");
                    mesh.normals.add(new Vector3d(Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3])));
                    continue;
                }
                if (line.startsWith("v")) {
                    data = line.split(" ");
                    mesh.positions.add(new Vector3d(Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3])));
                    continue;
                }
                if (!line.startsWith("f")) continue;
                data = line.split(" ");
                for (int i = 1; i < data.length; ++i) {
                    String[] idata = data[i].split("/");
                    mesh.indices.add(new Vector3i(Integer.parseInt(idata[0]) - ov, Integer.parseInt(idata[1]) - ot, Integer.parseInt(idata[2]) - on));
                }
            }
            if (mesh != null) {
                mesh.calculateOffset(true);
                meshes.add(mesh);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return meshes;
    }

    public static void createCapeDirectory() {
        try {
            Files.createDirectories(CAPES_DIRECTORY, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            PhysicsMod.copyResource("assets/capes/Example Cape.blend", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Physics Mod Cape.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Physics Mod Cape.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Physics Mod Cape Ripped.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Physics Mod Cape Ripped.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Curtain.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Curtain.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Bat Cape.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Bat Cape.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/TUTORIAL.txt", CAPES_DIRECTORY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadCape() {
        if (capeTexture != null) {
            capeTexture.destroy();
        }
        try {
            if (defaultCapeMesh == null) {
                defaultCapeMesh = ColladaParser.loadStaticModel(new File(CAPES_DIRECTORY + "/Physics Mod Cape.dae"));
            }
            capeMesh = ColladaParser.loadStaticModel(new File(CAPES_DIRECTORY + "/" + ConfigClient.selectedPhysicsCape));
            capeTexture = Texture.load(CAPES_DIRECTORY + "/" + ConfigClient.selectedPhysicsCape.replace(".dae", ".png"), Texture.FILTER_MINECRAFT_TEXTURE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyResource(String res, Path dest) throws IOException {
        String[] split = res.split("/");
        InputStream src = PhysicsMod.class.getClassLoader().getResourceAsStream(res);
        Files.copy(src, dest.resolve(split[split.length - 1]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void resetClothSimulations() {
        for (PhysicsMod mod : instances.values()) {
            for (VerletSimulation simulation : mod.getPhysicsWorld().getVerletSimulations()) {
                simulation.destroyed = true;
            }
        }
    }

    public static double getPlaybackSpeed() {
        if (class_310.method_1551().method_1493()) {
            return 0.0;
        }
        return 1.0 * Replay.getPlaybackSpeed();
    }

    public static PhysicsMod getInstance(class_1937 level) {
        PhysicsMod mod = (PhysicsMod)instances.get((Object)level);
        if (mod == null) {
            mod = new PhysicsMod(level);
            instances.put((Object)level, (Object)mod);
        }
        return mod;
    }

    public static PhysicsMod getCurrentInstance() {
        return currentInstance;
    }

    public static void setCurrentInstance(PhysicsMod currentInstance) {
        PhysicsMod.currentInstance = currentInstance;
    }

    public static Object2ObjectMap<class_1937, PhysicsMod> getInstances() {
        return instances;
    }

    public PhysicsMod(class_1937 level) {
        this.physicsWorld = new PhysicsWorld(level);
    }

    public PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    public static void blockifyEntity(class_1937 level, class_1297 entity) {
        class_897 entityRenderer;
        PhysicsMod mod = PhysicsMod.getInstance(level);
        if (ConfigMobs.getMobSetting(entity) == 0) {
            return;
        }
        if (mod.alreadyBlockified.contains(entity.method_5628()) && !(entity instanceof class_1657)) {
            return;
        }
        if (entity instanceof class_1309 && ((class_1309)entity).method_5767()) {
            return;
        }
        mod.alreadyBlockified.add(entity.method_5628());
        class_897 renderer = entityRenderer = class_310.method_1551().method_1561().method_3953(entity);
        class_583 model = null;
        if (entityRenderer instanceof class_922) {
            model = ((class_922)entityRenderer).method_4038();
        }
        class_4587 stack = new class_4587();
        stack.method_22903();
        mod.blockify = true;
        mod.localPivotMatrix = new class_4587();
        mod.cubifyEntityRenderer = renderer;
        mod.cubifyEntity = (class_1309)entity;
        PhysicsMod.setCurrentInstance(mod);
        class_1060 textureManager = class_310.method_1551().method_1531();
        mod.blockifyTexture = textureManager.method_4619(renderer.method_3931(entity));
        mod.blockifyEntity = entity;
        mod.blockifyFeature = null;
        mod.blockifyFeatureIndex = 0;
        float partialTicks = class_310.method_1551().method_1488();
        double px = class_3532.method_16436((double)partialTicks, (double)entity.field_6014, (double)entity.method_23317());
        double py = class_3532.method_16436((double)partialTicks, (double)entity.field_6036, (double)entity.method_23318());
        double pz = class_3532.method_16436((double)partialTicks, (double)entity.field_5969, (double)entity.method_23321());
        try {
            renderer.method_3936((class_1297)((class_1309)entity), 0.0f, class_310.method_1551().method_1488(), stack, (class_4597)new DummyMultiBufferSource(), 0);
        }
        catch (Exception e) {
            System.err.println("error rendering " + entity.getClass());
            e.printStackTrace();
        }
        PhysicsMod.setCurrentInstance(null);
        mod.blockify = false;
        try {
            RagdollMapper.filterCuboidsFromEntities(entity, model);
        }
        catch (Exception e) {
            System.err.println("error filtering " + entity.getClass());
            e.printStackTrace();
        }
        stack.method_22909();
        for (PhysicsEntity physicsEntity : mod.blockifiedEntity) {
            physicsEntity.backfaceCulling = false;
        }
        if (ConfigMobs.getMobSetting(entity) == 4) {
            Ragdoll ragdoll = null;
            try {
                ragdoll = RagdollMapper.map(entity, model);
            }
            catch (Exception e) {
                System.err.println("error creating ragdoll for " + entity.getClass());
                e.printStackTrace();
            }
            if (ragdoll == null) {
                mod.entityBlocks.addAll(mod.blockifiedEntity);
                if (mod.entityBlocks.size() > 0 && entity instanceof class_1309) {
                    ((class_1309)entity).method_5650(class_1297.class_5529.field_26999);
                }
            } else {
                class_1657 closest;
                mod.ragdolls.add(ragdoll);
                if (level instanceof class_638 && (closest = ((class_638)level).method_18459(entity.method_23317(), entity.method_23318(), entity.method_23321(), 8.0, false)) != null) {
                    ragdoll.velocity.set(entity.method_23317() - closest.method_23317(), 2.0, entity.method_23321() - closest.method_23321()).normalize().mul(5.0);
                }
                ragdoll.velocity.add(entity.method_18798().field_1352 * 10.0, entity.method_18798().field_1351 * 10.0, entity.method_18798().field_1350 * 10.0);
                if (entity instanceof class_1309) {
                    ((class_1309)entity).method_5650(class_1297.class_5529.field_26999);
                }
            }
        } else {
            mod.entityBlocks.addAll(mod.blockifiedEntity);
            if (mod.entityBlocks.size() > 0 && entity instanceof class_1309) {
                ((class_1309)entity).method_5650(class_1297.class_5529.field_26999);
            }
        }
        mod.blockifiedEntity.clear();
        mod.cuboidEntity.clear();
    }

    public static void createParticlesFromCuboids(class_4587.class_4665 stack, class_4587 local, List<class_630.class_628> cuboids, class_1297 entity, class_897 renderer, class_3887 feature, int overlay, float red, float green, float blue) {
        class_1159 m = stack.method_23761();
        class_1159 localM = local.method_23760().method_23761();
        class_4581 localNM = local.method_23760().method_23762();
        Matrix4d transformation = new Matrix4d();
        Matrix4d transformationLocal = new Matrix4d();
        ModExecutor.setMatrix(transformation, m);
        ModExecutor.setMatrix(transformationLocal, localM);
        transformation.mul(transformationLocal.invert(new Matrix4d()));
        PhysicsMod mod = PhysicsMod.getInstance(entity.method_5770());
        int[] textureIDs = TextureHelper.getLoadedTextures();
        float partialTicks = class_310.method_1551().method_1488();
        double px = class_3532.method_16436((double)partialTicks, (double)entity.field_6014, (double)entity.method_23317());
        double py = class_3532.method_16436((double)partialTicks, (double)entity.field_6036, (double)entity.method_23318());
        double pz = class_3532.method_16436((double)partialTicks, (double)entity.field_5969, (double)entity.method_23321());
        transformation.setTranslation(px + transformation.m30(), py + transformation.m31(), pz + transformation.m32());
        Vector4f[] minMax = new Vector4f[6];
        class_1160 tmpNormal = new class_1160();
        class_1162 tmpPos = new class_1162();
        for (int i = 0; i < minMax.length; ++i) {
            minMax[i] = new Vector4f();
        }
        for (class_630.class_628 box : cuboids) {
            if (box.field_3649[2] == null || box.field_3649[3] == null) continue;
            float minX = box.field_3649[2].field_3502[2].field_3605.method_4943();
            float minY = box.field_3649[2].field_3502[2].field_3605.method_4945();
            float minZ = box.field_3649[2].field_3502[2].field_3605.method_4947();
            float maxX = box.field_3649[3].field_3502[3].field_3605.method_4943();
            float maxY = box.field_3649[3].field_3502[3].field_3605.method_4945();
            float maxZ = box.field_3649[3].field_3502[3].field_3605.method_4947();
            int[] remap = new int[]{5, 0, 4, 1, 3, 2};
            float volume = java.lang.Math.abs(maxX - minX) / 16.0f * (java.lang.Math.abs(maxY - minY) / 16.0f) * (java.lang.Math.abs(maxZ - minZ) / 16.0f);
            boolean isBlocky = ConfigMobs.getMobSetting(entity) == 3 || ConfigMobs.getMobSetting(entity) == 4;
            boolean noVolume = false;
            if ((double)volume <= 1.0E-4) {
                if (!isBlocky) continue;
                noVolume = true;
            }
            boolean mirror = false;
            Boolean cuboidMirror = mirroredCuboids.get(box);
            if (cuboidMirror != null) {
                mirror = cuboidMirror;
            }
            List<Mesh> meshes = brokenBlocksLittle.get((int)(java.lang.Math.random() * (double)brokenBlocksLittle.size()));
            if ((double)volume <= 0.04 || isBlocky) {
                meshes = brokenBlock;
            }
            for (int i = 0; i < box.field_3649.length; ++i) {
                float minU = 1.0f;
                float maxU = 0.0f;
                float minV = 1.0f;
                float maxV = 0.0f;
                for (class_630.class_618 vertex : box.field_3649[i].field_3502) {
                    if (vertex.field_3604 < minU) {
                        minU = vertex.field_3604;
                    }
                    if (vertex.field_3603 < minV) {
                        minV = vertex.field_3603;
                    }
                    if (vertex.field_3604 > maxU) {
                        maxU = vertex.field_3604;
                    }
                    if (!(vertex.field_3603 > maxV)) continue;
                    maxV = vertex.field_3603;
                }
                minMax[i].set(minU, maxU, minV, maxV);
            }
            PhysicsEntity parent = null;
            for (Mesh mesh : meshes) {
                Mesh clone;
                PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.MOB);
                particle.feature = feature;
                particle.noVolume = noVolume;
                particle.models.get((int)0).textureIDs = textureIDs;
                particle.models.get((int)0).overlay = overlay;
                particle.models.get((int)0).mesh = clone = new Mesh();
                particle.setTransformation(new Matrix4d(transformation));
                particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
                int count = 1;
                Vector3d offset = new Vector3d();
                for (Vector3i index : mesh.indices) {
                    int sideIndex = mesh.sides.get(index.z - 1);
                    Vector3d position = mesh.positions.get(index.x - 1);
                    Vector2d uv = mesh.uvs.get(index.y - 1);
                    Vector3d normal = mesh.normals.get(index.z - 1);
                    Vector3f color = new Vector3f(red, green, blue);
                    if (sideIndex == -1) {
                        if (ConfigMobs.getMobSetting(entity) == 2) {
                            color.set(0.6f, 0.0f, 0.0f);
                        }
                        sideIndex = 0;
                    }
                    tmpNormal.method_4949(mirror ? (float)(-normal.x) : (float)normal.x, (float)normal.y, (float)normal.z);
                    tmpNormal.method_23215(localNM);
                    Vector4f minMaxUVs = minMax[remap[sideIndex]];
                    tmpPos.method_23851((float)Math.remap(position.x + mesh.offset.x, -0.5, 0.5, (double)minX, (double)maxX) / 16.0f, (float)Math.remap(position.y + mesh.offset.y, -0.5, 0.5, (double)minY, (double)maxY) / 16.0f, (float)Math.remap(position.z + mesh.offset.z, mirror ? 0.5 : -0.5, mirror ? -0.5 : 0.5, (double)minZ, (double)maxZ) / 16.0f, 1.0f);
                    tmpPos.method_22674(localM);
                    clone.indices.add(new Vector3i(count, count, count));
                    offset.add(tmpPos.method_4953(), tmpPos.method_4956(), tmpPos.method_4957());
                    ++count;
                    Vector3d posR = new Vector3d(tmpPos.method_4953(), tmpPos.method_4956(), tmpPos.method_4957());
                    clone.positions.add(posR);
                    clone.uvs.add(new Vector2d(Math.remap((float)uv.x, 1.0f, 0.0f, minMaxUVs.x, minMaxUVs.y), Math.remap((float)uv.y, 0.0f, 1.0f, minMaxUVs.z, minMaxUVs.w)));
                    clone.normals.add(new Vector3d(tmpNormal.method_4943(), tmpNormal.method_4945(), tmpNormal.method_4947()));
                    clone.colors.add(color);
                }
                offset.div(clone.positions.size());
                for (Vector3d position : clone.positions) {
                    position.sub(offset);
                }
                clone.offset = offset;
                Vector3d ps = transformationLocal.getTranslation(new Vector3d());
                particle.pivot.set(ps);
                if (parent == null) {
                    parent = particle;
                    mod.blockifiedEntity.add(particle);
                    continue;
                }
                parent.children.add(particle);
            }
        }
    }

    public static void blockifyItemStack(class_1799 item, boolean mainHand) {
    }

    private static void renderHand(class_1799 item, class_4184 camera, float tickDelta, boolean mainHand) {
        class_310.method_1551().field_1773.method_22709(class_310.method_1551().field_1773.method_22973(class_310.method_1551().field_1773.method_3196(camera, tickDelta, false)));
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, -0.2);
        matrices.method_22907(class_1160.field_20703.method_23214(camera.method_19329()));
        matrices.method_22907(class_1160.field_20705.method_23214(camera.method_19330() + 180.0f));
        Matrix4d m = new Matrix4d();
        ModExecutor.setMatrix(m, matrices.method_23760().method_23761());
        m.invert();
        class_1159 view = new class_1159();
        ModExecutor.setMojangMatrix(view, m);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_34425(view);
        PhysicsMod.bobViewWhenHurt(matrices, tickDelta);
        if (class_310.method_1551().field_1690.field_1891) {
            PhysicsMod.bobView(matrices, tickDelta);
        }
        PhysicsMod.renderItem(item, camera, mainHand, class_310.method_1551().field_1773.field_4012, tickDelta, matrices, class_310.method_1551().field_1724, class_310.method_1551().method_1561().method_23839((class_1297)class_310.method_1551().field_1724, tickDelta));
        matrices.method_22909();
    }

    private static void renderItem(class_1799 item, class_4184 camera, boolean mainHand, class_759 firstPersonRenderer, float tickDelta, class_4587 matrices, class_746 player, int light) {
        float f = player.method_6055(tickDelta);
        class_1268 hand = (class_1268)MoreObjects.firstNonNull((Object)player.field_6266, (Object)class_1268.field_5808);
        float g = class_3532.method_16439((float)tickDelta, (float)player.field_6004, (float)player.method_36455());
        float h = class_3532.method_16439((float)tickDelta, (float)player.field_3914, (float)player.field_3916);
        float i = class_3532.method_16439((float)tickDelta, (float)player.field_3931, (float)player.field_3932);
        matrices.method_22907(class_1160.field_20703.method_23214((player.method_5695(tickDelta) - h) * 0.1f));
        matrices.method_22907(class_1160.field_20705.method_23214((player.method_5705(tickDelta) - i) * 0.1f));
        System.out.println("pitch: " + (player.method_5695(tickDelta) - h) * 0.1f);
        System.out.println("yaw: " + (player.method_5705(tickDelta) - i) * 0.1f);
        System.out.println("cam pitch: " + camera.method_19329());
        System.out.println("cam yaw: " + (camera.method_19330() + 180.0f));
        ItemVertexConsumerProvider dummy = new ItemVertexConsumerProvider();
        float l = hand == class_1268.field_5808 ? f : 0.0f;
        float m = 1.0f - class_3532.method_16439((float)tickDelta, (float)firstPersonRenderer.field_4053, (float)firstPersonRenderer.field_4043);
        firstPersonRenderer.method_3228((class_742)player, tickDelta, g, mainHand ? class_1268.field_5808 : class_1268.field_5810, l, item, m, matrices, (class_4597)dummy, light);
    }

    private static void bobView(class_4587 matrices, float f) {
        if (class_310.method_1551().method_1560() instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_310.method_1551().method_1560();
            float g = playerEntity.field_5973 - playerEntity.field_6039;
            float h = -(playerEntity.field_5973 + g * f);
            float i = class_3532.method_16439((float)f, (float)playerEntity.field_7505, (float)playerEntity.field_7483);
            matrices.method_22904((double)(class_3532.method_15374((float)(h * (float)java.lang.Math.PI)) * i * 0.5f), (double)(-java.lang.Math.abs(class_3532.method_15362((float)(h * (float)java.lang.Math.PI)) * i)), 0.0);
            matrices.method_22907(class_1160.field_20707.method_23214(class_3532.method_15374((float)(h * (float)java.lang.Math.PI)) * i * 3.0f));
            matrices.method_22907(class_1160.field_20703.method_23214(java.lang.Math.abs(class_3532.method_15362((float)(h * (float)java.lang.Math.PI - 0.2f)) * i) * 5.0f));
        }
    }

    private static void bobViewWhenHurt(class_4587 matrices, float f) {
        if (class_310.method_1551().method_1560() instanceof class_1309) {
            float i;
            class_1309 livingEntity = (class_1309)class_310.method_1551().method_1560();
            float g = (float)livingEntity.field_6235 - f;
            if (livingEntity.method_29504()) {
                i = java.lang.Math.min((float)livingEntity.field_6213 + f, 20.0f);
                matrices.method_22907(class_1160.field_20707.method_23214(40.0f - 8000.0f / (i + 200.0f)));
            }
            if (g < 0.0f) {
                return;
            }
            g /= (float)livingEntity.field_6254;
            g = class_3532.method_15374((float)(g * g * g * g * (float)java.lang.Math.PI));
            i = livingEntity.field_6271;
            matrices.method_22907(class_1160.field_20705.method_23214(-i));
            matrices.method_22907(class_1160.field_20707.method_23214(-g * 14.0f));
            matrices.method_22907(class_1160.field_20705.method_23214(i));
        }
    }

    public PhysicsEntity renderBlockIntoEntity(PhysicsEntity.Type type, class_2680 state, class_2338 pos) {
        this.itemStackEntity = new PhysicsEntity(type);
        this.itemStackEntity.models.get((int)0).mesh = new Mesh();
        PhysicsMod.setCurrentInstance(this);
        class_776 manager = class_310.method_1551().method_1541();
        class_1087 model = manager.method_3349(state);
        this.renderFlat(this.itemStackEntity, (class_1920)this.physicsWorld.getWorld(), model, state, pos, new Random(0L), state.method_26190(pos), class_4608.field_21444);
        if (this.itemStackEntity.models.get((int)0).mesh.indices.size() < 9) {
            PhysicsMod.setCurrentInstance(null);
            return null;
        }
        this.itemStackEntity.models.get((int)0).mesh.calculateOffset();
        this.itemStackEntity.models.get((int)0).textureIDs = new int[]{model.method_4711().method_24119().method_4624()};
        this.itemStackEntity.getTransformation().set(new Matrix4d().translate(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        this.itemStackEntity.getOldTransformation().set(this.itemStackEntity.getTransformation());
        this.itemStackEntity.models.get((int)0).animationSprite = model.method_4711();
        return this.itemStackEntity;
    }

    private boolean renderFlat(PhysicsEntity entity, class_1920 world, class_1087 model, class_2680 state, class_2338 pos, Random random, long seed, int overlay) {
        boolean rendered = false;
        entity.models.get((int)0).textureIDs = TextureHelper.getLoadedTextures();
        Mesh mesh = entity.models.get((int)0).mesh;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            class_2350 direction = DIRECTIONS[i];
            random.setSeed(seed);
            List list = model.method_4707(state, direction, random);
            if (list.isEmpty()) continue;
            this.renderQuadsFlat(entity, mesh, world, state, pos, overlay, list);
            rendered = true;
        }
        random.setSeed(seed);
        List quads = model.method_4707(state, (class_2350)null, random);
        if (!quads.isEmpty()) {
            this.renderQuadsFlat(entity, mesh, world, state, pos, overlay, quads);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadsFlat(PhysicsEntity entity, Mesh mesh, class_1920 world, class_2680 state, class_2338 pos, int overlay, List<class_777> quads) {
        for (class_777 quad : quads) {
            this.renderQuad(entity, mesh, world, state, pos, quad, overlay);
        }
    }

    private void renderQuad(PhysicsEntity entity, Mesh mesh, class_1920 world, class_2680 state, class_2338 pos, class_777 quad, int overlay) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (quad.method_3360()) {
            int i = class_310.method_1551().method_1505().method_1697(state, world, pos, quad.method_3359());
            red = (float)(i >> 16 & 0xFF) / 255.0f;
            green = (float)(i >> 8 & 0xFF) / 255.0f;
            blue = (float)(i & 0xFF) / 255.0f;
        }
        entity.shade = quad.method_24874();
        int[] vertexData = quad.method_3357();
        class_2382 normal = quad.method_3358().method_10163();
        int vertexSize = class_290.field_1590.method_1359();
        int vertices = vertexData.length / vertexSize;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize;
            float x = Float.intBitsToFloat(vertexData[offset]);
            float y = Float.intBitsToFloat(vertexData[offset + 1]);
            float z = Float.intBitsToFloat(vertexData[offset + 2]);
            int rgb = vertexData[offset + 3];
            float r = (float)(rgb >> 24 & 0xFF) / 255.0f * red;
            float g = (float)(rgb >> 16 & 0xFF) / 255.0f * green;
            float b = (float)(rgb >> 8 & 0xFF) / 255.0f * blue;
            mesh.positions.add(new Vector3d(x, y, z));
            mesh.colors.add(new Vector3f(r, g, b));
            mesh.normals.add(new Vector3d(normal.method_10263(), normal.method_10264(), normal.method_10260()));
            mesh.uvs.add(new Vector2d(Float.intBitsToFloat(vertexData[offset + 4]), Float.intBitsToFloat(vertexData[offset + 5])));
        }
        int index = mesh.positions.size() - 4 + 1;
        mesh.indices.add(new Vector3i(index).add(0, 0, 0));
        mesh.indices.add(new Vector3i(index).add(1, 1, 1));
        mesh.indices.add(new Vector3i(index).add(2, 2, 2));
        mesh.indices.add(new Vector3i(index).add(0, 0, 0));
        mesh.indices.add(new Vector3i(index).add(2, 2, 2));
        mesh.indices.add(new Vector3i(index).add(3, 3, 3));
    }

    static {
        renderers = new Object2ObjectOpenHashMap();
        registeredBlocks = new Object2ObjectOpenHashMap();
        mirroredCuboids = new Object2ObjectOpenHashMap();
        loadedModels = new Object2ObjectOpenHashMap();
        brokenBlocksLittle = new ObjectArrayList();
        brokenBlocksLots = new ObjectArrayList();
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_little_1.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_little_2.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_little_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_2.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_4.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_5.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_6.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_7.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_8.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_9.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_10.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_11.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_12.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_13.obj"));
        brokenBlock = PhysicsMod.readBlock("assets/fractures/physics_simple.obj");
        DIRECTIONS = class_2350.values();
    }
}

