/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ragdoll;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.ModExecutor;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.ragdoll.RagdollJoint;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.joml.Matrix3d;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxArticulation;
import physx.physics.PxArticulationBase;
import physx.physics.PxArticulationJoint;
import physx.physics.PxArticulationLink;
import physx.physics.PxRigidBody;

public class Ragdoll {
    protected PhysicsEntity entireMesh;
    public List<PhysicsEntity> bodies = new ObjectArrayList();
    public List<RagdollJoint> joints = new ObjectArrayList();
    public List<IRigidBody> btBodies = new ObjectArrayList();
    public List<PxArticulationBase> articulations = new ObjectArrayList();
    public Vector3d velocity = new Vector3d();
    public boolean kinematic;
    public boolean frozen;

    public void updatePhysics(PhysicsWorld physics) {
        if (this.isKinematic() || this.isFrozen()) {
            return;
        }
        if (this.velocity != null && this.velocity.lengthSquared() > 0.01) {
            for (IRigidBody body : this.btBodies) {
                if (!(body.getRigidBody() instanceof PxRigidBody)) continue;
                PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
                float angularForce = 10.0f;
                PxVec3 v = rigidBody.getLinearVelocity();
                v.setX((float)this.velocity.x);
                v.setY((float)this.velocity.y);
                v.setZ((float)this.velocity.z);
                rigidBody.setLinearVelocity(v, true);
                PxVec3 a = rigidBody.getAngularVelocity();
                a.setX((float)(Math.random() - 0.5) * angularForce);
                a.setY((float)(Math.random() - 0.5) * angularForce);
                a.setZ((float)(Math.random() - 0.5) * angularForce);
                rigidBody.setAngularVelocity(a);
            }
            this.velocity = null;
        }
    }

    public boolean blockUpdate(PhysicsWorld physics, class_2338 pos, class_2680 state) {
        return false;
    }

    public PhysicsEntity getEntireMesh() {
        return this.entireMesh;
    }

    public void buildMesh(PhysicsWorld physics) {
    }

    public boolean supportMeshBuilding() {
        return false;
    }

    public RagdollJoint addConnection(int from, int connectedTo, boolean fixed, boolean onlyVisual) {
        Matrix4d transFrom;
        Matrix4d transTo;
        Vector3d localPos1 = this.bodies.get((int)from).models.get((int)0).mesh.offset;
        Vector3d localPos2 = this.bodies.get((int)connectedTo).models.get((int)0).mesh.offset;
        Vector3d pivotPoint = this.bodies.get((int)from).pivot;
        Vector3d scaleFrom = this.bodies.get(from).getTransformation().getScale(new Vector3d());
        Vector3d scaleTo = this.bodies.get(connectedTo).getTransformation().getScale(new Vector3d());
        this.bodies.get((int)from).models.get((int)0).onlyVisual = onlyVisual;
        RagdollJoint ragdollJoint = new RagdollJoint(from, connectedTo, new Vector3d(pivotPoint.x - localPos1.x, pivotPoint.y - localPos1.y, pivotPoint.z - localPos1.z).mul(scaleTo), new Vector3d(pivotPoint.x - localPos2.x, pivotPoint.y - localPos2.y, pivotPoint.z - localPos2.z).mul(scaleFrom));
        ragdollJoint.fixed = fixed;
        this.joints.add(ragdollJoint);
        if (fixed && !(transTo = this.bodies.get(connectedTo).getTransformation()).equals(transFrom = this.bodies.get(from).getTransformation())) {
            Matrix4d transformation = transFrom.mulLocal(transTo.invert(new Matrix4d()));
            Matrix3d normalTransformation = transformation.normal(new Matrix3d());
            for (Vector3d pos : this.bodies.get((int)from).models.get((int)0).mesh.positions) {
                transformation.transformPosition(pos);
            }
            for (Vector3d normal : this.bodies.get((int)from).models.get((int)0).mesh.normals) {
                normalTransformation.transform(normal);
            }
        }
        return ragdollJoint;
    }

    public RagdollJoint addConnection(int from, int connectedTo, boolean fixed) {
        return this.addConnection(from, connectedTo, fixed, false);
    }

    public void addOverlayConnections(boolean onlyVisual, int bodiesSize, int offset) {
        int size = bodiesSize / 2;
        for (int i = 0; i < size; ++i) {
            this.addConnection(i + size + offset, i, true, onlyVisual);
        }
    }

    public void addOverlayConnections(boolean onlyVisual) {
        this.addOverlayConnections(onlyVisual, this.bodies.size(), 0);
    }

    public void addOverlayConnections() {
        this.addOverlayConnections(false);
    }

    public RagdollJoint addConnection(int from, int connectedTo) {
        return this.addConnection(from, connectedTo, false);
    }

    public List<Node> generateTree() {
        Node parent;
        ArrayList<Node> roots = new ArrayList<Node>();
        ObjectArrayList notUsedBodies = new ObjectArrayList(this.bodies);
        for (int j = 0; j < this.joints.size(); ++j) {
            RagdollJoint joint = this.joints.get(j);
            if (!notUsedBodies.contains(this.bodies.get(joint.index2))) continue;
            parent = new Node(joint.index2, -1);
            roots.add(parent);
            notUsedBodies.remove(this.bodies.get(joint.index2));
            this.searchChildren(parent, (List<PhysicsEntity>)notUsedBodies);
        }
        for (PhysicsEntity body : notUsedBodies) {
            parent = new Node(this.bodies.indexOf(body), -1);
            roots.add(parent);
        }
        return roots;
    }

    private void searchChildren(Node parent, List<PhysicsEntity> notUsedBodies) {
        if (notUsedBodies.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.joints.size(); ++i) {
            Node child;
            RagdollJoint joint = this.joints.get(i);
            if (notUsedBodies.contains(this.bodies.get(joint.index2)) && parent.index == joint.index1) {
                child = new Node(joint.index2, i);
                parent.children.add(child);
                notUsedBodies.remove(this.bodies.get(joint.index2));
                this.searchChildren(child, notUsedBodies);
                continue;
            }
            if (!notUsedBodies.contains(this.bodies.get(joint.index1)) || parent.index != joint.index2) continue;
            child = new Node(joint.index1, i);
            parent.children.add(child);
            notUsedBodies.remove(this.bodies.get(joint.index1));
            this.searchChildren(child, notUsedBodies);
        }
    }

    public void add(PhysicsWorld physics) {
        double rnd = Math.random() * 3.0;
        List<Node> tree = this.generateTree();
        for (Node root : tree) {
            for (int i = 0; i < root.children.size(); ++i) {
                this.createChildLinkPrePass(root, root.children.get(i));
            }
        }
        for (Node root : tree) {
            PhysicsEntity particle = this.bodies.get(root.index);
            if (particle.noVolume) continue;
            PxArticulation articulation = ModExecutor.physics.createArticulation();
            articulation.setMaxProjectionIterations(8);
            if (physics.getBodies().size() == 0 && physics.getChunkBodies().size() == 0) {
                particle.getTransformation().getTranslation(physics.getOffset());
            }
            Vector3d offset = physics.getOffset();
            Vector3d translation = new Matrix4d(particle.getTransformation()).translateLocal(-offset.x, -offset.y, -offset.z).translate(particle.models.get((int)0).mesh.offset).getTranslation(new Vector3d());
            Quaterniond rotation = new Matrix4d(particle.getTransformation()).translateLocal(-offset.x, -offset.y, -offset.z).translate(particle.models.get((int)0).mesh.offset).getUnnormalizedRotation(new Quaterniond()).normalize();
            PxArticulationLink rootLink = null;
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxVec3 tmpVec = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)translation.x, (float)translation.y, (float)translation.z);
                PxQuat tmpQuat = PxQuat.createAt(mem, MemoryStack::nmalloc, (float)rotation.x, (float)rotation.y, (float)rotation.z, (float)rotation.w);
                PxTransform tmpPose = PxTransform.createAt(mem, MemoryStack::nmalloc, tmpVec, tmpQuat);
                rootLink = articulation.createLink(null, tmpPose);
            }
            IRigidBody rigidBody = physics.addBlockParticle(particle, rootLink);
            particle.time = ConfigClient.particleLifetimeMobs + rnd;
            rigidBody.isRagdoll = true;
            this.btBodies.add(rigidBody);
            this.articulations.add(articulation);
            for (int i = 0; i < root.children.size(); ++i) {
                this.createChildLink(physics, articulation, rootLink, root, root.children.get(i), rnd);
            }
            physics.getDynamicsWorld().addArticulation(articulation);
        }
        for (IRigidBody body : this.btBodies) {
            body.applyRandomSpawnForces();
        }
    }

    protected void createChildLinkPrePass(Node parent, Node root) {
        PhysicsEntity particle = this.bodies.get(root.index);
        RagdollJoint rjoint = this.joints.get(root.jointIndex);
        if (rjoint.fixed) {
            PhysicsEntity parentParticle = this.bodies.get(parent.index);
            Mesh mesh = particle.models.get((int)0).mesh;
            for (int i = 0; i < mesh.positions.size(); ++i) {
                mesh.positions.get(i).add(mesh.offset).sub(parentParticle.models.get((int)0).mesh.offset);
            }
            parentParticle.models.add(particle.models.get(0));
        } else {
            for (int i = 0; i < root.children.size(); ++i) {
                this.createChildLinkPrePass(root, root.children.get(i));
            }
        }
    }

    private void createChildLink(PhysicsWorld physics, PxArticulationBase articulation, PxArticulationLink rootLink, Node parent, Node root, double rnd) {
        PhysicsEntity particle = this.bodies.get(root.index);
        if (!particle.noVolume) {
            RagdollJoint rjoint = this.joints.get(root.jointIndex);
            if (rjoint.fixed) {
                return;
            }
            particle.stopCollision = rjoint.stopCollision;
            Vector3d offset = physics.getOffset();
            Vector3d translation = new Matrix4d(particle.getTransformation()).translateLocal(-offset.x, -offset.y, -offset.z).translate(particle.models.get((int)0).mesh.offset).getTranslation(new Vector3d());
            Quaterniond rotation = new Matrix4d(particle.getTransformation()).translateLocal(-offset.x, -offset.y, -offset.z).translate(particle.models.get((int)0).mesh.offset).getUnnormalizedRotation(new Quaterniond()).normalize();
            PxArticulationLink link = null;
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxVec3 tmpVec = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)translation.x, (float)translation.y, (float)translation.z);
                PxQuat tmpQuat = PxQuat.createAt(mem, MemoryStack::nmalloc, (float)rotation.x, (float)rotation.y, (float)rotation.z, (float)rotation.w);
                PxTransform tmpPose = PxTransform.createAt(mem, MemoryStack::nmalloc, tmpVec, tmpQuat);
                link = articulation.createLink(rootLink, tmpPose);
            }
            IRigidBody rigidBody = physics.addBlockParticle(particle, link);
            particle.time = ConfigClient.particleLifetimeMobs + rnd;
            rigidBody.isRagdoll = true;
            this.btBodies.add(rigidBody);
            PxArticulationJoint joint = PxArticulationJoint.wrapPointer(link.getInboundJoint().getAddress());
            joint.setSwingLimitEnabled(true);
            joint.setTwistLimitEnabled(true);
            joint.setTwistLimit((float)Math.toRadians(-90.0), (float)Math.toRadians(90.0));
            joint.setSwingLimit((float)Math.toRadians(90.0), (float)Math.toRadians(90.0));
            joint.setSwingLimitContactDistance(0.7f);
            joint.setTwistLimitContactDistance(0.7f);
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxTransform parentPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)rjoint.point1.x, (float)rjoint.point1.y, (float)rjoint.point1.z), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                PxTransform childPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)rjoint.point2.x, (float)rjoint.point2.y, (float)rjoint.point2.z), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                if (rjoint.index1 == root.index) {
                    PxTransform tmp = parentPose;
                    parentPose = childPose;
                    childPose = tmp;
                }
                joint.setParentPose(parentPose);
                joint.setChildPose(childPose);
            }
            for (int i = 0; i < root.children.size(); ++i) {
                this.createChildLink(physics, articulation, link, root, root.children.get(i), rnd);
            }
        }
    }

    public void remove(PhysicsWorld physicsWorld) {
        for (PxArticulationBase articulation : this.articulations) {
            physicsWorld.getDynamicsWorld().removeArticulation(articulation);
        }
        for (IRigidBody body : this.btBodies) {
            physicsWorld.getBodies().remove(body);
            if (body.getLastChunk() == null || body.isKinematicOrFrozen()) continue;
            physicsWorld.removeLoadedChunkEntity(body.getLastChunk());
        }
    }

    public boolean isKinematic() {
        return this.kinematic;
    }

    public void setKinematic(boolean kinematic) {
        if (this.kinematic != kinematic) {
            for (IRigidBody body : this.btBodies) {
                body.setKinematic(kinematic);
            }
            this.kinematic = kinematic;
        }
    }

    public void setFrozen(boolean frozen) {
        if (this.frozen != frozen) {
            for (IRigidBody body : this.btBodies) {
                body.setFrozen(frozen);
            }
            this.frozen = frozen;
        }
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void destroy() {
        for (PxArticulationBase articulation : this.articulations) {
            articulation.release();
        }
        for (IRigidBody body : this.btBodies) {
            body.getEntity().destroy();
        }
    }

    public class Node {
        public int index;
        public int jointIndex;
        public List<Node> children = new ObjectArrayList();

        public Node(int index, int jointIndex) {
            this.index = index;
            this.jointIndex = jointIndex;
        }

        public String toString() {
            return super.toString();
        }

        public String generateString(int indents) {
            int i;
            Object t = "";
            for (i = 0; i < indents; ++i) {
                t = (String)t + ">";
            }
            t = (String)t + this.index + "\n";
            for (i = 0; i < this.children.size(); ++i) {
                t = (String)t + this.children.get(i).generateString(indents + 1);
            }
            return t;
        }
    }
}

