/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ragdoll;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.RagdollHook;
import net.diebuddies.physics.ragdoll.VanillaRagdollHook;
import net.minecraft.class_1297;
import net.minecraft.class_1492;
import net.minecraft.class_1937;
import net.minecraft.class_4592;
import net.minecraft.class_5597;
import net.minecraft.class_578;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class RagdollMapper {
    private static final List<RagdollHook> hooks = new ObjectArrayList();
    private static final RagdollHook vanillaHook = new VanillaRagdollHook();

    public static void addHook(RagdollHook hook) {
        hooks.add(hook);
    }

    public static void removeHook(RagdollHook hook) {
        hooks.remove(hook);
    }

    public static Ragdoll map(class_1297 entity, class_583 model) {
        Ragdoll ragdoll = new Ragdoll();
        ragdoll.bodies.addAll(PhysicsMod.getInstance((class_1937)entity.method_5770()).blockifiedEntity);
        for (RagdollHook hook : hooks) {
            hook.map(ragdoll, entity, model);
        }
        if (ragdoll.joints.size() > 0) {
            return ragdoll;
        }
        vanillaHook.map(ragdoll, entity, model);
        if (ragdoll.joints.size() == 0) {
            return null;
        }
        return ragdoll;
    }

    public static void filterCuboidsFromEntities(class_1297 entity, class_583 model) {
        PhysicsMod mod = PhysicsMod.getInstance(entity.method_5770());
        for (RagdollHook hook : hooks) {
            hook.filterCuboidsFromEntities(mod.blockifiedEntity, entity, model);
        }
        vanillaHook.filterCuboidsFromEntities(mod.blockifiedEntity, entity, model);
    }

    public static void printModelParts(class_583 model) {
        if (model instanceof class_4592) {
            int index = 0;
            for (class_630 part : ((class_4592)model).method_22946()) {
                index = RagdollMapper.printModelPart(part, index);
            }
            for (class_630 part : ((class_4592)model).method_22948()) {
                index = RagdollMapper.printModelPart(part, index);
            }
            System.out.println("total: " + index);
        } else if (model instanceof class_5597) {
            int total = RagdollMapper.printModelParts((class_5597)model);
            System.out.println(model.getClass());
            System.out.println("total: " + total);
        }
    }

    public static int countModelParts(class_1297 entity, class_583 model) {
        if (model instanceof class_578) {
            int total = 9;
            if (!((class_1492)entity).method_6109() && ((class_1492)entity).method_6703()) {
                total = 11;
            }
            return total;
        }
        if (model instanceof class_4592) {
            int total = 0;
            for (class_630 part : ((class_4592)model).method_22946()) {
                total = RagdollMapper.printModelPart(part, total, true);
            }
            for (class_630 part : ((class_4592)model).method_22948()) {
                total = RagdollMapper.printModelPart(part, total, true);
            }
            return total;
        }
        if (model instanceof class_5597) {
            int total = RagdollMapper.printModelParts((class_5597)model, true);
            return total;
        }
        return 0;
    }

    public static boolean areRagdollsEnabled(class_1297 entity) {
        return ConfigMobs.getMobSetting(entity) == 4;
    }

    public static boolean isMobFracturingEnabled(class_1297 entity) {
        return ConfigMobs.getMobSetting(entity) == 1 || ConfigMobs.getMobSetting(entity) == 2;
    }

    private static int printModelParts(class_5597 entityModel, boolean hidePrint) {
        class_630 root = entityModel.method_32008();
        return RagdollMapper.printModelPart(root, 0, hidePrint);
    }

    private static int printModelParts(class_5597 entityModel) {
        return RagdollMapper.printModelParts(entityModel, false);
    }

    public static int printModelPart(class_630 part, int index, boolean hidePrint) {
        if (part.field_3665) {
            for (int i = 0; i < part.field_3663.size(); ++i) {
                ++index;
            }
            for (Map.Entry entry : part.field_3661.entrySet()) {
                if (!hidePrint) {
                    System.out.println((String)entry.getKey() + ": " + index);
                }
                class_630 child = (class_630)entry.getValue();
                index = RagdollMapper.printModelPart(child, index, hidePrint);
            }
        }
        return index;
    }

    public static int printModelPart(class_630 part, int index) {
        return RagdollMapper.printModelPart(part, index, false);
    }

    public static int getCuboids(Ragdoll ragdoll, class_630 part, Counter counter, boolean onlyVisual) {
        if (part.field_3665) {
            for (int c = 1; c < part.field_3663.size(); ++c) {
                ragdoll.addConnection(counter.count + c, counter.count, true, onlyVisual);
            }
            counter.count += part.field_3663.size();
            for (class_630 p : part.field_3661.values()) {
                counter.count = RagdollMapper.getCuboids(ragdoll, p, counter);
            }
        }
        return counter.count;
    }

    public static int getCuboids(Ragdoll ragdoll, class_630 part, Counter counter) {
        return RagdollMapper.getCuboids(ragdoll, part, counter, false);
    }

    public static class Counter {
        public int count;
    }
}

