/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class CapeObjectSelectionList
extends class_4280<BaseEntry> {
    public CapeObjectSelectionList(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.method_25339();
        Path path = PhysicsMod.CAPES_DIRECTORY;
        try {
            Collection folders = Files.list(path).filter(CapeObjectSelectionList::isValidCape).collect(Collectors.toList());
            for (Path folder : folders) {
                String name = folder.getFileName().toString();
                LabelEntry entry = new LabelEntry(name);
                this.method_25321((class_350.class_351)entry);
                if (!name.equalsIgnoreCase(ConfigClient.selectedPhysicsCape)) continue;
                this.setSelected(entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSelected(BaseEntry entry) {
        super.method_25313((class_350.class_351)entry);
        ConfigClient.selectedPhysicsCape = (String)entry.getUserData();
        ConfigClient.save();
    }

    public static boolean isValidCape(Path file) {
        return file.toFile().getName().endsWith("dae");
    }

    public class LabelEntry
    extends BaseEntry {
        private final String text;

        public LabelEntry(String text) {
            super(text);
            this.text = text;
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String newText;
            class_327 font = class_310.method_1551().field_1772;
            Object text = this.text.replace(".dae", "");
            if (font.method_27525((class_5348)new class_2585((String)text).method_27692(class_124.field_1067)) > CapeObjectSelectionList.this.method_25322() - 55 && !((String)text).equalsIgnoreCase(newText = font.method_27523((String)text, CapeObjectSelectionList.this.method_25322() - 58))) {
                text = newText + "...";
            }
            class_2585 label = new class_2585((String)text);
            if (hovered) {
                label = label.method_27692(class_124.field_1067);
                class_332.method_27534((class_4587)poseStack, (class_327)font, (class_2561)label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xFFFFFF);
            } else {
                class_332.method_27534((class_4587)poseStack, (class_327)font, (class_2561)label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xC2C2C2);
            }
        }

        public class_2561 method_37006() {
            return new class_2585(this.text);
        }
    }

    public abstract class BaseEntry
    extends class_4280.class_4281<BaseEntry> {
        private Object object;

        protected BaseEntry(Object object) {
            this.object = object;
        }

        public boolean isSelected() {
            return CapeObjectSelectionList.this.method_25334() == this;
        }

        public boolean method_25402(double d, double e, int i) {
            if (!this.isSelected()) {
                CapeObjectSelectionList.this.setSelected(this);
                return true;
            }
            return false;
        }

        public Object getUserData() {
            return this.object;
        }
    }
}

