/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.model.ColladaParser;
import net.diebuddies.opengl.Texture;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.CapeObjectSelectionList;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5244;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.joml.Matrix4d;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class CapeSelectionScreen
extends class_437 {
    private static final double ROTATE_SPEED = 6.0;
    private static final double START_ROTATE_SPEED = 30.0;
    private class_437 parent;
    private CapeObjectSelectionList capeList;
    private VerletSimulation simulation;
    private Texture texture;
    private long lastTime;
    private double timeDelta;
    private static final double FIXED_TIME_STEP = 0.016666666666666666;
    private Vector3d capeMin;
    private Vector3d capeMax;
    private double rotationSpeed = 30.0;
    private int capeXPosition = 70;
    private Object selectedCape = null;

    protected CapeSelectionScreen(class_437 parent) {
        super((class_2561)new class_2585("Cape Selection"));
        this.parent = parent;
        this.lastTime = System.nanoTime();
    }

    private void loadCape() {
        if (this.selectedCape != null) {
            int i;
            String file = (String)this.selectedCape;
            this.simulation = new VerletSimulation(new Vector3d(DynamicsWorld.DEFAULT_GRAVITY).negate(), 15, false);
            ColladaMesh mesh = ColladaParser.loadStaticModel(new File(PhysicsMod.CAPES_DIRECTORY + "/" + file));
            if (mesh == null) {
                return;
            }
            this.rotationSpeed = 30.0;
            for (Vector3f position : mesh.positions) {
                VerletPoint point = new VerletPoint(new Vector3d(position.x, -position.y, position.z));
                this.simulation.addPoint(point);
            }
            List<VerletPoint> points = this.simulation.getPoints();
            for (i = 0; i < mesh.indices.size(); ++i) {
                int pindex = mesh.indices.get((int)i).x;
                int cindex = mesh.indices.get((int)i).w;
                int tindex = mesh.indices.get((int)i).z;
                VerletPoint point = points.get(pindex);
                point.locked = mesh.colors.get((int)cindex).x < 0.99f;
                point.uv.set(mesh.texCoords.get(tindex));
            }
            for (i = 0; i < mesh.indices.size() / 4; ++i) {
                int index1 = mesh.indices.get((int)(i * 4)).x;
                int index2 = mesh.indices.get((int)(i * 4 + 1)).x;
                int index3 = mesh.indices.get((int)(i * 4 + 2)).x;
                int index4 = mesh.indices.get((int)(i * 4 + 3)).x;
                this.simulation.addStick(new VerletStick(points.get(index1), points.get(index2)));
                this.simulation.addStick(new VerletStick(points.get(index2), points.get(index3)));
                this.simulation.addStick(new VerletStick(points.get(index3), points.get(index4)));
                this.simulation.addStick(new VerletStick(points.get(index4), points.get(index1)));
                this.simulation.addStick(new VerletStick(points.get(index1), points.get(index3)));
                this.simulation.addStick(new VerletStick(points.get(index2), points.get(index4)));
                this.simulation.addQuad(new VerletQuad(points.get(index1), points.get(index2), points.get(index3), points.get(index4)));
            }
            this.capeMin = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            this.capeMax = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
            for (i = 0; i < this.simulation.getPoints().size(); ++i) {
                Vector3d position = this.simulation.getPoints().get((int)i).position;
                this.capeMin.min(position);
                this.capeMax.max(position);
            }
            try {
                if (this.texture != null) {
                    this.texture.destroy();
                }
                this.texture = Texture.load(PhysicsMod.CAPES_DIRECTORY + "/" + file.replace(".dae", ".png"), Texture.FILTER_MINECRAFT_TEXTURE);
                if (this.texture != null) {
                    this.simulation.textureID = this.texture.getID();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        PhysicsMod.createCapeDirectory();
        int bottomCenter = this.field_22789 / 2;
        this.method_37063((class_364)new class_4185(this.capeXPosition - 10, this.field_22790 - 57, 20, 20, (class_2561)new class_2585("?"), button -> {
            this.rotationSpeed = 30.0;
        }));
        this.capeList = new CapeObjectSelectionList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.field_22786.add(this.capeList);
        this.loadCape();
        this.method_37063((class_364)new RotateButton(this.capeXPosition - 35, this.field_22790 - 57, 20, 20, (class_2561)new class_2585("<"), true));
        this.method_37063((class_364)new RotateButton(this.capeXPosition + 15, this.field_22790 - 57, 20, 20, (class_2561)new class_2585(">"), false));
        this.method_37063((class_364)new class_4185(bottomCenter - 100, this.field_22790 - 27, 100, 20, (class_2561)new class_2585("Open Cape Folder"), button -> class_156.method_668().method_672(PhysicsMod.CAPES_DIRECTORY.toFile())));
        this.method_37063((class_364)new class_4185(bottomCenter + 5, this.field_22790 - 27, 100, 20, class_5244.field_24334, button -> this.method_25419()));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.capeList.method_25334() != null && this.selectedCape != ((CapeObjectSelectionList.BaseEntry)this.capeList.method_25334()).getUserData()) {
            this.selectedCape = ((CapeObjectSelectionList.BaseEntry)this.capeList.method_25334()).getUserData();
            this.loadCape();
        }
        this.method_25420(matrices);
        this.capeList.method_25394(matrices, mouseX, mouseY, delta);
        CapeSelectionScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)5, (int)0xFFFFFF);
        this.updateCape();
        this.renderCape();
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void updateCape() {
        long time = System.nanoTime();
        double passedTime = (double)(System.nanoTime() - this.lastTime) / 1.0E9;
        this.lastTime = time;
        this.timeDelta += passedTime;
        while (this.timeDelta >= 0.016666666666666666) {
            this.timeDelta -= 0.016666666666666666;
            this.rotationSpeed = Math.lerp(this.rotationSpeed, 0.0, 0.06);
            this.rotateCape();
            this.simulation.update(0.016666666666666666);
        }
    }

    private void rotateCape() {
        Matrix4d rotation = new Matrix4d();
        double capeHeight = this.capeMax.y - this.capeMin.y;
        double capeWidth = this.capeMax.x - this.capeMin.x;
        double capeDepth = this.capeMax.z - this.capeMin.z;
        rotation.translate(-capeWidth * 0.5 - this.capeMin.x, -capeHeight * 0.5 - this.capeMin.y, -capeDepth * 0.5 - this.capeMin.z);
        rotation.rotate(java.lang.Math.toRadians(this.rotationSpeed), new Vector3d(0.0, 1.0, 0.0));
        rotation.translate(capeWidth * 0.5 + this.capeMin.x, capeHeight * 0.5 + this.capeMin.y, capeDepth * 0.5 + this.capeMin.z);
        for (int i = 0; i < this.simulation.getPoints().size(); ++i) {
            VerletPoint point = this.simulation.getPoints().get(i);
            if (!point.locked) continue;
            rotation.transformPosition(point.position);
        }
    }

    private void renderCape() {
        if (this.simulation.getQuads().size() == 0) {
            return;
        }
        float scale = 100.0f;
        class_4587 matrices = RenderSystem.getModelViewStack();
        double capeHeight = this.capeMax.y - this.capeMin.y;
        double capeWidth = this.capeMax.x - this.capeMin.x;
        double capeDepth = this.capeMax.z - this.capeMin.z;
        matrices.method_22903();
        matrices.method_22904((double)this.capeXPosition, (double)(this.field_22790 / 2), 100.0);
        matrices.method_22905(scale, scale, scale);
        matrices.method_22904(-capeWidth * 0.5 - this.capeMin.x, -capeHeight * 0.5 - this.capeMin.y, -capeDepth * 0.5 - this.capeMin.z);
        RenderSystem.applyModelViewMatrix();
        class_5944 shader = RenderSystem.getShader();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34501);
        RenderSystem.enableDepthTest();
        class_310.method_1551().field_1773.method_22974().method_3316();
        int glID = this.simulation.textureID;
        class_308.method_34742();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.setShaderTexture((int)0, (int)glID);
        RenderSystem.bindTexture((int)glID);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.disableCull();
        double renderPercent = Math.clamp(this.timeDelta / 0.016666666666666666, 0.0, 1.0);
        int brightness = 0xF00000;
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1580);
        List<VerletQuad> quads = this.simulation.getQuads();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        for (int i = 0; i < quads.size(); ++i) {
            VerletQuad quad = quads.get(i);
            if (ConfigClient.clothSmoothShading) {
                this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point4.position, quad.point4.prevPosition, quad.point4.uv, quad.point4.normal, brightness, r, g, b, a);
                this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point3.position, quad.point3.prevPosition, quad.point3.uv, quad.point3.normal, brightness, r, g, b, a);
                this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point2.position, quad.point2.prevPosition, quad.point2.uv, quad.point2.normal, brightness, r, g, b, a);
                this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point1.position, quad.point1.prevPosition, quad.point1.uv, quad.point1.normal, brightness, r, g, b, a);
                continue;
            }
            this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point4.position, quad.point4.prevPosition, quad.point4.uv, quad.point1.normal, brightness, r, g, b, a);
            this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point3.position, quad.point3.prevPosition, quad.point3.uv, quad.point1.normal, brightness, r, g, b, a);
            this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point2.position, quad.point2.prevPosition, quad.point2.uv, quad.point1.normal, brightness, r, g, b, a);
            this.bufferVertex((class_4588)bufferbuilder, renderPercent, quad.point1.position, quad.point1.prevPosition, quad.point1.uv, quad.point1.normal, brightness, r, g, b, a);
        }
        tessellator.method_1350();
        matrices.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        RenderSystem.setShader(() -> shader);
    }

    private void bufferVertex(class_4588 bufferbuilder, double renderPercent, Vector3d position, Vector3d prevPosition, Vector2f uv, Vector3d normal, int brightness, float r, float g, float b, float a) {
        bufferbuilder.method_23919((float)Math.lerp(prevPosition.x, position.x, renderPercent), (float)Math.lerp(prevPosition.y, position.y, renderPercent), (float)Math.lerp(prevPosition.z, position.z, renderPercent), r, g, b, 1.0f, uv.x, uv.y, 0, brightness, (float)normal.x, (float)normal.y, (float)normal.z);
    }

    public void method_25419() {
        if (this.texture != null) {
            this.texture.destroy();
        }
        PhysicsMod.loadCape();
        this.field_22787.method_1507(this.parent);
    }

    public class RotateButton
    extends class_4185 {
        private boolean left;

        public RotateButton(int i, int j, int k, int l, class_2561 component, boolean left) {
            super(i, j, k, l, component, button -> {});
            this.left = left;
        }

        public void method_25359(class_4587 poseStack, int i, int j, float f) {
            super.method_25359(poseStack, i, j, f);
            if (this.method_25367()) {
                CapeSelectionScreen.this.rotationSpeed = this.left ? -6.0 : 6.0;
            }
        }
    }
}

