/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3i;

public class VerletSimulation {
    private Vector3d gravity;
    private List<VerletPoint> points;
    private List<VerletStick> sticks;
    private List<VerletQuad> quads;
    private int iterations;
    private Random random;
    private Vector3d offset;
    public boolean active = true;
    public boolean destroyed = false;
    public int textureID;
    public ColladaMesh mesh;
    private Vector3d tmp = new Vector3d();
    private Vector3i tmpInt = new Vector3i(0, 0, 0);

    public VerletSimulation(Vector3d gravity, int iterations, boolean useOffset) {
        this.gravity = new Vector3d(gravity);
        this.iterations = iterations;
        this.random = new Random(0L);
        this.points = new ObjectArrayList();
        this.sticks = new ObjectArrayList();
        this.quads = new ObjectArrayList();
        if (!useOffset) {
            this.offset = new Vector3d(0.0);
        }
    }

    public VerletSimulation(Vector3d gravity, int iterations) {
        this(gravity, iterations, true);
    }

    public void update(PhysicsWorld physics, double delta) {
        int i;
        double gx = this.gravity.x * delta * delta;
        double gy = this.gravity.y * delta * delta;
        double gz = this.gravity.z * delta * delta;
        double friction = 0.93;
        if (!this.points.isEmpty() && this.points.get((int)0).position.length() > 100.0) {
            this.setOffset(new Vector3d(this.getOffset()).add(this.points.get((int)0).position));
        }
        for (i = 0; i < this.points.size(); ++i) {
            VerletPoint p = this.points.get(i);
            if (!p.locked) {
                double vx = p.position.x - p.prevPosition.x;
                double vy = p.position.y - p.prevPosition.y;
                double vz = p.position.z - p.prevPosition.z;
                p.prevPosition.set(p.position);
                p.position.x += gx + vx * friction;
                p.position.y += gy + vy * friction;
                p.position.z += gz + vz * friction;
                continue;
            }
            p.prevPosition.set(p.position);
        }
        for (i = 0; i < this.iterations; ++i) {
            for (int j = 0; j < this.sticks.size(); ++j) {
                VerletStick stick = this.sticks.get(j);
                if (stick.pointA.locked && stick.pointB.locked) continue;
                double stickCenterX = (stick.pointA.position.x + stick.pointB.position.x) * 0.5;
                double stickCenterY = (stick.pointA.position.y + stick.pointB.position.y) * 0.5;
                double stickCenterZ = (stick.pointA.position.z + stick.pointB.position.z) * 0.5;
                double stickDirX = stick.pointA.position.x - stick.pointB.position.x;
                double stickDirY = stick.pointA.position.y - stick.pointB.position.y;
                double stickDirZ = stick.pointA.position.z - stick.pointB.position.z;
                double length = Vector3d.length(stickDirX, stickDirY, stickDirZ);
                if (length != 0.0) {
                    double invLength = stick.halfLength / length;
                    stickDirX *= invLength;
                    stickDirY *= invLength;
                    stickDirZ *= invLength;
                } else {
                    stickDirZ = 1.0 * stick.halfLength;
                }
                if (!stick.pointA.locked) {
                    stick.pointA.position.x = stickCenterX + stickDirX;
                    stick.pointA.position.y = stickCenterY + stickDirY;
                    stick.pointA.position.z = stickCenterZ + stickDirZ;
                }
                if (stick.pointB.locked) continue;
                stick.pointB.position.x = stickCenterX - stickDirX;
                stick.pointB.position.y = stickCenterY - stickDirY;
                stick.pointB.position.z = stickCenterZ - stickDirZ;
            }
        }
        if (physics != null) {
            this.checkVerletCollisions(physics);
        }
        this.calculateNormals();
        this.active = false;
    }

    public void update(double delta) {
        this.update(null, delta);
    }

    private void checkVerletCollisions(PhysicsWorld physics) {
        int z;
        int y;
        int x;
        if (this.points.size() == 0) {
            return;
        }
        VerletPoint start = this.points.get(0);
        class_2338.class_2339 min = new class_2338.class_2339(start.position.x + this.offset.x, start.position.y + this.offset.y, start.position.z + this.offset.z);
        class_2338.class_2339 max = new class_2338.class_2339(start.position.x + this.offset.x, start.position.y + this.offset.y, start.position.z + this.offset.z);
        for (int i = 0; i < this.points.size(); ++i) {
            VerletPoint point = this.points.get(i);
            x = class_3532.method_15357((double)(point.position.x + this.offset.x));
            y = class_3532.method_15357((double)(point.position.y + this.offset.y));
            z = class_3532.method_15357((double)(point.position.z + this.offset.z));
            if (x < min.method_10263()) {
                min.method_33097(x);
            } else if (x > max.method_10263()) {
                max.method_33097(x);
            }
            if (y < min.method_10264()) {
                min.method_33098(y);
            } else if (y > max.method_10264()) {
                max.method_33098(y);
            }
            if (z < min.method_10260()) {
                min.method_33099(z);
                continue;
            }
            if (z <= max.method_10260()) continue;
            max.method_33099(z);
        }
        Object2ObjectOpenHashMap bodies = new Object2ObjectOpenHashMap();
        class_2338.class_2339 currentPos = new class_2338.class_2339(0, 0, 0);
        for (x = min.method_10263() - 1; x <= max.method_10263() + 1; ++x) {
            for (y = min.method_10264() - 1; y <= max.method_10264() + 1; ++y) {
                for (z = min.method_10260() - 1; z <= max.method_10260() + 1; ++z) {
                    class_265 voxelShape;
                    currentPos.method_10103(x, y, z);
                    class_2680 state = physics.getWorld().method_8320((class_2338)currentPos);
                    if (state.method_26204() == class_2246.field_10124 || (voxelShape = state.method_26220((class_1922)physics.getWorld(), (class_2338)currentPos)).method_1110() || VineHelper.isVine(state)) continue;
                    for (class_238 aabb : voxelShape.method_1090()) {
                        this.addToSuroundings(new class_238(aabb.field_1323 + (double)x - this.offset.x, aabb.field_1322 + (double)y - this.offset.y, aabb.field_1321 + (double)z - this.offset.z, aabb.field_1320 + (double)x - this.offset.x, aabb.field_1325 + (double)y - this.offset.y, aabb.field_1324 + (double)z - this.offset.z), x, y, z, (Map<Vector3i, List<class_238>>)bodies);
                    }
                }
            }
        }
        double enlarge = 0.05;
        block5: for (VerletPoint point : this.points) {
            int z2;
            int y2;
            int x2;
            List boxes;
            if (point.locked || (boxes = (List)bodies.get(this.tmpInt.set(x2 = class_3532.method_15357((double)(point.position.x + this.offset.x)), y2 = class_3532.method_15357((double)(point.position.y + this.offset.y)), z2 = class_3532.method_15357((double)(point.position.z + this.offset.z))))) == null) continue;
            for (int i = 0; i < boxes.size(); ++i) {
                class_238 box = (class_238)boxes.get(i);
                if (VerletHelper.movePointOutOfBox(point.position, (float)(box.field_1323 - enlarge), (float)(box.field_1322 - enlarge), (float)(box.field_1321 - enlarge), (float)(box.field_1320 + enlarge), (float)(box.field_1325 + enlarge), (float)(box.field_1324 + enlarge))) continue block5;
            }
        }
    }

    private void addToSuroundings(class_238 box, int x, int y, int z, Map<Vector3i, List<class_238>> bodies) {
        for (int xi = -1; xi <= 1; ++xi) {
            for (int yi = -1; yi <= 1; ++yi) {
                for (int zi = -1; zi <= 1; ++zi) {
                    ObjectArrayList boxes = bodies.get(this.tmpInt.set(x + xi, y + yi, z + zi));
                    if (boxes == null) {
                        boxes = new ObjectArrayList();
                        bodies.put(new Vector3i(this.tmpInt), (List<class_238>)boxes);
                    }
                    boxes.add((class_238)box);
                }
            }
        }
    }

    private void calculateNormals() {
        for (VerletQuad quad : this.quads) {
            double ax = quad.point3.position.x - quad.point1.position.x;
            double ay = quad.point3.position.y - quad.point1.position.y;
            double az = quad.point3.position.z - quad.point1.position.z;
            double bx = quad.point2.position.x - quad.point1.position.x;
            double by = quad.point2.position.y - quad.point1.position.y;
            double bz = quad.point2.position.z - quad.point1.position.z;
            double nx = ay * bz - az * by;
            double ny = az * bx - ax * bz;
            double nz = ax * by - ay * bx;
            double invLength = Math.invsqrt(nx * nx + ny * ny + nz * nz);
            nx *= invLength;
            ny *= invLength;
            nz *= invLength;
            if (ConfigClient.clothSmoothShading) {
                quad.point1.normal.set(nx, ny, nz);
                quad.point2.normal.set(nx, ny, nz);
                quad.point3.normal.set(nx, ny, nz);
                quad.point4.normal.set(nx, ny, nz);
                continue;
            }
            quad.point1.normal.set(nx, ny, nz);
        }
    }

    public void addPoint(VerletPoint point) {
        if (this.offset == null) {
            this.offset = new Vector3d(point.position);
        }
        point.position.sub(this.offset);
        point.prevPosition.set(point.position);
        this.points.add(point);
    }

    public void addStick(VerletStick stick) {
        this.sticks.add(stick);
    }

    public void addQuad(VerletQuad quad) {
        this.quads.add(quad);
    }

    public void removePoint(VerletPoint point) {
        this.points.remove(point);
    }

    public void removeStick(VerletStick stick) {
        this.sticks.remove(stick);
    }

    public void removeQuad(VerletQuad quad) {
        this.quads.remove(quad);
    }

    public List<VerletStick> getSticks() {
        return this.sticks;
    }

    public List<VerletPoint> getPoints() {
        return this.points;
    }

    public List<VerletQuad> getQuads() {
        return this.quads;
    }

    public Vector3d getGravity() {
        return this.gravity;
    }

    public void setGravity(Vector3d gravity) {
        this.gravity.set(gravity);
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3d offset) {
        double dx = -offset.x + this.offset.x;
        double dy = -offset.y + this.offset.y;
        double dz = -offset.z + this.offset.z;
        for (VerletPoint point : this.points) {
            point.position.x += dx;
            point.position.y += dy;
            point.position.z += dz;
            point.prevPosition.x += dx;
            point.prevPosition.y += dy;
            point.prevPosition.z += dz;
        }
        this.offset.set(offset);
    }
}

