/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.diebuddies.physics.DynamicsWorld;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public final class ConfigClient {
    private static final String DIR = "config/physicsmod";
    private static final String CONFIG = "physics_client_config.json";
    public static Map<String, Vector3f> customizedGravities;
    public static Map<String, Vector3f> customizedBuoyancies;
    public static int mobPhysicsType;
    public static int blockPhysics;
    public static boolean itemPhysics;
    public static int maxPhysicsObjects;
    public static int cpuThreads;
    public static double blockPhysicsScale;
    public static double particleLifetimeBlocks;
    public static double particleLifetimeMobs;
    public static double particleLifetimeVines;
    public static boolean gravityChanged;
    public static boolean minecraftBlockBreakParticles;
    public static boolean vinePhysics;
    public static boolean clothPhysics;
    public static boolean clothSmoothShading;
    public static boolean physicsModCape;
    public static boolean showUpdateNotifications;
    public static String selectedPhysicsCape;
    public static volatile double vineRange;

    public static void init() {
    }

    public static Vector3f getGravity(String id) {
        Vector3f val = customizedGravities.get(id);
        if (val == null) {
            val = new Vector3f(DynamicsWorld.DEFAULT_GRAVITY);
        }
        return val;
    }

    public static Vector3f getGravity(ResourceLocation id) {
        return ConfigClient.getGravity(id.toString());
    }

    public static Vector3f getBuoyancy(String id) {
        Vector3f val = customizedBuoyancies.get(id);
        if (val == null) {
            val = new Vector3f(DynamicsWorld.DEFAULT_BUOYANCY);
        }
        return val;
    }

    public static Vector3f getBuoyancy(ResourceLocation id) {
        return ConfigClient.getBuoyancy(id.toString());
    }

    public static void setGravity(String id, Vector3f gravity) {
        customizedGravities.put(id, gravity);
        gravityChanged = true;
    }

    public static void setBuoyancy(String id, Vector3f buoyancy) {
        customizedBuoyancies.put(id, buoyancy);
        gravityChanged = true;
    }

    public static boolean addGravityBuoyancyEntry(ResourceLocation id) {
        if (!customizedGravities.containsKey(id.toString())) {
            customizedGravities.put(id.toString(), new Vector3f(DynamicsWorld.DEFAULT_GRAVITY));
            customizedBuoyancies.put(id.toString(), new Vector3f(DynamicsWorld.DEFAULT_BUOYANCY));
            return true;
        }
        return false;
    }

    public static boolean hasItemPhysics() {
        return itemPhysics;
    }

    private static JsonObject createConfig() {
        Vector3f val;
        JsonObject config = new JsonObject();
        config.add("mobPhysicsType", (JsonElement)new JsonPrimitive((Number)mobPhysicsType));
        config.add("blockPhysicsNew", (JsonElement)new JsonPrimitive((Number)blockPhysics));
        config.add("maxPhysicsObjects", (JsonElement)new JsonPrimitive((Number)maxPhysicsObjects));
        config.add("blockPhysicsScale", (JsonElement)new JsonPrimitive((Number)blockPhysicsScale));
        config.add("particleLifetimeMobs", (JsonElement)new JsonPrimitive((Number)particleLifetimeMobs));
        config.add("particleLifetimeBlocks", (JsonElement)new JsonPrimitive((Number)particleLifetimeBlocks));
        config.add("particleLifetimeVines", (JsonElement)new JsonPrimitive((Number)particleLifetimeVines));
        config.add("cpuThreads", (JsonElement)new JsonPrimitive((Number)cpuThreads));
        config.add("itemPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(itemPhysics)));
        config.add("minecraftBlockBreakParticles", (JsonElement)new JsonPrimitive(Boolean.valueOf(minecraftBlockBreakParticles)));
        config.add("vinePhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(vinePhysics)));
        config.add("clothPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(clothPhysics)));
        config.add("clothSmoothShading", (JsonElement)new JsonPrimitive(Boolean.valueOf(clothSmoothShading)));
        config.add("physicsModCape", (JsonElement)new JsonPrimitive(Boolean.valueOf(physicsModCape)));
        config.add("selectedPhysicsCape", (JsonElement)new JsonPrimitive(selectedPhysicsCape));
        config.add("showUpdateNotifications", (JsonElement)new JsonPrimitive(Boolean.valueOf(showUpdateNotifications)));
        JsonArray array = new JsonArray();
        for (Map.Entry<String, Vector3f> entry : customizedGravities.entrySet()) {
            array.add(entry.getKey());
            val = entry.getValue();
            array.add((Number)Float.valueOf(val.x));
            array.add((Number)Float.valueOf(val.y));
            array.add((Number)Float.valueOf(val.z));
        }
        config.add("customizedGravities", (JsonElement)array);
        array = new JsonArray();
        for (Map.Entry<String, Vector3f> entry : customizedBuoyancies.entrySet()) {
            array.add(entry.getKey());
            val = entry.getValue();
            array.add((Number)Float.valueOf(val.x));
            array.add((Number)Float.valueOf(val.y));
            array.add((Number)Float.valueOf(val.z));
        }
        config.add("customizedBuoyancies", (JsonElement)array);
        return config;
    }

    public static void resetOptions() {
        mobPhysicsType = 4;
        blockPhysics = 1;
        itemPhysics = true;
        maxPhysicsObjects = 10000;
        cpuThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 4);
        blockPhysicsScale = 1.0;
        particleLifetimeBlocks = 4.0;
        particleLifetimeMobs = 4.0;
        minecraftBlockBreakParticles = false;
        vinePhysics = true;
        ConfigClient.save();
    }

    public static void resetGravities() {
        for (Map.Entry<String, Vector3f> entry : customizedGravities.entrySet()) {
            customizedGravities.put(entry.getKey(), new Vector3f(DynamicsWorld.DEFAULT_GRAVITY));
        }
        for (Map.Entry<String, Vector3f> entry : customizedBuoyancies.entrySet()) {
            customizedBuoyancies.put(entry.getKey(), new Vector3f(DynamicsWorld.DEFAULT_BUOYANCY));
        }
        gravityChanged = true;
        ConfigClient.save();
    }

    public static void save() {
        File configFile;
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if ((configFile = new File("config/physicsmod/physics_client_config.json")).exists()) {
            configFile.delete();
        }
        JsonObject config = ConfigClient.createConfig();
        try {
            configFile.createNewFile();
            try (FileWriter writer = new FileWriter(configFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((JsonElement)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        File configFile;
        customizedGravities = new HashMap<String, Vector3f>();
        customizedBuoyancies = new HashMap<String, Vector3f>();
        mobPhysicsType = 4;
        blockPhysics = 1;
        itemPhysics = true;
        maxPhysicsObjects = 10000;
        cpuThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 4);
        blockPhysicsScale = 1.0;
        particleLifetimeBlocks = 4.0;
        particleLifetimeMobs = 4.0;
        particleLifetimeVines = 4.0;
        gravityChanged = false;
        minecraftBlockBreakParticles = false;
        vinePhysics = true;
        clothPhysics = true;
        clothSmoothShading = false;
        physicsModCape = true;
        showUpdateNotifications = true;
        selectedPhysicsCape = "Physics Mod Cape.dae";
        vineRange = 32.0;
        JsonObject config = ConfigClient.createConfig();
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!(configFile = new File("config/physicsmod/physics_client_config.json")).exists()) {
            try {
                configFile.createNewFile();
                try (FileWriter writer = new FileWriter(configFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Gson gson = new Gson();
            try {
                config = (JsonObject)gson.fromJson((Reader)new FileReader(configFile), JsonObject.class);
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            Float z;
            Float y;
            Float x;
            String id;
            int i;
            blockPhysics = config.get("blockPhysicsNew").getAsInt();
            mobPhysicsType = config.get("mobPhysicsType").getAsInt();
            maxPhysicsObjects = config.get("maxPhysicsObjects").getAsInt();
            blockPhysicsScale = config.get("blockPhysicsScale").getAsDouble();
            particleLifetimeMobs = config.get("particleLifetimeMobs").getAsDouble();
            particleLifetimeBlocks = config.get("particleLifetimeBlocks").getAsDouble();
            particleLifetimeVines = config.get("particleLifetimeVines").getAsDouble();
            cpuThreads = config.get("cpuThreads").getAsInt();
            itemPhysics = config.get("itemPhysics").getAsBoolean();
            minecraftBlockBreakParticles = config.get("minecraftBlockBreakParticles").getAsBoolean();
            vinePhysics = config.get("vinePhysics").getAsBoolean();
            clothPhysics = config.get("clothPhysics").getAsBoolean();
            clothSmoothShading = config.get("clothSmoothShading").getAsBoolean();
            physicsModCape = config.get("physicsModCape").getAsBoolean();
            selectedPhysicsCape = config.get("selectedPhysicsCape").getAsString();
            showUpdateNotifications = config.get("showUpdateNotifications").getAsBoolean();
            JsonArray array = config.get("customizedGravities").getAsJsonArray();
            for (i = 0; i < array.size() / 4; ++i) {
                id = array.get(i * 4).getAsString();
                x = Float.valueOf(array.get(i * 4 + 1).getAsFloat());
                y = Float.valueOf(array.get(i * 4 + 2).getAsFloat());
                z = Float.valueOf(array.get(i * 4 + 3).getAsFloat());
                customizedGravities.put(id, new Vector3f(x.floatValue(), y.floatValue(), z.floatValue()));
            }
            array = config.get("customizedBuoyancies").getAsJsonArray();
            for (i = 0; i < array.size() / 4; ++i) {
                id = array.get(i * 4).getAsString();
                x = Float.valueOf(array.get(i * 4 + 1).getAsFloat());
                y = Float.valueOf(array.get(i * 4 + 2).getAsFloat());
                z = Float.valueOf(array.get(i * 4 + 3).getAsFloat());
                customizedBuoyancies.put(id, new Vector3f(x.floatValue(), y.floatValue(), z.floatValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

