/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Creeper;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPacketListener {
    @Inject(at={@At(value="HEAD")}, method={"handleExplosion"})
    public void handleExplosion(ClientboundExplodePacket explosionPacket, CallbackInfo ci) {
        if (RenderSystem.m_69586_()) {
            Explosion explosion = new Explosion();
            explosion.strength = explosionPacket.m_132135_();
            explosion.position = new Vector3d(explosionPacket.m_132132_(), explosionPacket.m_132133_(), explosionPacket.m_132134_());
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                mod.explosions.add(explosion);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleRemoveEntities"})
    public void handleRemoveEntities(ClientboundRemoveEntitiesPacket packetIn, CallbackInfo ci) {
        if (RenderSystem.m_69586_()) {
            for (int i = 0; i < packetIn.m_182730_().size(); ++i) {
                int j = packetIn.m_182730_().getInt(i);
                Entity entity = Minecraft.m_91087_().f_91074_.f_108545_.m_6815_(j);
                if (entity == null || !(entity instanceof EnderDragon) && !(entity instanceof Creeper) || !(entity.m_20182_().m_82554_(Minecraft.m_91087_().f_91074_.m_20182_()) < 40.0)) continue;
                PhysicsMod.blockifyEntity(((LivingEntity)entity).m_20193_(), entity);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleLogin"})
    public void handleLogin(ClientboundLoginPacket packet, CallbackInfo ci) {
        boolean changed = false;
        for (ResourceKey entry : packet.m_132405_()) {
            changed |= ConfigClient.addGravityBuoyancyEntry(entry.m_135782_());
        }
        if (changed) {
            ConfigClient.save();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleContainerSetSlot"})
    public void handleContainerSetSlot(ClientboundContainerSetSlotPacket packet, CallbackInfo ci) {
    }
}

