/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.vines.VineLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void render(float tickDelta, long timeNano, boolean render, CallbackInfo info) {
        for (Map.Entry entry : PhysicsMod.getInstances().entrySet()) {
            PhysicsMod mod = (PhysicsMod)entry.getValue();
            while (!mod.sodiumRemoveRagdolls.isEmpty()) {
                Ragdoll ragdoll = mod.sodiumRemoveRagdolls.poll();
                mod.physicsWorld.removeRagdoll(ragdoll);
                ragdoll.destroy();
            }
        }
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        long currentTime = timeNano;
        ObjectIterator it = PhysicsMod.getInstances().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Level level = (Level)entry.getKey();
            PhysicsMod mod = (PhysicsMod)entry.getValue();
            if (level instanceof ClientLevel) {
                ((VineLoader)((ClientLevel)level).m_7726_()).setPhysicsMod(mod);
            }
            if ((double)(currentTime - mod.time) / 1000000.0 > 4000.0) {
                mod.time = currentTime;
            }
            double diff = (double)(currentTime - mod.time) / 1.0E9 * PhysicsMod.getPlaybackSpeed();
            PhysicsWorld physics = mod.getPhysicsWorld();
            if (!physics.isActive()) {
                physics.destroy();
                it.remove();
                continue;
            }
            physics.update(diff);
            mod.time = currentTime;
            if (!(level instanceof ClientLevel)) continue;
            ClientLevel client = (ClientLevel)level;
            for (Entity entity : client.m_104735_()) {
                if (!(entity instanceof Player)) continue;
                Player p = (Player)entity;
                Float health = mod.players.get(p);
                if (health != null && health.floatValue() > 0.0f && p.m_21223_() <= 0.0f && ConfigMobs.getMobSetting((Entity)p) != 0) {
                    PhysicsMod.blockifyEntity(p.m_20193_(), (Entity)p);
                }
                mod.players.put(p, Float.valueOf(p.m_21223_()));
            }
        }
    }
}

