/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.math.MatrixUtil;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.Usage;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.JsonUnbakedModelHolder;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.FrustumIntersection;
import org.joml.Matrix3d;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.lwjgl.opengl.GL32C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    @Unique
    private static final Matrix3d IDENTITY_3_BY_3 = new Matrix3d();
    @Unique
    private FrustumIntersection frustumInt;
    @Unique
    private org.joml.Matrix4f viewProjectionMatrix = new org.joml.Matrix4f();
    @Unique
    private org.joml.Matrix4f projectionMatrix = new org.joml.Matrix4f();
    @Unique
    private org.joml.Matrix4f viewMatrix = new org.joml.Matrix4f();
    private static final int DEFAULT_SIZE = 200;
    @Unique
    private int size = 200;
    @Unique
    private float[] mpos = new float[this.size * 3];
    @Unique
    private byte[] mcol = new byte[this.size * 4];
    @Unique
    private float[] muv = new float[this.size * 2];
    @Unique
    private short[] moverlay = new short[this.size * 2];
    @Unique
    private short[] mlight = new short[this.size * 2];
    @Unique
    private byte[] mnormals = new byte[this.size * 3];
    @Unique
    private int[] mindices = new int[this.size];
    @Unique
    private Matrix4d transformation = new Matrix4d();
    @Unique
    private Matrix3d normalMatrix = new Matrix3d();
    @Unique
    private Vector3d pos = new Vector3d();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private Matrix4f mojangNormalMatrix = new Matrix4f();
    @Unique
    private BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
    @Unique
    private ObjectSet<TextureAtlasSprite> uniqueSprites = new ObjectOpenHashSet();

    @Inject(at={@At(value="HEAD")}, method={"renderLevel"})
    public void renderLevelHead(PoseStack viewMatrixStack, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f projectionMatrix, CallbackInfo info) {
    }

    @Inject(at={@At(value="TAIL")}, method={"renderLevel"})
    public void renderLevelTail(PoseStack viewMatrixStack, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f projectionMatrix, CallbackInfo info) {
        StarterClient.setMatrix(this.projectionMatrix, projectionMatrix);
        StarterClient.setMatrix(this.viewMatrix, viewMatrixStack.m_85850_().m_85861_());
        this.projectionMatrix.mul(this.viewMatrix, this.viewProjectionMatrix);
        this.frustumInt.set(this.viewProjectionMatrix, true);
        RenderSystem.m_157427_(GameRenderer::m_172658_);
        RenderSystem.m_157425_((Matrix4f)projectionMatrix);
        PoseStack matrixStackIn = RenderSystem.m_157191_();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_166854_(viewMatrixStack.m_85850_().m_85861_());
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        RenderSystem.m_69388_((int)33984);
        RenderSystem.m_69493_();
        this.renderVerletSimulations(matrixStackIn);
        matrixStackIn.m_85849_();
        RenderSystem.m_69388_((int)33984);
        RenderSystem.m_69481_();
        RenderSystem.m_157182_();
    }

    private void renderVerletSimulations(PoseStack matrixStackIn) {
        Level level;
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (level = player.m_20193_()) != null) {
            PhysicsMod mod = PhysicsMod.getInstance(level);
            for (VerletSimulation verletSimulation : mod.getPhysicsWorld().getVerletSimulations()) {
                if (!verletSimulation.active || verletSimulation.destroyed || !verletSimulation.render) continue;
                int glID = verletSimulation.textureID;
                RenderSystem.m_69388_((int)33984);
                RenderSystem.m_157453_((int)0, (int)glID);
                RenderSystem.m_69396_((int)glID);
                this.localT.m_27624_();
                Vector3d offset = verletSimulation.getOffset();
                this.localT.m_162199_((float)(-view.f_82479_ + offset.x), (float)(-view.f_82480_ + offset.y), (float)(-view.f_82481_ + offset.z));
                matrixStackIn.m_85836_();
                matrixStackIn.m_166854_(this.localT);
                RenderSystem.m_157182_();
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tessellator.m_85915_();
                Matrix4f identity = new Matrix4f();
                identity.m_27624_();
                if (Minecraft.m_91087_().f_91074_ != null && (level instanceof ClientLevel ? ((ClientLevel)level).m_104583_().m_108885_() : Minecraft.m_91087_().f_91074_.f_108545_.m_104583_().m_108885_())) {
                    Lighting.m_84925_((Matrix4f)identity);
                } else {
                    Lighting.m_84928_((Matrix4f)identity);
                }
                bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
                verletSimulation.render((VertexConsumer)bufferbuilder, mod.getPhysicsWorld().getRenderPercent());
                verletSimulation.render = false;
                tessellator.m_85914_();
                matrixStackIn.m_85849_();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"renderChunkLayer"})
    private void renderChunkLayer(RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, Matrix4f projectionMatrix, CallbackInfo ci) {
        RenderSystem.m_69393_(RenderSystem::m_69586_);
        if (StarterClient.updateMessage != null && !StarterClient.updateMessage.isBlank() && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.Serializer.m_130701_((String)StarterClient.updateMessage), false);
            StarterClient.updateMessage = "";
        }
        if (StarterClient.customMessage != null && !StarterClient.customMessage.isBlank() && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.Serializer.m_130701_((String)StarterClient.customMessage), false);
            StarterClient.customMessage = "";
        }
        blockLayerIn.m_110185_();
        if (blockLayerIn == RenderType.m_110466_()) {
            if (this.frustumInt == null) {
                this.frustumInt = new FrustumIntersection();
            }
            StarterClient.setMatrix(this.projectionMatrix, projectionMatrix);
            StarterClient.setMatrix(this.viewMatrix, viewMatrixStack.m_85850_().m_85861_());
            this.projectionMatrix.mul(this.viewMatrix, this.viewProjectionMatrix);
            this.frustumInt.set(this.viewProjectionMatrix, true);
            ShaderInstance shaderBefore = RenderSystem.m_157196_();
            Matrix4f projectionBefore = RenderSystem.m_157192_();
            RenderSystem.m_157427_(GameRenderer::m_172658_);
            RenderSystem.m_157425_((Matrix4f)projectionMatrix);
            PoseStack matrixStackIn = RenderSystem.m_157191_();
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_166854_(viewMatrixStack.m_85850_().m_85861_());
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
            RenderSystem.m_69388_((int)33984);
            RenderSystem.m_69493_();
            RenderSystem.m_69464_();
            this.renderVerletSimulations(matrixStackIn);
            matrixStackIn.m_85849_();
            RenderSystem.m_157427_(() -> shaderBefore);
            RenderSystem.m_157425_((Matrix4f)projectionBefore);
            RenderSystem.m_157182_();
        } else if (blockLayerIn == RenderType.m_110463_()) {
            Level level;
            if (this.frustumInt == null) {
                this.frustumInt = new FrustumIntersection();
            }
            StarterClient.setMatrix(this.projectionMatrix, projectionMatrix);
            StarterClient.setMatrix(this.viewMatrix, viewMatrixStack.m_85850_().m_85861_());
            this.projectionMatrix.mul(this.viewMatrix, this.viewProjectionMatrix);
            this.frustumInt.set(this.viewProjectionMatrix, true);
            RenderSystem.m_157427_(GameRenderer::m_172658_);
            RenderSystem.m_157425_((Matrix4f)projectionMatrix);
            PoseStack matrixStackIn = RenderSystem.m_157191_();
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_166854_(viewMatrixStack.m_85850_().m_85861_());
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
            RenderSystem.m_69388_((int)33984);
            RenderSystem.m_69493_();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.uniqueSprites.clear();
            if (player != null && (level = player.m_20193_()) != null) {
                matrixStackIn.m_85836_();
                PhysicsMod mod = PhysicsMod.getInstance(level);
                PhysicsWorld physics = mod.getPhysicsWorld();
                physics.updateLastSeen();
                this.updatePhysics(mod, level, player, physics);
                int oldVao = 0;
                if (physics.getBodies().size() > 0 || physics.getRagdolls().size() > 0) {
                    if (!StarterClient.RENDER_LEGACY) {
                        this.setupShader(RenderSystem.m_157196_());
                        oldVao = GL32C.glGetInteger((int)34229);
                    }
                    for (IRigidBody body : physics.getBodies()) {
                        if (body.isRagdoll) continue;
                        this.setTransformation(physics, body, body.getEntity());
                        this.render(physics, level, matrixStackIn, view, body.getEntity());
                    }
                    for (Ragdoll ragdoll : physics.getRagdolls()) {
                        for (IRigidBody body : ragdoll.btBodies) {
                            this.setTransformation(physics, body, body.getEntity());
                            this.render(physics, level, matrixStackIn, view, body.getEntity());
                        }
                    }
                    if (!StarterClient.RENDER_LEGACY) {
                        GL32C.glBindVertexArray((int)oldVao);
                        RenderSystem.m_157196_().m_173362_();
                    }
                }
                matrixStackIn.m_85849_();
            }
            if (StarterClient.sodium) {
                for (TextureAtlasSprite sprite : this.uniqueSprites) {
                    Sodium.markSpriteActive(sprite);
                }
            }
            matrixStackIn.m_85849_();
        }
        RenderSystem.m_69388_((int)33984);
        RenderSystem.m_69481_();
        blockLayerIn.m_110188_();
        RenderSystem.m_157182_();
    }

    @Unique
    private void setTransformation(PhysicsWorld physics, IRigidBody body, PhysicsEntity entity) {
        if (body.hasTransformationChanged()) {
            MatrixUtil.slerp(entity.getOldTransformation(), entity.getTransformation(), physics.getRenderPercent(), this.transformation);
        } else {
            this.transformation.set(entity.getTransformation());
        }
    }

    @Unique
    private void render(PhysicsWorld physics, Level level, PoseStack matrixStackIn, Vec3 view, PhysicsEntity particle) {
        if (particle.models.get((int)0).mesh == null) {
            return;
        }
        if (particle.backfaceCulling) {
            RenderSystem.m_69481_();
        } else {
            RenderSystem.m_69464_();
        }
        double scaleX = Math.clamp(particle.time * 2.0, 0.0, 1.0) * particle.scalePhysics.x * particle.scale;
        double scaleY = Math.clamp(particle.time * 2.0, 0.0, 1.0) * particle.scalePhysics.y * particle.scale;
        double scaleZ = Math.clamp(particle.time * 2.0, 0.0, 1.0) * particle.scalePhysics.z * particle.scale;
        this.transformation.m30(this.transformation.m30() + physics.getOffset().x - view.f_82479_);
        this.transformation.m31(this.transformation.m31() + physics.getOffset().y - view.f_82480_);
        this.transformation.m32(this.transformation.m32() + physics.getOffset().z - view.f_82481_);
        this.transformation.scale((float)scaleX, (float)scaleY, (float)scaleZ);
        this.transformation.getTranslation(this.pos);
        if (!this.frustumInt.testSphere((float)this.pos.x, (float)this.pos.y, (float)this.pos.z, (float)particle.getBoundingSphereRadius())) {
            return;
        }
        this.blockPos.m_122169_(this.pos.x + view.f_82479_, this.pos.y + view.f_82480_, this.pos.z + view.f_82481_);
        matrixStackIn.m_85836_();
        StarterClient.setMojangMatrix(this.localT, this.transformation);
        matrixStackIn.m_166854_(this.localT);
        this.transformation.normal(this.normalMatrix).invert();
        if (particle.shade) {
            StarterClient.setMojangMatrix(this.mojangNormalMatrix, this.normalMatrix);
        } else {
            StarterClient.setMojangMatrix(this.mojangNormalMatrix, IDENTITY_3_BY_3);
        }
        RenderSystem.m_157182_();
        if (Minecraft.m_91087_().f_91074_ != null && (level instanceof ClientLevel ? ((ClientLevel)level).m_104583_().m_108885_() : Minecraft.m_91087_().f_91074_.f_108545_.m_104583_().m_108885_())) {
            Lighting.m_84925_((Matrix4f)this.mojangNormalMatrix);
        } else {
            Lighting.m_84928_((Matrix4f)this.mojangNormalMatrix);
        }
        for (Model model : particle.models) {
            for (int i = 0; i < model.textureIDs.length; ++i) {
                RenderSystem.m_157453_((int)i, (int)model.textureIDs[i]);
                RenderSystem.m_69388_((int)(33984 + i));
                RenderSystem.m_69396_((int)model.textureIDs[i]);
            }
            if (model.animationSprite != null) {
                this.uniqueSprites.add((Object)model.animationSprite);
            }
            if (StarterClient.RENDER_LEGACY) {
                this.renderLegacy(level, particle, model, this.blockPos);
                continue;
            }
            this.renderFast(level, particle, model, this.blockPos);
        }
        matrixStackIn.m_85849_();
    }

    @Unique
    private void updatePhysics(PhysicsMod mod, Level level, LocalPlayer player, PhysicsWorld physics) {
        PhysicsEntity particle;
        int qsize;
        mod.removeUpdates.clear();
        for (int i = mod.updateQueue.size() - 1; i >= 0; --i) {
            mod.removeUpdates.add(mod.updateQueue.get(i));
        }
        mod.updateQueue.clear();
        ObjectArrayList newParts = new ObjectArrayList();
        for (BlockUpdate bu : mod.removeUpdates) {
            Object entity;
            if (bu.state.m_60734_() == Blocks.f_50077_ || bu.state.m_60734_() == Blocks.f_50040_) continue;
            int blockSetting = ConfigBlocks.getBlockSetting(bu.state.m_60734_());
            if (blockSetting == 1) {
                newParts.addAll(this.getBlockData(bu, bu.level));
                continue;
            }
            if (blockSetting != 3 || bu.state.m_60734_() == Blocks.f_50016_ || (entity = mod.renderBlockIntoEntity(PhysicsEntity.Type.BLOCK, bu.state, bu.pos)) == null) continue;
            physics.addBlockParticle((PhysicsEntity)entity).applyRandomSpawnForces();
        }
        double chance = 1.0;
        if (newParts.size() > 10 || (double)physics.getBodies().size() > (double)ConfigClient.maxPhysicsObjects * 0.4) {
            chance = 0.3;
            if ((double)physics.getBodies().size() > (double)ConfigClient.maxPhysicsObjects * 0.7) {
                chance = 0.05;
            }
        }
        if (physics.getBodies().size() > ConfigClient.maxPhysicsObjects) {
            chance = 0.0;
        }
        if ((qsize = newParts.size()) == 1) {
            chance = 1.0;
        }
        for (PhysicsEntity particle2 : newParts) {
            double volume = (particle2.max.x - particle2.min.x) * (particle2.max.y - particle2.min.y) * (particle2.max.z - particle2.min.z);
            List<Mesh> mesh = PhysicsMod.brokenBlock;
            if (!(java.lang.Math.random() < chance)) continue;
            mesh = chance < 0.5 || (double)physics.getBodies().size() > (double)ConfigClient.maxPhysicsObjects * 0.4 ? PhysicsMod.brokenBlocksLittle.get(new Random().nextInt(PhysicsMod.brokenBlocksLittle.size())) : PhysicsMod.brokenBlocksLots.get(new Random().nextInt(PhysicsMod.brokenBlocksLots.size()));
            if (volume < 0.05) {
                mesh = PhysicsMod.brokenBlock;
            } else if (volume < 0.9) {
                mesh = PhysicsMod.brokenBlocksLittle.get(new Random().nextInt(PhysicsMod.brokenBlocksLittle.size()));
            }
            particle2.scale = ConfigClient.blockPhysicsScale;
            physics.addBlockParticle(mesh, particle2);
        }
        while (!mod.entityBlocks.isEmpty()) {
            particle = mod.entityBlocks.poll();
            if (particle.noVolume) continue;
            physics.addBlockParticle(particle).applyRandomSpawnForces();
        }
        while (!mod.additionalPhysics.isEmpty()) {
            particle = mod.additionalPhysics.poll();
            physics.addBlockParticle(particle).applyRandomSpawnForces();
        }
        while (!mod.ragdolls.isEmpty()) {
            Ragdoll ragdoll = mod.ragdolls.poll();
            physics.addRagdoll(ragdoll);
        }
        while (!mod.blockUpdates.isEmpty()) {
            BlockPos pos = mod.blockUpdates.poll();
            physics.blockUpdate(pos);
        }
        while (!mod.explosions.isEmpty()) {
            physics.applyExplosion(mod.explosions.poll());
        }
    }

    @Unique
    private void renderFast(Level level, PhysicsEntity particle, Model model, BlockPos.MutableBlockPos blockPos) {
        Mesh mesh = model.mesh;
        boolean shade = particle.shade;
        if (mesh.indices.size() < 3) {
            return;
        }
        int brightness = mesh.light.size() == 0 ? particle.getLight(level, blockPos) : 0;
        int j = brightness >> 16 & 0xFFFF;
        int k = brightness & 0xFFFF;
        int overlay = model.overlay;
        short overlayX = (short)(overlay >> 16 & 0xFFFF);
        short overlayY = (short)(overlay & 0xFFFF);
        if (model.vao == null) {
            model.brightness = brightness;
            float b = (float)(particle.color & 0xFF) / 255.0f;
            float g = (float)(particle.color >> 8 & 0xFF) / 255.0f;
            float r = (float)(particle.color >> 16 & 0xFF) / 255.0f;
            net.diebuddies.opengl.Mesh openglMesh = new net.diebuddies.opengl.Mesh();
            this.checkArrays(mesh.indices.size());
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 0.0f;
            float maxV = 1.0f;
            if (model.texture != null) {
                minU = model.texture.m_118409_();
                maxU = model.texture.m_118410_();
                minV = model.texture.m_118411_();
                maxV = model.texture.m_118412_();
            }
            for (int i = 0; i < mesh.indices.size(); ++i) {
                Vector3i index = mesh.indices.get(i);
                Vector3d p = mesh.positions.get(index.x - 1);
                Vector2d uv = mesh.uvs.get(index.y - 1);
                Vector3d normal = mesh.normals.get(index.z - 1);
                if (mesh.colors.size() > 0) {
                    Vector3f color = mesh.colors.get(index.x - 1);
                    r = color.x;
                    g = color.y;
                    b = color.z;
                }
                if (mesh.light.size() > 0) {
                    Vector2i light = mesh.light.get(index.x - 1);
                    this.mlight[i * 2] = (short)light.x;
                    this.mlight[i * 2 + 1] = (short)light.y;
                } else {
                    this.mlight[i * 2] = (short)k;
                    this.mlight[i * 2 + 1] = (short)j;
                }
                this.mpos[i * 3] = (float)p.x;
                this.mpos[i * 3 + 1] = (float)p.y;
                this.mpos[i * 3 + 2] = (float)p.z;
                this.mcol[i * 4] = (byte)(r * 255.0f);
                this.mcol[i * 4 + 1] = (byte)(g * 255.0f);
                this.mcol[i * 4 + 2] = (byte)(b * 255.0f);
                this.mcol[i * 4 + 3] = -1;
                this.muv[i * 2] = Math.remap((float)uv.x, 0.0f, 1.0f, minU, maxU);
                this.muv[i * 2 + 1] = Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV);
                this.moverlay[i * 2] = overlayX;
                this.moverlay[i * 2 + 1] = overlayY;
                if (shade) {
                    this.mnormals[i * 3] = BufferVertexConsumer.m_85774_((float)((float)normal.x));
                    this.mnormals[i * 3 + 1] = BufferVertexConsumer.m_85774_((float)((float)normal.y));
                    this.mnormals[i * 3 + 2] = BufferVertexConsumer.m_85774_((float)((float)normal.z));
                } else {
                    this.mnormals[i * 3] = BufferVertexConsumer.m_85774_((float)0.0f);
                    this.mnormals[i * 3 + 1] = BufferVertexConsumer.m_85774_((float)1.0f);
                    this.mnormals[i * 3 + 2] = BufferVertexConsumer.m_85774_((float)0.0f);
                }
                this.mindices[i] = i;
            }
            openglMesh.set(this.mpos, Data.POSITION);
            openglMesh.set(this.mcol, Data.COLOR);
            openglMesh.set(this.muv, Data.TEX_COORD);
            openglMesh.set(this.moverlay, Data.OVERLAY);
            openglMesh.set(this.mlight, Data.LIGHT);
            openglMesh.set(this.mnormals, Data.NORMAL);
            openglMesh.set(this.mindices, Data.INDEX);
            openglMesh.setSize(Data.POSITION, mesh.indices.size() * 3);
            openglMesh.setSize(Data.COLOR, mesh.indices.size() * 4);
            openglMesh.setSize(Data.TEX_COORD, mesh.indices.size() * 2);
            openglMesh.setSize(Data.OVERLAY, mesh.indices.size() * 2);
            openglMesh.setSize(Data.LIGHT, mesh.indices.size() * 2);
            openglMesh.setSize(Data.NORMAL, mesh.indices.size() * 3);
            openglMesh.setSize(Data.INDEX, mesh.indices.size());
            model.vao = openglMesh.constructVAO(Usage.DYNAMIC);
        }
        if (brightness != model.brightness && mesh.light.size() == 0) {
            model.brightness = brightness;
            this.checkArrays(mesh.indices.size());
            for (int i = 0; i < mesh.indices.size(); ++i) {
                this.mlight[i * 2] = (short)k;
                this.mlight[i * 2 + 1] = (short)j;
            }
            model.vao.bind();
            model.vao.updateAttribute(Data.LIGHT, this.mlight, mesh.indices.size() * 2);
        }
        ShaderInstance shader = RenderSystem.m_157196_();
        shader.f_173308_.m_5679_(RenderSystem.m_157190_());
        RenderSystem.m_157461_((ShaderInstance)shader);
        if (shader.f_173313_ != null) {
            shader.f_173313_.m_85633_();
        }
        if (shader.f_173314_ != null) {
            shader.f_173314_.m_85633_();
        }
        shader.f_173308_.m_85633_();
        model.vao.render();
    }

    @Unique
    private void checkArrays(int neededSize) {
        if (neededSize > this.size) {
            this.size *= 2;
            this.mpos = new float[this.size * 3];
            this.mcol = new byte[this.size * 4];
            this.muv = new float[this.size * 2];
            this.moverlay = new short[this.size * 2];
            this.mlight = new short[this.size * 2];
            this.mnormals = new byte[this.size * 3];
            this.mindices = new int[this.size];
        }
    }

    @Unique
    private void renderLegacy(Level level, PhysicsEntity particle, Model model, BlockPos.MutableBlockPos blockPos) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
        int brightness = particle.getLight(level, blockPos);
        Mesh mesh = model.mesh;
        boolean shade = particle.shade;
        int j = brightness >> 16 & 0xFFFF;
        int k = brightness & 0xFFFF;
        float b = (float)(particle.color & 0xFF) / 255.0f;
        float g = (float)(particle.color >> 8 & 0xFF) / 255.0f;
        float r = (float)(particle.color >> 16 & 0xFF) / 255.0f;
        for (Vector3i index : mesh.indices) {
            Vector3d position = mesh.positions.get(index.x - 1);
            Vector2d uv = mesh.uvs.get(index.y - 1);
            Vector3d normal = mesh.normals.get(index.z - 1);
            if (mesh.colors.size() > 0) {
                Vector3f color = mesh.colors.get(index.x - 1);
                r = color.x;
                g = color.y;
                b = color.z;
            }
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 0.0f;
            float maxV = 1.0f;
            if (model.texture != null) {
                minU = model.texture.m_118409_();
                maxU = model.texture.m_118410_();
                minV = model.texture.m_118411_();
                maxV = model.texture.m_118412_();
            }
            if (shade) {
                bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, r, g, b, 1.0f, Math.remap((float)uv.x, 0.0f, 1.0f, minU, maxU), Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV), model.overlay, k | j << 16, (float)normal.x, (float)normal.y, (float)normal.z);
                continue;
            }
            bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, r, g, b, 1.0f, Math.remap((float)uv.x, 0.0f, 1.0f, minU, maxU), Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV), model.overlay, k | j << 16, 0.0f, 1.0f, 0.0f);
        }
        tessellator.m_85914_();
    }

    @Unique
    private void debugRenderBox(float width, float height, float depth, float r, float g, float b, float a) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        float[] positions = new float[]{-0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f};
        int[] indices = new int[]{0, 1, 2, 0, 2, 3, 6, 5, 4, 7, 6, 4, 10, 9, 8, 11, 10, 8, 12, 13, 14, 12, 14, 15, 18, 17, 16, 19, 18, 16, 20, 21, 22, 20, 22, 23};
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i] * 3;
            bufferbuilder.m_5483_((double)(positions[index] * width), (double)(positions[index + 1] * height), (double)(positions[index + 2] * depth)).m_85950_(r, g, b, a).m_5752_();
        }
        tessellator.m_85914_();
    }

    @Unique
    private void setupShader(ShaderInstance shader) {
        for (int n = 0; n < 8; ++n) {
            int o = RenderSystem.m_157203_((int)n);
            shader.m_173350_("Sampler" + n, (Object)o);
        }
        if (shader.f_173308_ != null) {
            shader.f_173308_.m_5679_(RenderSystem.m_157190_());
        }
        if (shader.f_173309_ != null) {
            shader.f_173309_.m_5679_(RenderSystem.m_157192_());
        }
        if (shader.f_173312_ != null) {
            shader.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shader.f_173315_ != null) {
            shader.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shader.f_173316_ != null) {
            shader.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shader.f_173317_ != null) {
            shader.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shader.f_173310_ != null) {
            shader.f_173310_.m_5679_(RenderSystem.m_157207_());
        }
        if (shader.f_173319_ != null) {
            shader.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
        if (shader.f_173311_ != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            shader.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        RenderSystem.m_157461_((ShaderInstance)shader);
        shader.m_173363_();
    }

    @Unique
    private List<PhysicsEntity> getBlockData(BlockUpdate update, Level level) {
        ObjectArrayList particles = new ObjectArrayList();
        BlockPos pos = update.pos;
        BlockState state = update.state;
        ModelResourceLocation id = BlockModelShaper.m_110895_((BlockState)state);
        BakedModel bakedModel = Minecraft.m_91087_().m_91304_().m_119422_(id);
        if (state.m_60734_() == Blocks.f_50180_ || state.m_60734_() == Blocks.f_50181_ || state.m_60734_() == Blocks.f_50182_) {
            bakedModel = null;
        }
        if (bakedModel instanceof MultiPartBakedModel) {
            MultiPartBakedModel multi = (MultiPartBakedModel)bakedModel;
            BitSet bitSet = (BitSet)multi.f_119460_.get(state);
            if (bitSet == null) {
                bitSet = new BitSet();
                for (int i = 0; i < multi.f_119459_.size(); ++i) {
                    Pair pair = (Pair)multi.f_119459_.get(i);
                    if (!((Predicate)pair.getLeft()).test(state)) continue;
                    bitSet.set(i);
                }
                multi.f_119460_.put(state, bitSet);
            }
            for (int j = 0; j < bitSet.length(); ++j) {
                BakedModel model;
                JsonUnbakedModelHolder unbakedModel;
                if (!bitSet.get(j) || (unbakedModel = PhysicsMod.loadedModels.get(model = (BakedModel)((Pair)multi.f_119459_.get(j)).getRight())) == null || !(unbakedModel.model instanceof BlockModel)) continue;
                this.addParticles((List<PhysicsEntity>)particles, unbakedModel, level, update);
            }
        } else {
            JsonUnbakedModelHolder unbakedModel = PhysicsMod.loadedModels.get(bakedModel);
            if (unbakedModel != null && unbakedModel.model instanceof BlockModel) {
                this.addParticles((List<PhysicsEntity>)particles, unbakedModel, level, update);
            } else {
                PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.BLOCK);
                Minecraft minecraft = Minecraft.m_91087_();
                BlockRenderDispatcher ren = minecraft.m_91289_();
                BakedModel model = ren.m_110910_(state);
                particle.setTransformation(new Matrix4d().translate((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
                particle.setOldTransformation(new Matrix4d().translate((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
                particle.models.get((int)0).texture = model.m_6160_();
                particle.models.get((int)0).textureIDs = new int[]{model.m_6160_().m_118414_().m_117963_()};
                int color = Minecraft.m_91087_().m_91298_().m_92577_(update.state, (BlockAndTintGetter)level, update.pos, 0);
                if (color == -1) {
                    color = -1;
                }
                particle.color = color;
                if (update.state.m_60734_() == Blocks.f_50256_ || update.state.m_60734_() == Blocks.f_50440_) {
                    particle.color = -1;
                }
                particles.add(particle);
            }
        }
        return particles;
    }

    @Unique
    private void addParticles(List<PhysicsEntity> particles, JsonUnbakedModelHolder unbakedModel, Level level, BlockUpdate update) {
        BlockState state = update.state;
        BlockPos pos = update.pos;
        for (BlockElement element : unbakedModel.model.m_111436_()) {
            PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.BLOCK);
            particle.min.set(element.f_111308_.m_122239_() / 16.0f, element.f_111308_.m_122260_() / 16.0f, element.f_111308_.m_122269_() / 16.0f);
            particle.max.set(element.f_111309_.m_122239_() / 16.0f, element.f_111309_.m_122260_() / 16.0f, element.f_111309_.m_122269_() / 16.0f);
            particle.shade = element.f_111312_;
            Minecraft minecraft = Minecraft.m_91087_();
            BlockRenderDispatcher ren = minecraft.m_91289_();
            BakedModel model = ren.m_110910_(state);
            Matrix4f m = unbakedModel.transformation;
            Matrix4d transformation = new Matrix4d();
            StarterClient.setMatrix(transformation, m);
            particle.setTransformation(new Matrix4d().translate((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5).mul(transformation));
            particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
            particle.models.get((int)0).texture = model.m_6160_();
            particle.models.get((int)0).textureIDs = new int[]{model.m_6160_().m_118414_().m_117963_()};
            int color = Minecraft.m_91087_().m_91298_().m_92577_(update.state, (BlockAndTintGetter)level, update.pos, 0);
            if (color == -1) {
                color = -1;
            }
            particle.color = color;
            if (update.state.m_60734_() == Blocks.f_50256_ || update.state.m_60734_() == Blocks.f_50440_) {
                particle.color = -1;
            }
            particles.add(particle);
        }
    }
}

