/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.capes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.diebuddies.bridge.ReflectionsForge;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public class MixinCapeFeatureRenderer {
    @Unique
    private Map<String, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private AbstractClientPlayer player;
    @Unique
    private float tickDelta;
    @Unique
    private float animationProgress;
    @Unique
    private boolean renderedCape;
    @Unique
    private MultiBufferSource multiBufferSource;

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void renderHead(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        this.player = player;
        this.tickDelta = tickDelta;
        this.animationProgress = animationProgress;
        this.renderedCape = false;
        this.multiBufferSource = multiBufferSource;
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    public void renderTail(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    public void renderCloak(PlayerModel playerModel, PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay) {
        ((PlayerModel)((CapeLayer)this).m_117386_()).m_103411_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_);
        this.renderedCape = true;
    }

    private boolean shouldRenderPhysicsCape(AbstractClientPlayer player) {
        return !PhysicsMod.hudRendering && ConfigClient.clothPhysics && player.m_108555_() && !player.m_20145_() && player.m_36170_(PlayerModelPart.CAPE) && (player.m_108561_() != null || Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_36316_().getName().equals(player.m_36316_().getName()) && ConfigClient.physicsModCape);
    }

    private void renderPhysicsCape(AbstractClientPlayer player, int light) {
    }

    private int getCapeTexture(AbstractClientPlayer player) {
        if (this.isMojangCape(player)) {
            return Minecraft.m_91087_().m_91097_().m_118506_(player.m_108561_()).m_117963_();
        }
        return PhysicsMod.capeTexture.getID();
    }

    private ColladaMesh getCapeMesh(AbstractClientPlayer player) {
        if (this.isMojangCape(player)) {
            return PhysicsMod.defaultCapeMesh;
        }
        return PhysicsMod.capeMesh;
    }

    public boolean isMojangCape(AbstractClientPlayer player) {
        return player.m_108561_() != null && (!ConfigClient.physicsModCape || Minecraft.m_91087_().f_91074_ != player);
    }

    @Unique
    private void doCapeTransformation(PoseStack modelMatrix, AbstractClientPlayer player, float tickDelta) {
        double d = Mth.m_14139_((double)tickDelta, (double)player.f_36102_, (double)player.f_36105_) - Mth.m_14139_((double)tickDelta, (double)player.f_19854_, (double)player.m_20185_());
        double e = Mth.m_14139_((double)tickDelta, (double)player.f_36103_, (double)player.f_36106_) - Mth.m_14139_((double)tickDelta, (double)player.f_19855_, (double)player.m_20186_());
        double m = Mth.m_14139_((double)tickDelta, (double)player.f_36104_, (double)player.f_36075_) - Mth.m_14139_((double)tickDelta, (double)player.f_19856_, (double)player.m_20189_());
        float n = player.f_20884_ + (player.f_20883_ - player.f_20884_);
        double o = Mth.m_14031_((float)(n * ((float)java.lang.Math.PI / 180)));
        double p = -Mth.m_14089_((float)(n * ((float)java.lang.Math.PI / 180)));
        float q = (float)e * 10.0f;
        q = Mth.m_14036_((float)q, (float)-6.0f, (float)32.0f);
        float r = (float)(d * o + m * p) * 100.0f;
        r = Mth.m_14036_((float)r, (float)0.0f, (float)150.0f);
        float s = (float)(d * p - m * o) * 100.0f;
        s = Mth.m_14036_((float)s, (float)-20.0f, (float)20.0f);
        if (r < 0.0f) {
            r = 0.0f;
        }
        float t = Mth.m_14179_((float)tickDelta, (float)player.f_36099_, (float)player.f_36100_);
        q += Mth.m_14031_((float)(Mth.m_14179_((float)tickDelta, (float)player.f_19867_, (float)player.f_19787_) * 6.0f)) * 32.0f * t;
        if (player.m_6047_()) {
            q += 25.0f;
        }
        modelMatrix.m_85837_(0.0, 0.0, 0.125);
        modelMatrix.m_85845_(Vector3f.f_122223_.m_122240_(6.0f + r / 2.0f + q));
        modelMatrix.m_85845_(Vector3f.f_122227_.m_122240_(s / 2.0f));
        modelMatrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - s / 2.0f));
        PlayerModel entityModel = (PlayerModel)((CapeLayer)this).m_117386_();
        entityModel.f_103373_.m_104299_(modelMatrix);
    }

    @Unique
    private void playerCollisionDetection(PoseStack modelMatrix, VerletSimulation simulation, AbstractClientPlayer player, float tickDelta, float animationProgress) {
        Direction direction;
        LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
        float enlarge = 0.075f;
        double px = Mth.m_14139_((double)tickDelta, (double)player.f_19790_, (double)player.m_20185_());
        double py = Mth.m_14139_((double)tickDelta, (double)player.f_19791_, (double)player.m_20186_());
        double pz = Mth.m_14139_((double)tickDelta, (double)player.f_19792_, (double)player.m_20189_());
        if (simulation != null) {
            px -= simulation.getOffset().x;
            py -= simulation.getOffset().y;
            pz -= simulation.getOffset().z;
        }
        modelMatrix.m_85837_(px, py, pz);
        Vec3 positionOffset = renderer.m_7860_((Entity)player, tickDelta);
        modelMatrix.m_85837_(positionOffset.f_82479_, positionOffset.f_82480_, positionOffset.f_82481_);
        float yaw = Mth.m_14189_((float)tickDelta, (float)player.f_20884_, (float)player.f_20883_);
        if (player.m_20089_() == Pose.SLEEPING && (direction = player.m_21259_()) != null) {
            float eyeHeight = player.m_20236_(Pose.STANDING) - 0.1f;
            modelMatrix.m_85837_((double)((float)(-direction.m_122429_()) * eyeHeight), 0.0, (double)((float)(-direction.m_122431_()) * eyeHeight));
        }
        try {
            ReflectionsForge.setupRotations.invoke((Object)renderer, player, modelMatrix, Float.valueOf(animationProgress), Float.valueOf(yaw), Float.valueOf(tickDelta));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        modelMatrix.m_85841_(-1.0f, -1.0f, 1.0f);
        modelMatrix.m_85841_(0.9375f, 0.9375f, 0.9375f);
        modelMatrix.m_85837_(0.0, (double)-1.501f, 0.0);
    }

    @Unique
    private void bufferVertex(VertexConsumer bufferbuilder, double renderPercent, Vector3d position, Vector3d prevPosition, Vector2f uv, Vector3d normal, int brightness, float r, float g, float b, float a) {
        bufferbuilder.m_5954_((float)Math.lerp(prevPosition.x, position.x, renderPercent), (float)Math.lerp(prevPosition.y, position.y, renderPercent), (float)Math.lerp(prevPosition.z, position.z, renderPercent), r, g, b, 1.0f, uv.x, uv.y, 0, brightness, (float)normal.x, (float)normal.y, (float)normal.z);
    }

    @Unique
    public Vector3d[] createBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        Vector3d[] box = new Vector3d[]{new Vector3d(minX, minY, minZ), new Vector3d(minX, minY, maxZ), new Vector3d(minX, maxY, minZ), new Vector3d(minX, maxY, maxZ), new Vector3d(maxX, minY, minZ), new Vector3d(maxX, minY, maxZ), new Vector3d(maxX, maxY, minZ), new Vector3d(maxX, maxY, maxZ)};
        return box;
    }
}

