/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.BitSet;
import java.util.List;
import net.diebuddies.compat.Sodium;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.VineRagdoll;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.LevelChunk;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class})
public class MixinClientChunkManager
implements VineLoader {
    @Shadow
    @Final
    volatile ClientChunkCache.Storage f_104410_;
    @Unique
    private Long2ObjectMap<List<VineRagdoll>> loadedVines = new Long2ObjectOpenHashMap();
    @Unique
    private PhysicsMod mod;
    @Unique
    private LongSet loadedChunksSodiumFix = new LongOpenHashSet();
    @Unique
    private int loadDistance;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void constructor(ClientLevel level, int loadDistance, CallbackInfo info) {
        this.loadDistance = loadDistance;
    }

    @Override
    public void chunkPosChanged() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        ObjectOpenHashSet affectedChunks = new ObjectOpenHashSet();
        while (it.hasNext()) {
            boolean shouldBeLoaded;
            long chunkIndex = it.nextLong();
            int chunkX = this.getChunkX(chunkIndex);
            int chunkZ = this.getChunkZ(chunkIndex);
            boolean isLoaded = this.loadedVines.containsKey(chunkIndex);
            if (isLoaded == (shouldBeLoaded = VineHelper.isChunkInRange(chunkX, chunkZ))) continue;
            if (isLoaded) {
                this.unloadChunk(chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks, StarterClient.sodium || StarterClient.optifabric);
            } else {
                this.loadChunk(((ClientChunkCache)this).m_62227_(chunkX, chunkZ, false), chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks);
            }
            for (Vector3i affectedChunk : affectedChunks) {
                if (StarterClient.sodium) {
                    Sodium.scheduleChunkRebuild(Minecraft.m_91087_().f_91060_, affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
                    continue;
                }
                Minecraft.m_91087_().f_91060_.m_109501_(affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
            }
            affectedChunks.clear();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"updateViewRadius"})
    public void updateLoadDistance(int loadDistance, CallbackInfo info) {
        this.loadDistance = loadDistance;
        ObjectIterator it = this.loadedVines.long2ObjectEntrySet().iterator();
        while (it.hasNext()) {
            int chunkZ;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long chunkIndex = entry.getLongKey();
            List ragdolls = (List)entry.getValue();
            int chunkX = this.getChunkX(chunkIndex);
            if (this.isInRadius(loadDistance, chunkX, chunkZ = this.getChunkZ(chunkIndex))) continue;
            this.loadedChunksSodiumFix.remove(chunkIndex);
            if (this.mod != null) {
                this.unloadRagdolls(ragdolls, false);
            }
            it.remove();
        }
    }

    @Unique
    public boolean isInRadius(int radius, int chunkX, int chunkZ) {
        return Math.abs(chunkX - this.f_104410_.f_104469_) <= radius && Math.abs(chunkZ - this.f_104410_.f_104470_) <= radius;
    }

    @Inject(at={@At(value="HEAD")}, method={"drop"})
    public void drop(int chunkX, int chunkZ, CallbackInfo info) {
        long chunkIndex = this.calcChunkIndex(chunkX, chunkZ);
        this.loadedChunksSodiumFix.remove(chunkIndex);
        if (this.mod != null) {
            this.unloadChunk(chunkX, chunkZ);
        }
    }

    @Unique
    private void unloadChunk(int chunkX, int chunkZ) {
        this.unloadChunk(chunkX, chunkZ, null, false);
    }

    @Unique
    private void unloadChunk(int chunkX, int chunkZ, ObjectSet<Vector3i> affectedChunks, boolean removeOneFrameLater) {
        long chunkIndex = this.calcChunkIndex(chunkX, chunkZ);
        List ragdolls = (List)this.loadedVines.remove(chunkIndex);
        Level level = this.mod.getPhysicsWorld().getWorld();
        if (affectedChunks != null && ragdolls != null) {
            for (VineRagdoll ragdoll : ragdolls) {
                for (BlockPos pos : ragdoll.bodiesPos) {
                    affectedChunks.add((Object)new Vector3i(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)(pos.m_123342_() - level.m_141937_())), SectionPos.m_123171_((int)pos.m_123343_())));
                }
            }
        }
        this.unloadRagdolls(ragdolls, removeOneFrameLater);
    }

    @Unique
    private void unloadRagdolls(List<VineRagdoll> ragdolls, boolean removeOneFrameLater) {
        if (ragdolls != null) {
            for (VineRagdoll ragdoll : ragdolls) {
                if (removeOneFrameLater) {
                    this.mod.sodiumRemoveRagdolls.add(ragdoll);
                    continue;
                }
                this.mod.physicsWorld.removeRagdoll(ragdoll);
                ragdoll.destroy();
            }
        }
    }

    @Override
    public void unloadAllRagdolls() {
        for (List ragdolls : this.loadedVines.values()) {
            this.unloadRagdolls(ragdolls, false);
        }
        this.loadedVines.clear();
    }

    @Override
    public void loadAllRagdolls() {
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            int chunkZ;
            long chunkIndex = it.nextLong();
            int chunkX = this.getChunkX(chunkIndex);
            if (!VineHelper.isChunkInRange(chunkX, chunkZ = this.getChunkZ(chunkIndex))) continue;
            this.loadChunk(((ClientChunkCache)this).m_7587_(chunkX, chunkZ, null, false), chunkX, chunkZ);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"replaceWithPacketData"})
    public void replaceWithPacketData(int x, int z, ChunkBiomeContainer biomes, FriendlyByteBuf buf, CompoundTag nbt, BitSet bitSet, CallbackInfoReturnable<LevelChunk> info) {
        LevelChunk chunk = (LevelChunk)info.getReturnValue();
        long chunkIndex = this.calcChunkIndex(x, z);
        this.loadedChunksSodiumFix.add(chunkIndex);
        if (VineHelper.isChunkInRange(x, z) && this.mod != null) {
            this.loadChunk(chunk, x, z);
        }
    }

    @Unique
    private void loadChunk(LevelChunk chunk, int x, int z) {
        this.loadChunk(chunk, x, z, null);
    }

    @Unique
    private void loadChunk(LevelChunk chunk, int x, int z, ObjectSet<Vector3i> affectedChunks) {
        long chunkIndex = this.calcChunkIndex(x, z);
    }

    @Override
    public void addVineRagdoll(VineRagdoll ragdoll, BlockPos pos) {
        long chunkIndex = this.calcChunkIndex(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
        List ragdolls = (List)this.loadedVines.get(chunkIndex);
        if (ragdolls == null) {
            ragdolls = new ObjectArrayList();
            this.loadedVines.put(chunkIndex, (Object)ragdolls);
        }
        ragdolls.add(ragdoll);
    }

    @Unique
    private long calcChunkIndex(int chunkX, int chunkZ) {
        return ((long)chunkX & 0xFFFFFFFFL) << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    @Unique
    private int getChunkX(long index) {
        return (int)(index >> 32) & 0xFFFFFFFF;
    }

    @Unique
    private int getChunkZ(long index) {
        return (int)index & 0xFFFFFFFF;
    }

    @Unique
    private static long calcIndex(int x, int y, int z) {
        return (long)x << 60 | (long)z << 56 | (long)y & 0xFFFFFFFFL;
    }

    @Unique
    private List<VineRagdoll> searchConnections(int chunkX, int chunkZ, Long2ObjectMap<BlockState> vines) {
        ObjectArrayList ragdolls = new ObjectArrayList();
        while (vines.size() > 0) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)vines.long2ObjectEntrySet().iterator().next();
            long index = entry.getLongKey();
            BlockState current = (BlockState)entry.getValue();
            int x = (int)(index >> 60) & 0xF;
            int y = (int)(index & 0xFFFFFFFFFFFFFFL);
            int z = (int)(index >> 56) & 0xF;
            VineRagdoll ragdoll = new VineRagdoll();
            ragdoll.bottomFixed = !VineHelper.topFixed(current);
            ragdoll.hookedEntity = this.addRagdoll(this.mod, ragdoll, current, y, x + chunkX * 16, y, z + chunkZ * 16);
            ragdoll.stiffness = VineHelper.getStiffness(current);
            ragdoll.damping = VineHelper.getDamping(current);
            int count = 1;
            long indexNext = MixinClientChunkManager.calcIndex(x, y + count, z);
            BlockState state = null;
            while ((state = (BlockState)vines.get(indexNext)) != null && VineHelper.canLink(state, current)) {
                PhysicsEntity vineEntity = this.addRagdoll(this.mod, ragdoll, state, y, x + chunkX * 16, y + count, z + chunkZ * 16);
                if (!ragdoll.bottomFixed) {
                    ragdoll.hookedEntity = vineEntity;
                }
                ragdoll.addConnection(ragdoll.bodies.size() - 2, ragdoll.bodies.size() - 1);
                vines.remove(indexNext);
                indexNext = MixinClientChunkManager.calcIndex(x, y + ++count, z);
            }
            count = 1;
            indexNext = MixinClientChunkManager.calcIndex(x, y - count, z);
            ragdoll.hookedEntity.noCollision = true;
            Vector3d offset = ragdoll.hookedEntity.models.get((int)0).mesh.offset;
            ragdoll.hook = new Vector3d(0.0, (ragdoll.bottomFixed ? -1.0 : 1.0) * (1.0 - offset.y % 1.0), 0.0);
            ragdoll.setAlwaysInWater(VineHelper.applyWaterPhysics(current));
            vines.remove(index);
            ragdolls.add(ragdoll);
        }
        return ragdolls;
    }

    private PhysicsEntity addRagdoll(PhysicsMod mod, VineRagdoll ragdoll, BlockState state, int baseY, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        PhysicsEntity entity = mod.renderBlockIntoEntity(PhysicsEntity.Type.VINE, state, pos);
        int baseOffset = y - baseY;
        Vector3d offset = entity.models.get((int)0).mesh.offset;
        offset.y += (double)baseOffset;
        entity.getTransformation().translate(0.0, -baseOffset, 0.0);
        entity.getOldTransformation().translate(0.0, -baseOffset, 0.0);
        entity.pivot = new Vector3d(offset.x, (double)baseOffset + 1.0, offset.z);
        ragdoll.bodies.add(entity);
        ragdoll.bodiesPos.add(pos);
        ragdoll.bodiesState.add(state);
        return mod.itemStackEntity;
    }

    @Override
    public void setPhysicsMod(PhysicsMod physicsMod) {
        if (this.mod != null) {
            if (this.mod != physicsMod) {
                this.unloadAllRagdolls();
                this.mod = physicsMod;
                if (physicsMod != null) {
                    this.loadAllRagdolls();
                }
            }
        } else {
            this.mod = physicsMod;
            if (physicsMod != null) {
                this.loadAllRagdolls();
            }
        }
    }
}

