/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.model.XmlNode;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class ColladaMesh {
    public XmlNode geometry;
    public List<Vector3f> positions;
    public List<Vector3f> normals;
    public List<Vector2f> texCoords;
    public List<Vector3f> colors;
    public List<Vector4i> indices;
    public byte[] polyCount;

    public ColladaMesh(XmlNode geometryNode) {
        this.geometry = geometryNode;
    }

    public void parseMeshes() {
        for (XmlNode geometry : this.geometry.getChildren("geometry")) {
            XmlNode mesh = geometry.getChild("mesh");
            this.parseMesh(mesh);
        }
    }

    private void parseMesh(XmlNode meshNode) {
        this.parsePositions(meshNode);
        this.parseNormals(meshNode);
        this.parseTextureCoordinates(meshNode);
        this.parseColors(meshNode);
        this.parseIndices(meshNode);
    }

    private void parsePositions(XmlNode mesh) {
        String id = mesh.getChild("vertices").getChild("input").getAttribute("source").substring(1);
        XmlNode source = mesh.getChildWithAttribute("source", "id", id);
        XmlNode floatArray = source.getChild("float_array");
        this.positions = new ObjectArrayList();
        String[] data = floatArray.getData().split(" ");
        for (int i = 0; i < data.length / 3; ++i) {
            this.positions.add(new Vector3f(Float.parseFloat(data[i * 3]), Float.parseFloat(data[i * 3 + 1]), Float.parseFloat(data[i * 3 + 2])));
        }
    }

    private void parseIndices(XmlNode mesh) {
        int i;
        boolean onlyTriangles = false;
        XmlNode triangles = mesh.getChild("polylist");
        if (triangles == null) {
            triangles = mesh.getChild("triangles");
            onlyTriangles = true;
        }
        XmlNode indicesArray = triangles.getChild("p");
        int vertexOffset = Integer.parseInt(triangles.getChildWithAttribute("input", "semantic", "VERTEX").getAttribute("offset"));
        int normalOffset = Integer.parseInt(triangles.getChildWithAttribute("input", "semantic", "NORMAL").getAttribute("offset"));
        int texCoordOffset = Integer.parseInt(triangles.getChildWithAttribute("input", "semantic", "TEXCOORD").getAttribute("offset"));
        int colorOffset = Integer.parseInt(triangles.getChildWithAttribute("input", "semantic", "COLOR").getAttribute("offset"));
        this.indices = new ObjectArrayList();
        String[] data = indicesArray.getData().split(" ");
        if (onlyTriangles) {
            for (i = 0; i < this.polyCount.length; ++i) {
                this.polyCount[i] = 3;
            }
        } else {
            String[] vcountData = triangles.getChild("vcount").getData().split(" ");
            this.polyCount = new byte[vcountData.length];
            for (int i2 = 0; i2 < vcountData.length; ++i2) {
                this.polyCount[i2] = Byte.parseByte(vcountData[i2]);
            }
        }
        for (i = 0; i < data.length / 4; ++i) {
            int[] indices = new int[]{Integer.parseInt(data[i * 4]), Integer.parseInt(data[i * 4 + 1]), Integer.parseInt(data[i * 4 + 2]), Integer.parseInt(data[i * 4 + 3])};
            this.indices.add(new Vector4i(indices[vertexOffset], indices[normalOffset], indices[texCoordOffset], indices[colorOffset]));
        }
    }

    private void parseNormals(XmlNode mesh) {
        XmlNode triangles = mesh.getChild("polylist");
        if (triangles == null) {
            triangles = mesh.getChild("triangles");
        }
        String id = triangles.getChildWithAttribute("input", "semantic", "NORMAL").getAttribute("source").substring(1);
        XmlNode source = mesh.getChildWithAttribute("source", "id", id);
        XmlNode floatArray = source.getChild("float_array");
        this.normals = new ObjectArrayList();
        String[] data = floatArray.getData().split(" ");
        for (int i = 0; i < data.length / 3; ++i) {
            this.normals.add(new Vector3f(Float.parseFloat(data[i * 3]), Float.parseFloat(data[i * 3 + 1]), Float.parseFloat(data[i * 3 + 2])));
        }
    }

    private void parseTextureCoordinates(XmlNode mesh) {
        XmlNode texCoordNode;
        XmlNode triangles = mesh.getChild("polylist");
        if (triangles == null) {
            triangles = mesh.getChild("triangles");
        }
        if ((texCoordNode = triangles.getChildWithAttribute("input", "semantic", "TEXCOORD")) == null) {
            return;
        }
        String id = texCoordNode.getAttribute("source").substring(1);
        XmlNode source = mesh.getChildWithAttribute("source", "id", id);
        XmlNode floatArray = source.getChild("float_array");
        this.texCoords = new ObjectArrayList();
        String[] data = floatArray.getData().split(" ");
        for (int i = 0; i < data.length / 2; ++i) {
            this.texCoords.add(new Vector2f(Float.parseFloat(data[i * 2]), Float.parseFloat(data[i * 2 + 1])));
        }
    }

    private void parseColors(XmlNode mesh) {
        XmlNode color;
        XmlNode triangles = mesh.getChild("polylist");
        if (triangles == null) {
            triangles = mesh.getChild("triangles");
        }
        if ((color = triangles.getChildWithAttribute("input", "semantic", "COLOR")) == null) {
            return;
        }
        String id = color.getAttribute("source").substring(1);
        XmlNode source = mesh.getChildWithAttribute("source", "id", id);
        XmlNode floatArray = source.getChild("float_array");
        int stride = Integer.parseInt(source.getChild("technique_common").getChild("accessor").getAttribute("stride"));
        this.colors = new ObjectArrayList();
        String[] data = floatArray.getData().split(" ");
        for (int i = 0; i < data.length / stride; ++i) {
            this.colors.add(new Vector3f(Float.parseFloat(data[i * stride]), Float.parseFloat(data[i * stride + 1]), Float.parseFloat(data[i * stride + 2])));
        }
    }
}

