/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import net.diebuddies.math.Vector3i;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxActorFlagEnum;
import physx.physics.PxActorFlags;
import physx.physics.PxArticulationLink;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;
import physx.physics.PxShape;

public abstract class IRigidBody {
    protected PxShape shape;
    protected PxRigidActor rigidBody;
    protected PhysicsEntity entity;
    protected Object userData;
    protected Matrix4d offset;
    protected boolean destroyed = false;
    protected Quaterniond tmpQuat = new Quaterniond();
    public boolean isInWater;
    public boolean isRagdoll;
    private float mass;
    private boolean wasSleeping = false;
    private boolean isSleeping = false;
    private boolean kinematic;
    private boolean frozen;
    private boolean gravity = true;
    private BlockPos.MutableBlockPos blockPos;
    private BlockState blockState;
    private float fluidHeight;
    private Vector3d fluidVelocity;
    private float angularDamping;
    private float linearDamping;
    private Vector3i lastChunk;
    private PhysicsWorld physics;
    private BlockPos.MutableBlockPos tmpPos;

    public IRigidBody() {
        this.offset = new Matrix4d();
        this.blockPos = new BlockPos.MutableBlockPos();
        this.tmpPos = new BlockPos.MutableBlockPos();
        this.fluidVelocity = new Vector3d();
    }

    public void destroy() {
        if (!this.destroyed) {
            if (this.entity != null) {
                this.entity.destroy();
            }
            if (this.shape != null) {
                this.shape.release();
            }
            if (this.rigidBody != null) {
                this.rigidBody.release();
            }
        }
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public PhysicsEntity getEntity() {
        return this.entity;
    }

    public Matrix4d getOffset() {
        return this.offset;
    }

    public Object getUserData() {
        return this.userData;
    }

    public PxShape getShape() {
        return this.shape;
    }

    public PxRigidActor getRigidBody() {
        return this.rigidBody;
    }

    public void updatePositions(PhysicsWorld physics, double diff, boolean blocksChanged) {
        this.physics = physics;
        this.isSleeping = false;
        if (this.rigidBody instanceof PxRigidDynamic) {
            this.isSleeping = ((PxRigidDynamic)this.rigidBody).isSleeping();
        }
        if (!this.wasSleeping || !this.isSleeping) {
            this.entity.getOldTransformation().set(this.entity.getTransformation());
            PxRigidActor rigidBody = this.getRigidBody();
            PxTransform transform = rigidBody.getGlobalPose();
            PxVec3 pos = transform.getP();
            PxQuat rot = transform.getQ();
            double yPos = (double)pos.getY() + physics.getOffset().y;
            if (yPos < (double)(physics.getWorld().m_141937_() - 10) && this.entity.time > 0.5) {
                this.entity.time = 0.5;
            }
            this.entity.getTransformation().translationRotate(pos.getX(), pos.getY(), pos.getZ(), this.tmpQuat.set(rot.getX(), rot.getY(), rot.getZ(), rot.getW()).normalize());
            Vector3d offset = physics.getOffset();
            this.tmpPos.m_122169_((double)pos.getX() + offset.x, (double)pos.getY() + offset.y, (double)pos.getZ() + offset.z);
            if (!(this.blockState != null && this.tmpPos.equals((Object)this.blockPos) || this.isKinematicOrFrozen())) {
                int cz;
                int cx = this.tmpPos.m_123341_() < 0 ? (int)((double)(this.tmpPos.m_123341_() + 1) / 4.0) - 1 : (int)((double)this.tmpPos.m_123341_() / 4.0);
                int cy = this.tmpPos.m_123342_() < 0 ? (int)((double)(this.tmpPos.m_123342_() + 1) / 4.0) - 1 : (int)((double)this.tmpPos.m_123342_() / 4.0);
                int n = cz = this.tmpPos.m_123343_() < 0 ? (int)((double)(this.tmpPos.m_123343_() + 1) / 4.0) - 1 : (int)((double)this.tmpPos.m_123343_() / 4.0);
                if (this.lastChunk == null || !this.lastChunk.equals(cx, cy, cz)) {
                    if (this.lastChunk == null) {
                        this.lastChunk = new Vector3i(cx, cy, cz);
                    } else {
                        physics.removeLoadedChunkEntity(this.lastChunk);
                        this.lastChunk.set(cx, cy, cz);
                    }
                    physics.addLoadedChunkEntity(this.lastChunk);
                }
            }
            if (this.blockState == null || !this.tmpPos.equals((Object)this.blockPos) || blocksChanged) {
                BlockPos.MutableBlockPos tmp = this.blockPos;
                this.blockPos = this.tmpPos;
                this.tmpPos = tmp;
                this.blockState = physics.getWorld().m_8055_((BlockPos)this.blockPos);
                if (!(this.blockState.m_60819_().m_76152_() instanceof EmptyFluid)) {
                    this.fluidHeight = this.blockState.m_60819_().m_76182_();
                    if (this.blockState.m_60819_().m_76152_().m_6212_(physics.getWorld().m_6425_((BlockPos)this.tmpPos.m_122190_((Vec3i)this.blockPos).m_122184_(0, 1, 0)).m_76152_())) {
                        this.fluidHeight = 1.0f;
                    }
                    Vec3 fv = this.blockState.m_60819_().m_76179_((BlockGetter)physics.getWorld(), (BlockPos)this.blockPos);
                    this.fluidVelocity.set(fv.m_7096_(), fv.m_7098_(), fv.m_7094_());
                    boolean bubble = false;
                    if (this.blockState.m_60734_() == Blocks.f_50628_) {
                        bubble = true;
                        boolean drag = (Boolean)this.blockState.m_61143_((Property)BubbleColumnBlock.f_50956_);
                        this.fluidVelocity.y = drag ? -2.0 : 8.0;
                    }
                    this.fluidVelocity.y = bubble ? this.fluidVelocity.y : Math.max(this.fluidVelocity.y, 0.0);
                } else {
                    this.fluidHeight = -1.0f;
                }
            }
        }
        this.wasSleeping = this.isSleeping;
        float height = this.getFluidHeight();
        if (height >= 0.0f && (this.getEntity().getTransformation().m31() + physics.getOffset().y) % 1.0 < (double)height && this.getRigidBody() instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)this.getRigidBody();
            this.setGravity(false);
            float mass = this.getMass();
            float flowStrength = 4.6f;
            this.setAngularDamping(2.355f);
            this.setLinearDamping(2.355f);
            try (MemoryStack mem = physics.getLocalStack().push();){
                Vector3d direction = this.getFluidVelocity();
                Vector3f buoyancy = physics.getDynamicsWorld().getBuoyancy();
                if (rigidBody instanceof PxArticulationLink) {
                    PxVec3 v = rigidBody.getLinearVelocity();
                    PxVec3 a = rigidBody.getAngularVelocity();
                    float damping = 0.885f;
                    float aDamping = 0.885f;
                    PxVec3 flowForce = PxVec3.createAt(mem, MemoryStack::nmalloc, -v.getX() * (1.0f - damping), -v.getY() * (1.0f - damping), -v.getZ() * (1.0f - damping));
                    rigidBody.addForce(flowForce, PxForceModeEnum.eVELOCITY_CHANGE);
                    PxVec3 angularForce = PxVec3.createAt(mem, MemoryStack::nmalloc, -a.getX() * (1.0f - aDamping), -a.getY() * (1.0f - aDamping), -a.getZ() * (1.0f - aDamping));
                    rigidBody.addTorque(angularForce, PxForceModeEnum.eVELOCITY_CHANGE);
                }
                PxVec3 counterForce = PxVec3.createAt(mem, MemoryStack::nmalloc, (buoyancy.x + (float)direction.x * flowStrength) * mass, (buoyancy.y + (float)direction.y * flowStrength) * mass, (buoyancy.z + (float)direction.z * flowStrength) * mass);
                rigidBody.addForce(counterForce, PxForceModeEnum.eFORCE);
            }
        } else {
            this.setGravity(true);
            this.setAngularDamping(0.0f);
            this.setLinearDamping(0.0f);
        }
    }

    public boolean hasTransformationChanged() {
        if (this.kinematic) {
            return false;
        }
        return !this.wasSleeping || !this.isSleeping;
    }

    public void setKinematic(boolean kinematic) {
        if (this.kinematic != kinematic) {
            if (this.rigidBody instanceof PxRigidDynamic) {
                ((PxRigidDynamic)this.rigidBody).setRigidBodyFlag(PxRigidBodyFlagEnum.eKINEMATIC, kinematic);
                if (!this.isKinematicOrFrozen() && this.physics != null && this.lastChunk != null && kinematic) {
                    this.physics.removeLoadedChunkEntity(this.lastChunk);
                    this.lastChunk = null;
                }
            }
            this.kinematic = kinematic;
        }
    }

    public boolean isKinematicOrFrozen() {
        return this.kinematic || this.frozen;
    }

    public void setFrozen(boolean frozen) {
        if (this.frozen != frozen) {
            PxActorFlags flags = this.rigidBody.getActorFlags();
            if (frozen) {
                flags.set(PxActorFlagEnum.eDISABLE_SIMULATION);
                if (!this.isKinematicOrFrozen() && this.physics != null && this.lastChunk != null) {
                    this.physics.removeLoadedChunkEntity(this.lastChunk);
                    this.lastChunk = null;
                }
            } else {
                flags.clear(PxActorFlagEnum.eDISABLE_SIMULATION);
            }
            this.rigidBody.setActorFlags(flags);
            this.frozen = frozen;
        }
    }

    public void setGravity(boolean gravity) {
        if (this.gravity != gravity) {
            PxActorFlags flags = this.rigidBody.getActorFlags();
            if (gravity) {
                flags.clear(PxActorFlagEnum.eDISABLE_GRAVITY);
            } else {
                flags.set(PxActorFlagEnum.eDISABLE_GRAVITY);
            }
            this.rigidBody.setActorFlags(flags);
            this.gravity = gravity;
        }
    }

    public void applyRandomSpawnForces() {
        if (this.getRigidBody() instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)this.getRigidBody();
            PxVec3 v = rigidBody.getLinearVelocity();
            float strength = 9.0f;
            v.setX((float)(Math.random() - 0.5) * strength);
            v.setY((float)(Math.random() - 0.5) * strength);
            v.setZ((float)(Math.random() - 0.5) * strength);
            rigidBody.setLinearVelocity(v);
        }
    }

    public boolean hasGravity() {
        return this.gravity;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public float getMass() {
        return this.mass;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public BlockPos.MutableBlockPos getBlockPos() {
        return this.blockPos;
    }

    public float getFluidHeight() {
        return this.fluidHeight;
    }

    public Vector3d getFluidVelocity() {
        return this.fluidVelocity;
    }

    public void setAngularDamping(float angularDamping) {
        if (this.angularDamping != angularDamping) {
            this.angularDamping = angularDamping;
            ((PxRigidBody)this.rigidBody).setAngularDamping(angularDamping);
        }
    }

    public void setLinearDamping(float linearDamping) {
        if (this.linearDamping != linearDamping) {
            this.linearDamping = linearDamping;
            ((PxRigidBody)this.rigidBody).setLinearDamping(linearDamping);
        }
    }

    public Vector3i getLastChunk() {
        return this.lastChunk;
    }
}

