/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.diebuddies.physics.Model;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4d;
import org.joml.Vector3d;

public class PhysicsEntity {
    private Matrix4d transformation;
    private Matrix4d oldTransformation;
    public List<Model> models = new ObjectArrayList();
    public Type type;
    public double time;
    public Vector3d min = new Vector3d(0.0);
    public Vector3d max = new Vector3d(1.0);
    public Vector3d pivot = new Vector3d();
    public double scale = 1.0;
    public int color = -1;
    public Vector3d scalePhysics = new Vector3d(1.0);
    public boolean stopCollision;
    public boolean noCollision;
    public boolean noVolume;
    public boolean backfaceCulling = true;
    public boolean staticPhysics = false;
    public boolean shade = true;
    public RenderLayer feature = null;
    public List<PhysicsEntity> children = new ArrayList<PhysicsEntity>();

    public PhysicsEntity(Type type) {
        this.transformation = new Matrix4d();
        this.oldTransformation = new Matrix4d();
        this.models.add(new Model());
        this.type = type;
    }

    public Matrix4d getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Matrix4d transformation) {
        this.transformation = transformation;
    }

    public void setOldTransformation(Matrix4d oldTransformation) {
        this.oldTransformation = oldTransformation;
    }

    public Matrix4d getOldTransformation() {
        return this.oldTransformation;
    }

    public double getBoundingSphereRadius() {
        double maxRadius = 0.0;
        for (Model model : this.models) {
            maxRadius = Math.max(maxRadius, model.mesh.getRadius());
        }
        return maxRadius * Math.max(this.scalePhysics.x, Math.max(this.scalePhysics.y, this.scalePhysics.z)) * this.scale * 1.2;
    }

    public void destroy() {
        this.destroyModels();
    }

    public void destroyModels() {
        for (Model model : this.models) {
            if (model.vao == null) continue;
            model.vao.destroy();
        }
    }

    public int getLight(Level level, BlockPos.MutableBlockPos blockPos) {
        BlockState bState = level.m_8055_((BlockPos)blockPos);
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        int brightness = 0;
        if (!bState.m_60815_()) {
            brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
        } else {
            bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y + 1, z));
            if (!bState.m_60815_()) {
                brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
            } else {
                bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y - 1, z));
                if (!bState.m_60815_()) {
                    brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                } else {
                    bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y, z - 1));
                    if (!bState.m_60815_()) {
                        brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                    } else {
                        bState = level.m_8055_((BlockPos)blockPos.m_122178_(x + 1, y, z));
                        if (!bState.m_60815_()) {
                            brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                        } else {
                            bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y, z + 1));
                            if (!bState.m_60815_()) {
                                brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                            } else {
                                bState = level.m_8055_((BlockPos)blockPos.m_122178_(x - 1, y, z));
                                if (!bState.m_60815_()) {
                                    brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                                }
                            }
                        }
                    }
                }
            }
        }
        blockPos.m_122178_(x, y, z);
        return brightness;
    }

    public static enum Type {
        MOB,
        BLOCK,
        VINE,
        OTHER;

    }
}

