/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.math.Vector3i;
import net.diebuddies.physics.BoxRigidBody;
import net.diebuddies.physics.ConvexRigidBody;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineLoader;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxActorFlagEnum;
import physx.physics.PxActorFlags;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;

public class PhysicsWorld {
    public static final int CHUNK_SIZE = 4;
    private static final double CHUNK_UNLOAD_TIME = 1000.0;
    private DynamicsWorld dynamicsWorld;
    private Level level;
    private List<IRigidBody> bodies;
    private List<Ragdoll> ragdolls;
    private Set<Vector3i> loadedChunks;
    private Object2IntMap<Vector3i> loadedChunkEntities;
    private Map<Vector3i, List<IRigidBody>> chunkBodies;
    private Int2ObjectMap<IRigidBody> worldEntities = new Int2ObjectOpenHashMap();
    private IntSet lastEntityUpdates = new IntOpenHashSet();
    private IntSet tmpSet = new IntOpenHashSet();
    private IRigidBody player;
    private double renderPercent;
    private List<Explosion> explosions = new ObjectArrayList();
    private Set<Vector3i> chunkUpdates = new ObjectOpenHashSet();
    private Vector3d offset;
    private long lastSeen;
    private boolean blocksChanged;
    private boolean loadedChunkEntitiesChanged = false;
    private Vector3d center = new Vector3d();
    private MemoryStack localStack;

    public PhysicsWorld(Level level) {
        this.dynamicsWorld = new DynamicsWorld(level, 0.025f);
        this.level = level;
        this.ragdolls = new ObjectArrayList();
        this.bodies = new ObjectArrayList();
        this.loadedChunks = new ObjectOpenHashSet();
        this.loadedChunkEntities = new Object2IntOpenHashMap();
        this.loadedChunkEntities.defaultReturnValue(0);
        this.chunkBodies = new Object2ObjectOpenHashMap();
        this.offset = new Vector3d();
        this.lastSeen = System.nanoTime();
    }

    public void update(double diff) {
        IntIterator it;
        this.localStack = MemoryStack.stackGet();
        if (this.dynamicsWorld.willUpdate(diff) && this.level instanceof ClientLevel) {
            this.checkChunksToUnload();
            ClientLevel clientLevel = (ClientLevel)this.level;
            this.tmpSet.clear();
            for (Entity entity : clientLevel.m_104735_()) {
                LivingEntity living;
                AABB boundingBox;
                if (!(entity instanceof LivingEntity) || (boundingBox = (living = (LivingEntity)entity).m_142469_()) == null || boundingBox.m_82392_()) continue;
                this.center.set(boundingBox.f_82291_ + boundingBox.f_82288_, boundingBox.f_82292_ + boundingBox.f_82289_, boundingBox.f_82293_ + boundingBox.f_82290_).mul(0.5);
                if (!this.lastEntityUpdates.contains(living.m_142049_())) {
                    PhysicsEntity physicsEntity = new PhysicsEntity(PhysicsEntity.Type.MOB);
                    physicsEntity.getTransformation().translate(this.center);
                    physicsEntity.getOldTransformation().translate(this.center);
                    IRigidBody body = BoxRigidBody.create(physicsEntity, (float)(boundingBox.f_82291_ - boundingBox.f_82288_), (float)(boundingBox.f_82292_ - boundingBox.f_82289_), (float)(boundingBox.f_82293_ - boundingBox.f_82290_), true);
                    PxActorFlags flags = body.getRigidBody().getActorFlags();
                    flags.set(PxActorFlagEnum.eDISABLE_GRAVITY);
                    body.setKinematic(true);
                    body.getRigidBody().setActorFlags(flags);
                    this.dynamicsWorld.addActor(body.getRigidBody());
                    this.worldEntities.put(living.m_142049_(), (Object)body);
                }
                PxRigidDynamic body = (PxRigidDynamic)((IRigidBody)this.worldEntities.get(living.m_142049_())).getRigidBody();
                try (MemoryStack mem = MemoryStack.stackPush();){
                    body.setKinematicTarget(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(this.center.x - this.offset.x), (float)(this.center.y - this.offset.y), (float)(this.center.z - this.offset.z)), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f)));
                }
                this.tmpSet.add(living.m_142049_());
            }
            this.lastEntityUpdates.removeAll((IntCollection)this.tmpSet);
            it = this.lastEntityUpdates.iterator();
            while (it.hasNext()) {
                int n = it.nextInt();
                IRigidBody body = (IRigidBody)this.worldEntities.remove(n);
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
            IntSet intSet = this.lastEntityUpdates;
            this.lastEntityUpdates = this.tmpSet;
            this.tmpSet = intSet;
        }
        boolean updated = this.dynamicsWorld.update(this, diff);
        this.renderPercent = this.dynamicsWorld.getTime() / (double)this.dynamicsWorld.getFixedTimeStep();
        if (updated) {
            this.checkLoadedChunks();
            this.loadedChunkEntitiesChanged = false;
            for (IRigidBody iRigidBody : this.bodies) {
                if (iRigidBody.isKinematicOrFrozen()) continue;
                iRigidBody.updatePositions(this, diff, this.blocksChanged);
            }
            for (Ragdoll r : this.ragdolls) {
                r.updatePhysics(this);
            }
            Iterator<Explosion> iterator = this.explosions.iterator();
            while (iterator.hasNext()) {
                Explosion explosion = iterator.next();
                if (explosion.tickDelay == 0) {
                    this.executeExplosion(explosion);
                    iterator.remove();
                }
                --explosion.tickDelay;
            }
            this.blocksChanged = false;
        }
        this.chunkUpdates.clear();
        it = this.bodies.iterator();
        while (it.hasNext()) {
            IRigidBody iRigidBody = (IRigidBody)it.next();
            if (iRigidBody.getEntity().type != PhysicsEntity.Type.VINE) {
                iRigidBody.entity.time -= diff;
            }
            if (iRigidBody.isRagdoll || !(iRigidBody.entity.time <= 0.0)) continue;
            this.dynamicsWorld.removeActor(iRigidBody.getRigidBody());
            iRigidBody.destroy();
            if (iRigidBody.getLastChunk() != null && !iRigidBody.isKinematicOrFrozen()) {
                this.removeLoadedChunkEntity(iRigidBody.getLastChunk());
            }
            it.remove();
        }
        Iterator<Ragdoll> iterator = this.ragdolls.iterator();
        while (iterator.hasNext()) {
            Ragdoll ragdoll = iterator.next();
            boolean destroyRagdoll = true;
            if (ragdoll.isKinematic()) continue;
            for (IRigidBody body : ragdoll.btBodies) {
                if (!(body.entity.time >= 0.0)) continue;
                destroyRagdoll = false;
            }
            if (!destroyRagdoll) continue;
            iterator.remove();
            ragdoll.remove(this);
            ragdoll.destroy();
        }
    }

    private void checkLoadedChunks() {
        if (!this.loadedChunkEntitiesChanged) {
            return;
        }
        for (Object2IntMap.Entry entry : this.loadedChunkEntities.object2IntEntrySet()) {
            boolean wasLoaded;
            Vector3i chunk = (Vector3i)entry.getKey();
            int amount = entry.getIntValue();
            if (amount == 0 || this.loadedChunks.contains(chunk) || !(wasLoaded = this.loadChunk(chunk))) continue;
            this.loadedChunks.add(chunk);
        }
    }

    private void checkChunksToUnload() {
        if (!this.loadedChunkEntitiesChanged) {
            return;
        }
        Iterator<Vector3i> it = this.loadedChunks.iterator();
        while (it.hasNext()) {
            Vector3i chunk = it.next();
            if (this.loadedChunkEntities.getInt((Object)chunk) > 0) continue;
            this.unloadChunk(chunk);
            it.remove();
        }
    }

    public void addLoadedChunkEntity(Vector3i chunk) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.addLoadedChunkEntityOffset(new Vector3i(chunk.x + x, chunk.y + y, chunk.z + z));
                }
            }
        }
    }

    private void addLoadedChunkEntityOffset(Vector3i loaded) {
        int amount = this.loadedChunkEntities.getInt((Object)loaded);
        this.loadedChunkEntities.put((Object)loaded, amount + 1);
        this.loadedChunkEntitiesChanged = true;
    }

    public void removeLoadedChunkEntity(Vector3i chunk) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.removeLoadedChunkEntityOffset(new Vector3i(chunk.x + x, chunk.y + y, chunk.z + z));
                }
            }
        }
    }

    public void removeLoadedChunkEntityOffset(Vector3i chunk) {
        int amount = this.loadedChunkEntities.getInt((Object)chunk);
        this.loadedChunkEntities.put((Object)chunk, amount - 1);
        this.loadedChunkEntitiesChanged = true;
    }

    private void unloadChunk(Vector3i chunkPos) {
        List<IRigidBody> bodies = this.chunkBodies.remove(chunkPos);
        if (bodies != null) {
            for (IRigidBody body : bodies) {
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
        }
    }

    public void blockUpdate(BlockPos pos) {
        this.blocksChanged = true;
        BlockState state = this.level.m_8055_(pos);
        boolean changedRagdoll = false;
        for (int i = 0; i < this.ragdolls.size(); ++i) {
            if (!this.ragdolls.get(i).blockUpdate(this, pos, state)) continue;
            changedRagdoll = true;
            break;
        }
        if (!changedRagdoll) {
            // empty if block
        }
        int cx = pos.m_123341_() < 0 ? (int)((double)(pos.m_123341_() + 1) / 4.0) - 1 : (int)((double)pos.m_123341_() / 4.0);
        int cy = pos.m_123342_() < 0 ? (int)((double)(pos.m_123342_() + 1) / 4.0) - 1 : (int)((double)pos.m_123342_() / 4.0);
        int cz = pos.m_123343_() < 0 ? (int)((double)(pos.m_123343_() + 1) / 4.0) - 1 : (int)((double)pos.m_123343_() / 4.0);
        int ax = pos.m_123341_() < 0 ? 4 + (pos.m_123341_() + 1) % 4 - 1 : pos.m_123341_() % 4;
        int ay = pos.m_123342_() < 0 ? 4 + (pos.m_123342_() + 1) % 4 - 1 : pos.m_123342_() % 4;
        int az = pos.m_123343_() < 0 ? 4 + (pos.m_123343_() + 1) % 4 - 1 : pos.m_123343_() % 4;
        this.updateChunk(cx, cy, cz);
        if (ax == 0) {
            this.updateChunk(cx - 1, cy, cz);
        }
        if (ay == 0) {
            this.updateChunk(cx, cy - 1, cz);
        }
        if (az == 0) {
            this.updateChunk(cx, cy, cz - 1);
        }
        if (ax == 3) {
            this.updateChunk(cx + 1, cy, cz);
        }
        if (ay == 3) {
            this.updateChunk(cx, cy + 1, cz);
        }
        if (az == 3) {
            this.updateChunk(cx, cy, cz + 1);
        }
    }

    private void updateChunk(int cx, int cy, int cz) {
        Vector3i chunkPos = new Vector3i(cx, cy, cz);
        if (this.chunkUpdates.contains(chunkPos)) {
            return;
        }
        this.chunkUpdates.add(chunkPos);
        if (this.loadedChunks.contains(chunkPos)) {
            this.unloadChunk(chunkPos);
            this.loadChunk(chunkPos);
        }
    }

    private boolean loadChunk(Vector3i chunkPos) {
        if (chunkPos.y < this.level.m_141937_() || chunkPos.y >= this.level.m_151558_() / 4) {
            return true;
        }
        int chunkX = chunkPos.x / 4;
        int chunkZ = chunkPos.z / 4;
        if (this.level.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false) == null) {
            return false;
        }
        ObjectArrayList bodies = this.chunkBodies.get(chunkPos);
        if (bodies == null) {
            bodies = new ObjectArrayList();
            this.chunkBodies.put(chunkPos, (List<IRigidBody>)bodies);
        }
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    BlockPos pos = new BlockPos(chunkPos.x * 4 + x, chunkPos.y * 4 + y, chunkPos.z * 4 + z);
                    BlockState state = this.level.m_8055_(pos);
                    VoxelShape voxelShape = state.m_60812_((BlockGetter)this.level, pos);
                    if (voxelShape.m_83281_() || VineHelper.isVine(state) || !this.areNeighboursEmpty(this.level, pos)) continue;
                    for (AABB aabb : voxelShape.m_83299_()) {
                        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.OTHER);
                        double width = aabb.f_82291_ - aabb.f_82288_;
                        double height = aabb.f_82292_ - aabb.f_82289_;
                        double depth = aabb.f_82293_ - aabb.f_82290_;
                        entity.getTransformation().translate((double)pos.m_123341_() + aabb.f_82288_ + width / 2.0 - this.offset.x, (double)pos.m_123342_() + aabb.f_82289_ + height / 2.0 - this.offset.y, (double)pos.m_123343_() + aabb.f_82290_ + depth / 2.0 - this.offset.z);
                        BoxRigidBody body = BoxRigidBody.create(entity, (float)width, (float)height, (float)depth, false);
                        this.dynamicsWorld.addActor(body.getRigidBody());
                        bodies.add(body);
                    }
                }
            }
        }
        return true;
    }

    private boolean areNeighboursEmpty(Level level, BlockPos pos) {
        return pos.m_123342_() >= level.m_151558_() || pos.m_123342_() <= level.m_141937_() || pos.m_123342_() < level.m_151558_() - 1 && this.isTranslucent(level, pos.m_7494_()) || pos.m_123342_() > level.m_141937_() && this.isTranslucent(level, pos.m_7495_()) || this.isTranslucent(level, pos.m_142127_()) || this.isTranslucent(level, pos.m_142126_()) || this.isTranslucent(level, pos.m_142128_()) || this.isTranslucent(level, pos.m_142125_());
    }

    private boolean isTranslucent(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return !Block.m_49916_((VoxelShape)state.m_60808_((BlockGetter)level, pos)) || state.m_60812_((BlockGetter)level, pos).m_83281_();
    }

    public void destroy() {
        if (this.level instanceof ClientLevel) {
            ((VineLoader)((ClientLevel)this.level).m_7726_()).setPhysicsMod(null);
        }
        for (IRigidBody iRigidBody : this.bodies) {
            if (iRigidBody.isRagdoll) continue;
            this.dynamicsWorld.removeActor(iRigidBody.getRigidBody());
            iRigidBody.destroy();
        }
        for (IRigidBody iRigidBody : this.worldEntities.values()) {
            this.dynamicsWorld.removeActor(iRigidBody.getRigidBody());
            iRigidBody.destroy();
        }
        for (Ragdoll ragdoll : this.ragdolls) {
            ragdoll.remove(this);
            ragdoll.destroy();
        }
        for (Map.Entry entry : this.chunkBodies.entrySet()) {
            for (IRigidBody body : (List)entry.getValue()) {
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
        }
        if (this.player != null) {
            this.dynamicsWorld.removeActor(this.player.getRigidBody());
            this.player.destroy();
        }
        this.dynamicsWorld.destroy();
        this.ragdolls.clear();
        this.chunkBodies.clear();
        this.loadedChunks.clear();
        this.bodies.clear();
    }

    public void addBlockParticle(List<Mesh> brokenBlock, PhysicsEntity particle) {
        if (particle.noVolume) {
            return;
        }
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        for (Mesh mesh : brokenBlock) {
            PhysicsEntity broken = new PhysicsEntity(particle.type);
            broken.models.get((int)0).texture = particle.models.get((int)0).texture;
            broken.models.get((int)0).textureIDs = particle.models.get((int)0).textureIDs;
            broken.color = particle.color;
            broken.backfaceCulling = particle.backfaceCulling;
            broken.models.get((int)0).overlay = particle.models.get((int)0).overlay;
            broken.shade = particle.shade;
            broken.models.get((int)0).mesh = particle.min.equals(0.0, 0.0, 0.0) && particle.max.equals(1.0, 1.0, 1.0) ? mesh : this.scale(mesh, particle.min, particle.max);
            broken.setTransformation(new Matrix4d(particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate(broken.models.get((int)0).mesh.offset));
            broken.setOldTransformation(new Matrix4d(broken.getTransformation()));
            broken.scale = particle.scale;
            broken.time = particle.type == PhysicsEntity.Type.MOB ? ConfigClient.particleLifetimeMobs : ConfigClient.particleLifetimeBlocks + java.lang.Math.random() * 3.0;
            ConvexRigidBody body = ConvexRigidBody.create(broken, true);
            this.bodies.add(body);
            this.dynamicsWorld.addActor(body.getRigidBody());
            body.applyRandomSpawnForces();
        }
    }

    private Mesh scale(Mesh mesh, Vector3d min, Vector3d max) {
        Mesh scaled = new Mesh();
        List<Integer> sides = mesh.calculedAngleSides();
        int count = 1;
        for (org.joml.Vector3i index : mesh.indices) {
            Vector3d pos = mesh.positions.get(index.x - 1);
            Vector2d uv = new Vector2d(mesh.uvs.get(index.y - 1));
            Vector3d normal = mesh.normals.get(index.z - 1);
            Integer side = sides.get(index.z - 1);
            double posX = Math.clamp(Math.remapClamp(pos.x + mesh.offset.x, -0.5, 0.5, min.x, max.x), 0.0, 1.0);
            double posY = Math.clamp(Math.remapClamp(pos.y + mesh.offset.y, -0.5, 0.5, min.y, max.y), 0.0, 1.0);
            double posZ = Math.clamp(Math.remapClamp(pos.z + mesh.offset.z, -0.5, 0.5, min.z, max.z), 0.0, 1.0);
            if (side == 4 || side == 5) {
                uv.set(posX, posZ);
            } else if (side == 1 || side == 3) {
                uv.set(1.0 - posZ, 1.0 - posY);
            } else if (side == 0 || side == 2) {
                uv.set(posX, 1.0 - posY);
            }
            if (mesh.colors.size() > 0) {
                Vector3f color = mesh.colors.get(index.x - 1);
                scaled.colors.add(new Vector3f(color));
            }
            scaled.indices.add(new org.joml.Vector3i(count, count, count));
            scaled.uvs.add(uv);
            scaled.normals.add(new Vector3d(normal));
            scaled.positions.add(new Vector3d(Math.remap(pos.x + 0.5 + mesh.offset.x, 0.0, 1.0, min.x, max.x) - 0.5, Math.remap(pos.y + 0.5 + mesh.offset.y, 0.0, 1.0, min.y, max.y) - 0.5, Math.remap(pos.z + 0.5 + mesh.offset.z, 0.0, 1.0, min.z, max.z) - 0.5));
            ++count;
        }
        scaled.calculateOffset(false);
        return scaled;
    }

    public void addRagdoll(Ragdoll ragdoll) {
        ragdoll.add(this);
        this.ragdolls.add(ragdoll);
    }

    public void removeRagdoll(Ragdoll ragdoll) {
        ragdoll.remove(this);
        this.ragdolls.remove(ragdoll);
    }

    public IRigidBody addBlockParticle(PhysicsEntity particle, PxRigidActor actor) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.setTransformation(new Matrix4d(particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate(particle.models.get((int)0).mesh.offset));
        particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
        particle.time = particle.type == PhysicsEntity.Type.MOB ? ConfigClient.particleLifetimeMobs : ConfigClient.particleLifetimeBlocks + java.lang.Math.random() * 3.0;
        ConvexRigidBody body = ConvexRigidBody.create(particle, actor, !particle.staticPhysics);
        this.bodies.add(body);
        if (actor == null) {
            this.dynamicsWorld.addActor(body.getRigidBody());
        }
        return body;
    }

    public IRigidBody addBlockParticle(PhysicsEntity particle) {
        for (PhysicsEntity child : particle.children) {
            this.addBlockParticle(child, null);
        }
        return this.addBlockParticle(particle, null);
    }

    public List<IRigidBody> getBodies() {
        return this.bodies;
    }

    public Map<Vector3i, List<IRigidBody>> getChunkBodies() {
        return this.chunkBodies;
    }

    public double getRenderPercent() {
        return this.renderPercent;
    }

    public void applyExplosion(Explosion explosion) {
        this.explosions.add(explosion);
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public void executeExplosion(Explosion explosion) {
        for (IRigidBody body : this.bodies) {
            double distance = explosion.position.distance(body.getEntity().getTransformation().getTranslation(new Vector3d()).add(this.offset));
            Vector3d direction = body.getEntity().getTransformation().getTranslation(new Vector3d()).add(this.offset).sub(explosion.position).normalize();
            direction.y += 2.0;
            direction.normalize();
            double realStrength = 1.0 - Math.clamp(distance / ((double)explosion.strength * 2.0), 0.0, 1.0);
            realStrength *= 15.0;
            if (!(body.getRigidBody() instanceof PxRigidBody)) continue;
            PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
            if (rigidBody instanceof PxRigidDynamic) {
                ((PxRigidDynamic)rigidBody).wakeUp();
            }
            PxVec3 v = rigidBody.getLinearVelocity();
            v.setX(v.getX() + (float)(direction.x * realStrength));
            v.setY(v.getY() + (float)(direction.y * realStrength));
            v.setZ(v.getZ() + (float)(direction.z * realStrength));
            rigidBody.setLinearVelocity(v);
        }
    }

    public void updateLastSeen() {
        this.lastSeen = System.nanoTime();
    }

    public boolean isActive() {
        return System.nanoTime() - this.lastSeen <= 5000000000L;
    }

    public Level getWorld() {
        return this.level;
    }

    public DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public List<Ragdoll> getRagdolls() {
        return this.ragdolls;
    }

    public MemoryStack getLocalStack() {
        return this.localStack;
    }

    public void addVerletSimulation(VerletSimulation simulation) {
        this.dynamicsWorld.addVerletSimulation(simulation);
    }

    public void removeVerletSimulation(VerletSimulation simulation) {
        this.dynamicsWorld.removeVerletSimulation(simulation);
    }

    public List<VerletSimulation> getVerletSimulations() {
        return this.dynamicsWorld.getVerletSimulations();
    }
}

