/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.diebuddies.bridge.FabricAPIServer;
import net.diebuddies.config.ConfigServer;
import net.diebuddies.physics.FallingBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3i;

public class ServerPhysicsMod
implements FabricAPIServer.StartWorldTick,
FabricAPIServer.After {
    private List<FallingBlocks> fallingBlocks;

    public ServerPhysicsMod() {
        ConfigServer.init();
        this.fallingBlocks = new ObjectArrayList();
    }

    private boolean canFall(Level level, BlockPos pos, BlockState b) {
        if (b.m_60734_() != Blocks.f_50080_ && b.m_60734_() != Blocks.f_50752_ && b.m_60734_() != Blocks.f_50142_ && b.m_60734_() != Blocks.f_50257_ && b.m_60734_() != Blocks.f_50258_ && !b.m_60795_() && b.m_60734_() != Blocks.f_49990_ && b.m_60734_() != Blocks.f_49991_) {
            BlockState toCheck = level.m_8055_(pos.m_7495_());
            Block block = toCheck.m_60734_();
            if (toCheck.m_60795_() || block == Blocks.f_49990_ || block == Blocks.f_49991_ || block == Blocks.f_50033_) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void afterBlockBreak(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (!ConfigServer.collapse) {
            return;
        }
        this.checkAdjacentBlocks(new HashSet<Vector3i>(), new HashSet<Vector3i>(), level, player, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    @Override
    public void onStartTick(ServerLevel level) {
        Iterator<FallingBlocks> it = this.fallingBlocks.iterator();
        while (it.hasNext()) {
            FallingBlocks falling = it.next();
            if (ConfigServer.collapseSpeed == 0 || falling.ticks % ConfigServer.collapseSpeed == 0) {
                Vector3i tmp = new Vector3i();
                boolean end = false;
                do {
                    HashSet<Vector3i> toCheck = new HashSet<Vector3i>();
                    for (Vector3i check : falling.toCheck) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int x = -1; x <= 1; ++x) {
                                for (int z = -1; z <= 1; ++z) {
                                    if (x == 0 && y == 0 && z == 0) continue;
                                    tmp.set(check.x + x, check.y + y, check.z + z);
                                    if (falling.alreadyChecked.contains(tmp)) continue;
                                    BlockPos blockPos = new BlockPos(check.x + x, check.y + y, check.z + z);
                                    BlockState b = falling.level.m_8055_(blockPos);
                                    falling.alreadyChecked.add(new Vector3i(tmp));
                                    if (!this.canFall(falling.level, blockPos, b)) continue;
                                    if (ConfigServer.dropBlocks) {
                                        BlockState state = falling.level.m_8055_(blockPos);
                                        BlockEntity te = falling.level.m_7702_(blockPos);
                                        state.m_60734_().m_6240_(falling.level, falling.player, blockPos, state, te, falling.player.m_21211_());
                                    }
                                    falling.level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                                    falling.fallen.add(new Vector3i(tmp));
                                    toCheck.add(new Vector3i(tmp));
                                }
                            }
                        }
                        if (falling.fallen.size() <= ConfigServer.maxCollapseObjects) continue;
                        end = true;
                        it.remove();
                        break;
                    }
                    falling.toCheck = toCheck;
                    if (falling.toCheck.size() != 0) continue;
                    end = true;
                    it.remove();
                } while (ConfigServer.collapseSpeed == 0 && !end);
            }
            ++falling.ticks;
        }
    }

    private void checkAdjacentBlocks(Set<Vector3i> alreadyChecked, Set<Vector3i> fallen, Level level, Player player, int bx, int by, int bz) {
        FallingBlocks falling = new FallingBlocks(level, player);
        falling.toCheck.add(new Vector3i(bx, by, bz));
        this.fallingBlocks.add(falling);
    }
}

