/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ragdoll;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.BoxRigidBody;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.RagdollJoint;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4d;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxD6AxisEnum;
import physx.extensions.PxD6Joint;
import physx.extensions.PxD6JointDrive;
import physx.extensions.PxD6MotionEnum;
import physx.extensions.PxJoint;
import physx.extensions.PxJointAngularLimitPair;
import physx.extensions.PxSpring;
import physx.physics.PxFilterData;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidDynamic;

public class VineRagdoll
extends Ragdoll {
    public List<PxJoint> pxJoints = new ObjectArrayList();
    public List<Connector> connectors = new ObjectArrayList();
    public List<BlockPos> bodiesPos = new ObjectArrayList();
    public List<BlockState> bodiesState = new ObjectArrayList();
    public PhysicsEntity hookedEntity;
    public Vector3d hook;
    public IRigidBody hookBody;
    public PxD6Joint hookJoint;
    public boolean bottomFixed;
    public float stiffness = 10.0f;
    public float damping = 60.0f;
    private boolean initFreeze = true;
    private boolean alwaysInWater;

    public VineRagdoll() {
        this.frozen = true;
    }

    @Override
    public void updatePhysics(PhysicsWorld physics) {
        if (this.initFreeze) {
            Vector3d pos = ((PhysicsEntity)this.bodies.get(0)).getTransformation().getTranslation(new Vector3d());
            int chunkX = SectionPos.m_175552_((double)(pos.x + physics.getOffset().x));
            int chunkZ = SectionPos.m_175552_((double)(pos.z + physics.getOffset().z));
            if (physics.getWorld().m_6522_(chunkX, chunkZ, null, false) != null) {
                this.setFrozen(false);
                this.initFreeze = false;
            }
        }
        if (this.alwaysInWater) {
            for (IRigidBody body : this.btBodies) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)body.getRigidBody();
                float mass = rigidBody.getMass();
                try (MemoryStack mem = MemoryStack.stackPush();){
                    Vector3f buoyancy = physics.getDynamicsWorld().getBuoyancy();
                    PxVec3 counterForce = PxVec3.createAt(mem, MemoryStack::nmalloc, buoyancy.x * mass * 3.0f, buoyancy.y * mass * 3.0f, buoyancy.z * mass * 3.0f);
                    rigidBody.addForce(counterForce, PxForceModeEnum.eFORCE);
                }
                if (!body.hasGravity()) continue;
                body.setGravity(false);
            }
        }
    }

    @Override
    public boolean blockUpdate(PhysicsWorld physics, BlockPos pos, BlockState state) {
        if (this.bodiesPos.size() == 0) {
            return false;
        }
        BlockPos start = this.bodiesPos.get(0);
        if (start.m_123341_() != pos.m_123341_() || start.m_123343_() != pos.m_123343_()) {
            return false;
        }
        int index = this.bodiesPos.indexOf(pos);
        if (index != -1) {
            if (!VineHelper.canLink(this.bodiesState.get(index), state)) {
                int cutJoint = -1;
                BlockPos connectionDir = this.bottomFixed ? pos.m_7495_() : pos.m_7494_();
                for (int i = 0; i < this.connectors.size(); ++i) {
                    if (!this.connectors.get(i).connects(pos, connectionDir)) continue;
                    cutJoint = i;
                    break;
                }
                PxJoint releasedJoint = this.pxJoints.remove(cutJoint);
                releasedJoint.release();
                ObjectArrayList bodiesNew = new ObjectArrayList();
                ObjectArrayList btBodiesNew = new ObjectArrayList();
                ObjectArrayList pxJointsNew = new ObjectArrayList();
                ObjectArrayList connectorsNew = new ObjectArrayList();
                Object cutConnector = this.connectors.remove(cutJoint);
                BlockPos pos1 = pos;
                BlockPos pos2 = connectionDir;
                block11: while (cutConnector != null) {
                    cutConnector = null;
                    pos1 = this.bottomFixed ? pos1.m_7494_() : pos1.m_7495_();
                    pos2 = this.bottomFixed ? pos2.m_7494_() : pos2.m_7495_();
                    this.moveBodiesIntoNewRagdoll(pos1, (List<IRigidBody>)btBodiesNew, (List<PhysicsEntity>)bodiesNew);
                    this.moveBodiesIntoNewRagdoll(pos2, (List<IRigidBody>)btBodiesNew, (List<PhysicsEntity>)bodiesNew);
                    for (int i = 0; i < this.connectors.size(); ++i) {
                        Connector connection = this.connectors.get(i);
                        if (!connection.connects(pos1, pos2)) continue;
                        cutConnector = connection;
                        connectorsNew.add(this.connectors.remove(i));
                        pxJointsNew.add(this.pxJoints.remove(i));
                        continue block11;
                    }
                }
                VineRagdoll vine = new VineRagdoll();
                vine.bottomFixed = this.bottomFixed;
                vine.bodies.addAll(bodiesNew);
                vine.btBodies.addAll(btBodiesNew);
                vine.pxJoints.addAll((Collection<PxJoint>)pxJointsNew);
                vine.connectors.addAll((Collection<Connector>)connectorsNew);
                vine.initFreeze = false;
                ((IRigidBody)vine.btBodies.get(0)).applyRandomSpawnForces();
                for (IRigidBody body : vine.btBodies) {
                    if (body.getRigidBody() instanceof PxRigidDynamic) {
                        ((PxRigidDynamic)body.getRigidBody()).wakeUp();
                    }
                    body.setGravity(true);
                    MemoryStack mem = MemoryStack.stackPush();
                    try {
                        PxFilterData tmpFilterData = PxFilterData.createAt(mem, MemoryStack::nmalloc, 1, 1, 0, 0);
                        body.getShape().setSimulationFilterData(tmpFilterData);
                    }
                    finally {
                        if (mem == null) continue;
                        mem.close();
                    }
                }
                double rnd = Math.random() * 3.0;
                for (PhysicsEntity entity : vine.bodies) {
                    entity.type = PhysicsEntity.Type.OTHER;
                    entity.time = ConfigClient.particleLifetimeVines + rnd;
                }
                if (this.hookJoint == releasedJoint) {
                    physics.getDynamicsWorld().removeActor(this.hookBody.getRigidBody());
                    this.btBodies.remove(this.hookBody);
                    this.hookBody.destroy();
                    this.hookBody = null;
                }
                physics.getRagdolls().add(vine);
                return true;
            }
            PhysicsEntity entity = PhysicsMod.getInstance(physics.getWorld()).renderBlockIntoEntity(PhysicsEntity.Type.VINE, state, pos);
            ((PhysicsEntity)this.bodies.get(index)).destroy();
            ((PhysicsEntity)this.bodies.get((int)index)).models = entity.models;
            this.bodiesState.set(index, state);
            return true;
        }
        if (this.bodiesPos.size() > 0) {
            int highestY = this.bodiesPos.get(0).m_123342_();
            int highestIndex = 0;
            for (int i = 1; i < this.bodiesPos.size(); ++i) {
                int y = this.bodiesPos.get(i).m_123342_();
                if (this.bottomFixed) {
                    if (y <= highestY) continue;
                    highestY = y;
                    highestIndex = i;
                    continue;
                }
                if (y >= highestY) continue;
                highestY = y;
                highestIndex = i;
            }
            BlockPos check = new BlockPos(pos.m_123341_(), highestY, pos.m_123343_());
            index = this.bodiesPos.indexOf(check);
            if (index != -1 && (this.bottomFixed ? highestY + 1 == pos.m_123342_() : highestY - 1 == pos.m_123342_()) && VineHelper.canLink(this.bodiesState.get(index), state)) {
                IRigidBody appendTo = null;
                PhysicsEntity highestEntity = (PhysicsEntity)this.bodies.get(highestIndex);
                for (int i = 0; i < this.btBodies.size(); ++i) {
                    IRigidBody body = (IRigidBody)this.btBodies.get(i);
                    if (!body.getEntity().equals(highestEntity)) continue;
                    appendTo = body;
                    break;
                }
                PhysicsEntity entity = PhysicsMod.getInstance(physics.getWorld()).renderBlockIntoEntity(PhysicsEntity.Type.VINE, state, pos);
                Connector connector = new Connector(check, pos);
                this.connectors.add(connector);
                this.bodiesPos.add(pos);
                this.bodiesState.add(state);
                this.bodies.add(entity);
                IRigidBody childLink = physics.addBlockParticle(entity);
                entity.time = ConfigClient.particleLifetimeBlocks;
                childLink.setFrozen(this.frozen);
                childLink.isRagdoll = true;
                this.btBodies.add(childLink);
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxTransform parentPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, this.bottomFixed ? 0.5f : -0.5f, 0.0f), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                    PxTransform childPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, this.bottomFixed ? -0.5f : 0.5f, 0.0f), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                    PxD6Joint joint = this.createJoint(appendTo.getRigidBody(), parentPose, childLink.getRigidBody(), childPose);
                    this.pxJoints.add(joint);
                }
                return true;
            }
        }
        return false;
    }

    private void moveBodiesIntoNewRagdoll(BlockPos pos, List<IRigidBody> btBodiesNew, List<PhysicsEntity> bodiesNew) {
        int removeBody = this.bodiesPos.indexOf(pos);
        if (removeBody != -1) {
            this.bodiesPos.remove(removeBody);
            this.bodiesState.remove(removeBody);
            PhysicsEntity entity = (PhysicsEntity)this.bodies.remove(removeBody);
            bodiesNew.add(entity);
            for (int i = 0; i < this.btBodies.size(); ++i) {
                IRigidBody btBody = (IRigidBody)this.btBodies.get(i);
                if (!btBody.getEntity().equals(entity)) continue;
                this.btBodies.remove(btBody);
                btBodiesNew.add(btBody);
                break;
            }
        }
    }

    public void setAlwaysInWater(boolean alwaysInWater) {
        this.alwaysInWater = alwaysInWater;
        for (IRigidBody body : this.btBodies) {
            if (!body.hasGravity()) continue;
            body.setGravity(!alwaysInWater);
        }
    }

    @Override
    public void buildMesh(PhysicsWorld physics) {
        PhysicsEntity root = (PhysicsEntity)this.bodies.get(0);
        this.entireMesh = new PhysicsEntity(PhysicsEntity.Type.VINE);
        this.entireMesh.time = root.time;
        this.entireMesh.noCollision = root.noCollision;
        this.entireMesh.stopCollision = root.stopCollision;
        this.entireMesh.color = root.color;
        this.entireMesh.getTransformation().set(root.getTransformation());
        this.entireMesh.getOldTransformation().set(root.getOldTransformation());
        Model model = this.entireMesh.models.get(0);
        model.brightness = root.models.get((int)0).brightness;
        model.textureIDs = root.models.get((int)0).textureIDs;
        model.overlay = root.models.get((int)0).overlay;
        model.onlyVisual = root.models.get((int)0).onlyVisual;
        model.mesh = new Mesh();
        Matrix4d invModel = this.entireMesh.getTransformation().invert(new Matrix4d());
        Matrix4d transform = new Matrix4d();
        for (PhysicsEntity entity : this.bodies) {
            int i;
            Mesh mesh = entity.models.get((int)0).mesh;
            if (mesh == null) continue;
            int offset = model.mesh.positions.size();
            model.mesh.colors.addAll(mesh.colors);
            model.mesh.uvs.addAll(mesh.uvs);
            model.mesh.normals.addAll(mesh.normals);
            Vector3d translation = entity.getTransformation().getTranslation(new Vector3d()).add(physics.getOffset());
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(translation.x, translation.y, translation.z);
            int brightness = entity.getLight(physics.getWorld(), blockPos);
            int j = brightness >> 16 & 0xFFFF;
            int k = brightness & 0xFFFF;
            for (i = 0; i < mesh.uvs.size(); ++i) {
                model.mesh.light.add(new Vector2i(k, j));
            }
            for (i = 0; i < mesh.indices.size(); ++i) {
                model.mesh.indices.add(new Vector3i(mesh.indices.get(i)).add(offset, offset, offset));
            }
            invModel.mul(entity.getTransformation(), transform);
            for (i = 0; i < mesh.positions.size(); ++i) {
                model.mesh.positions.add(transform.transformPosition(mesh.positions.get(i), new Vector3d()));
            }
        }
    }

    @Override
    public boolean supportMeshBuilding() {
        return this.kinematic || this.frozen;
    }

    @Override
    public void add(PhysicsWorld physics) {
        double rnd = Math.random() * 3.0;
        List<Ragdoll.Node> tree = this.generateTree();
        for (Ragdoll.Node root : tree) {
            for (int i = 0; i < root.children.size(); ++i) {
                this.createChildLinkPrePass(root, root.children.get(i));
            }
        }
        for (Ragdoll.Node root : tree) {
            PhysicsEntity particle = (PhysicsEntity)this.bodies.get(root.index);
            if (particle.noVolume) continue;
            if (physics.getBodies().size() == 0 && physics.getChunkBodies().size() == 0) {
                particle.getTransformation().getTranslation(physics.getOffset());
            }
            IRigidBody rigidBody = physics.addBlockParticle(particle);
            rigidBody.setFrozen(this.frozen);
            particle.time = ConfigClient.particleLifetimeMobs + rnd;
            rigidBody.isRagdoll = true;
            this.btBodies.add(rigidBody);
            for (int i = 0; i < root.children.size(); ++i) {
                this.createChildLink(physics, rigidBody, root.children.get(i), rnd);
            }
            if (!particle.equals(this.hookedEntity)) continue;
            this.createHook(physics, particle, rigidBody);
        }
    }

    private void createHook(PhysicsWorld physics, PhysicsEntity particle, IRigidBody rigidBody) {
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.VINE);
        entity.getTransformation().translate(this.hook).translate(particle.getTransformation().getTranslation(new Vector3d()));
        this.hookBody = BoxRigidBody.create(entity, 0.5f, 0.5f, 0.5f, true);
        this.hookBody.isRagdoll = true;
        this.hookBody.setKinematic(true);
        this.btBodies.add(this.hookBody);
        BlockPos pos = this.bodiesPos.get(this.bodies.indexOf(rigidBody.getEntity()));
        this.connectors.add(new Connector(pos, this.bottomFixed ? pos.m_7495_() : pos.m_7494_()));
        physics.getDynamicsWorld().addActor(this.hookBody.getRigidBody());
        try (MemoryStack mem = MemoryStack.stackPush();){
            PxTransform localPose1 = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
            PxTransform localPose2 = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, (float)this.hook.y, 0.0f), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
            this.hookJoint = this.createJoint(rigidBody.getRigidBody(), localPose2, this.hookBody.getRigidBody(), localPose1);
            this.pxJoints.add(this.hookJoint);
        }
    }

    private void createChildLink(PhysicsWorld physics, IRigidBody rootLink, Ragdoll.Node root, double rnd) {
        PhysicsEntity particle = (PhysicsEntity)this.bodies.get(root.index);
        if (!particle.noVolume) {
            RagdollJoint rjoint = (RagdollJoint)this.joints.get(root.jointIndex);
            if (rjoint.fixed) {
                return;
            }
            particle.stopCollision = rjoint.stopCollision;
            IRigidBody childLink = physics.addBlockParticle(particle);
            particle.time = ConfigClient.particleLifetimeMobs + rnd;
            childLink.setFrozen(this.frozen);
            childLink.isRagdoll = true;
            this.btBodies.add(childLink);
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxTransform parentPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)rjoint.point1.x, (float)rjoint.point1.y, (float)rjoint.point1.z), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                PxTransform childPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)rjoint.point2.x, (float)rjoint.point2.y, (float)rjoint.point2.z), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                if (rjoint.index1 == root.index) {
                    PxTransform tmp = parentPose;
                    parentPose = childPose;
                    childPose = tmp;
                }
                PxD6Joint joint = this.createJoint(rootLink.getRigidBody(), parentPose, childLink.getRigidBody(), childPose);
                this.pxJoints.add(joint);
                this.connectors.add(new Connector(this.bodiesPos.get(this.bodies.indexOf(rootLink.getEntity())), this.bodiesPos.get(this.bodies.indexOf(childLink.getEntity()))));
                for (int i = 0; i < root.children.size(); ++i) {
                    this.createChildLink(physics, childLink, root.children.get(i), rnd);
                }
            }
            if (particle.equals(this.hookedEntity)) {
                this.createHook(physics, particle, childLink);
            }
        }
    }

    private PxD6Joint createJoint(PxRigidActor rigidBody1, PxTransform localPose1, PxRigidActor rigidBody2, PxTransform localPose2) {
        PxD6Joint joint = null;
        try (MemoryStack mem = MemoryStack.stackPush();){
            joint = PxTopLevelFunctions.D6JointCreate(StarterClient.physics, rigidBody1, localPose1, rigidBody2, localPose2);
            joint.setMotion(PxD6AxisEnum.eTWIST, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eSWING1, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eSWING2, PxD6MotionEnum.eLIMITED);
            PxD6JointDrive drive = new PxD6JointDrive(this.stiffness, this.damping, 100000.0f, true);
            joint.setDrive(PxD6AxisEnum.eTWIST, drive);
            joint.setDrive(PxD6AxisEnum.eSWING1, drive);
            joint.setDrive(PxD6AxisEnum.eSWING2, drive);
            joint.setDrivePosition(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f)));
            joint.setDriveVelocity(PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f), PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f));
            PxSpring spring = new PxSpring(this.stiffness, this.damping);
            PxJointAngularLimitPair angularLimit = new PxJointAngularLimitPair(-0.3926991f, 0.3926991f, spring);
            joint.setTwistLimit(angularLimit);
            drive.destroy();
            spring.destroy();
            angularLimit.destroy();
        }
        return joint;
    }

    @Override
    public void setKinematic(boolean kinematic) {
        super.setKinematic(kinematic);
        if (this.hookBody != null) {
            this.hookBody.setKinematic(true);
        }
    }

    @Override
    public void setFrozen(boolean frozen) {
        if (this.frozen != frozen) {
            for (IRigidBody body : this.btBodies) {
                if (body == this.hookBody) continue;
                body.setFrozen(frozen);
            }
            this.frozen = frozen;
        }
    }

    @Override
    public void remove(PhysicsWorld physicsWorld) {
        super.remove(physicsWorld);
        for (IRigidBody body : this.btBodies) {
            physicsWorld.getDynamicsWorld().removeActor(body.getRigidBody());
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        for (IRigidBody body : this.btBodies) {
            body.destroy();
        }
        for (PxJoint joint : this.pxJoints) {
            joint.release();
        }
        if (this.hookBody != null) {
            this.hookBody.destroy();
        }
    }

    class Connector {
        BlockPos pos1;
        BlockPos pos2;

        public Connector(BlockPos pos1, BlockPos pos2) {
            this.pos1 = pos1;
            this.pos2 = pos2;
        }

        public boolean connects(BlockPos pos1, BlockPos pos2) {
            return this.pos1.equals((Object)pos1) && this.pos2.equals((Object)pos2) || this.pos1.equals((Object)pos2) && this.pos2.equals((Object)pos1);
        }
    }
}

