/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class BlocksCustomizeSettingsScreen
extends OptionsSubScreen {
    private OptionsList list;

    public BlocksCustomizeSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent("Block Rules"));
    }

    protected void m_7856_() {
        EditBox search = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - 160, this.f_96544_ - 27, 100, 20, (Component)new TextComponent(""));
        search.m_94167_("Search...");
        this.updateBlocks("");
        search.m_94151_(changedText -> {
            if (changedText.isEmpty()) {
                search.m_94167_("Search...");
            } else {
                search.m_94167_("");
            }
            this.updateBlocks((String)changedText);
        });
        this.m_142416_((GuiEventListener)search);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 27, 100, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 60, this.f_96544_ - 27, 100, 20, (Component)new TextComponent("RESET"), button -> {
            ConfigBlocks.resetBlocks();
            this.f_96541_.m_91152_((Screen)new BlocksCustomizeSettingsScreen(this.f_96281_, this.f_96282_));
        }));
    }

    private void updateBlocks(String matcher) {
        if (this.list != null) {
            this.f_96540_.remove(this.list);
        }
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(this.list);
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : PhysicsMod.registeredBlocks.values()) {
            ids.add(id);
        }
        Collections.sort(ids);
        for (String id : ids) {
            if (!id.toLowerCase().contains(matcher.toLowerCase())) continue;
            CycleOption entityOption = CycleOption.m_167764_((String)id, (Object[])((Object[])BlocksPhysicsType.values()), blockPhysicsType -> {
                String text = "OFF";
                switch ((BlocksPhysicsType)((Object)((Object)blockPhysicsType))) {
                    case OFF: {
                        text = "OFF";
                        break;
                    }
                    case FRACTURED: {
                        text = "Fractured";
                        break;
                    }
                    case BLOCKY: {
                        text = "Blocky";
                        break;
                    }
                    case MAIN_RULE: {
                        text = "Main Rule";
                        break;
                    }
                    default: {
                        text = "OFF";
                    }
                }
                return new TextComponent(text);
            }, gameOptions -> {
                Integer val = ConfigBlocks.customizedBlocks.get(id);
                if (val == null) {
                    val = 2;
                    ConfigBlocks.customizedBlocks.put(id, val);
                }
                switch (val) {
                    case 0: {
                        return BlocksPhysicsType.OFF;
                    }
                    case 1: {
                        return BlocksPhysicsType.FRACTURED;
                    }
                    case 3: {
                        return BlocksPhysicsType.BLOCKY;
                    }
                    case 2: {
                        return BlocksPhysicsType.MAIN_RULE;
                    }
                }
                return BlocksPhysicsType.OFF;
            }, (gameOptions, option, blockPhysicsType) -> {
                BlocksPhysicsType type = (BlocksPhysicsType)((Object)((Object)blockPhysicsType));
                switch (type) {
                    case OFF: {
                        ConfigBlocks.customizedBlocks.put(id, 0);
                        break;
                    }
                    case FRACTURED: {
                        ConfigBlocks.customizedBlocks.put(id, 1);
                        break;
                    }
                    case BLOCKY: {
                        ConfigBlocks.customizedBlocks.put(id, 3);
                        break;
                    }
                    case MAIN_RULE: {
                        ConfigBlocks.customizedBlocks.put(id, 2);
                    }
                }
                ConfigBlocks.save();
            });
            this.list.m_94471_((Option)entityOption);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        BlocksCustomizeSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List list = BlocksCustomizeSettingsScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(matrices, list, mouseX, mouseY);
        }
    }

    public static enum BlocksPhysicsType {
        FRACTURED,
        BLOCKY,
        OFF,
        MAIN_RULE;

    }
}

