/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;

public class CapeObjectSelectionList
extends ObjectSelectionList<BaseEntry> {
    public CapeObjectSelectionList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.m_93516_();
        Path path = PhysicsMod.CAPES_DIRECTORY;
        try {
            Collection folders = Files.list(path).filter(CapeObjectSelectionList::isValidCape).collect(Collectors.toList());
            for (Path folder : folders) {
                String name = folder.getFileName().toString();
                LabelEntry entry = new LabelEntry(name);
                this.m_7085_((AbstractSelectionList.Entry)entry);
                if (!name.equalsIgnoreCase(ConfigClient.selectedPhysicsCape)) continue;
                this.setSelected(entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSelected(BaseEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        ConfigClient.selectedPhysicsCape = (String)entry.getUserData();
        ConfigClient.save();
    }

    public static boolean isValidCape(Path file) {
        return file.toFile().getName().endsWith("dae");
    }

    public class LabelEntry
    extends BaseEntry {
        private final String text;

        public LabelEntry(String text) {
            super(text);
            this.text = text;
        }

        public void m_6311_(PoseStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String newText;
            Font font = Minecraft.m_91087_().f_91062_;
            Object text = this.text.replace(".dae", "");
            if (font.m_92852_((FormattedText)new TextComponent((String)text).m_130940_(ChatFormatting.BOLD)) > CapeObjectSelectionList.this.m_5759_() - 55 && !((String)text).equalsIgnoreCase(newText = font.m_92834_((String)text, CapeObjectSelectionList.this.m_5759_() - 58))) {
                text = newText + "...";
            }
            TextComponent label = new TextComponent((String)text);
            if (hovered) {
                label = label.m_130940_(ChatFormatting.BOLD);
                GuiComponent.m_93215_((PoseStack)poseStack, (Font)font, (Component)label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xFFFFFF);
            } else {
                GuiComponent.m_93215_((PoseStack)poseStack, (Font)font, (Component)label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xC2C2C2);
            }
        }

        public Component m_142172_() {
            return new TextComponent(this.text);
        }
    }

    public abstract class BaseEntry
    extends ObjectSelectionList.Entry<BaseEntry> {
        private Object object;

        protected BaseEntry(Object object) {
            this.object = object;
        }

        public boolean isSelected() {
            return CapeObjectSelectionList.this.m_93511_() == this;
        }

        public boolean m_6375_(double d, double e, int i) {
            if (!this.isSelected()) {
                CapeObjectSelectionList.this.setSelected(this);
                return true;
            }
            return false;
        }

        public Object getUserData() {
            return this.object;
        }
    }
}

