/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.joml.Vector3f;

public class GravityCustomizeSettingsScreen
extends OptionsSubScreen {
    private OptionsList list;

    public GravityCustomizeSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent("Gravity Rules (join a world to see dimensions)"));
    }

    protected void m_7856_() {
        EditBox search = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - 160, this.f_96544_ - 27, 100, 20, (Component)new TextComponent(""));
        search.m_94167_("Search...");
        this.updateGravities("");
        search.m_94151_(changedText -> {
            if (changedText.isEmpty()) {
                search.m_94167_("Search...");
            } else {
                search.m_94167_("");
            }
            this.updateGravities((String)changedText);
        });
        this.m_142416_((GuiEventListener)search);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 27, 100, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 60, this.f_96544_ - 27, 100, 20, (Component)new TextComponent("RESET"), button -> {
            ConfigClient.resetGravities();
            this.f_96541_.m_91152_((Screen)new GravityCustomizeSettingsScreen(this.f_96281_, this.f_96282_));
        }));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        GravityCustomizeSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List list = GravityCustomizeSettingsScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(matrices, list, mouseX, mouseY);
        }
    }

    public void updateGravities(String matcher) {
        if (this.list != null) {
            this.f_96540_.remove(this.list);
        }
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(this.list);
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : ConfigClient.customizedGravities.keySet()) {
            ids.add(id);
        }
        Collections.sort(ids);
        for (String id : ids) {
            if (!id.toLowerCase().contains(matcher.toLowerCase())) continue;
            ProgressOption gravityX = new ProgressOption("Gravity X (" + id + ")", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getGravity((String)id).x, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getGravity(id);
                val.x = value.floatValue();
                ConfigClient.setGravity(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> new TextComponent("Gravity X (" + id + "): " + String.format("%.2f", option.m_92221_(gameOptions))));
            ProgressOption gravityY = new ProgressOption("Gravity Y (" + id + ")", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getGravity((String)id).y, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getGravity(id);
                val.y = value.floatValue();
                ConfigClient.setGravity(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> new TextComponent("Gravity Y (" + id + "): " + String.format("%.2f", option.m_92221_(gameOptions))));
            ProgressOption gravityZ = new ProgressOption("Gravity Z (" + id + ")", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getGravity((String)id).z, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getGravity(id);
                val.z = value.floatValue();
                ConfigClient.setGravity(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> new TextComponent("Gravity Z (" + id + "): " + String.format("%.2f", option.m_92221_(gameOptions))));
            ProgressOption buoyancyX = new ProgressOption("Buoyancy X (" + id + ")", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getBuoyancy((String)id).x, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getBuoyancy(id);
                val.x = value.floatValue();
                ConfigClient.setBuoyancy(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> new TextComponent("Buoyancy X (" + id + "): " + String.format("%.2f", option.m_92221_(gameOptions))));
            ProgressOption buoyancyY = new ProgressOption("Buoyancy Y (" + id + ")", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getBuoyancy((String)id).y, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getBuoyancy(id);
                val.y = value.floatValue();
                ConfigClient.setBuoyancy(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> new TextComponent("Buoyancy Y (" + id + "): " + String.format("%.2f", option.m_92221_(gameOptions))));
            ProgressOption buoyancyZ = new ProgressOption("Buoyancy Z (" + id + ")", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getBuoyancy((String)id).z, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getBuoyancy(id);
                val.z = value.floatValue();
                ConfigClient.setBuoyancy(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> new TextComponent("Buoyancy Z (" + id + "): " + String.format("%.2f", option.m_92221_(gameOptions))));
            this.list.m_94471_((Option)gravityX);
            this.list.m_94471_((Option)gravityY);
            this.list.m_94471_((Option)gravityZ);
            this.list.m_94471_((Option)buoyancyX);
            this.list.m_94471_((Option)buoyancyY);
            this.list.m_94471_((Option)buoyancyZ);
        }
    }

    public static enum BlocksPhysicsType {
        ON,
        OFF,
        MAIN_RULE;

    }
}

