/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet;

import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.VerletTriangle;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class VerletSimulation {
    private Vector3d gravity;
    private List<VerletPoint> points;
    private List<VerletStick> sticks;
    private List<VerletQuad> quads;
    private List<VerletTriangle> triangles;
    private int iterations;
    private Random random;
    private Vector3d offset;
    public boolean active = true;
    public boolean destroyed = false;
    public boolean render = true;
    public int textureID;
    public int brightness;
    public ColladaMesh mesh;
    private Vector3d tmp = new Vector3d();
    private Vector3i tmpInt = new Vector3i(0, 0, 0);

    public VerletSimulation(Vector3d gravity, int iterations, boolean useOffset) {
        this.gravity = new Vector3d(gravity);
        this.iterations = iterations;
        this.random = new Random(0L);
        this.points = new ObjectArrayList();
        this.sticks = new ObjectArrayList();
        this.quads = new ObjectArrayList();
        this.triangles = new ObjectArrayList();
        if (!useOffset) {
            this.offset = new Vector3d(0.0);
        }
    }

    public VerletSimulation(Vector3d gravity, int iterations) {
        this(gravity, iterations, true);
    }

    public void update(PhysicsWorld physics, double delta) {
        int i;
        double gx = this.gravity.x * delta * delta;
        double gy = this.gravity.y * delta * delta;
        double gz = this.gravity.z * delta * delta;
        double friction = 0.93;
        if (!this.points.isEmpty() && this.points.get((int)0).position.length() > 100.0) {
            this.setOffset(new Vector3d(this.getOffset()).add(this.points.get((int)0).position));
        }
        for (i = 0; i < this.points.size(); ++i) {
            VerletPoint p = this.points.get(i);
            if (!p.locked) {
                double vx = p.position.x - p.prevPosition.x;
                double vy = p.position.y - p.prevPosition.y;
                double vz = p.position.z - p.prevPosition.z;
                p.prevPosition.set(p.position);
                p.position.x += gx + vx * friction;
                p.position.y += gy + vy * friction;
                p.position.z += gz + vz * friction;
                continue;
            }
            p.prevPosition.set(p.position);
        }
        for (i = 0; i < this.iterations; ++i) {
            for (int j = 0; j < this.sticks.size(); ++j) {
                VerletStick stick = this.sticks.get(j);
                if (stick.pointA.locked && stick.pointB.locked) continue;
                double stickCenterX = (stick.pointA.position.x + stick.pointB.position.x) * 0.5;
                double stickCenterY = (stick.pointA.position.y + stick.pointB.position.y) * 0.5;
                double stickCenterZ = (stick.pointA.position.z + stick.pointB.position.z) * 0.5;
                double stickDirX = stick.pointA.position.x - stick.pointB.position.x;
                double stickDirY = stick.pointA.position.y - stick.pointB.position.y;
                double stickDirZ = stick.pointA.position.z - stick.pointB.position.z;
                double length = Vector3d.length(stickDirX, stickDirY, stickDirZ);
                if (length != 0.0) {
                    double invLength = stick.halfLength / length;
                    stickDirX *= invLength;
                    stickDirY *= invLength;
                    stickDirZ *= invLength;
                } else {
                    stickDirZ = 1.0 * stick.halfLength;
                }
                if (!stick.pointA.locked) {
                    stick.pointA.position.x = stickCenterX + stickDirX;
                    stick.pointA.position.y = stickCenterY + stickDirY;
                    stick.pointA.position.z = stickCenterZ + stickDirZ;
                }
                if (stick.pointB.locked) continue;
                stick.pointB.position.x = stickCenterX - stickDirX;
                stick.pointB.position.y = stickCenterY - stickDirY;
                stick.pointB.position.z = stickCenterZ - stickDirZ;
            }
        }
        if (physics != null) {
            this.checkVerletCollisions(physics);
        }
        this.calculateNormals();
        this.active = false;
    }

    public void addMesh(ColladaMesh mesh, Matrix4d transformation, boolean flipUV) {
        for (Vector3f position : mesh.positions) {
            VerletPoint point = new VerletPoint(new Vector3d(position.x, -position.y, position.z));
            if (transformation != null) {
                transformation.transformPosition(point.position);
            }
            this.addPoint(point);
        }
        List<VerletPoint> points = this.getPoints();
        for (int i = 0; i < mesh.indices.size(); ++i) {
            int pindex = mesh.indices.get((int)i).x;
            int cindex = mesh.indices.get((int)i).w;
            int tindex = mesh.indices.get((int)i).z;
            VerletPoint point = points.get(pindex);
            point.locked = mesh.colors.get((int)cindex).x < 0.99f;
            point.uv.set(mesh.texCoords.get(tindex));
            if (!flipUV) continue;
            point.uv.y = 1.0f - point.uv.y;
        }
        int offset = 0;
        for (int i = 0; i < mesh.polyCount.length; ++i) {
            byte polyCount = mesh.polyCount[i];
            if (polyCount == 4) {
                index1 = mesh.indices.get((int)offset).x;
                index2 = mesh.indices.get((int)(offset + 1)).x;
                index3 = mesh.indices.get((int)(offset + 2)).x;
                int index4 = mesh.indices.get((int)(offset + 3)).x;
                this.addStick(new VerletStick(points.get(index1), points.get(index2)));
                this.addStick(new VerletStick(points.get(index2), points.get(index3)));
                this.addStick(new VerletStick(points.get(index3), points.get(index4)));
                this.addStick(new VerletStick(points.get(index4), points.get(index1)));
                this.addStick(new VerletStick(points.get(index1), points.get(index3)));
                this.addStick(new VerletStick(points.get(index2), points.get(index4)));
                this.addQuad(new VerletQuad(points.get(index1), points.get(index2), points.get(index3), points.get(index4)));
            } else if (polyCount == 3) {
                index1 = mesh.indices.get((int)offset).x;
                index2 = mesh.indices.get((int)(offset + 1)).x;
                index3 = mesh.indices.get((int)(offset + 2)).x;
                this.addStick(new VerletStick(points.get(index1), points.get(index2)));
                this.addStick(new VerletStick(points.get(index2), points.get(index3)));
                this.addStick(new VerletStick(points.get(index3), points.get(index1)));
                this.addTriangle(new VerletTriangle(points.get(index1), points.get(index2), points.get(index3)));
            }
            offset += polyCount;
        }
    }

    public void update(double delta) {
        this.update(null, delta);
    }

    private void checkVerletCollisions(PhysicsWorld physics) {
        int z;
        int y;
        int x;
        if (this.points.size() == 0) {
            return;
        }
        VerletPoint start = this.points.get(0);
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(start.position.x + this.offset.x, start.position.y + this.offset.y, start.position.z + this.offset.z);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(start.position.x + this.offset.x, start.position.y + this.offset.y, start.position.z + this.offset.z);
        for (int i = 0; i < this.points.size(); ++i) {
            VerletPoint point = this.points.get(i);
            x = Mth.m_14107_((double)(point.position.x + this.offset.x));
            y = Mth.m_14107_((double)(point.position.y + this.offset.y));
            z = Mth.m_14107_((double)(point.position.z + this.offset.z));
            if (x < min.m_123341_()) {
                min.m_142451_(x);
            } else if (x > max.m_123341_()) {
                max.m_142451_(x);
            }
            if (y < min.m_123342_()) {
                min.m_142448_(y);
            } else if (y > max.m_123342_()) {
                max.m_142448_(y);
            }
            if (z < min.m_123343_()) {
                min.m_142443_(z);
                continue;
            }
            if (z <= max.m_123343_()) continue;
            max.m_142443_(z);
        }
        Object2ObjectOpenHashMap bodies = new Object2ObjectOpenHashMap();
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (x = min.m_123341_() - 1; x <= max.m_123341_() + 1; ++x) {
            for (y = min.m_123342_() - 1; y <= max.m_123342_() + 1; ++y) {
                for (z = min.m_123343_() - 1; z <= max.m_123343_() + 1; ++z) {
                    VoxelShape voxelShape;
                    currentPos.m_122178_(x, y, z);
                    BlockState state = physics.getWorld().m_8055_((BlockPos)currentPos);
                    if (state.m_60734_() == Blocks.f_50016_ || (voxelShape = state.m_60812_((BlockGetter)physics.getWorld(), (BlockPos)currentPos)).m_83281_() || VineHelper.isVine(state)) continue;
                    for (AABB aabb : voxelShape.m_83299_()) {
                        this.addToSuroundings(new AABB(aabb.f_82288_ + (double)x - this.offset.x, aabb.f_82289_ + (double)y - this.offset.y, aabb.f_82290_ + (double)z - this.offset.z, aabb.f_82291_ + (double)x - this.offset.x, aabb.f_82292_ + (double)y - this.offset.y, aabb.f_82293_ + (double)z - this.offset.z), x, y, z, (Map<Vector3i, List<AABB>>)bodies);
                    }
                }
            }
        }
        double enlarge = 0.05;
        block5: for (VerletPoint point : this.points) {
            int z2;
            int y2;
            int x2;
            List boxes;
            if (point.locked || (boxes = (List)bodies.get(this.tmpInt.set(x2 = Mth.m_14107_((double)(point.position.x + this.offset.x)), y2 = Mth.m_14107_((double)(point.position.y + this.offset.y)), z2 = Mth.m_14107_((double)(point.position.z + this.offset.z))))) == null) continue;
            for (int i = 0; i < boxes.size(); ++i) {
                AABB box = (AABB)boxes.get(i);
                if (VerletHelper.movePointOutOfBox(point.position, (float)(box.f_82288_ - enlarge), (float)(box.f_82289_ - enlarge), (float)(box.f_82290_ - enlarge), (float)(box.f_82291_ + enlarge), (float)(box.f_82292_ + enlarge), (float)(box.f_82293_ + enlarge))) continue block5;
            }
        }
    }

    private void addToSuroundings(AABB box, int x, int y, int z, Map<Vector3i, List<AABB>> bodies) {
        for (int xi = -1; xi <= 1; ++xi) {
            for (int yi = -1; yi <= 1; ++yi) {
                for (int zi = -1; zi <= 1; ++zi) {
                    ObjectArrayList boxes = bodies.get(this.tmpInt.set(x + xi, y + yi, z + zi));
                    if (boxes == null) {
                        boxes = new ObjectArrayList();
                        bodies.put(new Vector3i(this.tmpInt), (List<AABB>)boxes);
                    }
                    boxes.add((AABB)box);
                }
            }
        }
    }

    private void calculateNormals() {
        double invLength;
        double nz;
        double ny;
        double nx;
        double bz;
        double by;
        double bx;
        double az;
        double ay;
        double ax;
        for (VerletQuad quad : this.quads) {
            ax = quad.point3.position.x - quad.point1.position.x;
            ay = quad.point3.position.y - quad.point1.position.y;
            az = quad.point3.position.z - quad.point1.position.z;
            bx = quad.point2.position.x - quad.point1.position.x;
            by = quad.point2.position.y - quad.point1.position.y;
            bz = quad.point2.position.z - quad.point1.position.z;
            nx = ay * bz - az * by;
            ny = az * bx - ax * bz;
            nz = ax * by - ay * bx;
            invLength = Math.invsqrt(nx * nx + ny * ny + nz * nz);
            nx *= invLength;
            ny *= invLength;
            nz *= invLength;
            if (ConfigClient.clothSmoothShading) {
                quad.point1.normal.set(nx, ny, nz);
                quad.point2.normal.set(nx, ny, nz);
                quad.point3.normal.set(nx, ny, nz);
                quad.point4.normal.set(nx, ny, nz);
                continue;
            }
            quad.point1.normal.set(nx, ny, nz);
        }
        for (VerletTriangle triangle : this.triangles) {
            ax = triangle.point3.position.x - triangle.point1.position.x;
            ay = triangle.point3.position.y - triangle.point1.position.y;
            az = triangle.point3.position.z - triangle.point1.position.z;
            bx = triangle.point2.position.x - triangle.point1.position.x;
            by = triangle.point2.position.y - triangle.point1.position.y;
            bz = triangle.point2.position.z - triangle.point1.position.z;
            nx = ay * bz - az * by;
            ny = az * bx - ax * bz;
            nz = ax * by - ay * bx;
            invLength = Math.invsqrt(nx * nx + ny * ny + nz * nz);
            nx *= invLength;
            ny *= invLength;
            nz *= invLength;
            if (ConfigClient.clothSmoothShading) {
                triangle.point1.normal.set(nx, ny, nz);
                triangle.point2.normal.set(nx, ny, nz);
                triangle.point3.normal.set(nx, ny, nz);
                continue;
            }
            triangle.point1.normal.set(nx, ny, nz);
        }
    }

    public void addPoint(VerletPoint point) {
        if (this.offset == null) {
            this.offset = new Vector3d(point.position);
        }
        point.position.sub(this.offset);
        point.prevPosition.set(point.position);
        this.points.add(point);
    }

    public void addStick(VerletStick stick) {
        this.sticks.add(stick);
    }

    public void addQuad(VerletQuad quad) {
        this.quads.add(quad);
    }

    public void addTriangle(VerletTriangle triangle) {
        this.triangles.add(triangle);
    }

    public void removePoint(VerletPoint point) {
        this.points.remove(point);
    }

    public void removeStick(VerletStick stick) {
        this.sticks.remove(stick);
    }

    public void removeQuad(VerletQuad quad) {
        this.quads.remove(quad);
    }

    public void removeTriangle(VerletTriangle triangle) {
        this.triangles.remove(triangle);
    }

    public List<VerletStick> getSticks() {
        return this.sticks;
    }

    public List<VerletPoint> getPoints() {
        return this.points;
    }

    public List<VerletQuad> getQuads() {
        return this.quads;
    }

    public List<VerletTriangle> getTriangles() {
        return this.triangles;
    }

    public Vector3d getGravity() {
        return this.gravity;
    }

    public void setGravity(Vector3d gravity) {
        this.gravity.set(gravity);
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3d offset) {
        double dx = -offset.x + this.offset.x;
        double dy = -offset.y + this.offset.y;
        double dz = -offset.z + this.offset.z;
        for (VerletPoint point : this.points) {
            point.position.x += dx;
            point.position.y += dy;
            point.position.z += dz;
            point.prevPosition.x += dx;
            point.prevPosition.y += dy;
            point.prevPosition.z += dz;
        }
        this.offset.set(offset);
    }

    public void render(VertexConsumer bufferbuilder, double renderPercent) {
        int i;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        Vector3d tmp1 = new Vector3d();
        Vector3d tmp2 = new Vector3d();
        Vector3d tmp3 = new Vector3d();
        Vector3d tmp4 = new Vector3d();
        for (i = 0; i < this.quads.size(); ++i) {
            VerletQuad quad = this.quads.get(i);
            quad.point1.prevPosition.lerp(quad.point1.position, renderPercent, tmp1);
            quad.point2.prevPosition.lerp(quad.point2.position, renderPercent, tmp2);
            quad.point3.prevPosition.lerp(quad.point3.position, renderPercent, tmp3);
            quad.point4.prevPosition.lerp(quad.point4.position, renderPercent, tmp4);
            if (ConfigClient.clothSmoothShading) {
                this.bufferVertex(bufferbuilder, renderPercent, tmp4, quad.point4.uv, quad.point4.normal, this.brightness, r, g, b, a);
                this.bufferVertex(bufferbuilder, renderPercent, tmp3, quad.point3.uv, quad.point3.normal, this.brightness, r, g, b, a);
                this.bufferVertex(bufferbuilder, renderPercent, tmp2, quad.point2.uv, quad.point2.normal, this.brightness, r, g, b, a);
                this.bufferVertex(bufferbuilder, renderPercent, tmp1, quad.point1.uv, quad.point1.normal, this.brightness, r, g, b, a);
                this.bufferVertex(bufferbuilder, renderPercent, tmp4, quad.point4.uv, quad.point4.normal, this.brightness, r, g, b, a);
                this.bufferVertex(bufferbuilder, renderPercent, tmp2, quad.point2.uv, quad.point2.normal, this.brightness, r, g, b, a);
                continue;
            }
            this.bufferVertex(bufferbuilder, renderPercent, tmp4, quad.point4.uv, quad.point1.normal, this.brightness, r, g, b, a);
            this.bufferVertex(bufferbuilder, renderPercent, tmp3, quad.point3.uv, quad.point1.normal, this.brightness, r, g, b, a);
            this.bufferVertex(bufferbuilder, renderPercent, tmp2, quad.point2.uv, quad.point1.normal, this.brightness, r, g, b, a);
            this.bufferVertex(bufferbuilder, renderPercent, tmp1, quad.point1.uv, quad.point1.normal, this.brightness, r, g, b, a);
            this.bufferVertex(bufferbuilder, renderPercent, tmp4, quad.point4.uv, quad.point1.normal, this.brightness, r, g, b, a);
            this.bufferVertex(bufferbuilder, renderPercent, tmp2, quad.point2.uv, quad.point1.normal, this.brightness, r, g, b, a);
        }
        for (i = 0; i < this.triangles.size(); ++i) {
            VerletTriangle triangle = this.triangles.get(i);
            triangle.point1.prevPosition.lerp(triangle.point1.position, renderPercent, tmp1);
            triangle.point2.prevPosition.lerp(triangle.point2.position, renderPercent, tmp2);
            triangle.point3.prevPosition.lerp(triangle.point3.position, renderPercent, tmp3);
            if (ConfigClient.clothSmoothShading) {
                this.bufferVertex(bufferbuilder, renderPercent, tmp3, triangle.point3.uv, triangle.point3.normal, this.brightness, r, g, b, a);
                this.bufferVertex(bufferbuilder, renderPercent, tmp2, triangle.point2.uv, triangle.point2.normal, this.brightness, r, g, b, a);
                this.bufferVertex(bufferbuilder, renderPercent, tmp1, triangle.point1.uv, triangle.point1.normal, this.brightness, r, g, b, a);
                continue;
            }
            this.bufferVertex(bufferbuilder, renderPercent, tmp3, triangle.point3.uv, triangle.point1.normal, this.brightness, r, g, b, a);
            this.bufferVertex(bufferbuilder, renderPercent, tmp2, triangle.point2.uv, triangle.point1.normal, this.brightness, r, g, b, a);
            this.bufferVertex(bufferbuilder, renderPercent, tmp1, triangle.point1.uv, triangle.point1.normal, this.brightness, r, g, b, a);
        }
    }

    private void bufferVertex(VertexConsumer bufferbuilder, double renderPercent, Vector3d position, Vector2f uv, Vector3d normal, int brightness, float r, float g, float b, float a) {
        bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, r, g, b, 1.0f, uv.x, uv.y, 0, brightness, (float)normal.x, (float)normal.y, (float)normal.z);
    }
}

