/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.crafting;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairHelper;
import com.blakebr0.pickletweaks.init.ModRecipeSerializers;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GridRepairRecipe
extends ShapelessRecipe {
    public GridRepairRecipe(ResourceLocation id) {
        super(id, "", ItemStack.field_190927_a, NonNullList.func_191196_a());
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        if (!((Boolean)ModConfigs.GRID_REPAIR_ENABLED.get()).booleanValue()) {
            return ItemStack.field_190927_a;
        }
        ItemStack tool = ItemStack.field_190927_a;
        NonNullList inputs = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            if (tool.func_190926_b() && slotStack.func_77984_f()) {
                tool = slotStack;
                continue;
            }
            inputs.add((Object)slotStack);
        }
        if (tool.func_190926_b() || !tool.func_77951_h() || inputs.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (GridRepairHelper.isBlacklisted(tool.func_77973_b())) {
            return ItemStack.field_190927_a;
        }
        int repairCost = (Integer)ModConfigs.GRID_REPAIR_COST.get();
        boolean cheaperShovel = (Boolean)ModConfigs.GRID_REPAIR_CHEAP_SHOVEL.get();
        if (cheaperShovel && tool.func_77973_b() instanceof ShovelItem) {
            repairCost = Math.max(1, repairCost / 2);
        }
        int damage = tool.func_77958_k() / repairCost;
        double matCount = 0.0;
        boolean maxed = false;
        for (ItemStack mat : inputs) {
            if (maxed) {
                return ItemStack.field_190927_a;
            }
            if (!mat.hasContainerItem()) {
                double matValue = GridRepairHelper.getMaterialValue(tool, mat);
                if (matValue == 0.0) {
                    return ItemStack.field_190927_a;
                }
                matCount += matValue;
                if (!((double)tool.func_77952_i() - (double)damage * matCount <= 0.0)) continue;
                maxed = true;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        tool = StackHelper.withSize((ItemStack)tool, (int)1, (boolean)false);
        tool.func_196085_b(tool.func_77952_i() - (int)((double)damage * matCount));
        if (((Boolean)ModConfigs.GRID_REPAIR_STRIP_ENCHANTMENTS.get()).booleanValue()) {
            Map<Enchantment, Integer> enchantments = EnchantmentHelper.func_82781_a((ItemStack)tool).entrySet().stream().filter(x -> ((Enchantment)x.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            EnchantmentHelper.func_82782_a(enchantments, (ItemStack)tool);
        }
        return tool;
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        return !this.func_77572_b(inv).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.CRAFTING_GRID_REPAIR;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<GridRepairRecipe> {
        public GridRepairRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new GridRepairRecipe(recipeId);
        }

        public GridRepairRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new GridRepairRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, GridRepairRecipe recipe) {
        }
    }
}

