/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks;

import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.blocks.tileentity.ItemPipeTileEntity;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.containerfactory.PipeContainerProvider;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemPipeBlock
extends PipeBlock {
    protected ItemPipeBlock() {
        this.setRegistryName(new ResourceLocation("pipez", "item_pipe"));
    }

    @Override
    public boolean canConnectTo(IWorldReader world, BlockPos pos, Direction facing) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(facing));
        return te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).isPresent();
    }

    @Override
    public boolean isPipe(IWorldReader world, BlockPos pos, Direction facing) {
        BlockState state = world.func_180495_p(pos.func_177972_a(facing));
        return state.func_177230_c().equals(this);
    }

    @Override
    TileEntity createTileEntity() {
        return new ItemPipeTileEntity();
    }

    @Override
    public ActionResultType onPipeSideActivated(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit, Direction direction) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof ItemPipeTileEntity && this.isExtracting((IWorldReader)worldIn, pos, direction)) {
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            ItemPipeTileEntity pipe = (ItemPipeTileEntity)tileEntity;
            PipeContainerProvider.openGui(player, pipe, direction, (i, playerInventory, playerEntity) -> new ExtractContainer(i, (IInventory)playerInventory, pipe, direction));
            return ActionResultType.SUCCESS;
        }
        return super.onPipeSideActivated(state, worldIn, pos, player, handIn, hit, direction);
    }
}

