/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.ModTileEntities;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.corelib.energy.EnergyUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyPipeTileEntity
extends UpgradeLogicTileEntity<Void> {
    private final int[] rrIndex = new int[Direction.values().length];

    public EnergyPipeTileEntity() {
        super(ModTileEntities.ENERGY_PIPE);
    }

    @Override
    public boolean canInsert(TileEntity tileEntity, Direction direction) {
        return tileEntity.getCapability(CapabilityEnergy.ENERGY, direction).isPresent();
    }

    @Override
    public Filter<Void> createFilter() {
        return new Filter<Void>(){};
    }

    @Override
    public String getFilterKey() {
        return "";
    }

    @Override
    public boolean hasFilter() {
        return false;
    }

    @Override
    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.ROUND_ROBIN;
    }

    @Override
    public UpgradeTileEntity.RedstoneMode getDefaultRedstoneMode() {
        return UpgradeTileEntity.RedstoneMode.IGNORED;
    }

    @Override
    public UpgradeTileEntity.FilterMode getDefaultFilterMode() {
        return UpgradeTileEntity.FilterMode.WHITELIST;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (Direction side : Direction.values()) {
            IEnergyStorage energyStorage;
            if (!this.isExtracting(side) || !this.shouldWork(side) || (energyStorage = this.getEnergyStorage(this.field_174879_c.func_177972_a(side), side.func_176734_d())) == null || !energyStorage.canExtract()) continue;
            List<PipeTileEntity.Connection> connections = this.getSortedConnections(side);
            if (this.getDistribution(side).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(side, connections, energyStorage);
                continue;
            }
            this.insertOrdered(side, connections, energyStorage);
        }
    }

    protected void insertEqually(Direction side, List<PipeTileEntity.Connection> connections, IEnergyStorage energyStorage) {
        int completeAmount;
        if (connections.isEmpty()) {
            return;
        }
        int energyToTransfer = completeAmount = this.getRate(side);
        boolean[] connectionsFull = new boolean[connections.size()];
        int p = this.rrIndex[side.func_176745_a()] % connections.size();
        while (energyToTransfer > 0 && this.hasNotInserted(connectionsFull)) {
            int transferred;
            int simulatedExtract;
            PipeTileEntity.Connection connection = connections.get(p);
            IEnergyStorage destination = this.getEnergyStorage(connection.getPos(), connection.getDirection());
            boolean hasInserted = false;
            if (destination != null && destination.canReceive() && (simulatedExtract = energyStorage.extractEnergy(Math.min(Math.max(completeAmount / connections.size(), 1), energyToTransfer), true)) > 0 && (transferred = EnergyUtils.pushEnergy(energyStorage, destination, simulatedExtract)) > 0) {
                energyToTransfer -= transferred;
                hasInserted = true;
            }
            if (!hasInserted) {
                connectionsFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        this.rrIndex[side.func_176745_a()] = p;
    }

    protected void insertOrdered(Direction side, List<PipeTileEntity.Connection> connections, IEnergyStorage energyStorage) {
        int energyToTransfer = this.getRate(side);
        for (PipeTileEntity.Connection connection : connections) {
            int simulatedExtract;
            if (energyToTransfer <= 0) break;
            IEnergyStorage destination = this.getEnergyStorage(connection.getPos(), connection.getDirection());
            if (destination == null || !destination.canReceive() || (simulatedExtract = energyStorage.extractEnergy(energyToTransfer, true)) <= 0) continue;
            int extract = EnergyUtils.pushEnergy(energyStorage, destination, simulatedExtract);
            energyToTransfer -= extract;
        }
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IEnergyStorage getEnergyStorage(BlockPos pos, Direction direction) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity == null) {
            return null;
        }
        return (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, direction).orElse(null);
    }

    @Override
    public int getRate(Direction direction) {
        Upgrade upgrade = this.getUpgrade(direction);
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.energyPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.energyPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.energyPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.energyPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.energyPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

