/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.ModTileEntities;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidPipeTileEntity
extends UpgradeLogicTileEntity<Fluid> {
    private final int[] rrIndex = new int[Direction.values().length];

    public FluidPipeTileEntity() {
        super(ModTileEntities.FLUID_PIPE);
    }

    @Override
    public boolean canInsert(TileEntity tileEntity, Direction direction) {
        return tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).isPresent();
    }

    @Override
    public Filter<Fluid> createFilter() {
        return new FluidFilter();
    }

    @Override
    public String getFilterKey() {
        return "FluidFilters";
    }

    @Override
    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.ROUND_ROBIN;
    }

    @Override
    public UpgradeTileEntity.RedstoneMode getDefaultRedstoneMode() {
        return UpgradeTileEntity.RedstoneMode.IGNORED;
    }

    @Override
    public UpgradeTileEntity.FilterMode getDefaultFilterMode() {
        return UpgradeTileEntity.FilterMode.WHITELIST;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (Direction side : Direction.values()) {
            IFluidHandler fluidHandler;
            if (!this.isExtracting(side) || !this.shouldWork(side) || (fluidHandler = this.getFluidHandler(this.field_174879_c.func_177972_a(side), side.func_176734_d())) == null) continue;
            List<PipeTileEntity.Connection> connections = this.getSortedConnections(side);
            if (this.getDistribution(side).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(side, connections, fluidHandler);
                continue;
            }
            this.insertOrdered(side, connections, fluidHandler);
        }
    }

    protected void insertEqually(Direction side, List<PipeTileEntity.Connection> connections, IFluidHandler fluidHandler) {
        int completeAmount;
        if (connections.isEmpty()) {
            return;
        }
        int mbToTransfer = completeAmount = this.getRate(side);
        boolean[] connectionsFull = new boolean[connections.size()];
        int p = this.rrIndex[side.func_176745_a()] % connections.size();
        while (mbToTransfer > 0 && this.hasNotInserted(connectionsFull)) {
            PipeTileEntity.Connection connection = connections.get(p);
            IFluidHandler destination = this.getFluidHandler(connection.getPos(), connection.getDirection());
            boolean hasInserted = false;
            if (destination != null) {
                for (int j = 0; j < fluidHandler.getTanks(); ++j) {
                    FluidStack stack;
                    FluidStack fluidInTank = fluidHandler.getFluidInTank(j);
                    FluidStack simulatedExtract = fluidHandler.drain(new FluidStack(fluidInTank.getFluid(), Math.min(Math.max(completeAmount / connections.size(), 1), mbToTransfer), fluidInTank.getTag()), IFluidHandler.FluidAction.SIMULATE);
                    if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, this.getFilters(side)) == this.getFilterMode(side).equals(UpgradeTileEntity.FilterMode.BLACKLIST) || (stack = FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)fluidHandler, (FluidStack)simulatedExtract, (boolean)true)).getAmount() <= 0) continue;
                    mbToTransfer -= stack.getAmount();
                    hasInserted = true;
                    break;
                }
            }
            if (!hasInserted) {
                connectionsFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        this.rrIndex[side.func_176745_a()] = p;
    }

    protected void insertOrdered(Direction side, List<PipeTileEntity.Connection> connections, IFluidHandler fluidHandler) {
        int mbToTransfer = this.getRate(side);
        block0: for (PipeTileEntity.Connection connection : connections) {
            IFluidHandler destination = this.getFluidHandler(connection.getPos(), connection.getDirection());
            if (destination == null) continue;
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                if (mbToTransfer <= 0) break block0;
                FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                FluidStack simulatedExtract = fluidHandler.drain(new FluidStack(fluidInTank.getFluid(), mbToTransfer, fluidInTank.getTag()), IFluidHandler.FluidAction.SIMULATE);
                if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, this.getFilters(side)) == this.getFilterMode(side).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                FluidStack stack = FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)fluidHandler, (FluidStack)simulatedExtract, (boolean)true);
                mbToTransfer -= stack.getAmount();
            }
        }
    }

    private boolean canInsert(PipeTileEntity.Connection connection, FluidStack stack, List<Filter<Fluid>> filters) {
        for (Filter filter : filters.stream().filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(filter, stack)) continue;
            return false;
        }
        List collect = filters.stream().filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter : collect) {
            if (!this.matches(filter, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Filter<Fluid> filter, FluidStack stack) {
        CompoundNBT metadata = filter.getMetadata();
        if (metadata == null) {
            return filter.getTag() == null || stack.getFluid().func_207185_a(filter.getTag());
        }
        if (filter.isExactMetadata()) {
            if (this.deepExactCompare((INBT)metadata, (INBT)stack.getTag())) {
                return filter.getTag() == null || stack.getFluid().func_207185_a(filter.getTag());
            }
            return false;
        }
        CompoundNBT stackNBT = stack.getTag();
        if (stackNBT == null) {
            return metadata.func_186856_d() <= 0;
        }
        if (!this.deepFuzzyCompare((INBT)metadata, (INBT)stackNBT)) {
            return false;
        }
        return filter.getTag() == null || stack.getFluid().func_207185_a(filter.getTag());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IFluidHandler getFluidHandler(BlockPos pos, Direction direction) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity == null) {
            return null;
        }
        return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).orElse(null);
    }

    @Override
    public int getRate(Direction direction) {
        Upgrade upgrade = this.getUpgrade(direction);
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.fluidPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.fluidPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.fluidPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.fluidPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.fluidPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

