/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.GasFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.ModTileEntities;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.capabilities.ModCapabilities;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class GasPipeTileEntity
extends UpgradeLogicTileEntity<Gas> {
    private final int[] rrIndex = new int[Direction.values().length];

    public GasPipeTileEntity() {
        super(ModTileEntities.GAS_PIPE);
    }

    @Override
    public boolean canInsert(TileEntity tileEntity, Direction direction) {
        return tileEntity.getCapability(ModCapabilities.GAS_HANDLER_CAPABILITY, direction).isPresent();
    }

    @Override
    public Filter<Gas> createFilter() {
        return new GasFilter();
    }

    @Override
    public String getFilterKey() {
        return "GasFilters";
    }

    @Override
    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.ROUND_ROBIN;
    }

    @Override
    public UpgradeTileEntity.RedstoneMode getDefaultRedstoneMode() {
        return UpgradeTileEntity.RedstoneMode.IGNORED;
    }

    @Override
    public UpgradeTileEntity.FilterMode getDefaultFilterMode() {
        return UpgradeTileEntity.FilterMode.WHITELIST;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (Direction side : Direction.values()) {
            IGasHandler gasHandler;
            if (!this.isExtracting(side) || !this.shouldWork(side) || (gasHandler = this.getGasHandler(this.field_174879_c.func_177972_a(side), side.func_176734_d())) == null) continue;
            List<PipeTileEntity.Connection> connections = this.getSortedConnections(side);
            if (this.getDistribution(side).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(side, connections, gasHandler);
                continue;
            }
            this.insertOrdered(side, connections, gasHandler);
        }
    }

    protected void insertEqually(Direction side, List<PipeTileEntity.Connection> connections, IGasHandler gasHandler) {
        long completeAmount;
        if (connections.isEmpty()) {
            return;
        }
        long mbToTransfer = completeAmount = (long)this.getRate(side);
        boolean[] connectionsFull = new boolean[connections.size()];
        int p = this.rrIndex[side.func_176745_a()] % connections.size();
        while (mbToTransfer > 0L && this.hasNotInserted(connectionsFull)) {
            PipeTileEntity.Connection connection = connections.get(p);
            IGasHandler destination = this.getGasHandler(connection.getPos(), connection.getDirection());
            boolean hasInserted = false;
            if (destination != null) {
                for (int j = 0; j < gasHandler.getTanks(); ++j) {
                    GasStack stack;
                    GasStack gasInTank = (GasStack)gasHandler.getChemicalInTank(j);
                    GasStack simulatedExtract = gasHandler.extractChemical(new GasStack((IGasProvider)gasInTank.getType(), Math.min(Math.max(completeAmount / (long)connections.size(), 1L), mbToTransfer)), Action.SIMULATE);
                    if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, this.getFilters(side)) == this.getFilterMode(side).equals(UpgradeTileEntity.FilterMode.BLACKLIST) || (stack = this.transfer(gasHandler, destination, simulatedExtract)).getAmount() <= 0L) continue;
                    mbToTransfer -= stack.getAmount();
                    hasInserted = true;
                    break;
                }
            }
            if (!hasInserted) {
                connectionsFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        this.rrIndex[side.func_176745_a()] = p;
    }

    protected void insertOrdered(Direction side, List<PipeTileEntity.Connection> connections, IGasHandler gasHandler) {
        long mbToTransfer = this.getRate(side);
        block0: for (PipeTileEntity.Connection connection : connections) {
            IGasHandler destination = this.getGasHandler(connection.getPos(), connection.getDirection());
            if (destination == null) continue;
            for (int i = 0; i < gasHandler.getTanks(); ++i) {
                if (mbToTransfer <= 0L) break block0;
                GasStack gasInTank = (GasStack)gasHandler.getChemicalInTank(i);
                GasStack simulatedExtract = gasHandler.extractChemical(new GasStack((IGasProvider)gasInTank.getType(), mbToTransfer), Action.SIMULATE);
                if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, this.getFilters(side)) == this.getFilterMode(side).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                GasStack stack = this.transfer(gasHandler, destination, simulatedExtract);
                mbToTransfer -= stack.getAmount();
            }
        }
    }

    private GasStack transfer(IGasHandler source, IGasHandler destination, GasStack transfer) {
        GasStack extracted = source.extractChemical(transfer, Action.SIMULATE);
        GasStack gasStack = destination.insertChemical(extracted, Action.EXECUTE);
        return source.extractChemical(gasStack, Action.EXECUTE);
    }

    private boolean canInsert(PipeTileEntity.Connection connection, GasStack stack, List<Filter<Gas>> filters) {
        for (Filter filter : filters.stream().filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(filter, stack)) continue;
            return false;
        }
        List collect = filters.stream().filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter : collect) {
            if (!this.matches(filter, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Filter<Gas> filter, GasStack stack) {
        return filter.getTag() == null || ((Gas)stack.getType()).isIn(filter.getTag());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IGasHandler getGasHandler(BlockPos pos, Direction direction) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity == null) {
            return null;
        }
        return (IGasHandler)tileEntity.getCapability(ModCapabilities.GAS_HANDLER_CAPABILITY, direction).orElse(null);
    }

    @Override
    public int getRate(Direction direction) {
        Upgrade upgrade = this.getUpgrade(direction);
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.gasPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

