/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.ModTileEntities;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemPipeTileEntity
extends UpgradeLogicTileEntity<Item> {
    private final int[] rrIndex = new int[Direction.values().length];

    public ItemPipeTileEntity() {
        super(ModTileEntities.ITEM_PIPE);
    }

    @Override
    public boolean canInsert(TileEntity tileEntity, Direction direction) {
        return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).isPresent();
    }

    @Override
    public Filter<Item> createFilter() {
        return new ItemFilter();
    }

    @Override
    public String getFilterKey() {
        return "ItemFilters";
    }

    @Override
    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.NEAREST;
    }

    @Override
    public UpgradeTileEntity.RedstoneMode getDefaultRedstoneMode() {
        return UpgradeTileEntity.RedstoneMode.IGNORED;
    }

    @Override
    public UpgradeTileEntity.FilterMode getDefaultFilterMode() {
        return UpgradeTileEntity.FilterMode.WHITELIST;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (Direction side : Direction.values()) {
            IItemHandler itemHandler;
            if (this.field_145850_b.func_82737_E() % (long)this.getSpeed(side) != 0L || !this.isExtracting(side) || !this.shouldWork(side) || (itemHandler = this.getItemHandler(this.field_174879_c.func_177972_a(side), side.func_176734_d())) == null) continue;
            List<PipeTileEntity.Connection> connections = this.getSortedConnections(side);
            if (this.getDistribution(side).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(side, connections, itemHandler);
                continue;
            }
            this.insertOrdered(side, connections, itemHandler);
        }
    }

    protected void insertEqually(Direction side, List<PipeTileEntity.Connection> connections, IItemHandler itemHandler) {
        if (connections.isEmpty()) {
            return;
        }
        int itemsToTransfer = this.getRate(side);
        boolean[] inventoriesFull = new boolean[connections.size()];
        int p = this.rrIndex[side.func_176745_a()] % connections.size();
        while (itemsToTransfer > 0 && this.hasNotInserted(inventoriesFull)) {
            PipeTileEntity.Connection connection = connections.get(p);
            IItemHandler destination = this.getItemHandler(connection.getPos(), connection.getDirection());
            boolean hasInserted = false;
            if (destination != null) {
                for (int j = 0; j < itemHandler.getSlots(); ++j) {
                    ItemStack simulatedExtract = itemHandler.extractItem(j, 1, true);
                    if (simulatedExtract.func_190926_b() || this.canInsert(connection, simulatedExtract, this.getFilters(side)) == this.getFilterMode(side).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                    ItemStack stack = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)simulatedExtract, (boolean)false);
                    int insertedAmount = simulatedExtract.func_190916_E() - stack.func_190916_E();
                    if (insertedAmount <= 0) continue;
                    itemsToTransfer -= insertedAmount;
                    itemHandler.extractItem(j, insertedAmount, false);
                    hasInserted = true;
                    break;
                }
            }
            if (!hasInserted) {
                inventoriesFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        this.rrIndex[side.func_176745_a()] = p;
    }

    protected void insertOrdered(Direction side, List<PipeTileEntity.Connection> connections, IItemHandler itemHandler) {
        int itemsToTransfer = this.getRate(side);
        block0: for (PipeTileEntity.Connection connection : connections) {
            IItemHandler destination = this.getItemHandler(connection.getPos(), connection.getDirection());
            if (destination == null) continue;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemsToTransfer <= 0) break block0;
                ItemStack simulatedExtract = itemHandler.extractItem(i, itemsToTransfer, true);
                if (simulatedExtract.func_190926_b() || this.canInsert(connection, simulatedExtract, this.getFilters(side)) == this.getFilterMode(side).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                ItemStack stack = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)simulatedExtract, (boolean)false);
                int insertedAmount = simulatedExtract.func_190916_E() - stack.func_190916_E();
                itemsToTransfer -= insertedAmount;
                itemHandler.extractItem(i, insertedAmount, false);
            }
        }
    }

    private boolean canInsert(PipeTileEntity.Connection connection, ItemStack stack, List<Filter<Item>> filters) {
        for (Filter filter : filters.stream().filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(filter, stack)) continue;
            return false;
        }
        List collect = filters.stream().filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter : collect) {
            if (!this.matches(filter, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Filter<Item> filter, ItemStack stack) {
        CompoundNBT metadata = filter.getMetadata();
        if (metadata == null) {
            return filter.getTag() == null || stack.func_77973_b().func_206844_a(filter.getTag());
        }
        if (filter.isExactMetadata()) {
            if (this.deepExactCompare((INBT)metadata, (INBT)stack.func_77978_p())) {
                return filter.getTag() == null || stack.func_77973_b().func_206844_a(filter.getTag());
            }
            return false;
        }
        CompoundNBT stackNBT = stack.func_77978_p();
        if (stackNBT == null) {
            return metadata.func_186856_d() <= 0;
        }
        if (!this.deepFuzzyCompare((INBT)metadata, (INBT)stackNBT)) {
            return false;
        }
        return filter.getTag() == null || stack.func_77973_b().func_206844_a(filter.getTag());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IItemHandler getItemHandler(BlockPos pos, Direction direction) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity == null) {
            return null;
        }
        return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).orElse(null);
    }

    public int getSpeed(Direction direction) {
        Upgrade upgrade = this.getUpgrade(direction);
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.itemPipeSpeed.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedUltimate.get();
            }
        }
        return 1;
    }

    @Override
    public int getRate(Direction direction) {
        Upgrade upgrade = this.getUpgrade(direction);
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.itemPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

