/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.blocks.PipeBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class PipeTileEntity
extends TileEntity
implements ITickableTileEntity {
    @Nullable
    protected List<Connection> connectionCache;
    protected boolean[] extractingSides = new boolean[Direction.values().length];
    protected boolean[] disconnectedSides = new boolean[Direction.values().length];

    public PipeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public List<Connection> getConnections() {
        if (this.field_145850_b == null) {
            return new ArrayList<Connection>();
        }
        if (this.connectionCache == null) {
            this.updateCache();
            if (this.connectionCache == null) {
                return new ArrayList<Connection>();
            }
        }
        return this.connectionCache;
    }

    public static void markPipesDirty(World world, BlockPos pos) {
        ArrayList<BlockPos> travelPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> queue = new ArrayList<BlockPos>();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        PipeTileEntity pipeTe = pipeBlock.getTileEntity((IWorldReader)world, pos);
        if (pipeTe != null) {
            for (Direction side : Direction.values()) {
                if (!pipeTe.isExtracting(side) || pipeBlock.canConnectTo((IWorldReader)world, pos, side)) continue;
                pipeTe.setExtracting(side, false);
                if (pipeTe.hasReasonToStay()) continue;
                pipeBlock.setHasData(world, pos, false);
            }
        }
        travelPositions.add(pos);
        PipeTileEntity.addToDirtyList(world, pos, pipeBlock, travelPositions, queue);
        while (queue.size() > 0) {
            BlockPos blockPos = (BlockPos)queue.get(0);
            block = world.func_180495_p(blockPos).func_177230_c();
            if (block instanceof PipeBlock) {
                PipeTileEntity.addToDirtyList(world, blockPos, (PipeBlock)block, travelPositions, queue);
            }
            queue.remove(0);
        }
        for (BlockPos p : travelPositions) {
            TileEntity te = world.func_175625_s(p);
            if (!(te instanceof PipeTileEntity)) continue;
            PipeTileEntity pipe = (PipeTileEntity)te;
            pipe.connectionCache = null;
        }
    }

    private static void addToDirtyList(World world, BlockPos pos, PipeBlock pipeBlock, List<BlockPos> travelPositions, List<BlockPos> queue) {
        for (Direction direction : Direction.values()) {
            BlockPos p;
            if (!pipeBlock.isConnected((IWorldReader)world, pos, direction) || travelPositions.contains(p = pos.func_177972_a(direction)) || queue.contains(p)) continue;
            travelPositions.add(p);
            queue.add(p);
        }
    }

    private void updateCache() {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof PipeBlock)) {
            this.connectionCache = null;
            return;
        }
        if (!this.isExtracting()) {
            this.connectionCache = null;
            return;
        }
        HashMap<DirectionalPosition, Integer> connections = new HashMap<DirectionalPosition, Integer>();
        HashMap<BlockPos, Integer> queue = new HashMap<BlockPos, Integer>();
        ArrayList<BlockPos> travelPositions = new ArrayList<BlockPos>();
        this.addToQueue(this.field_145850_b, this.field_174879_c, queue, travelPositions, connections, 1);
        while (queue.size() > 0) {
            Map.Entry blockPosIntegerEntry = (Map.Entry)queue.entrySet().stream().findAny().get();
            this.addToQueue(this.field_145850_b, (BlockPos)blockPosIntegerEntry.getKey(), queue, travelPositions, connections, (Integer)blockPosIntegerEntry.getValue());
            travelPositions.add((BlockPos)blockPosIntegerEntry.getKey());
            queue.remove(blockPosIntegerEntry.getKey());
        }
        this.connectionCache = connections.entrySet().stream().map(entry -> new Connection(((DirectionalPosition)entry.getKey()).getPos(), ((DirectionalPosition)entry.getKey()).getDirection(), (Integer)entry.getValue())).collect(Collectors.toList());
    }

    public void addToQueue(World world, BlockPos position, Map<BlockPos, Integer> queue, List<BlockPos> travelPositions, Map<DirectionalPosition, Integer> insertPositions, int distance) {
        Block block = world.func_180495_p(position).func_177230_c();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        for (Direction direction : Direction.values()) {
            if (!pipeBlock.isConnected((IWorldReader)world, position, direction)) continue;
            BlockPos p = position.func_177972_a(direction);
            DirectionalPosition dp = new DirectionalPosition(p, direction.func_176734_d());
            if (this.canInsert(position, direction)) {
                if (!insertPositions.containsKey(dp)) {
                    insertPositions.put(dp, distance);
                    continue;
                }
                if (insertPositions.get(dp) <= distance) continue;
                insertPositions.put(dp, distance);
                continue;
            }
            if (travelPositions.contains(p) || queue.containsKey(p)) continue;
            queue.put(p, distance + 1);
        }
    }

    public boolean canInsert(BlockPos pos, Direction direction) {
        PipeTileEntity pipe;
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof PipeTileEntity && (pipe = (PipeTileEntity)te).isExtracting(direction)) {
            return false;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos.func_177972_a(direction));
        if (tileEntity == null) {
            return false;
        }
        return this.canInsert(tileEntity, direction.func_176734_d());
    }

    public abstract boolean canInsert(TileEntity var1, Direction var2);

    public void func_73660_a() {
    }

    public boolean isExtracting(Direction side) {
        return this.extractingSides[side.func_176745_a()];
    }

    public boolean isExtracting() {
        for (boolean extract : this.extractingSides) {
            if (!extract) continue;
            return true;
        }
        return false;
    }

    public boolean hasReasonToStay() {
        if (this.isExtracting()) {
            return true;
        }
        for (boolean disconnected : this.disconnectedSides) {
            if (!disconnected) continue;
            return true;
        }
        return false;
    }

    public void setExtracting(Direction side, boolean extracting) {
        this.extractingSides[side.func_176745_a()] = extracting;
        this.func_70296_d();
    }

    public boolean isDisconnected(Direction side) {
        return this.disconnectedSides[side.func_176745_a()];
    }

    public void setDisconnected(Direction side, boolean disconnected) {
        this.disconnectedSides[side.func_176745_a()] = disconnected;
        this.func_70296_d();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.extractingSides = new boolean[Direction.values().length];
        ListNBT extractingList = compound.func_150295_c("ExtractingSides", 1);
        if (extractingList.size() >= this.extractingSides.length) {
            for (int i = 0; i < this.extractingSides.length; ++i) {
                ByteNBT b = (ByteNBT)extractingList.get(i);
                this.extractingSides[i] = b.func_150290_f() != 0;
            }
        }
        this.disconnectedSides = new boolean[Direction.values().length];
        ListNBT disconnectedList = compound.func_150295_c("DisconnectedSides", 1);
        if (disconnectedList.size() >= this.disconnectedSides.length) {
            for (int i = 0; i < this.disconnectedSides.length; ++i) {
                ByteNBT b = (ByteNBT)disconnectedList.get(i);
                this.disconnectedSides[i] = b.func_150290_f() != 0;
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT extractingList = new ListNBT();
        for (boolean extractingSide : this.extractingSides) {
            extractingList.add((Object)ByteNBT.func_229672_a_((boolean)extractingSide));
        }
        compound.func_218657_a("ExtractingSides", (INBT)extractingList);
        ListNBT disconnectedList = new ListNBT();
        for (boolean disconnected : this.disconnectedSides) {
            disconnectedList.add((Object)ByteNBT.func_229672_a_((boolean)disconnected));
        }
        compound.func_218657_a("DisconnectedSides", (INBT)disconnectedList);
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public static class Connection {
        private final BlockPos pos;
        private final Direction direction;
        private final int distance;

        public Connection(BlockPos pos, Direction direction, int distance) {
            this.pos = pos;
            this.direction = direction;
            this.distance = distance;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getDistance() {
            return this.distance;
        }

        public String toString() {
            return "Connection{pos=" + this.pos + ", direction=" + this.direction + ", distance=" + this.distance + '}';
        }
    }
}

