/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.corelib.CachedValue;
import de.maxhenkel.pipez.corelib.inventory.ItemListInventory;
import de.maxhenkel.pipez.corelib.item.ItemUtils;
import de.maxhenkel.pipez.items.UpgradeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class UpgradeTileEntity<T>
extends PipeTileEntity {
    protected NonNullList<ItemStack> upgradeInventory = NonNullList.func_191197_a((int)Direction.values().length, (Object)ItemStack.field_190927_a);
    protected CachedValue<Distribution>[] distributions;
    protected CachedValue<RedstoneMode>[] redstoneModes;
    protected CachedValue<FilterMode>[] filterModes;
    protected CachedValue<List<Filter<T>>>[] filters;

    public UpgradeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.initCaches();
    }

    public void initCaches() {
        this.distributions = new CachedValue[Direction.values().length];
        this.redstoneModes = new CachedValue[Direction.values().length];
        this.filterModes = new CachedValue[Direction.values().length];
        this.filters = new CachedValue[Direction.values().length];
        for (int i = 0; i < Direction.values().length; ++i) {
            int index = i;
            this.distributions[i] = new CachedValue<Distribution>(() -> UpgradeTileEntity.deserialize((ItemStack)this.upgradeInventory.get(index), "Distribution", Distribution.class, this::getDefaultDistribution));
            this.redstoneModes[i] = new CachedValue<RedstoneMode>(() -> UpgradeTileEntity.deserialize((ItemStack)this.upgradeInventory.get(index), "RedstoneMode", RedstoneMode.class, this::getDefaultRedstoneMode));
            this.filterModes[i] = new CachedValue<FilterMode>(() -> UpgradeTileEntity.deserialize((ItemStack)this.upgradeInventory.get(index), "FilterMode", FilterMode.class, this::getDefaultFilterMode));
            this.filters[i] = new CachedValue<List>(() -> this.deserializeFilters((ItemStack)this.upgradeInventory.get(index)));
        }
    }

    public void invalidateAllCaches() {
        for (int i = 0; i < Direction.values().length; ++i) {
            this.distributions[i].invalidate();
            this.redstoneModes[i].invalidate();
            this.filterModes[i].invalidate();
            this.filters[i].invalidate();
        }
    }

    private static <T extends Enum<? extends ICyclable<T>>> T deserialize(ItemStack stack, String key, Class<T> clazz, Supplier<T> defaultSupplier) {
        if (stack.func_190926_b()) {
            return (T)((Enum)defaultSupplier.get());
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return (T)((Enum)defaultSupplier.get());
        }
        if (!tag.func_150297_b(key, 1)) {
            return (T)((Enum)defaultSupplier.get());
        }
        byte b = tag.func_74771_c(key);
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        if (b < 0 || b >= enumConstants.length) {
            return (T)((Enum)defaultSupplier.get());
        }
        return (T)enumConstants[b];
    }

    private <T extends Enum<? extends ICyclable<T>>> void serialize(ItemStack stack, String key, T value) {
        if (stack.func_190926_b()) {
            return;
        }
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74774_a(key, (byte)value.ordinal());
        this.func_70296_d();
    }

    private List<Filter<T>> deserializeFilters(ItemStack stack) {
        if (!this.hasFilter()) {
            return new ArrayList<Filter<T>>();
        }
        if (stack.func_190926_b()) {
            return new ArrayList<Filter<T>>();
        }
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null) {
            return new ArrayList<Filter<T>>();
        }
        if (!compound.func_150297_b(this.getFilterKey(), 9)) {
            return new ArrayList<Filter<T>>();
        }
        ListNBT list = compound.func_150295_c(this.getFilterKey(), 10);
        ArrayList<Filter<T>> filters = new ArrayList<Filter<T>>();
        for (int i = 0; i < list.size(); ++i) {
            Filter<T> filter = this.createFilter();
            filter.deserializeNBT(list.func_150305_b(i));
            filters.add(filter);
        }
        return filters;
    }

    private void serializeFilters(ItemStack stack, List<Filter<T>> filters) {
        if (!this.hasFilter()) {
            return;
        }
        if (stack.func_190926_b()) {
            return;
        }
        CompoundNBT tag = stack.func_196082_o();
        ListNBT list = new ListNBT();
        for (Filter<T> filter : filters) {
            list.add((Object)filter.serializeNBT());
        }
        tag.func_218657_a(this.getFilterKey(), (INBT)list);
        this.func_70296_d();
    }

    public abstract Filter<T> createFilter();

    public abstract String getFilterKey();

    public boolean hasFilter() {
        return true;
    }

    public List<Filter<T>> getFilters(Direction side) {
        return this.filters[side.func_176745_a()].get();
    }

    public void setFilters(Direction side, List<Filter<T>> f) {
        this.serializeFilters((ItemStack)this.upgradeInventory.get(side.func_176745_a()), f);
        this.filters[side.func_176745_a()].invalidate();
    }

    public void setDistribution(Direction side, Distribution dist) {
        this.serialize((ItemStack)this.upgradeInventory.get(side.func_176745_a()), "Distribution", dist);
        this.distributions[side.func_176745_a()].invalidate();
    }

    public void setRedstoneMode(Direction side, RedstoneMode mode) {
        this.serialize((ItemStack)this.upgradeInventory.get(side.func_176745_a()), "RedstoneMode", mode);
        this.redstoneModes[side.func_176745_a()].invalidate();
    }

    public void setFilterMode(Direction side, FilterMode mode) {
        this.serialize((ItemStack)this.upgradeInventory.get(side.func_176745_a()), "FilterMode", mode);
        this.filterModes[side.func_176745_a()].invalidate();
    }

    public Distribution getDistribution(Direction side) {
        return this.distributions[side.func_176745_a()].get();
    }

    public RedstoneMode getRedstoneMode(Direction side) {
        return this.redstoneModes[side.func_176745_a()].get();
    }

    public FilterMode getFilterMode(Direction side) {
        return this.filterModes[side.func_176745_a()].get();
    }

    public abstract Distribution getDefaultDistribution();

    public abstract RedstoneMode getDefaultRedstoneMode();

    public abstract FilterMode getDefaultFilterMode();

    @Override
    public void setExtracting(Direction side, boolean extracting) {
        super.setExtracting(side, extracting);
        if (!extracting) {
            ItemStack stack = (ItemStack)this.upgradeInventory.get(side.func_176745_a());
            this.upgradeInventory.set(side.func_176745_a(), (Object)ItemStack.field_190927_a);
            InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (NonNullList)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{stack}));
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, this.upgradeInventory);
        super.func_145843_s();
    }

    public IInventory getUpgradeInventory() {
        return new ItemListInventory(this.upgradeInventory, () -> {
            this.invalidateAllCaches();
            this.func_70296_d();
        });
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.upgradeInventory.clear();
        ItemUtils.readInventory(compound, "Upgrades", this.upgradeInventory);
        this.invalidateAllCaches();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ItemUtils.saveInventory(compound, "Upgrades", this.upgradeInventory);
        return super.func_189515_b(compound);
    }

    @Nullable
    public Upgrade getUpgrade(Direction direction) {
        ItemStack stack = (ItemStack)this.upgradeInventory.get(direction.func_176745_a());
        if (stack.func_77973_b() instanceof UpgradeItem) {
            return ((UpgradeItem)stack.func_77973_b()).getTier();
        }
        return null;
    }

    public List<PipeTileEntity.Connection> getSortedConnections(Direction side) {
        Distribution distribution = this.getDistribution(side);
        switch (distribution) {
            case FURTHEST: {
                return this.getConnections().stream().sorted((o1, o2) -> Integer.compare(o2.getDistance(), o1.getDistance())).collect(Collectors.toList());
            }
            case RANDOM: {
                ArrayList<PipeTileEntity.Connection> shuffle = new ArrayList<PipeTileEntity.Connection>(this.getConnections());
                Collections.shuffle(shuffle);
                return shuffle;
            }
        }
        return this.getConnections().stream().sorted(Comparator.comparingInt(PipeTileEntity.Connection::getDistance)).collect(Collectors.toList());
    }

    public boolean matchesConnection(PipeTileEntity.Connection connection, Filter<T> filter) {
        if (filter.getDestination() == null) {
            return true;
        }
        return filter.getDestination().equals(new DirectionalPosition(connection.getPos(), connection.getDirection()));
    }

    public boolean deepExactCompare(INBT meta, INBT item) {
        if (meta instanceof CompoundNBT) {
            if (!(item instanceof CompoundNBT)) {
                return false;
            }
            CompoundNBT c = (CompoundNBT)meta;
            CompoundNBT i = (CompoundNBT)item;
            HashSet allKeys = new HashSet();
            allKeys.addAll(c.func_150296_c());
            allKeys.addAll(i.func_150296_c());
            for (String key : allKeys) {
                if (c.func_74764_b(key)) {
                    if (i.func_74764_b(key)) {
                        INBT nbt = c.func_74781_a(key);
                        if (this.deepExactCompare(nbt, i.func_74781_a(key))) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        if (meta instanceof ListNBT) {
            ListNBT l = (ListNBT)meta;
            if (!(item instanceof ListNBT)) {
                return false;
            }
            ListNBT il = (ListNBT)item;
            if (!l.stream().allMatch(inbt -> il.stream().anyMatch(inbt1 -> this.deepExactCompare((INBT)inbt, (INBT)inbt1)))) {
                return false;
            }
            return il.stream().allMatch(inbt -> l.stream().anyMatch(inbt1 -> this.deepExactCompare((INBT)inbt, (INBT)inbt1)));
        }
        return meta != null && meta.equals(item);
    }

    public boolean deepFuzzyCompare(INBT meta, INBT item) {
        if (meta instanceof CompoundNBT) {
            if (!(item instanceof CompoundNBT)) {
                return false;
            }
            CompoundNBT c = (CompoundNBT)meta;
            CompoundNBT i = (CompoundNBT)item;
            for (String key : c.func_150296_c()) {
                INBT nbt;
                if (i.func_150297_b(key, (int)(nbt = c.func_74781_a(key)).func_74732_a())) {
                    if (this.deepFuzzyCompare(nbt, i.func_74781_a(key))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        if (meta instanceof ListNBT) {
            ListNBT l = (ListNBT)meta;
            if (!(item instanceof ListNBT)) {
                return false;
            }
            ListNBT il = (ListNBT)item;
            return l.stream().allMatch(inbt -> il.stream().anyMatch(inbt1 -> this.deepFuzzyCompare((INBT)inbt, (INBT)inbt1)));
        }
        return meta != null && meta.equals(item);
    }

    public abstract int getRate(Direction var1);

    public static interface ICyclable<T extends Enum<?>> {
        public T cycle();
    }

    public static enum FilterMode implements ICyclable<FilterMode>
    {
        WHITELIST("whitelist"),
        BLACKLIST("blacklist");

        private final String name;

        private FilterMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public FilterMode cycle() {
            return FilterMode.values()[Math.floorMod(this.ordinal() + 1, FilterMode.values().length)];
        }
    }

    public static enum RedstoneMode implements ICyclable<RedstoneMode>
    {
        IGNORED("ignored"),
        OFF_WHEN_POWERED("off_when_powered"),
        ON_WHEN_POWERED("on_when_powered");

        private final String name;

        private RedstoneMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public RedstoneMode cycle() {
            return RedstoneMode.values()[Math.floorMod(this.ordinal() + 1, RedstoneMode.values().length)];
        }
    }

    public static enum Distribution implements ICyclable<Distribution>
    {
        NEAREST("nearest"),
        FURTHEST("furthest"),
        ROUND_ROBIN("round_robin"),
        RANDOM("random");

        private final String name;

        private Distribution(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Distribution cycle() {
            return Distribution.values()[Math.floorMod(this.ordinal() + 1, Distribution.values().length)];
        }
    }
}

