/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.corelib.CachedValue;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public abstract class PipeRenderer
extends TileEntityRenderer<PipeTileEntity> {
    protected Minecraft minecraft = Minecraft.func_71410_x();
    protected CachedValue<IBakedModel> cachedModel = new CachedValue<IBakedModel>(() -> {
        IUnbakedModel modelOrMissing = ModelLoader.instance().getModelOrMissing(this.getModel());
        return modelOrMissing.func_225613_a_((ModelBakery)ModelLoader.instance(), arg_0 -> ((SpriteMap)ModelLoader.instance().getSpriteMap()).func_229151_a_(arg_0), (IModelTransform)ModelRotation.X0_Y0, this.getModel());
    });

    public PipeRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(PipeTileEntity pipe, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        IBakedModel iBakedModel = this.cachedModel.get();
        List quads = iBakedModel.getQuads(null, null, this.minecraft.field_71441_e.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
        IVertexBuilder b = buffer.getBuffer(RenderType.func_228639_c_());
        for (Direction side : Direction.values()) {
            if (!pipe.isExtracting(side)) continue;
            this.renderExtractor(side, matrixStack, b, quads, combinedLight, combinedOverlay);
        }
    }

    private void renderExtractor(Direction direction, MatrixStack matrixStack, IVertexBuilder b, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(this.getRotation(direction));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        for (BakedQuad quad : quads) {
            b.func_227889_a_(matrixStack.func_227866_c_(), quad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
        }
        matrixStack.func_227865_b_();
    }

    private Quaternion getRotation(Direction direction) {
        Quaternion q = Quaternion.field_227060_a_.func_227068_g_();
        switch (direction) {
            case NORTH: {
                return q;
            }
            case SOUTH: {
                q.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                return q;
            }
            case WEST: {
                q.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                return q;
            }
            case EAST: {
                q.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                return q;
            }
            case UP: {
                q.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                return q;
            }
        }
        q.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(270.0f));
        return q;
    }

    abstract ResourceLocation getModel();
}

