/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.gui.CycleIconButton;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.FilterList;
import de.maxhenkel.pipez.net.CycleDistributionMessage;
import de.maxhenkel.pipez.net.CycleFilterModeMessage;
import de.maxhenkel.pipez.net.CycleRedstoneModeMessage;
import de.maxhenkel.pipez.net.EditFilterMessage;
import de.maxhenkel.pipez.net.RemoveFilterMessage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtractScreen
extends ScreenBase<ExtractContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("pipez", "textures/gui/container/extract.png");
    private CycleIconButton redstoneButton;
    private CycleIconButton sortButton;
    private CycleIconButton filterButton;
    private Button addFilterButton;
    private Button editFilterButton;
    private Button removeFilterButton;
    private ScreenBase.HoverArea redstoneArea;
    private ScreenBase.HoverArea sortArea;
    private ScreenBase.HoverArea filterArea;
    private FilterList filterList;

    public ExtractScreen(ExtractContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(BACKGROUND, container, playerInventory, title);
        this.field_146999_f = 176;
        this.field_147000_g = 196;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.hoverAreas.clear();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        UpgradeTileEntity pipe = ((ExtractContainer)this.func_212873_a_()).getPipe();
        Direction side = ((ExtractContainer)this.func_212873_a_()).getSide();
        Supplier<Integer> redstoneModeIndex = () -> pipe.getRedstoneMode(((ExtractContainer)this.func_212873_a_()).getSide()).ordinal();
        List<CycleIconButton.Icon> redstoneModeIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 16), new CycleIconButton.Icon(BACKGROUND, 192, 16), new CycleIconButton.Icon(BACKGROUND, 208, 16));
        this.redstoneButton = new CycleIconButton(this.field_147003_i + 7, this.field_147009_r + 7, redstoneModeIcons, redstoneModeIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleRedstoneModeMessage()));
        Supplier<Integer> distributionIndex = () -> pipe.getDistribution(((ExtractContainer)this.func_212873_a_()).getSide()).ordinal();
        List<CycleIconButton.Icon> distributionIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 0), new CycleIconButton.Icon(BACKGROUND, 192, 0), new CycleIconButton.Icon(BACKGROUND, 208, 0), new CycleIconButton.Icon(BACKGROUND, 224, 0));
        this.sortButton = new CycleIconButton(this.field_147003_i + 7, this.field_147009_r + 31, distributionIcons, distributionIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleDistributionMessage()));
        Supplier<Integer> filterModeIndex = () -> pipe.hasFilter() ? pipe.getFilterMode(((ExtractContainer)this.func_212873_a_()).getSide()).ordinal() : 0;
        List<CycleIconButton.Icon> filterModeIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 32), new CycleIconButton.Icon(BACKGROUND, 192, 32));
        this.filterButton = new CycleIconButton(this.field_147003_i + 7, this.field_147009_r + 55, filterModeIcons, filterModeIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleFilterModeMessage()));
        this.addFilterButton = new Button(this.field_147003_i + 31, this.field_147009_r + 79, 40, 20, (ITextComponent)new TranslationTextComponent("message.pipez.filter.add"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new EditFilterMessage(pipe.createFilter())));
        this.editFilterButton = new Button(this.field_147003_i + 80, this.field_147009_r + 79, 40, 20, (ITextComponent)new TranslationTextComponent("message.pipez.filter.edit"), button -> {
            if (this.filterList.getSelected() >= 0) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new EditFilterMessage(pipe.getFilters(side).get(this.filterList.getSelected())));
            }
        });
        this.removeFilterButton = new Button(this.field_147003_i + 129, this.field_147009_r + 79, 40, 20, (ITextComponent)new TranslationTextComponent("message.pipez.filter.remove"), button -> {
            if (this.filterList.getSelected() >= 0) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new RemoveFilterMessage(pipe.getFilters(side).get(this.filterList.getSelected()).getId()));
            }
        });
        this.func_230480_a_(this.redstoneButton);
        this.func_230480_a_(this.sortButton);
        this.func_230480_a_(this.filterButton);
        this.func_230480_a_(this.addFilterButton);
        this.func_230480_a_(this.editFilterButton);
        this.func_230480_a_(this.removeFilterButton);
        this.redstoneArea = new ScreenBase.HoverArea(7, 7, 20, 20, () -> {
            if (this.redstoneButton.field_230693_o_) {
                return Arrays.asList(new TranslationTextComponent("tooltip.pipez.redstone_mode", new Object[]{new TranslationTextComponent("tooltip.pipez.redstone_mode." + pipe.getRedstoneMode(side).getName())}).func_241878_f());
            }
            return Collections.emptyList();
        });
        this.sortArea = new ScreenBase.HoverArea(7, 31, 20, 20, () -> {
            if (this.sortButton.field_230693_o_) {
                return Arrays.asList(new TranslationTextComponent("tooltip.pipez.distribution", new Object[]{new TranslationTextComponent("tooltip.pipez.distribution." + pipe.getDistribution(side).getName())}).func_241878_f());
            }
            return Collections.emptyList();
        });
        this.filterArea = new ScreenBase.HoverArea(7, 55, 20, 20, () -> {
            if (this.filterButton.field_230693_o_) {
                return Arrays.asList(new TranslationTextComponent("tooltip.pipez.filter_mode", new Object[]{new TranslationTextComponent("tooltip.pipez.filter_mode." + pipe.getFilterMode(side).getName())}).func_241878_f());
            }
            return Collections.emptyList();
        });
        this.hoverAreas.add(this.redstoneArea);
        this.hoverAreas.add(this.sortArea);
        this.hoverAreas.add(this.filterArea);
        this.filterList = new FilterList(this, 32, 8, 136, 66, () -> pipe.getFilters(side));
        this.checkButtons();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.checkButtons();
        this.filterList.tick();
    }

    private void checkButtons() {
        Upgrade upgrade = ((ExtractContainer)this.func_212873_a_()).getPipe().getUpgrade(((ExtractContainer)this.func_212873_a_()).getSide());
        if (upgrade == null) {
            this.redstoneButton.field_230693_o_ = false;
            this.sortButton.field_230693_o_ = false;
            this.filterButton.field_230693_o_ = false;
            this.addFilterButton.field_230693_o_ = false;
            this.editFilterButton.field_230693_o_ = false;
            this.removeFilterButton.field_230693_o_ = false;
        } else if (upgrade.equals((Object)Upgrade.BASIC)) {
            this.redstoneButton.field_230693_o_ = true;
            this.sortButton.field_230693_o_ = false;
            this.filterButton.field_230693_o_ = false;
            this.addFilterButton.field_230693_o_ = false;
            this.editFilterButton.field_230693_o_ = false;
            this.removeFilterButton.field_230693_o_ = false;
        } else if (upgrade.equals((Object)Upgrade.IMPROVED)) {
            this.redstoneButton.field_230693_o_ = true;
            this.sortButton.field_230693_o_ = true;
            this.filterButton.field_230693_o_ = false;
            this.addFilterButton.field_230693_o_ = false;
            this.editFilterButton.field_230693_o_ = false;
            this.removeFilterButton.field_230693_o_ = false;
        } else {
            this.redstoneButton.field_230693_o_ = true;
            this.sortButton.field_230693_o_ = true;
            this.filterButton.field_230693_o_ = ((ExtractContainer)this.field_147002_h).getPipe().hasFilter();
            this.addFilterButton.field_230693_o_ = ((ExtractContainer)this.field_147002_h).getPipe().hasFilter();
            this.editFilterButton.field_230693_o_ = this.filterList.getSelected() >= 0;
            this.removeFilterButton.field_230693_o_ = this.filterList.getSelected() >= 0;
        }
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        this.filterList.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        this.drawHoverAreas(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.filterList.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.filterList.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.filterList.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return this.filterList.mouseScrolled(mouseX, mouseY, delta);
    }

    public <T extends Widget> T func_230480_a_(T button) {
        return (T)super.func_230480_a_(button);
    }

    public void addHoverArea(ScreenBase.HoverArea hoverArea) {
        this.hoverAreas.add(hoverArea);
    }
}

