/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.items;

import de.maxhenkel.pipez.ModItemGroups;
import de.maxhenkel.pipez.Upgrade;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class UpgradeItem
extends Item {
    private final Upgrade tier;

    public UpgradeItem(Upgrade tier) {
        super(new Item.Properties().func_200916_a(ModItemGroups.TAB_PIPEZ));
        this.tier = tier;
        this.setRegistryName(new ResourceLocation("pipez", tier.getName() + "_upgrade"));
    }

    public Upgrade getTier() {
        return this.tier;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int fluidFilters;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int itemFilters = this.getFilterCount(stack, "ItemFilters");
        if (itemFilters > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pipez.upgrade.filters.item", new Object[]{new StringTextComponent(String.valueOf(itemFilters)).func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(TextFormatting.YELLOW));
        }
        if ((fluidFilters = this.getFilterCount(stack, "FluidFilters")) > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pipez.upgrade.filters.fluid", new Object[]{new StringTextComponent(String.valueOf(fluidFilters)).func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(TextFormatting.BLUE));
        }
    }

    private int getFilterCount(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (!tag.func_150297_b(key, 9)) {
            return 0;
        }
        ListNBT filters = tag.func_150295_c(key, 10);
        return filters.size();
    }
}

